/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.push.notification;

import android.app.Notification;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.alibaba.sdk.android.ams.common.logger.AmsLogger;
import com.alibaba.sdk.android.push.common.a.c;
import com.alibaba.sdk.android.push.f.a;
import com.alibaba.sdk.android.push.notification.BasicCustomPushNotification;
import com.alibaba.sdk.android.push.notification.b;
import com.alibaba.sdk.android.push.notification.e;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public class CustomNotificationBuilder {
    static AmsLogger a = AmsLogger.getLogger("MPS:CustomNotificationBuilder");
    public static final String NOTIFICATION_ICON_RES_TYPE = "drawable";
    public static final String NOTIFICATION_LARGE_ICON_FILE = "alicloud_notification_largeicon";
    public static final String NOTIFICATION_SMALL_ICON_FILE = "alicloud_notification_smallicon";
    private Map<String, Object> b = null;
    private static CustomNotificationBuilder c = null;

    private CustomNotificationBuilder() {
        if (null == this.b) {
            this.b = new HashMap<String, Object>();
        }
    }

    public static CustomNotificationBuilder getInstance() {
        if (null == c) {
            c = new CustomNotificationBuilder();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicCustomPushNotification a(int n) {
        if (this.b.containsKey("custom_notification_" + n)) {
            a.d("find custom notification from cache");
            return (BasicCustomPushNotification)this.b.get("custom_notification_" + n);
        }
        a.d("do not find custom notification from cache, find it from SharedPreferences");
        SharedPreferences sharedPreferences = com.alibaba.sdk.android.ams.common.a.a.g();
        String string = sharedPreferences.getString("custom_notification_" + n, null);
        if (string == null) {
            a.e("no corresponding custom notificaiton");
            return null;
        }
        String string2 = null;
        BasicCustomPushNotification basicCustomPushNotification = null;
        try {
            string2 = URLDecoder.decode(string, "UTF-8");
            String string3 = "ISO-8859-1";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes(string3));
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            basicCustomPushNotification = (BasicCustomPushNotification)objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            a.e("get custom notification failed", unsupportedEncodingException);
        }
        catch (OptionalDataException optionalDataException) {
            a.e("get custom notification failed", optionalDataException);
        }
        catch (StreamCorruptedException streamCorruptedException) {
            a.e("get custom notification failed", streamCorruptedException);
        }
        catch (IOException iOException) {
            a.e("get custom notification failed", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            a.e("get custom notification failed", classNotFoundException);
        }
        finally {
            a.d(basicCustomPushNotification.toString());
            if (basicCustomPushNotification != null) {
                this.b.put("custom_notification_" + n, basicCustomPushNotification);
            }
            return basicCustomPushNotification;
        }
    }

    public boolean setCustomNotification(int n, BasicCustomPushNotification basicCustomPushNotification) {
        if (n <= 0) {
            a.e("custom notification id must be an integer greater than 0");
            return false;
        }
        if (basicCustomPushNotification == null) {
            a.e("notification cannot be null");
            return false;
        }
        SharedPreferences sharedPreferences = com.alibaba.sdk.android.ams.common.a.a.g();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        boolean bl = true;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(basicCustomPushNotification);
            String string = byteArrayOutputStream.toString("ISO-8859-1");
            string = URLEncoder.encode(string, "UTF-8");
            objectOutputStream.close();
            byteArrayOutputStream.close();
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString("custom_notification_" + n, string);
            editor.commit();
        }
        catch (IOException iOException) {
            a.e("get custom notification failed", iOException);
            bl = false;
        }
        if (bl) {
            if (this.b.containsKey("custom_notification_" + n)) {
                this.b.remove("custom_notification_" + n);
            }
            a.d("save the notification to cache");
            this.b.put("custom_notification_" + n, basicCustomPushNotification);
        }
        return bl;
    }

    public Notification a(Context context, b b2) {
        if (2 == b2.g()) {
            return this.b(context, b2);
        }
        if (3 == b2.g()) {
            return this.c(context, b2);
        }
        return null;
    }

    private Notification b(Context context, b b2) {
        Notification notification = null;
        a.d("building basic custom notification");
        int n = b2.s();
        String string = b2.t();
        String string2 = b2.u();
        String string3 = b2.w();
        Bitmap bitmap = null;
        String string4 = b2.a();
        if (!TextUtils.isEmpty((CharSequence)b2.v())) {
            bitmap = com.alibaba.sdk.android.push.f.a.a(context, b2.v());
        }
        Bitmap bitmap2 = this.e(context, b2);
        if (Build.VERSION.SDK_INT >= 16) {
            Notification.Builder builder = new Notification.Builder(context);
            builder.setContentTitle((CharSequence)b2.b()).setContentText((CharSequence)b2.c()).setSmallIcon(this.d(context, b2)).setPriority(b2.p()).setLargeIcon(bitmap2).setTicker((CharSequence)"").setWhen(System.currentTimeMillis());
            if (n == 1) {
                Notification.BigTextStyle bigTextStyle = new Notification.BigTextStyle().bigText((CharSequence)string2);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    bigTextStyle.setBigContentTitle((CharSequence)string);
                }
                builder.setStyle((Notification.Style)bigTextStyle);
            } else if (n == 2) {
                Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle().bigPicture(bitmap);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    bigPictureStyle.setBigContentTitle((CharSequence)string);
                }
                if (bitmap2 != null) {
                    bigPictureStyle.bigLargeIcon(bitmap2);
                }
                builder.setStyle((Notification.Style)bigPictureStyle);
            } else if (n == 3) {
                Notification.InboxStyle inboxStyle = new Notification.InboxStyle();
                try {
                    JSONArray jSONArray = new JSONArray(string3);
                    for (int j = 0; j < jSONArray.length(); ++j) {
                        inboxStyle.addLine((CharSequence)jSONArray.getString(j));
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    inboxStyle.setBigContentTitle((CharSequence)string);
                }
                builder.setStyle((Notification.Style)inboxStyle);
            }
            if (Build.VERSION.SDK_INT >= 17) {
                builder.setShowWhen(true);
            }
            if (Build.VERSION.SDK_INT >= 26 && !TextUtils.isEmpty((CharSequence)b2.q())) {
                builder.setChannelId(b2.q());
            }
            if (Build.VERSION.SDK_INT >= 20) {
                if (e.b()) {
                    builder.setGroupSummary(true);
                    builder.setGroup("group" + e.a());
                } else {
                    builder.setGroupSummary(false);
                    builder.setGroup("group");
                }
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                if (string4.startsWith("android.resource://")) {
                    builder.setSound(Uri.parse((String)string4));
                } else if (string4.startsWith("/raw/")) {
                    builder.setSound(Uri.parse((String)("android.resource://" + context.getPackageName() + string4)));
                } else {
                    builder.setSound(Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + string4)));
                }
            }
            notification = builder.build();
        } else {
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
            builder.setContentTitle((CharSequence)b2.b()).setContentText((CharSequence)b2.c()).setSmallIcon(this.d(context, b2)).setPriority(b2.p()).setLargeIcon(bitmap2).setWhen(System.currentTimeMillis()).setShowWhen(true).setTicker((CharSequence)"");
            if (n == 1) {
                NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle().bigText((CharSequence)string2);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    bigTextStyle.setBigContentTitle((CharSequence)string);
                }
                builder.setStyle((NotificationCompat.Style)bigTextStyle);
            } else if (n == 2) {
                NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle().bigPicture(bitmap);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    bigPictureStyle.setBigContentTitle((CharSequence)string);
                }
                if (bitmap2 != null) {
                    bigPictureStyle.bigLargeIcon(bitmap2);
                }
                builder.setStyle((NotificationCompat.Style)bigPictureStyle);
            } else if (n == 3) {
                NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
                try {
                    JSONArray jSONArray = new JSONArray(string3);
                    for (int j = 0; j < jSONArray.length(); ++j) {
                        inboxStyle.addLine((CharSequence)jSONArray.getString(j));
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    inboxStyle.setBigContentTitle((CharSequence)string);
                }
                builder.setStyle((NotificationCompat.Style)inboxStyle);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                if (string4.startsWith("android.resource://")) {
                    builder.setSound(Uri.parse((String)string4));
                } else if (string4.startsWith("/raw/")) {
                    builder.setSound(Uri.parse((String)("android.resource://" + context.getPackageName() + string4)));
                } else {
                    builder.setSound(Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + string4)));
                }
            }
            notification = builder.build();
        }
        return notification;
    }

    private Notification c(Context context, b b2) {
        Notification notification = null;
        String string = b2.a();
        a.d("building advanced custom notification");
        if (0 != b2.j()) {
            RemoteViews remoteViews = new RemoteViews(context.getPackageName(), b2.j());
            remoteViews.setTextViewText(b2.l(), (CharSequence)b2.b());
            remoteViews.setTextViewText(b2.m(), (CharSequence)b2.c());
            if (0 != b2.n()) {
                remoteViews.setImageViewResource(b2.k(), b2.n());
            } else {
                remoteViews.setImageViewResource(b2.k(), 17301623);
            }
            if (Build.VERSION.SDK_INT >= 16) {
                Notification.Builder builder = new Notification.Builder(context);
                builder.setContent(remoteViews).setPriority(b2.p()).setSmallIcon(this.d(context, b2)).setTicker((CharSequence)"").setWhen(System.currentTimeMillis());
                if (Build.VERSION.SDK_INT >= 17) {
                    builder.setShowWhen(true);
                }
                if (Build.VERSION.SDK_INT >= 26 && !TextUtils.isEmpty((CharSequence)b2.q())) {
                    builder.setChannelId(b2.q());
                }
                if (Build.VERSION.SDK_INT >= 20) {
                    if (e.b()) {
                        builder.setGroupSummary(true);
                        builder.setGroup("group" + e.a());
                    } else {
                        builder.setGroupSummary(false);
                        builder.setGroup("group");
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    if (string.startsWith("android.resource://")) {
                        builder.setSound(Uri.parse((String)string));
                    } else if (string.startsWith("/raw/")) {
                        builder.setSound(Uri.parse((String)("android.resource://" + context.getPackageName() + string)));
                    } else {
                        builder.setSound(Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + string)));
                    }
                }
                notification = builder.build();
            } else {
                NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
                builder.setContent(remoteViews).setPriority(b2.p()).setSmallIcon(this.d(context, b2)).setTicker((CharSequence)"").setShowWhen(true).setWhen(System.currentTimeMillis());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    if (string.startsWith("android.resource://")) {
                        builder.setSound(Uri.parse((String)string));
                    } else if (string.startsWith("/raw/")) {
                        builder.setSound(Uri.parse((String)("android.resource://" + context.getPackageName() + string)));
                    } else {
                        builder.setSound(Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + string)));
                    }
                }
                notification = builder.build();
            }
        }
        return notification;
    }

    private Bitmap a(Drawable drawable2) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    private int d(Context context, b b2) {
        int n = 0;
        n = b2.f();
        if (n != 0) {
            return n;
        }
        n = com.alibaba.sdk.android.push.common.a.c.c() != 0 ? com.alibaba.sdk.android.push.common.a.c.c() : context.getResources().getIdentifier(NOTIFICATION_SMALL_ICON_FILE, NOTIFICATION_ICON_RES_TYPE, context.getPackageName());
        int n2 = 17301623;
        try {
            n2 = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).applicationInfo.icon;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            a.e("Get system icon error, package name not found, ", nameNotFoundException);
        }
        if (n == 0) {
            n = n2;
        }
        return n;
    }

    private Bitmap e(Context context, b b2) {
        Drawable drawable2;
        int n;
        Bitmap bitmap = null;
        if (!TextUtils.isEmpty((CharSequence)b2.r())) {
            bitmap = com.alibaba.sdk.android.push.f.a.a(context, b2.r());
        }
        if (bitmap == null) {
            if (com.alibaba.sdk.android.push.common.a.c.b() != null) {
                bitmap = com.alibaba.sdk.android.push.common.a.c.b();
            } else {
                n = context.getResources().getIdentifier(NOTIFICATION_LARGE_ICON_FILE, NOTIFICATION_ICON_RES_TYPE, context.getPackageName());
                if (n != 0) {
                    drawable2 = context.getResources().getDrawable(n);
                    bitmap = this.a(drawable2);
                }
            }
        }
        if (bitmap == null) {
            n = 17301623;
            try {
                n = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).applicationInfo.icon;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                a.e("Get system icon error, package name not found, ", nameNotFoundException);
            }
            drawable2 = context.getResources().getDrawable(n);
            bitmap = this.a(drawable2);
        }
        return bitmap;
    }
}

