/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.push.notification;

import android.content.Context;
import android.os.Build;
import com.alibaba.sdk.android.ams.common.logger.AmsLogger;
import com.alibaba.sdk.android.ams.common.util.StringUtil;
import com.alibaba.sdk.android.push.common.util.JSONUtils;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PushData {
    private static final String TAG = "MPS:PushData";
    private static AmsLogger logger = AmsLogger.getLogger("MPS:PushData");
    public static final String KEY_TITLE = "title";
    public static final String KEY_CONTENT = "content";
    public static final String KEY_IMAGE = "image";
    public static final String KEY_NOTIFY_TYPE = "remind";
    public static final int NOTIFY_TYPE_SILENT = 0;
    public static final int NOTIFY_TYPE_VIBRATE = 1;
    public static final int NOTIFY_TYPE_SOUND = 2;
    public static final int NOTIFY_TYPE_VIBRATE_SOUND = 3;
    public static final String KEY_MUSIC = "music";
    public static final String KEY_EXT = "ext";
    public static final String KEY_CHANNEL = "notification_channel";
    public static final String KEY_CUSTOM_NOTIFICAITON_ID = "custom_notification_id";
    public static final int NO_CUSTOM_NOTIFICATION = 0;
    public static final String KEY_NOTIFICATION_PRIORITY = "_ALIYUN_NOTIFICATION_PRIORITY_";
    public static final String KEY_STYLE = "style";
    public static final String KEY_BIG_TITLE = "big_title";
    public static final String KEY_BIG_BODY = "big_body";
    public static final String KEY_BIG_PICTURE = "big_picture";
    public static final String KEY_INBOX_CONTENT = "inbox_content";
    public static final String KEY_NOTIFY_ID = "notify_id";
    public static final String KEY_MSG_ID = "msg_id";
    private String title;
    private String contentText;
    private String image;
    private int notifyType;
    private String sound;
    private String notificationChannel;
    private int priority = Build.VERSION.SDK_INT >= 16 ? 0 : 0;
    private int customNotificationId = 0;
    private Map<String, String> extraMap;
    private String style;
    private String bigTitle;
    private String bigPicture;
    private String bigBody;
    private String inboxContent;
    private int notifyId;
    private String msgId;

    public String getSound() {
        return this.sound;
    }

    private void setSound(String string) {
        this.sound = string;
    }

    public String getTitle() {
        return this.title;
    }

    private void setTitle(String string) {
        this.title = string;
    }

    public String getContentText() {
        return this.contentText;
    }

    private void setContentText(String string) {
        this.contentText = string;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String string) {
        this.image = string;
    }

    public int getNotifyType() {
        return this.notifyType;
    }

    private void setNotifyType(int n) {
        this.notifyType = n;
    }

    public Map<String, String> getExtraMap() {
        return this.extraMap;
    }

    private void setExtraMap(Map<String, String> map) {
        this.extraMap = map;
    }

    public int getPriority() {
        return this.priority;
    }

    private void setPriority(String string) {
        try {
            this.priority = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.e("formar error:\u6570\u5b57\u683c\u5f0f\u9519\u8bef", numberFormatException);
        }
    }

    public String getNotificationChannel() {
        return this.notificationChannel;
    }

    private void setNotificationChannel(String string) {
        this.notificationChannel = string;
    }

    public int getCustomNotificationId() {
        return this.customNotificationId;
    }

    private void setCustomNotificationId(int n) {
        this.customNotificationId = n;
    }

    public String getStyle() {
        return this.style;
    }

    private void setStyle(String string) {
        this.style = string;
    }

    public String getBigTitle() {
        return this.bigTitle;
    }

    private void setBigTitle(String string) {
        this.bigTitle = string;
    }

    public String getBigPicture() {
        return this.bigPicture;
    }

    private void setBigPicture(String string) {
        this.bigPicture = string;
    }

    public String getBigBody() {
        return this.bigBody;
    }

    private void setBigBody(String string) {
        this.bigBody = string;
    }

    public String getInboxContent() {
        return this.inboxContent;
    }

    private void setInboxContent(String string) {
        this.inboxContent = string;
    }

    public int getNotifyId() {
        return this.notifyId;
    }

    private void setNotifyId(int n) {
        this.notifyId = n;
    }

    public String getMsgId() {
        return this.msgId;
    }

    private void setMsgId(String string) {
        this.msgId = string;
    }

    public static PushData parse(Context context, Map<String, String> map) {
        Object object;
        String string = map.get(KEY_TITLE);
        String string2 = map.get(KEY_CONTENT);
        if (StringUtil.isEmpty(string) || StringUtil.isEmpty(string2)) {
            logger.e("title or content of notify is empty: " + map);
            return null;
        }
        PushData pushData = new PushData();
        String string3 = map.get(KEY_NOTIFY_TYPE);
        if (StringUtil.isEmpty(string3)) {
            string3 = String.valueOf(2);
        }
        String string4 = map.get(KEY_MUSIC);
        String string5 = map.get(KEY_EXT);
        String string6 = map.get(KEY_CHANNEL);
        pushData.setTitle(string);
        pushData.setContentText(string2);
        pushData.setNotifyType(Integer.parseInt(string3));
        pushData.setNotificationChannel(string6);
        pushData.setImage(map.get(KEY_IMAGE));
        pushData.setStyle(map.get(KEY_STYLE));
        pushData.setBigTitle(map.get(KEY_BIG_TITLE));
        pushData.setBigBody(map.get(KEY_BIG_BODY));
        pushData.setBigPicture(map.get(KEY_BIG_PICTURE));
        pushData.setInboxContent(map.get(KEY_INBOX_CONTENT));
        pushData.setMsgId(map.get(KEY_MSG_ID));
        try {
            pushData.setNotifyId(Integer.parseInt(map.get(KEY_NOTIFY_ID)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pushData.setSound(StringUtil.isEmpty(string4) ? null : string4);
        if (!StringUtil.isEmpty(string5)) {
            try {
                object = new JSONObject(string5);
                Map<String, String> map2 = JSONUtils.toMap(object);
                if (map2.containsKey(KEY_NOTIFICATION_PRIORITY)) {
                    String string7 = map2.get(KEY_NOTIFICATION_PRIORITY);
                    pushData.setPriority(string7);
                } else if (Build.VERSION.SDK_INT >= 16) {
                    pushData.setPriority(String.valueOf(0));
                } else {
                    pushData.setPriority(String.valueOf(0));
                }
                pushData.setExtraMap(map2);
            }
            catch (JSONException jSONException) {
                logger.e("Parse inner json(ext) error:", jSONException);
            }
        }
        if (map.containsKey(KEY_CUSTOM_NOTIFICAITON_ID)) {
            object = map.get(KEY_CUSTOM_NOTIFICAITON_ID);
            int n = Integer.parseInt((String)object);
            pushData.setCustomNotificationId(n);
        }
        return pushData;
    }
}

