/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tao.log;

import android.text.TextUtils;
import com.taobao.tao.log.ITLogController;
import com.taobao.tao.log.LogLevel;
import com.taobao.tao.log.TLogInitializer;
import com.taobao.tao.log.TLogNative;
import com.taobao.tao.log.TLogUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TLogController
implements ITLogController {
    private Map<String, LogLevel> moduleFilter;
    private LogLevel logLevel = LogLevel.I;

    private TLogController() {
        this.moduleFilter = new ConcurrentHashMap<String, LogLevel>();
    }

    public static final TLogController getInstance() {
        return a.a;
    }

    public void addModuleFilter(Map<String, LogLevel> map) {
        if (map != null && map.size() > 0) {
            Set<String> set = map.keySet();
            for (String string : set) {
                LogLevel logLevel = map.get(string);
                TLogController.getInstance().addModuleFilter(string, logLevel);
            }
        }
    }

    public void addModuleFilter(String string, LogLevel logLevel) {
        this.moduleFilter.put(string, logLevel);
        if (TLogInitializer.getInstance().getInitState() == 2) {
            try {
                TLogNative.addModuleFilter(string, logLevel.getIndex());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void cleanModuleFilter() {
        this.moduleFilter.clear();
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        if (TLogInitializer.getInstance().getInitState() == 2) {
            try {
                TLogNative.setLogLevel(logLevel.getIndex());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void closeLog() {
        if (TLogInitializer.getInstance().getInitState() != 2) {
            return;
        }
        try {
            TLogNative.setLogLevel(LogLevel.L.getIndex());
            TLogNative.appenderClose();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void updateLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    protected void updateAsyncConfig() {
        if (null == this.moduleFilter || null == this.logLevel || !TLogNative.isSoOpen()) {
            return;
        }
        try {
            for (Map.Entry<String, LogLevel> entry : this.moduleFilter.entrySet()) {
                TLogNative.addModuleFilter(entry.getKey(), entry.getValue().getIndex());
            }
            TLogNative.setLogLevel(this.logLevel.getIndex());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public boolean isFilter(LogLevel logLevel, String string) {
        if (this.logLevel == null || logLevel == null || string == null) {
            return false;
        }
        if (this.logLevel.getIndex() <= logLevel.getIndex()) {
            return true;
        }
        int n2 = string.indexOf(".");
        if (n2 < 0 || n2 >= string.length()) {
            return false;
        }
        String string2 = string.substring(0, n2);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return this.moduleFilter.size() > 0 && this.moduleFilter.get(string2) != null && this.moduleFilter.get(string2).getIndex() <= logLevel.getIndex();
    }

    @Override
    public byte[] ecrypted(byte[] byArray, int n2, int n3) {
        return new byte[0];
    }

    @Override
    public byte[] ecrypted(byte[] byArray) {
        return new byte[0];
    }

    @Override
    public String compress(String string) {
        return null;
    }

    @Override
    public LogLevel getLogLevel(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return this.logLevel;
        }
        return this.moduleFilter.get(string) == null ? this.logLevel : this.moduleFilter.get(string);
    }

    @Override
    public void setLogLevel(String string) {
        this.updateLogLevel(TLogUtils.convertLogLevel(string));
    }

    @Override
    public boolean isOpenLog() {
        return true;
    }

    @Override
    @Deprecated
    public void setEndTime(long l2) {
    }

    @Override
    public void setModuleFilter(Map<String, LogLevel> map) {
        this.addModuleFilter(map);
    }

    @Override
    public void destroyLog(boolean bl) {
    }

    @Override
    public boolean checkLogLength(String string) {
        return false;
    }

    @Override
    public void openLog(boolean bl) {
    }

    private static class a {
        private static final TLogController a = new TLogController();
    }
}

