/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tao.log;

import android.text.TextUtils;
import android.util.Log;
import com.taobao.android.tlog.protocol.TLogSecret;
import com.taobao.tao.log.TLogInitializer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class TLogNative {
    private static String TAG = "TLOG.TLogNative";
    private static final int MAX_CACHE_CAPACITY = 100;
    private static final List<XLoggerInfo> sInitCache = new CopyOnWriteArrayList<XLoggerInfo>();
    public static final int AppednerModeAsync = 0;
    public static final int AppednerModeSync = 1;
    private static volatile boolean sOpenSoSuccess = false;

    public static void appenderOpen(int n2, String string, String string2, String string3, String string4) {
        try {
            System.loadLibrary("c++_shared");
            System.loadLibrary("marsxlog");
            sOpenSoSuccess = TLogNative.appenderOpen(n2, 0, string, string2, string3, string4);
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)"appenderOpen", (Throwable)throwable);
        }
    }

    public static void appenderFlushData(boolean bl) {
        try {
            TLogNative.appenderFlush(bl);
        }
        catch (Exception exception) {
            Log.e((String)"TLogNative", (String)"appenderFlushData failure", (Throwable)exception);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Log.e((String)"TLogNative", (String)"appenderFlushData failure, unsatisfied link error", (Throwable)unsatisfiedLinkError);
        }
    }

    static boolean isSoOpen() {
        return sOpenSoSuccess;
    }

    public static String getSecurityKey() {
        String string = TLogInitializer.getInstance().getSecurityKey();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "t_remote_debugger";
        }
        if (TLogInitializer.getInstance().isDebugable()) {
            Log.d((String)"SecurityKey", (String)string);
        }
        return string;
    }

    public static String getRc4EncryptSecretyKeyValue() {
        try {
            return TLogSecret.getInstance().getRc4EncryptSecretValue(TLogInitializer.getInstance().getSecurityKey());
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"please check rsa key", (Throwable)exception);
            return null;
        }
    }

    public static String getRsaPublicKeyMd5Value() {
        return TLogSecret.getInstance().getRsaMd5Value();
    }

    private static void logWrite(int n2, String string, String string2, String string3, String string4, String string5, String string6) {
        if (!sOpenSoSuccess) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string) && string2.contains(".")) {
            string = string2.substring(0, string2.indexOf("."));
            string2 = string2.substring(string2.indexOf(".") + 1, string2.length());
        }
        string = TextUtils.isEmpty((CharSequence)string) ? "module" : string;
        string2 = TextUtils.isEmpty((CharSequence)string2) ? "tag" : string2;
        try {
            TLogNative.logWrite2(n2, string, string2, string3, string4, string5, string6);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static void dispatch(int n2, String string, String string2, String string3, String string4, String string5, String string6) {
        if (TLogInitializer.getInstance().getInitState() == 2) {
            if (sInitCache.size() > 0) {
                Log.e((String)"tlog", (String)"flush log in asyncInit Mode");
                for (XLoggerInfo xLoggerInfo : sInitCache) {
                    TLogNative.logWrite(xLoggerInfo.level, xLoggerInfo.module, xLoggerInfo.tag, xLoggerInfo.type, xLoggerInfo.clientID, xLoggerInfo.serverID, xLoggerInfo.log);
                }
                sInitCache.clear();
            }
            TLogNative.logWrite(n2, string, string2, string3, string4, string5, string6);
            return;
        }
        if (TLogInitializer.getInstance().isInitSync()) {
            Log.w((String)"tlog", (String)"tlog isn't init,please call init() ,or initSync(bool) method !");
        } else {
            if (sInitCache.size() >= 100) {
                try {
                    sInitCache.remove(0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            XLoggerInfo xLoggerInfo = new XLoggerInfo();
            xLoggerInfo.level = n2;
            xLoggerInfo.module = string;
            xLoggerInfo.tag = string2;
            xLoggerInfo.type = string3;
            xLoggerInfo.clientID = string4;
            xLoggerInfo.serverID = string5;
            xLoggerInfo.log = string6;
            sInitCache.add(xLoggerInfo);
        }
    }

    private static native void logWrite(XLoggerInfo var0, String var1);

    private static native void logWrite2(int var0, String var1, String var2, String var3, String var4, String var5, String var6);

    public static native int getLogLevel();

    public static native void setLogLevel(int var0);

    public static native void addModuleFilter(String var0, int var1);

    public static native void cleanModuleFilter();

    public static native void setAppenderMode(int var0);

    public static native void setConsoleLogOpen(boolean var0);

    public static native boolean appenderOpen(int var0, int var1, String var2, String var3, String var4, String var5);

    public static native void appenderClose();

    public static native void appenderFlush(boolean var0);

    static class XLoggerInfo {
        public int level;
        public String tag;
        public String filename;
        public String funcname;
        public int line;
        public long pid;
        public long tid;
        public long maintid;
        public String module;
        public String type;
        public String clientID;
        public String serverID;
        public String log;

        XLoggerInfo() {
        }
    }
}

