/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tao.log;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.taobao.tao.log.LogLevel;
import com.taobao.tao.log.TLogInitializer;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TLogUtils {
    public static boolean checkNetworkIsWifi(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo.State state = connectivityManager.getNetworkInfo(1).getState();
        return state == NetworkInfo.State.CONNECTED;
    }

    public static String getNetWorkType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            int n2 = networkInfo.getType();
            if (n2 == 1) {
                return "WIFI";
            }
            if (n2 == 0) {
                switch (networkInfo.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return "2G";
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return "3G";
                    }
                    case 13: {
                        return "4G";
                    }
                }
            }
        } else {
            return "NOT_NETWORK";
        }
        return null;
    }

    public static boolean cleanDir(File file) {
        boolean bl = true;
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                for (File file2 : fileArray) {
                    bl &= TLogUtils.cleanDir(file2);
                }
            }
            return bl;
        }
        return file.delete();
    }

    public static List<String> getFilePath(String string, Integer n2) {
        int n3;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (TLogInitializer.getInstance().getFileDir() == null) {
            return null;
        }
        String string2 = TLogInitializer.getInstance().getFileDir();
        ArrayList<String> arrayList = null;
        File file = new File(string2);
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                return null;
            }
            arrayList = new ArrayList<String>();
            block0: for (n3 = 0; n3 < fileArray.length; ++n3) {
                String string3 = fileArray[n3].getName();
                if (string3.endsWith("mmap2")) continue;
                if (string3.equals(string)) {
                    arrayList.add(fileArray[n3].getAbsolutePath());
                    continue;
                }
                if (!string3.endsWith(string)) continue;
                if ((string3 = TLogUtils.parseDataInName(string3)) != null && arrayList.size() > 0) {
                    int n4 = arrayList.size();
                    for (int i2 = 0; i2 < n4; ++i2) {
                        File file2 = new File((String)arrayList.get(i2));
                        String string4 = file2.getName();
                        String string5 = TLogUtils.parseDataInName(string4);
                        if (string5 == null) continue;
                        if (string3.compareTo(string5) <= 0) {
                            arrayList.add(i2, fileArray[n3].getAbsolutePath());
                            continue block0;
                        }
                        if (i2 != n4 - 1) continue;
                        arrayList.add(fileArray[n3].getAbsolutePath());
                        continue block0;
                    }
                    continue;
                }
                arrayList.add(fileArray[n3].getAbsolutePath());
            }
        }
        if (n2 > 0 && arrayList != null && arrayList.size() > n2) {
            int n5 = arrayList.size() - n2;
            for (n3 = 0; n3 < n5; ++n3) {
                arrayList.remove(0);
            }
        }
        return arrayList;
    }

    public static List<String> getFilePath(String string) {
        File[] fileArray;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (TLogInitializer.getInstance().getFileDir() == null) {
            return null;
        }
        String string2 = TLogInitializer.getInstance().getFileDir();
        ArrayList<String> arrayList = null;
        File file = new File(string2);
        if (file.exists() && (fileArray = file.listFiles()) != null && fileArray.length != 0) {
            arrayList = new ArrayList<String>();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                String string3 = fileArray[i2].getName();
                if (!string3.equals(string)) continue;
                arrayList.add(fileArray[i2].getAbsolutePath());
                break;
            }
        }
        return arrayList;
    }

    public static List<String> getFilePath(String string, int n2, String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (TLogInitializer.getInstance().getFileDir() == null) {
            return null;
        }
        String string2 = TLogInitializer.getInstance().getFileDir();
        ArrayList<String> arrayList = null;
        File file = new File(string2);
        if (file.exists()) {
            object3 = file.listFiles();
            if (object3 == null || ((File[])object3).length == 0) {
                return null;
            }
            arrayList = new ArrayList<String>();
            block0: for (int i2 = 0; i2 < ((File[])object3).length; ++i2) {
                Object object4;
                Object object5;
                object2 = object3[i2].getName();
                if (((String)object2).endsWith("mmap2")) continue;
                if (((String)object2).equals(string)) {
                    arrayList.add(object3[i2].getAbsolutePath());
                    continue;
                }
                if (!((String)object2).startsWith(string)) continue;
                if (stringArray != null) {
                    SimpleDateFormat simpleDateFormat;
                    object = TLogUtils.parseDataInName((String)object2);
                    if (TextUtils.isEmpty((CharSequence)object) || TextUtils.equals((CharSequence)(object5 = (simpleDateFormat = new SimpleDateFormat("yyyyMMdd")).format(new Date())), (CharSequence)object) && ((String[])(object4 = ((String)object2).split("_"))).length == 2) continue;
                    object4 = stringArray;
                    int n3 = ((String[])object4).length;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        String string3 = object4[i3];
                        if (!TextUtils.equals((CharSequence)string3, (CharSequence)object)) continue;
                        arrayList.add(object3[i2].getAbsolutePath());
                        continue block0;
                    }
                    continue;
                }
                if ((object2 = TLogUtils.parseDataInName((String)object2)) == null) continue;
                if (arrayList.size() > 0) {
                    int n4 = arrayList.size();
                    for (int i4 = 0; i4 < n4; ++i4) {
                        object5 = new File((String)arrayList.get(i4));
                        object4 = ((File)object5).getName();
                        String string4 = TLogUtils.parseDataInName((String)object4);
                        if (string4 == null) continue;
                        if (((String)object2).compareTo(string4) > 0) {
                            arrayList.add(i4, object3[i2].getAbsolutePath());
                            continue block0;
                        }
                        if (i4 != n4 - 1) continue;
                        arrayList.add(object3[i2].getAbsolutePath());
                        continue block0;
                    }
                    continue;
                }
                arrayList.add(object3[i2].getAbsolutePath());
            }
        }
        if (n2 > 0 && arrayList != null) {
            object2 = new HashSet();
            object = arrayList.iterator();
            while (object.hasNext()) {
                object3 = (String)object.next();
                String string5 = TLogUtils.parseDataInName((String)object3);
                if (string5 != null) {
                    if (object2.size() <= n2) {
                        object2.add(string5);
                        if (object2.size() <= n2) continue;
                        object.remove();
                        continue;
                    }
                    object.remove();
                    continue;
                }
                object.remove();
            }
        }
        return arrayList;
    }

    public static void transferTodayFileIfNeeded(String[] stringArray) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String string = simpleDateFormat.format(new Date());
        boolean bl = false;
        if (stringArray != null) {
            for (int i2 = 0; i2 != stringArray.length; ++i2) {
                if (!TextUtils.equals((CharSequence)string, (CharSequence)stringArray[i2])) continue;
                bl = true;
                break;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            return;
        }
        String string2 = TLogInitializer.getInstance().getFileDir();
        File file = new File(string2);
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                return;
            }
            block1: for (int i3 = 0; i3 < fileArray.length; ++i3) {
                String[] stringArray2;
                String string3;
                String string4 = fileArray[i3].getName();
                if (string4.endsWith("mmap2") || !TextUtils.equals((CharSequence)string, (CharSequence)(string3 = TLogUtils.parseDataInName(string4))) || fileArray[i3].length() == 0L || (stringArray2 = string4.split("_")).length != 2) continue;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(stringArray2[0]).append('_');
                string3 = stringArray2[1];
                int n2 = string3.indexOf(".");
                if (n2 == -1) continue;
                String string5 = stringBuilder.append(string3.substring(0, n2)).append('_').toString();
                for (int i4 = 1; i4 < 10000; ++i4) {
                    File file2 = new File(fileArray[i3].getParent(), string5 + i4 + "." + string3.substring(n2 + 1));
                    if (file2.exists()) continue;
                    boolean bl2 = fileArray[i3].renameTo(file2);
                    continue block1;
                }
            }
        }
    }

    public static String parseDataInName(String string) {
        String string2;
        String[] stringArray = string.split("_");
        if (stringArray != null && stringArray.length == 3) {
            string2 = stringArray[1];
        } else if (stringArray != null && stringArray.length == 2) {
            string2 = stringArray[1];
            int n2 = string2.indexOf(".");
            if (n2 == -1) {
                return null;
            }
            string2 = string2.substring(0, n2);
        } else {
            return null;
        }
        return string2;
    }

    public static Map<String, LogLevel> makeModule(String string) {
        HashMap<String, LogLevel> hashMap = null;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (string.equalsIgnoreCase("off")) {
            return null;
        }
        String[] stringArray = string.split(",");
        if (stringArray != null) {
            hashMap = new HashMap<String, LogLevel>();
            for (String string2 : stringArray) {
                String[] stringArray2 = string2.split("@");
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                if (stringArray2.length == 1) {
                    hashMap.put(stringArray2[0].toLowerCase(), LogLevel.E);
                    continue;
                }
                if (stringArray2.length != 2) continue;
                hashMap.put(stringArray2[0].toLowerCase(), TLogUtils.convertLogLevel(stringArray2[1]));
            }
        }
        return hashMap;
    }

    public static LogLevel convertLogLevel(String string) {
        LogLevel logLevel = LogLevel.L;
        if ("ERROR".equalsIgnoreCase(string)) {
            logLevel = LogLevel.E;
        } else if ("WARN".equalsIgnoreCase(string)) {
            logLevel = LogLevel.W;
        } else if ("INFO".equalsIgnoreCase(string)) {
            logLevel = LogLevel.I;
        } else if ("DEBUG".equalsIgnoreCase(string)) {
            logLevel = LogLevel.D;
        } else if ("VERBOSE".equalsIgnoreCase(string)) {
            logLevel = LogLevel.V;
        }
        return logLevel;
    }
}

