/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tao.log.upload;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSONObject;
import com.taobao.android.tlog.protocol.model.CommandInfo;
import com.taobao.android.tlog.protocol.model.reply.base.UploadTokenInfo;
import com.taobao.tao.log.TLog;
import com.taobao.tao.log.TLogInitializer;
import com.taobao.tao.log.TLogUtils;
import com.taobao.tao.log.monitor.TLogStage;
import com.taobao.tao.log.task.c;
import com.taobao.tao.log.task.l;
import com.taobao.tao.log.upload.FileUploadListener;
import com.taobao.tao.log.upload.LogUploader;
import com.taobao.tao.log.upload.UploadQueue;
import com.taobao.tao.log.upload.UploaderParam;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LogFileUploadManager {
    private static String TAG = "TLog.LogFileUploadManager";
    private Context mContext;
    private boolean isUploading = false;
    private JSONObject mExtData;
    private List<String> mFiles;
    public boolean isForceUpload = false;
    public CommandInfo mParmas;
    public String uploadId;
    public String tokenType;
    public UploadTokenInfo[] tokenInfos;

    public LogFileUploadManager(Context context) {
        this.mContext = context.getApplicationContext();
        this.mFiles = new ArrayList<String>();
    }

    private Map<String, String> getTokenParam(String string) {
        if (this.tokenInfos != null) {
            for (UploadTokenInfo uploadTokenInfo : this.tokenInfos) {
                if (uploadTokenInfo.fileInfo == null || !string.equals(uploadTokenInfo.fileInfo.absolutePath)) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (Map.Entry entry : uploadTokenInfo.entrySet()) {
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
                return hashMap;
            }
        }
        this.uploadFailed(string, "unknown", "1", "404", "tokenNotFound");
        return null;
    }

    private String getFileContentType(String string) {
        if (this.tokenInfos != null) {
            for (UploadTokenInfo uploadTokenInfo : this.tokenInfos) {
                if (uploadTokenInfo.fileInfo == null || !string.equals(uploadTokenInfo.fileInfo.absolutePath)) continue;
                return uploadTokenInfo.fileInfo.contentType;
            }
        }
        return null;
    }

    public void startUpload() {
        this.upload();
    }

    private void uploadCancelHandler() {
        LogUploader logUploader = TLogInitializer.getInstance().getLogUploader();
        if (logUploader != null) {
            logUploader.cancel();
        } else {
            Log.w((String)TAG, (String)"you need impl file uploader ");
        }
        TLog.logi("TLOG", TAG, "Cancel : the mCurrentUploadFileInfo is null !");
        this.persistTask();
        this.finish("\u7f51\u7edc\u72b6\u6001\u53d8\u66f4\uff0c\u4e0d\u7b26\u5408\u4e0a\u4f20\u65e5\u5fd7\u6761\u4ef6\u505c\u6b62\u4e0a\u4f20\uff01", false, "5", "");
    }

    private void upload() {
        if (this.mFiles.size() <= 0) {
            this.uploadFinish("There is not files to upload!", false, "3", "");
            return;
        }
        if (!this.checkNetworkIsWifi()) {
            this.persistTask();
            this.finish("\u7f51\u8def\u72b6\u6001\u4e0d\u7b26\u5408\u4e0a\u4f20\u6761\u4ef6\uff01", false, "5", "");
            TLogInitializer.getInstance().gettLogMonitor().stageError(TLogStage.MSG_LOG_UPLOAD, TAG, "\u6587\u4ef6\u4e0a\u4f20\uff1a\u7f51\u8def\u72b6\u6001\u4e0d\u7b26\u5408\u4e0a\u4f20\u6761\u4ef6,uploadId=" + this.uploadId + " isForceUpload:" + this.isForceUpload);
            return;
        }
        LogUploader logUploader = TLogInitializer.getInstance().getLogUploader();
        if (logUploader == null) {
            TLogInitializer.getInstance().gettLogMonitor().stageError(TLogStage.MSG_LOG_UPLOAD, TAG, "\u6587\u4ef6\u4e0a\u4f20\uff1a\u6ca1\u6709\u5b9e\u73b0\u6587\u4ef6\u4e0a\u4f20\u901a\u9053,uploadId=" + this.uploadId);
        }
        for (String string : this.mFiles) {
            File file = new File(string);
            if (!file.exists() || file.length() == 0L) {
                file.delete();
                continue;
            }
            TLogInitializer.getInstance().gettLogMonitor().stageInfo(TLogStage.MSG_LOG_UPLOAD_COUNT, "MSG LOG UPLOAD COUNT", "\u6587\u4ef6\u4e0a\u4f20\uff1a\u4e0a\u4f20\u6587\u4ef6");
            TLogInitializer.getInstance().gettLogMonitor().stageInfo(TLogStage.MSG_LOG_UPLOAD, TAG, "\u6587\u4ef6\u4e0a\u4f20\uff1a\u6821\u9a8c\u901a\u8fc7\uff0c\u5f00\u59cb\u6267\u884c\u6587\u4ef6\u4e0a\u4f20,uploadId=" + this.uploadId);
            UploaderParam uploaderParam = new UploaderParam();
            uploaderParam.build(this.mParmas);
            uploaderParam.context = this.mContext;
            uploaderParam.appVersion = TLogInitializer.getInstance().getAppVersion();
            uploaderParam.params = this.getTokenParam(string);
            uploaderParam.fileContentType = this.getFileContentType(string);
            String string2 = null;
            String string3 = null;
            if (logUploader.getUploadInfo().type.equals("oss")) {
                if (uploaderParam.params != null) {
                    string2 = uploaderParam.params.get("ossObjectKey");
                    string3 = uploaderParam.params.get("ossEndpoint");
                } else {
                    TLogInitializer.getInstance().gettLogMonitor().stageError(TLogStage.MSG_LOG_UPLOAD, TAG, "\u6587\u4ef6\u4e0a\u4f20\uff1aoss->params is null, uploadId=" + this.uploadId);
                }
                if (uploaderParam.params != null && !uploaderParam.params.containsKey("ossBucketName")) {
                    uploaderParam.params.put("ossBucketName", TLogInitializer.getInstance().ossBucketName);
                }
            } else if (logUploader.getUploadInfo().type.equals("arup")) {
                if (uploaderParam.params != null) {
                    string2 = uploaderParam.params.get("ossObjectKey");
                    string3 = uploaderParam.params.get("ossEndpoint");
                } else {
                    TLogInitializer.getInstance().gettLogMonitor().stageError(TLogStage.MSG_LOG_UPLOAD, TAG, "\u6587\u4ef6\u4e0a\u4f20\uff1aarup->params is null, uploadId=" + this.uploadId);
                }
                if (uploaderParam.params != null && !uploaderParam.params.containsKey("ossBucketName")) {
                    uploaderParam.params.put("ossBucketName", TLogInitializer.getInstance().ossBucketName);
                }
            } else if (logUploader.getUploadInfo().type.equals("ceph")) {
                if (uploaderParam.params != null) {
                    string2 = uploaderParam.params.get("objectKey");
                    string3 = uploaderParam.params.get("endpoint");
                } else {
                    TLogInitializer.getInstance().gettLogMonitor().stageError(TLogStage.MSG_LOG_UPLOAD, TAG, "\u6587\u4ef6\u4e0a\u4f20\uff1aceph->params is null, uploadId=" + this.uploadId);
                }
            } else {
                TLogInitializer.getInstance().gettLogMonitor().stageError(TLogStage.MSG_LOG_UPLOAD, TAG, "\u6587\u4ef6\u4e0a\u4f20\uff1anot support this type:" + logUploader.getUploadInfo().type + ", uploadId=" + this.uploadId);
            }
            TLogInitializer.getInstance().gettLogMonitor().stageInfo(TLogStage.MSG_LOG_UPLOAD, TAG, "\u6587\u4ef6\u4e0a\u4f20\uff1a\u6821\u9a8c\u901a\u8fc7\uff0c\u8c03\u7528\u4e0a\u4f20\u901a\u9053,uploadId=" + this.uploadId);
            logUploader.startUpload(uploaderParam, string, new TLogUploadListener(string, uploaderParam.fileContentType, string2, string3));
        }
    }

    public void addFiles(List<String> list) {
        if (this.mFiles == null) {
            this.mFiles = new ArrayList<String>();
        }
        if (list != null && list.size() > 0) {
            for (String string : list) {
                if (this.mFiles.contains(string)) continue;
                this.mFiles.add(string);
            }
        }
    }

    public void addFile(String string) {
        if (this.mFiles == null) {
            this.mFiles = new ArrayList<String>();
        }
        if (!TextUtils.isEmpty((CharSequence)string) && !this.mFiles.contains(string)) {
            this.mFiles.add(string);
        }
    }

    public int getUploadTaskCount() {
        if (this.mFiles != null) {
            return this.mFiles.size();
        }
        return 0;
    }

    private void finish(String string, boolean bl, String string2, String string3) {
        if (this.mFiles != null) {
            this.mFiles.clear();
        }
        this.uploadFinish(string, bl, string2, string3);
        TLog.logi("TLOG", TAG, string + " and quit the handlerThread!");
        this.isForceUpload = false;
    }

    private void persistTask() {
        TLog.logi("TLOG", TAG, "[persistTask] there is " + this.mFiles.size() + " task!");
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)TLogInitializer.getInstance().getContext());
        SharedPreferences.Editor editor = sharedPreferences.edit();
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = this.mFiles.size();
        if (n2 < 1) {
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            hashSet.add(this.mFiles.get(i2));
        }
        editor.putStringSet("tlog_upload_files", hashSet);
        editor.putString("userId", this.mParmas.userId);
        editor.putString("serviceId", this.mParmas.serviceId);
        editor.putString("serialNumber", this.mParmas.sessionId + "");
        if (this.mExtData != null) {
            editor.putString("tlog_upload_extdata", this.mExtData.toJSONString());
        }
        editor.commit();
    }

    private void remotePersistTask() {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)TLogInitializer.getInstance().getContext());
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove("tlog_upload_files");
        editor.remove("userId");
        editor.remove("serviceId");
        editor.remove("serialNumber");
        editor.remove("taskId");
        editor.remove("tlog_upload_type");
        if (sharedPreferences.contains("tlog_upload_extdata")) {
            editor.remove("tlog_upload_extdata");
        }
        editor.commit();
    }

    private boolean checkNetworkIsWifi() {
        if (this.isForceUpload) {
            return true;
        }
        return TLogUtils.checkNetworkIsWifi(this.mContext);
    }

    public boolean isUploading() {
        return this.isUploading;
    }

    private String getPrefixName(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            int n2 = string.indexOf("_");
            string = string.substring(0, n2);
            return string;
        }
        return null;
    }

    public void uploadFailed(String string, String string2, String string3, String string4, String string5) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u6587\u4ef6\u4e0a\u4f20\uff1a\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,uploadId=").append(this.uploadId == null ? "-" : this.uploadId).append(" file path=").append(string == null ? "-" : string).append(" error info=").append(string5 == null ? "-" : string5);
        TLogInitializer.getInstance().gettLogMonitor().stageError(TLogStage.MSG_LOG_UPLOAD, TAG, stringBuilder.toString());
        if (this.mParmas.opCode.equals("RDWP_APPLY_UPLOAD_TOKEN_REPLY")) {
            FileUploadListener fileUploadListener;
            l.b(this.mParmas, this.uploadId, string, string3, string4, string5, string2);
            if (this.uploadId != null && (fileUploadListener = UploadQueue.getInstance().popListener(this.uploadId)) != null) {
                fileUploadListener.onError(string3, string5, string4);
            }
        } else {
            FileUploadListener fileUploadListener;
            c.b(this.mParmas, this.uploadId, string, string3, string4, string5, string2);
            if (this.mParmas.requestId != null && (fileUploadListener = UploadQueue.getInstance().popListener(this.mParmas.requestId)) != null) {
                fileUploadListener.onError(string3, string5, string4);
            }
        }
        TLog.logi("TLOG", TAG, " upload remote file failure!");
        this.isForceUpload = false;
    }

    public void uploadSuccessed(String string, String string2, String string3, String string4, String string5) {
        this.uploadId = this.uploadId == null ? "-" : this.uploadId;
        string = string == null ? "-" : string;
        TLogInitializer.getInstance().gettLogMonitor().stageInfo(TLogStage.MSG_LOG_UPLOAD, TAG, "\u6587\u4ef6\u4e0a\u4f20\uff1a\u6587\u4ef6\u4e0a\u4f20\u6210\u529f,uploadId=" + this.uploadId + " file path=" + string);
        if (this.mParmas.opCode.equals("RDWP_APPLY_UPLOAD_TOKEN_REPLY")) {
            FileUploadListener fileUploadListener;
            l.a(this.mParmas, this.uploadId, string, string3, string2, string4, string5);
            if (this.uploadId != null && (fileUploadListener = UploadQueue.getInstance().popListener(this.uploadId)) != null) {
                fileUploadListener.onSucessed(string, string3);
            }
        } else {
            FileUploadListener fileUploadListener;
            c.a(this.mParmas, this.uploadId, string, string3, string2, string4, string5);
            if (this.mParmas.requestId != null && (fileUploadListener = UploadQueue.getInstance().popListener(this.mParmas.requestId)) != null) {
                fileUploadListener.onSucessed(string, string3);
            }
        }
        TLog.logi("TLOG", TAG, " upload remote file success!");
        this.isForceUpload = false;
        TLogUtils.cleanDir(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFinish(String string, boolean bl, String string2, String string3) {
        if (string != null) {
            if (!bl && TextUtils.isEmpty((CharSequence)string3)) {
                string3 = string;
            }
            this.mExtData = null;
        }
        LogFileUploadManager logFileUploadManager = this;
        synchronized (logFileUploadManager) {
            this.isUploading = false;
        }
    }

    public class TLogUploadListener
    implements FileUploadListener {
        private String fileName;
        private String contentType;
        private String ossObjectKey;
        private String ossEndpoint;

        public TLogUploadListener(String string, String string2, String string3, String string4) {
            this.fileName = string;
            this.contentType = string2;
            this.ossObjectKey = string3;
            this.ossEndpoint = string4;
        }

        @Override
        public void onError(String string, String string2, String string3) {
            LogFileUploadManager.this.uploadFailed(this.fileName, this.contentType, string, string2, string3);
            TLogInitializer.getInstance().gettLogMonitor().stageInfo(TLogStage.MSG_LOG_UPLOAD_COUNT, "MSG LOG UPLOAD", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\u4e86\uff1a\u68c0\u6d4b\u662f\u5426\u8fd8\u6709\u6587\u4ef6\u53ef\u4e0a\u4f20  \u662f\u5426\u5f00\u542f\u5f3a\u5236\u4e0a\u4f20\uff1a" + LogFileUploadManager.this.isForceUpload);
        }

        @Override
        public void onSucessed(String string, String string2) {
            LogFileUploadManager.this.uploadSuccessed(string, this.contentType, string2, this.ossObjectKey, this.ossEndpoint);
            LogFileUploadManager.this.isForceUpload = true;
            TLogInitializer.getInstance().gettLogMonitor().stageInfo(TLogStage.MSG_LOG_UPLOAD_COUNT, "MSG LOG UPLOAD", "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\u4e86\uff1a\u68c0\u6d4b\u662f\u5426\u8fd8\u6709\u6587\u4ef6\u53ef\u4e0a\u4f20  \u662f\u5426\u5f00\u542f\u5f3a\u5236\u4e0a\u4f20\uff1a" + LogFileUploadManager.this.isForceUpload);
        }
    }
}

