/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.parser.ResponseParseException;
import com.aliyun.oss.common.parser.ResponseParser;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.common.utils.StringUtils;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.model.OSSErrorResult;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.AccessMonitor;
import com.aliyun.oss.model.AccessPoint;
import com.aliyun.oss.model.AccessPointEndpoints;
import com.aliyun.oss.model.AccessPointVpcConfiguration;
import com.aliyun.oss.model.AddBucketCnameResult;
import com.aliyun.oss.model.AddBucketReplicationRequest;
import com.aliyun.oss.model.Aggregation;
import com.aliyun.oss.model.AggregationGroup;
import com.aliyun.oss.model.AggregationGroups;
import com.aliyun.oss.model.Aggregations;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.AsyncFetchTaskConfiguration;
import com.aliyun.oss.model.AsyncFetchTaskState;
import com.aliyun.oss.model.AsyncProcessObjectResult;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketInfo;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.BucketLoggingResult;
import com.aliyun.oss.model.BucketMetadata;
import com.aliyun.oss.model.BucketProcess;
import com.aliyun.oss.model.BucketQosInfo;
import com.aliyun.oss.model.BucketReferer;
import com.aliyun.oss.model.BucketReplicationProgress;
import com.aliyun.oss.model.BucketStat;
import com.aliyun.oss.model.BucketVersioningConfiguration;
import com.aliyun.oss.model.BucketWebsiteResult;
import com.aliyun.oss.model.CORSConfiguration;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CnameConfiguration;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.CreateAccessPointResult;
import com.aliyun.oss.model.CreateBucketCnameTokenResult;
import com.aliyun.oss.model.CreateBucketDataRedundancyTransitionResult;
import com.aliyun.oss.model.CreateLiveChannelResult;
import com.aliyun.oss.model.DataRedundancyType;
import com.aliyun.oss.model.DeleteDirectoryResult;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.DeleteVersionsResult;
import com.aliyun.oss.model.DescribeRegionsResult;
import com.aliyun.oss.model.DoMetaQueryResult;
import com.aliyun.oss.model.GenericResult;
import com.aliyun.oss.model.GetAccessPointPolicyResult;
import com.aliyun.oss.model.GetAccessPointResult;
import com.aliyun.oss.model.GetAsyncFetchTaskResult;
import com.aliyun.oss.model.GetBucketArchiveDirectReadResult;
import com.aliyun.oss.model.GetBucketCallbackPolicyResult;
import com.aliyun.oss.model.GetBucketCnameTokenResult;
import com.aliyun.oss.model.GetBucketDataRedundancyTransitionResult;
import com.aliyun.oss.model.GetBucketHttpsConfigResult;
import com.aliyun.oss.model.GetBucketImageResult;
import com.aliyun.oss.model.GetBucketInventoryConfigurationResult;
import com.aliyun.oss.model.GetBucketPolicyResult;
import com.aliyun.oss.model.GetBucketPolicyStatusResult;
import com.aliyun.oss.model.GetBucketPublicAccessBlockResult;
import com.aliyun.oss.model.GetBucketRequestPaymentResult;
import com.aliyun.oss.model.GetBucketResourceGroupResult;
import com.aliyun.oss.model.GetBucketWormResult;
import com.aliyun.oss.model.GetImageStyleResult;
import com.aliyun.oss.model.GetMetaQueryStatusResult;
import com.aliyun.oss.model.GetPublicAccessBlockResult;
import com.aliyun.oss.model.GroupGrantee;
import com.aliyun.oss.model.ImageProcess;
import com.aliyun.oss.model.InitiateBucketWormResult;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.InventoryConfiguration;
import com.aliyun.oss.model.InventoryDestination;
import com.aliyun.oss.model.InventoryEncryption;
import com.aliyun.oss.model.InventoryFilter;
import com.aliyun.oss.model.InventoryOSSBucketDestination;
import com.aliyun.oss.model.InventorySchedule;
import com.aliyun.oss.model.InventoryServerSideEncryptionKMS;
import com.aliyun.oss.model.InventoryServerSideEncryptionOSS;
import com.aliyun.oss.model.LifecycleFilter;
import com.aliyun.oss.model.LifecycleNot;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.ListAccessPointsResult;
import com.aliyun.oss.model.ListBucketInventoryConfigurationsResult;
import com.aliyun.oss.model.ListObjectsV2Result;
import com.aliyun.oss.model.ListUserDataRedundancyTransitionResult;
import com.aliyun.oss.model.LiveChannel;
import com.aliyun.oss.model.LiveChannelInfo;
import com.aliyun.oss.model.LiveChannelListing;
import com.aliyun.oss.model.LiveChannelStat;
import com.aliyun.oss.model.LiveChannelStatus;
import com.aliyun.oss.model.LiveChannelTarget;
import com.aliyun.oss.model.LiveRecord;
import com.aliyun.oss.model.MultipartUpload;
import com.aliyun.oss.model.MultipartUploadListing;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.OSSSymlink;
import com.aliyun.oss.model.OSSTagging;
import com.aliyun.oss.model.OSSUserMeta;
import com.aliyun.oss.model.OSSVersionSummary;
import com.aliyun.oss.model.ObjectAcl;
import com.aliyun.oss.model.ObjectFile;
import com.aliyun.oss.model.ObjectFiles;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.ObjectPermission;
import com.aliyun.oss.model.Owner;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.PartSummary;
import com.aliyun.oss.model.Payer;
import com.aliyun.oss.model.Permission;
import com.aliyun.oss.model.PolicyCallbackItem;
import com.aliyun.oss.model.PushflowStatus;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.RegionInfo;
import com.aliyun.oss.model.ReplicationRule;
import com.aliyun.oss.model.ReplicationStatus;
import com.aliyun.oss.model.RestoreObjectResult;
import com.aliyun.oss.model.RoutingRule;
import com.aliyun.oss.model.ServerSideEncryptionByDefault;
import com.aliyun.oss.model.ServerSideEncryptionConfiguration;
import com.aliyun.oss.model.SetAsyncFetchTaskResult;
import com.aliyun.oss.model.SetBucketCORSRequest;
import com.aliyun.oss.model.SimplifiedObjectMeta;
import com.aliyun.oss.model.StorageClass;
import com.aliyun.oss.model.Style;
import com.aliyun.oss.model.Tag;
import com.aliyun.oss.model.TagSet;
import com.aliyun.oss.model.Tagging;
import com.aliyun.oss.model.TransferAcceleration;
import com.aliyun.oss.model.UploadPartCopyResult;
import com.aliyun.oss.model.UserMeta;
import com.aliyun.oss.model.UserQos;
import com.aliyun.oss.model.UserQosInfo;
import com.aliyun.oss.model.VersionListing;
import com.aliyun.oss.model.VoidResult;
import com.aliyun.oss.model.VpcPolicy;
import com.aliyun.oss.model.Vpcip;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CheckedInputStream;
import org.codehaus.jettison.json.JSONObject;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.JDOMParseException;
import org.jdom2.input.SAXBuilder;

public final class ResponseParsers {
    public static final ListBucketResponseParser listBucketResponseParser = new ListBucketResponseParser();
    public static final ListImageStyleResponseParser listImageStyleResponseParser = new ListImageStyleResponseParser();
    public static final GetBucketRefererResponseParser getBucketRefererResponseParser = new GetBucketRefererResponseParser();
    public static final GetBucketAclResponseParser getBucketAclResponseParser = new GetBucketAclResponseParser();
    public static final GetBucketMetadataResponseParser getBucketMetadataResponseParser = new GetBucketMetadataResponseParser();
    public static final GetBucketLocationResponseParser getBucketLocationResponseParser = new GetBucketLocationResponseParser();
    public static final GetBucketLoggingResponseParser getBucketLoggingResponseParser = new GetBucketLoggingResponseParser();
    public static final GetBucketWebsiteResponseParser getBucketWebsiteResponseParser = new GetBucketWebsiteResponseParser();
    public static final GetBucketLifecycleResponseParser getBucketLifecycleResponseParser = new GetBucketLifecycleResponseParser();
    public static final GetBucketCorsResponseParser getBucketCorsResponseParser = new GetBucketCorsResponseParser();
    public static final GetBucketImageResponseParser getBucketImageResponseParser = new GetBucketImageResponseParser();
    public static final GetImageStyleResponseParser getImageStyleResponseParser = new GetImageStyleResponseParser();
    public static final GetBucketImageProcessConfResponseParser getBucketImageProcessConfResponseParser = new GetBucketImageProcessConfResponseParser();
    public static final GetTaggingResponseParser getTaggingResponseParser = new GetTaggingResponseParser();
    public static final GetBucketReplicationResponseParser getBucketReplicationResponseParser = new GetBucketReplicationResponseParser();
    public static final GetBucketReplicationProgressResponseParser getBucketReplicationProgressResponseParser = new GetBucketReplicationProgressResponseParser();
    public static final GetBucketReplicationLocationResponseParser getBucketReplicationLocationResponseParser = new GetBucketReplicationLocationResponseParser();
    public static final AddBucketCnameResponseParser addBucketCnameResponseParser = new AddBucketCnameResponseParser();
    public static final GetBucketCnameResponseParser getBucketCnameResponseParser = new GetBucketCnameResponseParser();
    public static final CreateBucketCnameTokenResponseParser createBucketCnameTokenResponseParser = new CreateBucketCnameTokenResponseParser();
    public static final GetBucketCnameTokenResponseParser getBucketCnameTokenResponseParser = new GetBucketCnameTokenResponseParser();
    public static final GetBucketInfoResponseParser getBucketInfoResponseParser = new GetBucketInfoResponseParser();
    public static final GetBucketStatResponseParser getBucketStatResponseParser = new GetBucketStatResponseParser();
    public static final GetBucketQosResponseParser getBucketQosResponseParser = new GetBucketQosResponseParser();
    public static final GetBucketVersioningResponseParser getBucketVersioningResponseParser = new GetBucketVersioningResponseParser();
    public static final GetBucketEncryptionResponseParser getBucketEncryptionResponseParser = new GetBucketEncryptionResponseParser();
    public static final GetBucketPolicyResponseParser getBucketPolicyResponseParser = new GetBucketPolicyResponseParser();
    public static final GetBucketRequestPaymentResponseParser getBucketRequestPaymentResponseParser = new GetBucketRequestPaymentResponseParser();
    public static final GetUSerQosInfoResponseParser getUSerQosInfoResponseParser = new GetUSerQosInfoResponseParser();
    public static final GetBucketQosInfoResponseParser getBucketQosInfoResponseParser = new GetBucketQosInfoResponseParser();
    public static final SetAsyncFetchTaskResponseParser setAsyncFetchTaskResponseParser = new SetAsyncFetchTaskResponseParser();
    public static final GetAsyncFetchTaskResponseParser getAsyncFetchTaskResponseParser = new GetAsyncFetchTaskResponseParser();
    public static final CreateVpcipResultResponseParser createVpcipResultResponseParser = new CreateVpcipResultResponseParser();
    public static final ListVpcipResultResponseParser listVpcipResultResponseParser = new ListVpcipResultResponseParser();
    public static final ListVpcPolicyResultResponseParser listVpcPolicyResultResponseParser = new ListVpcPolicyResultResponseParser();
    public static final InitiateBucketWormResponseParser initiateBucketWormResponseParser = new InitiateBucketWormResponseParser();
    public static final GetBucketWormResponseParser getBucketWormResponseParser = new GetBucketWormResponseParser();
    public static final GetBucketResourceGroupResponseParser getBucketResourceGroupResponseParser = new GetBucketResourceGroupResponseParser();
    public static final GetBucketTransferAccelerationResponseParser getBucketTransferAccelerationResponseParser = new GetBucketTransferAccelerationResponseParser();
    public static final GetBucketInventoryConfigurationParser getBucketInventoryConfigurationParser = new GetBucketInventoryConfigurationParser();
    public static final ListBucketInventoryConfigurationsParser listBucketInventoryConfigurationsParser = new ListBucketInventoryConfigurationsParser();
    public static final ListObjectsReponseParser listObjectsReponseParser = new ListObjectsReponseParser();
    public static final ListObjectsV2ResponseParser listObjectsV2ResponseParser = new ListObjectsV2ResponseParser();
    public static final ListVersionsReponseParser listVersionsReponseParser = new ListVersionsReponseParser();
    public static final PutObjectReponseParser putObjectReponseParser = new PutObjectReponseParser();
    public static final PutObjectProcessReponseParser putObjectProcessReponseParser = new PutObjectProcessReponseParser();
    public static final AppendObjectResponseParser appendObjectResponseParser = new AppendObjectResponseParser();
    public static final GetObjectMetadataResponseParser getObjectMetadataResponseParser = new GetObjectMetadataResponseParser();
    public static final CopyObjectResponseParser copyObjectResponseParser = new CopyObjectResponseParser();
    public static final DeleteObjectsResponseParser deleteObjectsResponseParser = new DeleteObjectsResponseParser();
    public static final DeleteVersionsResponseParser deleteVersionsResponseParser = new DeleteVersionsResponseParser();
    public static final GetObjectAclResponseParser getObjectAclResponseParser = new GetObjectAclResponseParser();
    public static final GetSimplifiedObjectMetaResponseParser getSimplifiedObjectMetaResponseParser = new GetSimplifiedObjectMetaResponseParser();
    public static final RestoreObjectResponseParser restoreObjectResponseParser = new RestoreObjectResponseParser();
    public static final ProcessObjectResponseParser processObjectResponseParser = new ProcessObjectResponseParser();
    public static final HeadObjectResponseParser headObjectResponseParser = new HeadObjectResponseParser();
    public static final CompleteMultipartUploadResponseParser completeMultipartUploadResponseParser = new CompleteMultipartUploadResponseParser();
    public static final CompleteMultipartUploadProcessResponseParser completeMultipartUploadProcessResponseParser = new CompleteMultipartUploadProcessResponseParser();
    public static final InitiateMultipartUploadResponseParser initiateMultipartUploadResponseParser = new InitiateMultipartUploadResponseParser();
    public static final ListMultipartUploadsResponseParser listMultipartUploadsResponseParser = new ListMultipartUploadsResponseParser();
    public static final ListPartsResponseParser listPartsResponseParser = new ListPartsResponseParser();
    public static final CreateLiveChannelResponseParser createLiveChannelResponseParser = new CreateLiveChannelResponseParser();
    public static final GetLiveChannelInfoResponseParser getLiveChannelInfoResponseParser = new GetLiveChannelInfoResponseParser();
    public static final GetLiveChannelStatResponseParser getLiveChannelStatResponseParser = new GetLiveChannelStatResponseParser();
    public static final GetLiveChannelHistoryResponseParser getLiveChannelHistoryResponseParser = new GetLiveChannelHistoryResponseParser();
    public static final ListLiveChannelsReponseParser listLiveChannelsReponseParser = new ListLiveChannelsReponseParser();
    public static final GetSymbolicLinkResponseParser getSymbolicLinkResponseParser = new GetSymbolicLinkResponseParser();
    public static final DeleteDirectoryResponseParser deleteDirectoryResponseParser = new DeleteDirectoryResponseParser();
    public static final GetBucketAccessMonitorResponseParser getBucketAccessMonitorResponseParser = new GetBucketAccessMonitorResponseParser();
    public static final GetMetaQueryStatusResponseParser getMetaQueryStatusResponseParser = new GetMetaQueryStatusResponseParser();
    public static final DoMetaQueryResponseParser doMetaQueryResponseParser = new DoMetaQueryResponseParser();
    public static final DescribeRegionsResponseParser describeRegionsResponseParser = new DescribeRegionsResponseParser();
    public static final GetBucketCallbackPolicyResponseParser getBucketCallbackPolicyResponseParser = new GetBucketCallbackPolicyResponseParser();
    public static final AsyncProcessObjectResponseParser asyncProcessObjectResponseParser = new AsyncProcessObjectResponseParser();
    public static final GetBucketArchiveDirectReadResponseParser getBucketArchiveDirectReadResponseParser = new GetBucketArchiveDirectReadResponseParser();
    public static final GetBucketHttpsConfigResponseParser getBucketHttpsConfigResponseParser = new GetBucketHttpsConfigResponseParser();
    public static final GetPublicAccessBlockResponseParser getPublicAccessBlockResponseParser = new GetPublicAccessBlockResponseParser();
    public static final GetBucketPublicAccessBlockResponseParser getBucketPublicAccessBlockResponseParser = new GetBucketPublicAccessBlockResponseParser();
    public static final GetBucketPolicyStatusResponseParser getBucketPolicyStatusResponseParser = new GetBucketPolicyStatusResponseParser();
    public static final CreateBucketDataRedundancyTransitionResponseParser createBucketDataRedundancyTransitionResponseParser = new CreateBucketDataRedundancyTransitionResponseParser();
    public static final GetBucketDataRedundancyTransitionResponseParser getBucketDataRedundancyTransitionResponseParser = new GetBucketDataRedundancyTransitionResponseParser();
    public static final ListBucketDataRedundancyTransitionResponseParser listBucketDataRedundancyTransitionResponseParser = new ListBucketDataRedundancyTransitionResponseParser();
    public static final ListUserDataRedundancyTransitionResponseParser listUserDataRedundancyTransitionResponseParser = new ListUserDataRedundancyTransitionResponseParser();
    public static final CreateAccessPointResponseParser createAccessPointResponseParser = new CreateAccessPointResponseParser();
    public static final GetAccessPointResponseParser getAccessPointResponseParser = new GetAccessPointResponseParser();
    public static final GetAccessPointPolicyResponseParser getAccessPointPolicyResponseParser = new GetAccessPointPolicyResponseParser();
    public static final ListAccessPointsResponseParser listAccessPointsResponseParser = new ListAccessPointsResponseParser();

    public static Long parseLongWithDefault(String defaultValue) {
        if (defaultValue == null || "".equals(defaultValue)) {
            return 0L;
        }
        return Long.parseLong(defaultValue);
    }

    public static void setResultParameter(GenericResult result, ResponseMessage response) {
        result.setRequestId(response.getRequestId());
        ResponseParsers.setCRC(result, response);
        result.setResponse(response);
    }

    public static <ResultType extends GenericResult> void setCRC(ResultType result, ResponseMessage response) {
        if (response.getRequest() != null) {
            String strSrvCrc;
            InputStream inputStream = response.getRequest().getContent();
            if (inputStream instanceof CheckedInputStream) {
                CheckedInputStream checkedInputStream = (CheckedInputStream)inputStream;
                result.setClientCRC(checkedInputStream.getChecksum().getValue());
            }
            if ((strSrvCrc = response.getHeaders().get("x-oss-hash-crc64ecma")) != null) {
                BigInteger bi = new BigInteger(strSrvCrc);
                result.setServerCRC(bi.longValue());
            }
        }
    }

    public static <ResultType extends GenericResult> void setServerCRC(ResultType result, ResponseMessage response) {
        String strSrvCrc = response.getHeaders().get("x-oss-hash-crc64ecma");
        if (strSrvCrc != null) {
            BigInteger bi = new BigInteger(strSrvCrc);
            result.setServerCRC(bi.longValue());
        }
    }

    private static Element getXmlRootElement(InputStream responseBody) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        builder.setExpandEntities(false);
        Document doc = builder.build(responseBody);
        return doc.getRootElement();
    }

    public static ObjectListing parseListObjects(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ObjectListing objectListing = new ObjectListing();
            objectListing.setBucketName(root.getChildText("Name"));
            objectListing.setMaxKeys(Integer.valueOf(root.getChildText("MaxKeys")));
            objectListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("Prefix") != null) {
                String prefix = root.getChildText("Prefix");
                objectListing.setPrefix(CodingUtils.isNullOrEmpty(prefix) ? null : prefix);
            }
            if (root.getChild("Marker") != null) {
                String marker = root.getChildText("Marker");
                objectListing.setMarker(CodingUtils.isNullOrEmpty(marker) ? null : marker);
            }
            if (root.getChild("Delimiter") != null) {
                String delimiter = root.getChildText("Delimiter");
                objectListing.setDelimiter(CodingUtils.isNullOrEmpty(delimiter) ? null : delimiter);
            }
            if (root.getChild("NextMarker") != null) {
                String nextMarker = root.getChildText("NextMarker");
                objectListing.setNextMarker(CodingUtils.isNullOrEmpty(nextMarker) ? null : nextMarker);
            }
            if (root.getChild("EncodingType") != null) {
                String encodingType = root.getChildText("EncodingType");
                objectListing.setEncodingType(CodingUtils.isNullOrEmpty(encodingType) ? null : encodingType);
            }
            List objectSummaryElems = root.getChildren("Contents");
            for (Element elem : objectSummaryElems) {
                OSSObjectSummary ossObjectSummary = new OSSObjectSummary();
                ossObjectSummary.setKey(elem.getChildText("Key"));
                ossObjectSummary.setETag(OSSUtils.trimQuotes(elem.getChildText("ETag")));
                ossObjectSummary.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ossObjectSummary.setSize(Long.valueOf(elem.getChildText("Size")));
                ossObjectSummary.setStorageClass(elem.getChildText("StorageClass"));
                ossObjectSummary.setRestoreInfo(elem.getChildText("RestoreInfo"));
                ossObjectSummary.setBucketName(objectListing.getBucketName());
                if (elem.getChild("Type") != null) {
                    ossObjectSummary.setType(elem.getChildText("Type"));
                }
                String id = elem.getChild("Owner").getChildText("ID");
                String displayName = elem.getChild("Owner").getChildText("DisplayName");
                ossObjectSummary.setOwner(new Owner(id, displayName));
                objectListing.addObjectSummary(ossObjectSummary);
            }
            List commonPrefixesElems = root.getChildren("CommonPrefixes");
            for (Element elem : commonPrefixesElems) {
                String prefix = elem.getChildText("Prefix");
                if (CodingUtils.isNullOrEmpty(prefix)) continue;
                objectListing.addCommonPrefix(prefix);
            }
            return objectListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static ListObjectsV2Result parseListObjectsV2(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ListObjectsV2Result result = new ListObjectsV2Result();
            result.setBucketName(root.getChildText("Name"));
            result.setMaxKeys(Integer.valueOf(root.getChildText("MaxKeys")));
            result.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            result.setKeyCount(Integer.valueOf(root.getChildText("KeyCount")));
            if (root.getChild("Prefix") != null) {
                String prefix = root.getChildText("Prefix");
                result.setPrefix(CodingUtils.isNullOrEmpty(prefix) ? null : prefix);
            }
            if (root.getChild("Delimiter") != null) {
                String delimiter = root.getChildText("Delimiter");
                result.setDelimiter(CodingUtils.isNullOrEmpty(delimiter) ? null : delimiter);
            }
            if (root.getChild("ContinuationToken") != null) {
                String continuationToken = root.getChildText("ContinuationToken");
                result.setContinuationToken(CodingUtils.isNullOrEmpty(continuationToken) ? null : continuationToken);
            }
            if (root.getChild("NextContinuationToken") != null) {
                String nextContinuationToken = root.getChildText("NextContinuationToken");
                result.setNextContinuationToken(CodingUtils.isNullOrEmpty(nextContinuationToken) ? null : nextContinuationToken);
            }
            if (root.getChild("EncodingType") != null) {
                String encodeType = root.getChildText("EncodingType");
                result.setEncodingType(CodingUtils.isNullOrEmpty(encodeType) ? null : encodeType);
            }
            if (root.getChild("StartAfter") != null) {
                String startAfter = root.getChildText("StartAfter");
                result.setStartAfter(CodingUtils.isNullOrEmpty(startAfter) ? null : startAfter);
            }
            List objectSummaryElems = root.getChildren("Contents");
            for (Element elem : objectSummaryElems) {
                OSSObjectSummary ossObjectSummary = new OSSObjectSummary();
                ossObjectSummary.setKey(elem.getChildText("Key"));
                ossObjectSummary.setETag(OSSUtils.trimQuotes(elem.getChildText("ETag")));
                ossObjectSummary.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ossObjectSummary.setSize(Long.valueOf(elem.getChildText("Size")));
                ossObjectSummary.setStorageClass(elem.getChildText("StorageClass"));
                ossObjectSummary.setRestoreInfo(elem.getChildText("RestoreInfo"));
                ossObjectSummary.setBucketName(result.getBucketName());
                if (elem.getChild("Type") != null) {
                    ossObjectSummary.setType(elem.getChildText("Type"));
                }
                if (elem.getChild("Owner") != null) {
                    String id = elem.getChild("Owner").getChildText("ID");
                    String displayName = elem.getChild("Owner").getChildText("DisplayName");
                    ossObjectSummary.setOwner(new Owner(id, displayName));
                }
                result.addObjectSummary(ossObjectSummary);
            }
            List commonPrefixesElems = root.getChildren("CommonPrefixes");
            for (Element elem : commonPrefixesElems) {
                String prefix = elem.getChildText("Prefix");
                if (CodingUtils.isNullOrEmpty(prefix)) continue;
                result.addCommonPrefix(prefix);
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static VersionListing parseListVersions(InputStream responseBody) throws ResponseParseException {
        try {
            String nextMarker;
            String marker;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            boolean shouldSDKDecode = false;
            VersionListing versionListing = new VersionListing();
            versionListing.setBucketName(root.getChildText("Name"));
            versionListing.setMaxKeys(Integer.valueOf(root.getChildText("MaxKeys")));
            versionListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("EncodingType") != null) {
                String encodingType = root.getChildText("EncodingType");
                if (encodingType.equals("url")) {
                    shouldSDKDecode = true;
                    versionListing.setEncodingType(null);
                } else {
                    versionListing.setEncodingType(CodingUtils.isNullOrEmpty(encodingType) ? null : encodingType);
                }
            }
            if (root.getChild("Prefix") != null) {
                String prefix = root.getChildText("Prefix");
                versionListing.setPrefix(CodingUtils.isNullOrEmpty(prefix) ? null : ResponseParsers.decodeIfSpecified(prefix, shouldSDKDecode));
            }
            if (root.getChild("KeyMarker") != null) {
                marker = root.getChildText("KeyMarker");
                versionListing.setKeyMarker(CodingUtils.isNullOrEmpty(marker) ? null : ResponseParsers.decodeIfSpecified(marker, shouldSDKDecode));
            }
            if (root.getChild("VersionIdMarker") != null) {
                marker = root.getChildText("VersionIdMarker");
                versionListing.setVersionIdMarker(CodingUtils.isNullOrEmpty(marker) ? null : marker);
            }
            if (root.getChild("Delimiter") != null) {
                String delimiter = root.getChildText("Delimiter");
                versionListing.setDelimiter(CodingUtils.isNullOrEmpty(delimiter) ? null : ResponseParsers.decodeIfSpecified(delimiter, shouldSDKDecode));
            }
            if (root.getChild("NextKeyMarker") != null) {
                nextMarker = root.getChildText("NextKeyMarker");
                versionListing.setNextKeyMarker(CodingUtils.isNullOrEmpty(nextMarker) ? null : ResponseParsers.decodeIfSpecified(nextMarker, shouldSDKDecode));
            }
            if (root.getChild("NextVersionIdMarker") != null) {
                nextMarker = root.getChildText("NextVersionIdMarker");
                versionListing.setNextVersionIdMarker(CodingUtils.isNullOrEmpty(nextMarker) ? null : nextMarker);
            }
            List objectSummaryElems = root.getChildren("Version");
            for (Object elem : objectSummaryElems) {
                OSSVersionSummary ossVersionSummary = new OSSVersionSummary();
                ossVersionSummary.setKey(ResponseParsers.decodeIfSpecified(elem.getChildText("Key"), shouldSDKDecode));
                ossVersionSummary.setVersionId(elem.getChildText("VersionId"));
                ossVersionSummary.setIsLatest("true".equals(elem.getChildText("IsLatest")));
                ossVersionSummary.setETag(OSSUtils.trimQuotes(elem.getChildText("ETag")));
                ossVersionSummary.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ossVersionSummary.setSize(Long.valueOf(elem.getChildText("Size")));
                ossVersionSummary.setStorageClass(elem.getChildText("StorageClass"));
                ossVersionSummary.setRestoreInfo(elem.getChildText("RestoreInfo"));
                ossVersionSummary.setBucketName(versionListing.getBucketName());
                ossVersionSummary.setIsDeleteMarker(false);
                String id = elem.getChild("Owner").getChildText("ID");
                String displayName = elem.getChild("Owner").getChildText("DisplayName");
                ossVersionSummary.setOwner(new Owner(id, displayName));
                versionListing.getVersionSummaries().add(ossVersionSummary);
            }
            List delSummaryElems = root.getChildren("DeleteMarker");
            for (Element elem : delSummaryElems) {
                OSSVersionSummary ossVersionSummary = new OSSVersionSummary();
                ossVersionSummary.setKey(ResponseParsers.decodeIfSpecified(elem.getChildText("Key"), shouldSDKDecode));
                ossVersionSummary.setVersionId(elem.getChildText("VersionId"));
                ossVersionSummary.setIsLatest("true".equals(elem.getChildText("IsLatest")));
                ossVersionSummary.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ossVersionSummary.setBucketName(versionListing.getBucketName());
                ossVersionSummary.setIsDeleteMarker(true);
                String id = elem.getChild("Owner").getChildText("ID");
                String displayName = elem.getChild("Owner").getChildText("DisplayName");
                ossVersionSummary.setOwner(new Owner(id, displayName));
                versionListing.getVersionSummaries().add(ossVersionSummary);
            }
            List commonPrefixesElems = root.getChildren("CommonPrefixes");
            for (Element elem : commonPrefixesElems) {
                String prefix = elem.getChildText("Prefix");
                if (CodingUtils.isNullOrEmpty(prefix)) continue;
                versionListing.getCommonPrefixes().add(ResponseParsers.decodeIfSpecified(prefix, shouldSDKDecode));
            }
            return versionListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    private static String decodeIfSpecified(String value, boolean decode) {
        return decode ? HttpUtil.urlDecode(value, "UTF-8") : value;
    }

    public static AccessControlList parseGetBucketAcl(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            AccessControlList acl = new AccessControlList();
            String id = root.getChild("Owner").getChildText("ID");
            String displayName = root.getChild("Owner").getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            acl.setOwner(owner);
            String aclString = root.getChild("AccessControlList").getChildText("Grant");
            CannedAccessControlList cacl = CannedAccessControlList.parse(aclString);
            acl.setCannedACL(cacl);
            switch (cacl) {
                case PublicRead: {
                    acl.grantPermission(GroupGrantee.AllUsers, Permission.Read);
                    break;
                }
                case PublicReadWrite: {
                    acl.grantPermission(GroupGrantee.AllUsers, Permission.FullControl);
                    break;
                }
            }
            return acl;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static ObjectAcl parseGetObjectAcl(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ObjectAcl acl = new ObjectAcl();
            String id = root.getChild("Owner").getChildText("ID");
            String displayName = root.getChild("Owner").getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            acl.setOwner(owner);
            String grantString = root.getChild("AccessControlList").getChildText("Grant");
            acl.setPermission(ObjectPermission.parsePermission(grantString));
            return acl;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketReferer parseGetBucketReferer(InputStream responseBody) throws ResponseParseException {
        try {
            Element refererListElem;
            List refererElems;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            boolean allowEmptyReferer = Boolean.valueOf(root.getChildText("AllowEmptyReferer"));
            ArrayList<String> refererList = new ArrayList<String>();
            if (root.getChild("RefererList") != null && (refererElems = (refererListElem = root.getChild("RefererList")).getChildren("Referer")) != null && !refererElems.isEmpty()) {
                for (Element e : refererElems) {
                    refererList.add(e.getText());
                }
            }
            BucketReferer bucketReferer = new BucketReferer(allowEmptyReferer, refererList);
            Boolean allowTruncateQueryString = null;
            if (root.getChildText("AllowTruncateQueryString") != null) {
                allowTruncateQueryString = Boolean.valueOf(root.getChildText("AllowTruncateQueryString"));
                bucketReferer.setAllowTruncateQueryString(allowTruncateQueryString);
            }
            if (root.getChild("RefererBlacklist") != null) {
                ArrayList<String> blackRefererList = new ArrayList<String>();
                Element refererListElem2 = root.getChild("RefererBlacklist");
                List refererElems2 = refererListElem2.getChildren("Referer");
                if (refererElems2 != null && !refererElems2.isEmpty()) {
                    for (Element e : refererElems2) {
                        blackRefererList.add(e.getText());
                    }
                }
                bucketReferer.setBlackRefererList(blackRefererList);
            }
            return bucketReferer;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static String parseUploadPartCopy(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            return root.getChildText("ETag");
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketList parseListBucket(InputStream responseBody) throws ResponseParseException {
        try {
            String value;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketList bucketList = new BucketList();
            if (root.getChild("Prefix") != null) {
                bucketList.setPrefix(root.getChildText("Prefix"));
            }
            if (root.getChild("Marker") != null) {
                bucketList.setMarker(root.getChildText("Marker"));
            }
            if (root.getChild("MaxKeys") != null) {
                value = root.getChildText("MaxKeys");
                bucketList.setMaxKeys(CodingUtils.isNullOrEmpty(value) ? null : Integer.valueOf(value));
            }
            if (root.getChild("IsTruncated") != null) {
                value = root.getChildText("IsTruncated");
                bucketList.setTruncated(CodingUtils.isNullOrEmpty(value) ? false : Boolean.valueOf(value));
            }
            if (root.getChild("NextMarker") != null) {
                bucketList.setNextMarker(root.getChildText("NextMarker"));
            }
            Element ownerElem = root.getChild("Owner");
            String id = ownerElem.getChildText("ID");
            String displayName = ownerElem.getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>();
            if (root.getChild("Buckets") != null) {
                List bucketElems = root.getChild("Buckets").getChildren("Bucket");
                for (Element e : bucketElems) {
                    Bucket bucket = new Bucket();
                    bucket.setOwner(owner);
                    bucket.setName(e.getChildText("Name"));
                    bucket.setLocation(e.getChildText("Location"));
                    bucket.setCreationDate(DateUtil.parseIso8601Date(e.getChildText("CreationDate")));
                    if (e.getChild("StorageClass") != null) {
                        bucket.setStorageClass(StorageClass.parse(e.getChildText("StorageClass")));
                    }
                    bucket.setExtranetEndpoint(e.getChildText("ExtranetEndpoint"));
                    bucket.setIntranetEndpoint(e.getChildText("IntranetEndpoint"));
                    if (e.getChild("Region") != null) {
                        bucket.setRegion(e.getChildText("Region"));
                    }
                    if (e.getChild("HierarchicalNamespace") != null) {
                        bucket.setHnsStatus(e.getChildText("HierarchicalNamespace"));
                    }
                    if (e.getChild("ResourceGroupId") != null) {
                        bucket.setResourceGroupId(e.getChildText("ResourceGroupId"));
                    }
                    buckets.add(bucket);
                }
            }
            bucketList.setBucketList(buckets);
            return bucketList;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<Style> parseListImageStyle(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<Style> styleList = new ArrayList<Style>();
            List styleElems = root.getChildren("Style");
            for (Element e : styleElems) {
                Style style = new Style();
                style.SetStyleName(e.getChildText("Name"));
                style.SetStyle(e.getChildText("Content"));
                style.SetLastModifyTime(DateUtil.parseRfc822Date(e.getChildText("LastModifyTime")));
                style.SetCreationDate(DateUtil.parseRfc822Date(e.getChildText("CreateTime")));
                styleList.add(style);
            }
            return styleList;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static String parseGetBucketLocation(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            return root.getText();
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketMetadata parseBucketMetadata(Map<String, String> headers) throws ResponseParseException {
        try {
            BucketMetadata bucketMetadata = new BucketMetadata();
            for (String key : headers.keySet()) {
                if (key.equalsIgnoreCase("x-oss-bucket-region")) {
                    bucketMetadata.setBucketRegion(headers.get(key));
                    continue;
                }
                bucketMetadata.addHttpMetadata(key, headers.get(key));
            }
            return bucketMetadata;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static SimplifiedObjectMeta parseSimplifiedObjectMeta(Map<String, String> headers) throws ResponseParseException {
        try {
            SimplifiedObjectMeta objectMeta = new SimplifiedObjectMeta();
            for (String key : headers.keySet()) {
                if (key.equalsIgnoreCase("Last-Modified")) {
                    try {
                        objectMeta.setLastModified(DateUtil.parseRfc822Date(headers.get(key)));
                    }
                    catch (ParseException pe) {
                        throw new ResponseParseException(pe.getMessage(), pe);
                    }
                } else if (key.equalsIgnoreCase("Content-Length")) {
                    Long value = Long.valueOf(headers.get(key));
                    objectMeta.setSize(value);
                } else if (key.equalsIgnoreCase("ETag")) {
                    objectMeta.setETag(OSSUtils.trimQuotes(headers.get(key)));
                } else if (key.equalsIgnoreCase("x-oss-request-id")) {
                    objectMeta.setRequestId(headers.get(key));
                } else if (key.equalsIgnoreCase("x-oss-version-id")) {
                    objectMeta.setVersionId(headers.get(key));
                }
                objectMeta.setHeader(key, headers.get(key));
            }
            return objectMeta;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static OSSSymlink parseSymbolicLink(ResponseMessage response) throws ResponseParseException {
        try {
            OSSSymlink smyLink = null;
            String targetObject = response.getHeaders().get("x-oss-symlink-target");
            if (targetObject != null) {
                targetObject = HttpUtil.urlDecode(targetObject, "UTF-8");
                smyLink = new OSSSymlink(null, targetObject);
            }
            smyLink.setMetadata(ResponseParsers.parseObjectMetadata(response.getHeaders()));
            return smyLink;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static ObjectMetadata parseObjectMetadata(Map<String, String> headers) throws ResponseParseException {
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            for (String key : headers.keySet()) {
                if (key.indexOf("x-oss-meta-") >= 0) {
                    key = key.substring("x-oss-meta-".length());
                    objectMetadata.addUserMetadata(key, headers.get("x-oss-meta-" + key));
                    continue;
                }
                if (key.equalsIgnoreCase("Last-Modified") || key.equalsIgnoreCase("Date")) {
                    try {
                        objectMetadata.setHeader(key, DateUtil.parseRfc822Date(headers.get(key)));
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new ResponseParseException(pe.getMessage(), pe);
                    }
                }
                if (key.equalsIgnoreCase("Content-Length")) {
                    Long value = Long.valueOf(headers.get(key));
                    objectMetadata.setHeader(key, value);
                    continue;
                }
                if (key.equalsIgnoreCase("ETag")) {
                    objectMetadata.setHeader(key, OSSUtils.trimQuotes(headers.get(key)));
                    continue;
                }
                objectMetadata.setHeader(key, headers.get(key));
            }
            return objectMetadata;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static InitiateMultipartUploadResult parseInitiateMultipartUpload(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            InitiateMultipartUploadResult result = new InitiateMultipartUploadResult();
            if (root.getChild("Bucket") != null) {
                result.setBucketName(root.getChildText("Bucket"));
            }
            if (root.getChild("Key") != null) {
                result.setKey(root.getChildText("Key"));
            }
            if (root.getChild("UploadId") != null) {
                result.setUploadId(root.getChildText("UploadId"));
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static MultipartUploadListing parseListMultipartUploads(InputStream responseBody) throws ResponseParseException {
        try {
            String nextUploadIdMarker;
            String nextKeyMarker;
            String uploadIdMarker;
            String keyMarker;
            String prefix;
            String delimiter;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            MultipartUploadListing multipartUploadListing = new MultipartUploadListing();
            multipartUploadListing.setBucketName(root.getChildText("Bucket"));
            multipartUploadListing.setMaxUploads(Integer.valueOf(root.getChildText("MaxUploads")));
            multipartUploadListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("Delimiter") != null && !CodingUtils.isNullOrEmpty(delimiter = root.getChildText("Delimiter"))) {
                multipartUploadListing.setDelimiter(delimiter);
            }
            if (root.getChild("Prefix") != null && !CodingUtils.isNullOrEmpty(prefix = root.getChildText("Prefix"))) {
                multipartUploadListing.setPrefix(prefix);
            }
            if (root.getChild("KeyMarker") != null && !CodingUtils.isNullOrEmpty(keyMarker = root.getChildText("KeyMarker"))) {
                multipartUploadListing.setKeyMarker(keyMarker);
            }
            if (root.getChild("UploadIdMarker") != null && !CodingUtils.isNullOrEmpty(uploadIdMarker = root.getChildText("UploadIdMarker"))) {
                multipartUploadListing.setUploadIdMarker(uploadIdMarker);
            }
            if (root.getChild("NextKeyMarker") != null && !CodingUtils.isNullOrEmpty(nextKeyMarker = root.getChildText("NextKeyMarker"))) {
                multipartUploadListing.setNextKeyMarker(nextKeyMarker);
            }
            if (root.getChild("NextUploadIdMarker") != null && !CodingUtils.isNullOrEmpty(nextUploadIdMarker = root.getChildText("NextUploadIdMarker"))) {
                multipartUploadListing.setNextUploadIdMarker(nextUploadIdMarker);
            }
            List uploadElems = root.getChildren("Upload");
            for (Element elem : uploadElems) {
                if (elem.getChild("Initiated") == null) continue;
                MultipartUpload mu = new MultipartUpload();
                mu.setKey(elem.getChildText("Key"));
                mu.setUploadId(elem.getChildText("UploadId"));
                mu.setStorageClass(elem.getChildText("StorageClass"));
                mu.setInitiated(DateUtil.parseIso8601Date(elem.getChildText("Initiated")));
                multipartUploadListing.addMultipartUpload(mu);
            }
            List commonPrefixesElems = root.getChildren("CommonPrefixes");
            for (Element elem : commonPrefixesElems) {
                String prefix2 = elem.getChildText("Prefix");
                if (CodingUtils.isNullOrEmpty(prefix2)) continue;
                multipartUploadListing.addCommonPrefix(prefix2);
            }
            return multipartUploadListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static PartListing parseListParts(InputStream responseBody) throws ResponseParseException {
        try {
            String nextPartNumberMarker;
            String partNumberMarker;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            PartListing partListing = new PartListing();
            partListing.setBucketName(root.getChildText("Bucket"));
            partListing.setKey(root.getChildText("Key"));
            partListing.setUploadId(root.getChildText("UploadId"));
            partListing.setStorageClass(root.getChildText("StorageClass"));
            partListing.setMaxParts(Integer.valueOf(root.getChildText("MaxParts")));
            partListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("PartNumberMarker") != null && !CodingUtils.isNullOrEmpty(partNumberMarker = root.getChildText("PartNumberMarker"))) {
                partListing.setPartNumberMarker(Integer.valueOf(partNumberMarker));
            }
            if (root.getChild("NextPartNumberMarker") != null && !CodingUtils.isNullOrEmpty(nextPartNumberMarker = root.getChildText("NextPartNumberMarker"))) {
                partListing.setNextPartNumberMarker(Integer.valueOf(nextPartNumberMarker));
            }
            List partElems = root.getChildren("Part");
            for (Element elem : partElems) {
                PartSummary ps = new PartSummary();
                ps.setPartNumber(Integer.valueOf(elem.getChildText("PartNumber")));
                ps.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ps.setETag(OSSUtils.trimQuotes(elem.getChildText("ETag")));
                ps.setSize(Integer.valueOf(elem.getChildText("Size")).intValue());
                partListing.addPart(ps);
            }
            return partListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static CompleteMultipartUploadResult parseCompleteMultipartUpload(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            CompleteMultipartUploadResult result = new CompleteMultipartUploadResult();
            result.setBucketName(root.getChildText("Bucket"));
            result.setETag(OSSUtils.trimQuotes(root.getChildText("ETag")));
            result.setKey(root.getChildText("Key"));
            result.setLocation(root.getChildText("Location"));
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketLoggingResult parseBucketLogging(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketLoggingResult result = new BucketLoggingResult();
            if (root.getChild("LoggingEnabled") != null) {
                result.setTargetBucket(root.getChild("LoggingEnabled").getChildText("TargetBucket"));
            }
            if (root.getChild("LoggingEnabled") != null) {
                result.setTargetPrefix(root.getChild("LoggingEnabled").getChildText("TargetPrefix"));
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetBucketImageResult parseBucketImage(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            GetBucketImageResult result = new GetBucketImageResult();
            result.SetBucketName(root.getChildText("Name"));
            result.SetDefault404Pic(root.getChildText("Default404Pic"));
            result.SetStyleDelimiters(root.getChildText("StyleDelimiters"));
            result.SetStatus(root.getChildText("Status"));
            result.SetIsAutoSetContentType(root.getChildText("AutoSetContentType").equals("True"));
            result.SetIsForbidOrigPicAccess(root.getChildText("OrigPicForbidden").equals("True"));
            result.SetIsSetAttachName(root.getChildText("SetAttachName").equals("True"));
            result.SetIsUseStyleOnly(root.getChildText("UseStyleOnly").equals("True"));
            result.SetIsUseSrcFormat(root.getChildText("UseSrcFormat").equals("True"));
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetImageStyleResult parseImageStyle(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            GetImageStyleResult result = new GetImageStyleResult();
            result.SetStyleName(root.getChildText("Name"));
            result.SetStyle(root.getChildText("Content"));
            result.SetLastModifyTime(DateUtil.parseRfc822Date(root.getChildText("LastModifyTime")));
            result.SetCreationDate(DateUtil.parseRfc822Date(root.getChildText("CreateTime")));
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketProcess parseGetBucketImageProcessConf(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            String compliedHost = root.getChildText("CompliedHost");
            boolean sourceFileProtect = false;
            if (root.getChildText("SourceFileProtect").equals("Enabled")) {
                sourceFileProtect = true;
            }
            String sourceFileProtectSuffix = root.getChildText("SourceFileProtectSuffix");
            String styleDelimiters = root.getChildText("StyleDelimiters");
            ImageProcess imageProcess = new ImageProcess(compliedHost, sourceFileProtect, sourceFileProtectSuffix, styleDelimiters);
            if (root.getChildText("Version") != null) {
                imageProcess.setVersion(Integer.parseInt(root.getChildText("Version")));
            }
            return new BucketProcess(imageProcess);
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketWebsiteResult parseBucketWebsite(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketWebsiteResult result = new BucketWebsiteResult();
            Element indexDocument = root.getChild("IndexDocument");
            if (indexDocument != null) {
                result.setIndexDocument(root.getChild("IndexDocument").getChildText("Suffix"));
                if (indexDocument.getChild("SupportSubDir") != null) {
                    result.setSupportSubDir(Boolean.valueOf(indexDocument.getChildText("SupportSubDir")));
                }
                if (indexDocument.getChild("Type") != null) {
                    result.setSubDirType(indexDocument.getChildText("Type"));
                }
            }
            if (root.getChild("ErrorDocument") != null) {
                result.setErrorDocument(root.getChild("ErrorDocument").getChildText("Key"));
                if (root.getChild("ErrorDocument").getChild("HttpStatus") != null) {
                    result.setHttpStatus(root.getChild("ErrorDocument").getChildText("HttpStatus"));
                }
            }
            if (root.getChild("RoutingRules") != null) {
                List ruleElements = root.getChild("RoutingRules").getChildren("RoutingRule");
                for (Element ruleElem : ruleElements) {
                    Element mirrorHeadersElem;
                    List mirrorURLElementList;
                    Element mirrorURLsElem;
                    Element redirectElem;
                    RoutingRule rule = new RoutingRule();
                    rule.setNumber(Integer.parseInt(ruleElem.getChildText("RuleNumber")));
                    Element condElem = ruleElem.getChild("Condition");
                    if (condElem != null) {
                        List includeHeadersElem;
                        rule.getCondition().setKeyPrefixEquals(condElem.getChildText("KeyPrefixEquals"));
                        if (condElem.getChild("KeySuffixEquals") != null) {
                            rule.getCondition().setKeySuffixEquals(condElem.getChildText("KeySuffixEquals"));
                        }
                        if (condElem.getChild("HttpErrorCodeReturnedEquals") != null) {
                            rule.getCondition().setHttpErrorCodeReturnedEquals(Integer.parseInt(condElem.getChildText("HttpErrorCodeReturnedEquals")));
                        }
                        if ((includeHeadersElem = condElem.getChildren("IncludeHeader")) != null && includeHeadersElem.size() > 0) {
                            ArrayList<RoutingRule.IncludeHeader> includeHeaders = new ArrayList<RoutingRule.IncludeHeader>();
                            for (Element includeHeaderElem : includeHeadersElem) {
                                RoutingRule.IncludeHeader includeHeader = new RoutingRule.IncludeHeader();
                                includeHeader.setKey(includeHeaderElem.getChildText("Key"));
                                includeHeader.setEquals(includeHeaderElem.getChildText("Equals"));
                                includeHeader.setStartsWith(includeHeaderElem.getChildText("StartsWith"));
                                includeHeader.setEndsWith(includeHeaderElem.getChildText("EndsWith"));
                                includeHeaders.add(includeHeader);
                            }
                            rule.getCondition().setIncludeHeaders(includeHeaders);
                        }
                    }
                    if ((redirectElem = ruleElem.getChild("Redirect")).getChild("RedirectType") != null) {
                        rule.getRedirect().setRedirectType(RoutingRule.RedirectType.parse(redirectElem.getChildText("RedirectType")));
                    }
                    rule.getRedirect().setHostName(redirectElem.getChildText("HostName"));
                    if (redirectElem.getChild("Protocol") != null) {
                        rule.getRedirect().setProtocol(RoutingRule.Protocol.parse(redirectElem.getChildText("Protocol")));
                    }
                    rule.getRedirect().setReplaceKeyPrefixWith(redirectElem.getChildText("ReplaceKeyPrefixWith"));
                    rule.getRedirect().setReplaceKeyWith(redirectElem.getChildText("ReplaceKeyWith"));
                    if (redirectElem.getChild("HttpRedirectCode") != null) {
                        rule.getRedirect().setHttpRedirectCode(Integer.parseInt(redirectElem.getChildText("HttpRedirectCode")));
                    }
                    rule.getRedirect().setMirrorURL(redirectElem.getChildText("MirrorURL"));
                    if (redirectElem.getChildText("MirrorTunnelId") != null) {
                        rule.getRedirect().setMirrorTunnelId(redirectElem.getChildText("MirrorTunnelId"));
                    }
                    rule.getRedirect().setMirrorSecondaryURL(redirectElem.getChildText("MirrorURLSlave"));
                    rule.getRedirect().setMirrorProbeURL(redirectElem.getChildText("MirrorURLProbe"));
                    if (redirectElem.getChildText("MirrorPassQueryString") != null) {
                        rule.getRedirect().setMirrorPassQueryString(Boolean.valueOf(redirectElem.getChildText("MirrorPassQueryString")));
                    }
                    if (redirectElem.getChildText("MirrorPassOriginalSlashes") != null) {
                        rule.getRedirect().setPassOriginalSlashes(Boolean.valueOf(redirectElem.getChildText("MirrorPassOriginalSlashes")));
                    }
                    if (redirectElem.getChildText("PassQueryString") != null) {
                        rule.getRedirect().setPassQueryString(Boolean.valueOf(redirectElem.getChildText("PassQueryString")));
                    }
                    if (redirectElem.getChildText("MirrorFollowRedirect") != null) {
                        rule.getRedirect().setMirrorFollowRedirect(Boolean.valueOf(redirectElem.getChildText("MirrorFollowRedirect")));
                    }
                    if (redirectElem.getChildText("MirrorUserLastModified") != null) {
                        rule.getRedirect().setMirrorUserLastModified(Boolean.valueOf(redirectElem.getChildText("MirrorUserLastModified")));
                    }
                    if (redirectElem.getChildText("MirrorIsExpressTunnel") != null) {
                        rule.getRedirect().setMirrorIsExpressTunnel(Boolean.valueOf(redirectElem.getChildText("MirrorIsExpressTunnel")));
                    }
                    if (redirectElem.getChildText("MirrorDstRegion") != null) {
                        rule.getRedirect().setMirrorDstRegion(redirectElem.getChildText("MirrorDstRegion"));
                    }
                    if (redirectElem.getChildText("MirrorDstVpcId") != null) {
                        rule.getRedirect().setMirrorDstVpcId(redirectElem.getChildText("MirrorDstVpcId"));
                    }
                    if (redirectElem.getChildText("MirrorUsingRole") != null) {
                        rule.getRedirect().setMirrorUsingRole(Boolean.valueOf(redirectElem.getChildText("MirrorUsingRole")));
                    }
                    if (redirectElem.getChildText("MirrorRole") != null) {
                        rule.getRedirect().setMirrorRole(redirectElem.getChildText("MirrorRole"));
                    }
                    if (redirectElem.getChild("EnableReplacePrefix") != null) {
                        rule.getRedirect().setEnableReplacePrefix(Boolean.valueOf(redirectElem.getChildText("EnableReplacePrefix")));
                    }
                    if (redirectElem.getChild("MirrorSwitchAllErrors") != null) {
                        rule.getRedirect().setMirrorSwitchAllErrors(Boolean.valueOf(redirectElem.getChildText("MirrorSwitchAllErrors")));
                    }
                    if (redirectElem.getChild("MirrorCheckMd5") != null) {
                        rule.getRedirect().setMirrorCheckMd5(Boolean.valueOf(redirectElem.getChildText("MirrorCheckMd5")));
                    }
                    if ((mirrorURLsElem = redirectElem.getChild("MirrorMultiAlternates")) != null && (mirrorURLElementList = mirrorURLsElem.getChildren("MirrorMultiAlternate")) != null && mirrorURLElementList.size() > 0) {
                        ArrayList<RoutingRule.Redirect.MirrorMultiAlternate> mirrorURLsList = new ArrayList<RoutingRule.Redirect.MirrorMultiAlternate>();
                        for (Element setElement : mirrorURLElementList) {
                            RoutingRule.Redirect.MirrorMultiAlternate mirrorMultiAlternate = new RoutingRule.Redirect.MirrorMultiAlternate();
                            mirrorMultiAlternate.setPrior(Integer.parseInt(setElement.getChildText("MirrorMultiAlternateNumber")));
                            mirrorMultiAlternate.setUrl(setElement.getChildText("MirrorMultiAlternateURL"));
                            mirrorURLsList.add(mirrorMultiAlternate);
                        }
                        rule.getRedirect().setMirrorMultiAlternates(mirrorURLsList);
                    }
                    if ((mirrorHeadersElem = redirectElem.getChild("MirrorHeaders")) != null) {
                        RoutingRule.MirrorHeaders mirrorHeaders = new RoutingRule.MirrorHeaders();
                        mirrorHeaders.setPassAll(Boolean.valueOf(mirrorHeadersElem.getChildText("PassAll")));
                        mirrorHeaders.setPass(ResponseParsers.parseStringListFromElemet(mirrorHeadersElem.getChildren("Pass")));
                        mirrorHeaders.setRemove(ResponseParsers.parseStringListFromElemet(mirrorHeadersElem.getChildren("Remove")));
                        List setElementList = mirrorHeadersElem.getChildren("Set");
                        if (setElementList != null && setElementList.size() > 0) {
                            ArrayList<Map<String, String>> setList = new ArrayList<Map<String, String>>();
                            for (Element setElement : setElementList) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("Key", setElement.getChildText("Key"));
                                map.put("Value", setElement.getChildText("Value"));
                                setList.add(map);
                            }
                            mirrorHeaders.setSet(setList);
                        }
                        rule.getRedirect().setMirrorHeaders(mirrorHeaders);
                    }
                    result.AddRoutingRule(rule);
                }
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    private static List<String> parseStringListFromElemet(List<Element> elementList) {
        if (elementList != null && elementList.size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (Element element : elementList) {
                list.add(element.getText());
            }
            return list;
        }
        return null;
    }

    public static CopyObjectResult parseCopyObjectResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            CopyObjectResult result = new CopyObjectResult();
            result.setLastModified(DateUtil.parseIso8601Date(root.getChildText("LastModified")));
            result.setEtag(OSSUtils.trimQuotes(root.getChildText("ETag")));
            return result;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static DeleteObjectsResult parseDeleteObjectsResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            DeleteObjectsResult deleteObjectsResult = new DeleteObjectsResult();
            if (root.getChild("EncodingType") != null) {
                String encodingType = root.getChildText("EncodingType");
                deleteObjectsResult.setEncodingType(CodingUtils.isNullOrEmpty(encodingType) ? null : encodingType);
            }
            ArrayList<String> deletedObjects = new ArrayList<String>();
            List deletedElements = root.getChildren("Deleted");
            for (Element elem : deletedElements) {
                deletedObjects.add(elem.getChildText("Key"));
            }
            deleteObjectsResult.setDeletedObjects(deletedObjects);
            return deleteObjectsResult;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static DeleteVersionsResult parseDeleteVersionsResult(InputStream responseBody) throws ResponseParseException {
        boolean shouldSDKDecodeResponse = false;
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            if (root.getChild("EncodingType") != null) {
                String encodingType = root.getChildText("EncodingType");
                shouldSDKDecodeResponse = "url".equals(encodingType);
            }
            ArrayList<DeleteVersionsResult.DeletedVersion> deletedVersions = new ArrayList<DeleteVersionsResult.DeletedVersion>();
            List deletedElements = root.getChildren("Deleted");
            for (Element elem : deletedElements) {
                DeleteVersionsResult.DeletedVersion key = new DeleteVersionsResult.DeletedVersion();
                if (shouldSDKDecodeResponse) {
                    key.setKey(HttpUtil.urlDecode(elem.getChildText("Key"), "UTF-8"));
                } else {
                    key.setKey(elem.getChildText("Key"));
                }
                if (elem.getChild("VersionId") != null) {
                    key.setVersionId(elem.getChildText("VersionId"));
                }
                if (elem.getChild("DeleteMarker") != null) {
                    key.setDeleteMarker(Boolean.parseBoolean(elem.getChildText("DeleteMarker")));
                }
                if (elem.getChild("DeleteMarkerVersionId") != null) {
                    key.setDeleteMarkerVersionId(elem.getChildText("DeleteMarkerVersionId"));
                }
                deletedVersions.add(key);
            }
            return new DeleteVersionsResult(deletedVersions);
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static CORSConfiguration parseListBucketCORS(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            CORSConfiguration result = new CORSConfiguration();
            List corsRuleElems = root.getChildren("CORSRule");
            for (Element corsRuleElem : corsRuleElems) {
                Object allowedHeaderElement2;
                Object allowedOriginElement2;
                SetBucketCORSRequest.CORSRule rule = new SetBucketCORSRequest.CORSRule();
                List allowedOriginElems = corsRuleElem.getChildren("AllowedOrigin");
                for (Object allowedOriginElement2 : allowedOriginElems) {
                    rule.getAllowedOrigins().add(allowedOriginElement2.getValue());
                }
                List allowedMethodElems = corsRuleElem.getChildren("AllowedMethod");
                allowedOriginElement2 = allowedMethodElems.iterator();
                while (allowedOriginElement2.hasNext()) {
                    Element allowedMethodElement = (Element)allowedOriginElement2.next();
                    rule.getAllowedMethods().add(allowedMethodElement.getValue());
                }
                List allowedHeaderElems = corsRuleElem.getChildren("AllowedHeader");
                for (Object allowedHeaderElement2 : allowedHeaderElems) {
                    rule.getAllowedHeaders().add(allowedHeaderElement2.getValue());
                }
                List exposeHeaderElems = corsRuleElem.getChildren("ExposeHeader");
                allowedHeaderElement2 = exposeHeaderElems.iterator();
                while (allowedHeaderElement2.hasNext()) {
                    Element exposeHeaderElement = (Element)allowedHeaderElement2.next();
                    rule.getExposeHeaders().add(exposeHeaderElement.getValue());
                }
                Element maxAgeSecondsElem = corsRuleElem.getChild("MaxAgeSeconds");
                if (maxAgeSecondsElem != null) {
                    rule.setMaxAgeSeconds(Integer.parseInt(maxAgeSecondsElem.getValue()));
                }
                result.getCorsRules().add(rule);
            }
            Element responseVaryElems = root.getChild("ResponseVary");
            if (responseVaryElems != null) {
                result.setResponseVary(Boolean.parseBoolean(responseVaryElems.getValue()));
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static TagSet parseGetBucketTagging(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            TagSet tagSet = new TagSet();
            List tagElems = root.getChild("TagSet").getChildren("Tag");
            for (Element tagElem : tagElems) {
                String key = null;
                String value = null;
                if (tagElem.getChild("Key") != null) {
                    key = tagElem.getChildText("Key");
                }
                if (tagElem.getChild("Value") != null) {
                    value = tagElem.getChildText("Value");
                }
                tagSet.setTag(key, value);
            }
            return tagSet;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<ReplicationRule> parseGetBucketReplication(InputStream responseBody) throws ResponseParseException {
        try {
            ArrayList<ReplicationRule> repRules = new ArrayList<ReplicationRule>();
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            List ruleElems = root.getChildren("Rule");
            for (Element ruleElem : ruleElems) {
                ReplicationRule repRule = new ReplicationRule();
                repRule.setReplicationRuleID(ruleElem.getChildText("ID"));
                Element destination = ruleElem.getChild("Destination");
                repRule.setTargetBucketName(destination.getChildText("Bucket"));
                repRule.setTargetBucketLocation(destination.getChildText("Location"));
                repRule.setTargetCloud(destination.getChildText("Cloud"));
                repRule.setTargetCloudLocation(destination.getChildText("CloudLocation"));
                repRule.setReplicationStatus(ReplicationStatus.parse(ruleElem.getChildText("Status")));
                if (ruleElem.getChildText("HistoricalObjectReplication").equals("enabled")) {
                    repRule.setEnableHistoricalObjectReplication(true);
                } else {
                    repRule.setEnableHistoricalObjectReplication(false);
                }
                if (ruleElem.getChild("PrefixSet") != null) {
                    ArrayList<String> objectPrefixes = new ArrayList<String>();
                    List prefixElems = ruleElem.getChild("PrefixSet").getChildren("Prefix");
                    for (Element prefixElem : prefixElems) {
                        objectPrefixes.add(prefixElem.getText());
                    }
                    repRule.setObjectPrefixList(objectPrefixes);
                }
                if (ruleElem.getChild("Action") != null) {
                    String[] actionStrs = ruleElem.getChildText("Action").split(",");
                    ArrayList<AddBucketReplicationRequest.ReplicationAction> repActions = new ArrayList<AddBucketReplicationRequest.ReplicationAction>();
                    for (String actionStr : actionStrs) {
                        repActions.add(AddBucketReplicationRequest.ReplicationAction.parse(actionStr));
                    }
                    repRule.setReplicationActionList(repActions);
                }
                repRule.setSyncRole(ruleElem.getChildText("SyncRole"));
                if (ruleElem.getChild("EncryptionConfiguration") != null) {
                    repRule.setReplicaKmsKeyID(ruleElem.getChild("EncryptionConfiguration").getChildText("ReplicaKmsKeyID"));
                }
                if (ruleElem.getChild("SourceSelectionCriteria") != null && ruleElem.getChild("SourceSelectionCriteria").getChild("SseKmsEncryptedObjects") != null) {
                    repRule.setSseKmsEncryptedObjectsStatus(ruleElem.getChild("SourceSelectionCriteria").getChild("SseKmsEncryptedObjects").getChildText("Status"));
                }
                if (ruleElem.getChild("Source") != null) {
                    repRule.setSourceBucketLocation(ruleElem.getChild("Source").getChildText("Location"));
                }
                repRules.add(repRule);
            }
            return repRules;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketReplicationProgress parseGetBucketReplicationProgress(InputStream responseBody) throws ResponseParseException {
        try {
            BucketReplicationProgress progress = new BucketReplicationProgress();
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            Element ruleElem = root.getChild("Rule");
            progress.setReplicationRuleID(ruleElem.getChildText("ID"));
            Element destination = ruleElem.getChild("Destination");
            progress.setTargetBucketName(destination.getChildText("Bucket"));
            progress.setTargetBucketLocation(destination.getChildText("Location"));
            progress.setTargetCloud(destination.getChildText("Cloud"));
            progress.setTargetCloudLocation(destination.getChildText("CloudLocation"));
            progress.setReplicationStatus(ReplicationStatus.parse(ruleElem.getChildText("Status")));
            if (ruleElem.getChildText("HistoricalObjectReplication").equals("enabled")) {
                progress.setEnableHistoricalObjectReplication(true);
            } else {
                progress.setEnableHistoricalObjectReplication(false);
            }
            Element progressElem = ruleElem.getChild("Progress");
            if (progressElem != null) {
                if (progressElem.getChild("HistoricalObject") != null) {
                    progress.setHistoricalObjectProgress(Float.parseFloat(progressElem.getChildText("HistoricalObject")));
                }
                progress.setNewObjectProgress(DateUtil.parseIso8601Date(progressElem.getChildText("NewObject")));
            }
            return progress;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<String> parseGetBucketReplicationLocation(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<String> locationList = new ArrayList<String>();
            List locElements = root.getChildren("Location");
            for (Element locElem : locElements) {
                locationList.add(locElem.getText());
            }
            return locationList;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketInfo parseGetBucketInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element policyElem;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            Element bucketElem = root.getChild("Bucket");
            BucketInfo bucketInfo = new BucketInfo();
            Bucket bucket = new Bucket();
            if (bucketElem.getChild("Owner") != null) {
                String id = bucketElem.getChild("Owner").getChildText("ID");
                String displayName = bucketElem.getChild("Owner").getChildText("DisplayName");
                Owner owner = new Owner(id, displayName);
                bucket.setOwner(owner);
            }
            bucket.setName(bucketElem.getChildText("Name"));
            bucket.setLocation(bucketElem.getChildText("Location"));
            bucket.setExtranetEndpoint(bucketElem.getChildText("ExtranetEndpoint"));
            bucket.setIntranetEndpoint(bucketElem.getChildText("IntranetEndpoint"));
            bucket.setCreationDate(DateUtil.parseIso8601Date(bucketElem.getChildText("CreationDate")));
            if (bucketElem.getChild("HierarchicalNamespace") != null) {
                String hnsStatus = bucketElem.getChildText("HierarchicalNamespace");
                bucket.setHnsStatus(hnsStatus);
            }
            if (bucketElem.getChild("ResourceGroupId") != null) {
                String resourceGroupId = bucketElem.getChildText("ResourceGroupId");
                bucket.setResourceGroupId(resourceGroupId);
            }
            if (bucketElem.getChild("StorageClass") != null) {
                bucket.setStorageClass(StorageClass.parse(bucketElem.getChildText("StorageClass")));
            }
            if (bucketElem.getChild("AccessMonitor") != null) {
                bucket.setAccessMonitor(bucketElem.getChildText("AccessMonitor"));
            }
            if (bucketElem.getChild("BucketPolicy") != null && (policyElem = bucketElem.getChild("BucketPolicy")).getChild("XCType") != null) {
                bucket.setXcType(policyElem.getChildText("XCType"));
            }
            bucketInfo.setBucket(bucket);
            if (bucketElem.getChild("Comment") != null) {
                String comment = bucketElem.getChildText("Comment");
                bucketInfo.setComment(comment);
            }
            if (bucketElem.getChild("DataRedundancyType") != null) {
                String dataRedundancyString = bucketElem.getChildText("DataRedundancyType");
                DataRedundancyType dataRedundancyType = DataRedundancyType.parse(dataRedundancyString);
                bucketInfo.setDataRedundancyType(dataRedundancyType);
            }
            String aclString = bucketElem.getChild("AccessControlList").getChildText("Grant");
            CannedAccessControlList acl = CannedAccessControlList.parse(aclString);
            bucketInfo.setCannedACL(acl);
            switch (acl) {
                case PublicRead: {
                    bucketInfo.grantPermission(GroupGrantee.AllUsers, Permission.Read);
                    break;
                }
                case PublicReadWrite: {
                    bucketInfo.grantPermission(GroupGrantee.AllUsers, Permission.FullControl);
                    break;
                }
            }
            Element sseElem = bucketElem.getChild("ServerSideEncryptionRule");
            if (sseElem != null) {
                ServerSideEncryptionConfiguration serverSideEncryptionConfiguration = new ServerSideEncryptionConfiguration();
                ServerSideEncryptionByDefault applyServerSideEncryptionByDefault = new ServerSideEncryptionByDefault();
                applyServerSideEncryptionByDefault.setSSEAlgorithm(sseElem.getChildText("SSEAlgorithm"));
                if (sseElem.getChild("KMSMasterKeyID") != null) {
                    applyServerSideEncryptionByDefault.setKMSMasterKeyID(sseElem.getChildText("KMSMasterKeyID"));
                }
                if (sseElem.getChild("KMSDataEncryption") != null) {
                    applyServerSideEncryptionByDefault.setKMSDataEncryption(sseElem.getChildText("KMSDataEncryption"));
                }
                serverSideEncryptionConfiguration.setApplyServerSideEncryptionByDefault(applyServerSideEncryptionByDefault);
                bucketInfo.setServerSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            }
            return bucketInfo;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketStat parseGetBucketStat(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            Long storage = Long.parseLong(root.getChildText("Storage"));
            Long objectCount = Long.parseLong(root.getChildText("ObjectCount"));
            Long multipartUploadCount = Long.parseLong(root.getChildText("MultipartUploadCount"));
            Long liveChannelCount = ResponseParsers.parseLongWithDefault(root.getChildText("LiveChannelCount"));
            Long lastModifiedTime = ResponseParsers.parseLongWithDefault(root.getChildText("LastModifiedTime"));
            Long standardStorage = ResponseParsers.parseLongWithDefault(root.getChildText("StandardStorage"));
            Long standardObjectCount = ResponseParsers.parseLongWithDefault(root.getChildText("StandardObjectCount"));
            Long infrequentAccessStorage = ResponseParsers.parseLongWithDefault(root.getChildText("InfrequentAccessStorage"));
            Long infrequentAccessRealStorage = ResponseParsers.parseLongWithDefault(root.getChildText("InfrequentAccessRealStorage"));
            Long infrequentAccessObjectCount = ResponseParsers.parseLongWithDefault(root.getChildText("InfrequentAccessObjectCount"));
            Long archiveStorage = ResponseParsers.parseLongWithDefault(root.getChildText("ArchiveStorage"));
            Long archiveRealStorage = ResponseParsers.parseLongWithDefault(root.getChildText("ArchiveRealStorage"));
            Long archiveObjectCount = ResponseParsers.parseLongWithDefault(root.getChildText("ArchiveObjectCount"));
            Long coldArchiveStorage = ResponseParsers.parseLongWithDefault(root.getChildText("ColdArchiveStorage"));
            Long coldArchiveRealStorage = ResponseParsers.parseLongWithDefault(root.getChildText("ColdArchiveRealStorage"));
            Long coldArchiveObjectCount = ResponseParsers.parseLongWithDefault(root.getChildText("ColdArchiveObjectCount"));
            BucketStat bucketStat = new BucketStat().withStorageSize(storage).withObjectCount(objectCount).withMultipartUploadCount(multipartUploadCount).withLiveChannelCount(liveChannelCount).withLastModifiedTime(lastModifiedTime).withStandardStorage(standardStorage).withStandardObjectCount(standardObjectCount).withInfrequentAccessStorage(infrequentAccessStorage).withInfrequentAccessRealStorage(infrequentAccessRealStorage).withInfrequentAccessObjectCount(infrequentAccessObjectCount).withArchiveStorage(archiveStorage).withArchiveRealStorage(archiveRealStorage).withArchiveObjectCount(archiveObjectCount).withColdArchiveStorage(coldArchiveStorage).withColdArchiveRealStorage(coldArchiveRealStorage).withColdArchiveObjectCount(coldArchiveObjectCount);
            return bucketStat;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static CreateLiveChannelResult parseCreateLiveChannel(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            CreateLiveChannelResult result = new CreateLiveChannelResult();
            ArrayList<String> publishUrls = new ArrayList<String>();
            List publishElems = root.getChild("PublishUrls").getChildren("Url");
            for (Element urlElem : publishElems) {
                publishUrls.add(urlElem.getText());
            }
            result.setPublishUrls(publishUrls);
            ArrayList<String> playUrls = new ArrayList<String>();
            List playElems = root.getChild("PlayUrls").getChildren("Url");
            for (Element urlElem : playElems) {
                playUrls.add(urlElem.getText());
            }
            result.setPlayUrls(playUrls);
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static LiveChannelInfo parseGetLiveChannelInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            LiveChannelInfo result = new LiveChannelInfo();
            result.setDescription(root.getChildText("Description"));
            result.setStatus(LiveChannelStatus.parse(root.getChildText("Status")));
            Element targetElem = root.getChild("Target");
            LiveChannelTarget target = new LiveChannelTarget();
            target.setType(targetElem.getChildText("Type"));
            target.setFragDuration(Integer.parseInt(targetElem.getChildText("FragDuration")));
            target.setFragCount(Integer.parseInt(targetElem.getChildText("FragCount")));
            target.setPlaylistName(targetElem.getChildText("PlaylistName"));
            result.setTarget(target);
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static LiveChannelStat parseGetLiveChannelStat(InputStream responseBody) throws ResponseParseException {
        try {
            Element audioElem;
            Element videoElem;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            LiveChannelStat result = new LiveChannelStat();
            result.setPushflowStatus(PushflowStatus.parse(root.getChildText("Status")));
            if (root.getChild("ConnectedTime") != null) {
                result.setConnectedDate(DateUtil.parseIso8601Date(root.getChildText("ConnectedTime")));
            }
            if (root.getChild("RemoteAddr") != null) {
                result.setRemoteAddress(root.getChildText("RemoteAddr"));
            }
            if ((videoElem = root.getChild("Video")) != null) {
                LiveChannelStat.VideoStat videoStat = new LiveChannelStat.VideoStat();
                videoStat.setWidth(Integer.parseInt(videoElem.getChildText("Width")));
                videoStat.setHeight(Integer.parseInt(videoElem.getChildText("Height")));
                videoStat.setFrameRate(Integer.parseInt(videoElem.getChildText("FrameRate")));
                videoStat.setBandWidth(Integer.parseInt(videoElem.getChildText("Bandwidth")));
                videoStat.setCodec(videoElem.getChildText("Codec"));
                result.setVideoStat(videoStat);
            }
            if ((audioElem = root.getChild("Audio")) != null) {
                LiveChannelStat.AudioStat audioStat = new LiveChannelStat.AudioStat();
                audioStat.setBandWidth(Integer.parseInt(audioElem.getChildText("Bandwidth")));
                audioStat.setSampleRate(Integer.parseInt(audioElem.getChildText("SampleRate")));
                audioStat.setCodec(audioElem.getChildText("Codec"));
                result.setAudioStat(audioStat);
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<LiveRecord> parseGetLiveChannelHistory(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<LiveRecord> liveRecords = new ArrayList<LiveRecord>();
            List recordElements = root.getChildren("LiveRecord");
            for (Element recordElem : recordElements) {
                LiveRecord record = new LiveRecord();
                record.setStartDate(DateUtil.parseIso8601Date(recordElem.getChildText("StartTime")));
                record.setEndDate(DateUtil.parseIso8601Date(recordElem.getChildText("EndTime")));
                record.setRemoteAddress(recordElem.getChildText("RemoteAddr"));
                liveRecords.add(record);
            }
            return liveRecords;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static LiveChannelListing parseListLiveChannels(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            LiveChannelListing liveChannelListing = new LiveChannelListing();
            liveChannelListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("Prefix") != null) {
                String prefix = root.getChildText("Prefix");
                liveChannelListing.setPrefix(CodingUtils.isNullOrEmpty(prefix) ? null : prefix);
            }
            if (root.getChild("Marker") != null) {
                String marker = root.getChildText("Marker");
                liveChannelListing.setMarker(CodingUtils.isNullOrEmpty(marker) ? null : marker);
            }
            if (root.getChild("MaxKeys") != null) {
                String maxKeys = root.getChildText("MaxKeys");
                liveChannelListing.setMaxKeys(Integer.valueOf(maxKeys));
            }
            if (root.getChild("NextMarker") != null) {
                String nextMarker = root.getChildText("NextMarker");
                liveChannelListing.setNextMarker(CodingUtils.isNullOrEmpty(nextMarker) ? null : nextMarker);
            }
            List liveChannelElems = root.getChildren("LiveChannel");
            for (Element elem : liveChannelElems) {
                LiveChannel liveChannel = new LiveChannel();
                liveChannel.setName(elem.getChildText("Name"));
                liveChannel.setDescription(elem.getChildText("Description"));
                liveChannel.setStatus(LiveChannelStatus.parse(elem.getChildText("Status")));
                liveChannel.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ArrayList<String> publishUrls = new ArrayList<String>();
                List publishElems = elem.getChild("PublishUrls").getChildren("Url");
                for (Element urlElem : publishElems) {
                    publishUrls.add(urlElem.getText());
                }
                liveChannel.setPublishUrls(publishUrls);
                ArrayList<String> playUrls = new ArrayList<String>();
                List playElems = elem.getChild("PlayUrls").getChildren("Url");
                for (Element urlElem : playElems) {
                    playUrls.add(urlElem.getText());
                }
                liveChannel.setPlayUrls(playUrls);
                liveChannelListing.addLiveChannel(liveChannel);
            }
            return liveChannelListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static UserQos parseGetUserQos(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            UserQos userQos = new UserQos();
            if (root.getChild("StorageCapacity") != null) {
                userQos.setStorageCapacity(Integer.parseInt(root.getChildText("StorageCapacity")));
            }
            return userQos;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketVersioningConfiguration parseGetBucketVersioning(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketVersioningConfiguration configuration = new BucketVersioningConfiguration();
            configuration.setStatus(root.getChildText("Status"));
            return configuration;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static ServerSideEncryptionConfiguration parseGetBucketEncryption(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ServerSideEncryptionConfiguration configuration = new ServerSideEncryptionConfiguration();
            ServerSideEncryptionByDefault sseByDefault = new ServerSideEncryptionByDefault();
            Element sseElem = root.getChild("ApplyServerSideEncryptionByDefault");
            sseByDefault.setSSEAlgorithm(sseElem.getChildText("SSEAlgorithm"));
            sseByDefault.setKMSMasterKeyID(sseElem.getChildText("KMSMasterKeyID"));
            if (sseElem.getChild("KMSDataEncryption") != null) {
                sseByDefault.setKMSDataEncryption(sseElem.getChildText("KMSDataEncryption"));
            }
            configuration.setApplyServerSideEncryptionByDefault(sseByDefault);
            return configuration;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetBucketPolicyResult parseGetBucketPolicy(InputStream responseBody) throws ResponseParseException {
        try {
            String s;
            GetBucketPolicyResult result = new GetBucketPolicyResult();
            BufferedReader reader = new BufferedReader(new InputStreamReader(responseBody));
            StringBuilder sb = new StringBuilder();
            while ((s = reader.readLine()) != null) {
                sb.append(s);
            }
            result.setPolicy(sb.toString());
            return result;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetBucketRequestPaymentResult parseGetBucketRequestPayment(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            GetBucketRequestPaymentResult paymentResult = new GetBucketRequestPaymentResult();
            if (root.getChild("Payer") != null) {
                Payer payer = Payer.parse(root.getChildText("Payer"));
                paymentResult.setPayer(payer);
            }
            return paymentResult;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static UserQosInfo parseGetUserQosInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            UserQosInfo userQosInfo = new UserQosInfo();
            userQosInfo.setRegion(root.getChildText("Region"));
            userQosInfo.setTotalUploadBw(Integer.valueOf(root.getChildText("TotalUploadBandwidth")));
            userQosInfo.setIntranetUploadBw(Integer.valueOf(root.getChildText("IntranetUploadBandwidth")));
            userQosInfo.setExtranetUploadBw(Integer.valueOf(root.getChildText("ExtranetUploadBandwidth")));
            userQosInfo.setTotalDownloadBw(Integer.valueOf(root.getChildText("TotalDownloadBandwidth")));
            userQosInfo.setIntranetDownloadBw(Integer.valueOf(root.getChildText("IntranetDownloadBandwidth")));
            userQosInfo.setExtranetDownloadBw(Integer.valueOf(root.getChildText("ExtranetDownloadBandwidth")));
            userQosInfo.setTotalQps(Integer.valueOf(root.getChildText("TotalQps")));
            userQosInfo.setIntranetQps(Integer.valueOf(root.getChildText("IntranetQps")));
            userQosInfo.setExtranetQps(Integer.valueOf(root.getChildText("ExtranetQps")));
            return userQosInfo;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketQosInfo parseGetBucketQosInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketQosInfo bucketQosInfo = new BucketQosInfo();
            bucketQosInfo.setTotalUploadBw(Integer.valueOf(root.getChildText("TotalUploadBandwidth")));
            bucketQosInfo.setIntranetUploadBw(Integer.valueOf(root.getChildText("IntranetUploadBandwidth")));
            bucketQosInfo.setExtranetUploadBw(Integer.valueOf(root.getChildText("ExtranetUploadBandwidth")));
            bucketQosInfo.setTotalDownloadBw(Integer.valueOf(root.getChildText("TotalDownloadBandwidth")));
            bucketQosInfo.setIntranetDownloadBw(Integer.valueOf(root.getChildText("IntranetDownloadBandwidth")));
            bucketQosInfo.setExtranetDownloadBw(Integer.valueOf(root.getChildText("ExtranetDownloadBandwidth")));
            bucketQosInfo.setTotalQps(Integer.valueOf(root.getChildText("TotalQps")));
            bucketQosInfo.setIntranetQps(Integer.valueOf(root.getChildText("IntranetQps")));
            bucketQosInfo.setExtranetQps(Integer.valueOf(root.getChildText("ExtranetQps")));
            return bucketQosInfo;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    private static InventoryConfiguration parseInventoryConfigurationElem(Element configElem) {
        InventoryConfiguration inventoryConfiguration = new InventoryConfiguration();
        if (configElem.getChildText("Id") != null) {
            inventoryConfiguration.setInventoryId(configElem.getChildText("Id"));
        }
        if (configElem.getChildText("IncludedObjectVersions") != null) {
            inventoryConfiguration.setIncludedObjectVersions(configElem.getChildText("IncludedObjectVersions"));
        }
        if (configElem.getChildText("IsEnabled") != null) {
            inventoryConfiguration.setEnabled(Boolean.valueOf(configElem.getChildText("IsEnabled")));
        }
        if (configElem.getChild("Filter") != null) {
            Element elem = configElem.getChild("Filter");
            InventoryFilter filter = new InventoryFilter();
            if (elem.getChildText("Prefix") != null) {
                filter = new InventoryFilter().withPrefix(elem.getChildText("Prefix"));
            }
            if (elem.getChildText("LastModifyBeginTimeStamp") != null) {
                filter.setLastModifyBeginTimeStamp(Long.valueOf(elem.getChildText("LastModifyBeginTimeStamp")));
            }
            if (elem.getChildText("LastModifyEndTimeStamp") != null) {
                filter.setLastModifyEndTimeStamp(Long.valueOf(elem.getChildText("LastModifyEndTimeStamp")));
            }
            if (elem.getChildText("LowerSizeBound") != null) {
                filter.setLowerSizeBound(Long.valueOf(elem.getChildText("LowerSizeBound")));
            }
            if (elem.getChildText("UpperSizeBound") != null) {
                filter.setUpperSizeBound(Long.valueOf(elem.getChildText("UpperSizeBound")));
            }
            if (elem.getChildText("StorageClass") != null) {
                filter.setStorageClass(elem.getChildText("StorageClass"));
            }
            inventoryConfiguration.setInventoryFilter(filter);
        }
        if (configElem.getChild("Schedule") != null) {
            InventorySchedule schedule = new InventorySchedule();
            Element elem = configElem.getChild("Schedule");
            if (elem.getChild("Frequency") != null) {
                schedule.setFrequency(elem.getChildText("Frequency"));
                inventoryConfiguration.setSchedule(schedule);
            }
        }
        if (configElem.getChild("OptionalFields") != null) {
            Element OptionalFieldsElem = configElem.getChild("OptionalFields");
            ArrayList<String> optionalFields = new ArrayList<String>();
            List fieldElems = OptionalFieldsElem.getChildren("Field");
            for (Element e : fieldElems) {
                optionalFields.add(e.getText());
            }
            inventoryConfiguration.setOptionalFields(optionalFields);
        }
        if (configElem.getChild("Destination") != null) {
            InventoryDestination destination = new InventoryDestination();
            Element destinElem = configElem.getChild("Destination");
            if (destinElem.getChild("OSSBucketDestination") != null) {
                InventoryOSSBucketDestination ossBucketDestion = new InventoryOSSBucketDestination();
                Element bucketDistinElem = destinElem.getChild("OSSBucketDestination");
                if (bucketDistinElem.getChildText("Format") != null) {
                    ossBucketDestion.setFormat(bucketDistinElem.getChildText("Format"));
                }
                if (bucketDistinElem.getChildText("AccountId") != null) {
                    ossBucketDestion.setAccountId(bucketDistinElem.getChildText("AccountId"));
                }
                if (bucketDistinElem.getChildText("RoleArn") != null) {
                    ossBucketDestion.setRoleArn(bucketDistinElem.getChildText("RoleArn"));
                }
                if (bucketDistinElem.getChildText("Bucket") != null) {
                    String tmpBucket = bucketDistinElem.getChildText("Bucket");
                    String bucket = tmpBucket.replaceFirst("acs:oss:::", "");
                    ossBucketDestion.setBucket(bucket);
                }
                if (bucketDistinElem.getChildText("Prefix") != null) {
                    ossBucketDestion.setPrefix(bucketDistinElem.getChildText("Prefix"));
                }
                if (bucketDistinElem.getChild("Encryption") != null) {
                    InventoryEncryption inventoryEncryption = new InventoryEncryption();
                    if (bucketDistinElem.getChild("Encryption").getChild("SSE-KMS") != null) {
                        String keyId = bucketDistinElem.getChild("Encryption").getChild("SSE-KMS").getChildText("KeyId");
                        inventoryEncryption.setServerSideKmsEncryption(new InventoryServerSideEncryptionKMS().withKeyId(keyId));
                    } else if (bucketDistinElem.getChild("Encryption").getChild("SSE-OSS") != null) {
                        inventoryEncryption.setServerSideOssEncryption(new InventoryServerSideEncryptionOSS());
                    }
                    ossBucketDestion.setEncryption(inventoryEncryption);
                }
                destination.setOssBucketDestination(ossBucketDestion);
            }
            inventoryConfiguration.setDestination(destination);
        }
        return inventoryConfiguration;
    }

    public static GetBucketInventoryConfigurationResult parseGetBucketInventoryConfig(InputStream responseBody) throws ResponseParseException {
        try {
            GetBucketInventoryConfigurationResult result = new GetBucketInventoryConfigurationResult();
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            InventoryConfiguration configuration = ResponseParsers.parseInventoryConfigurationElem(root);
            result.setInventoryConfiguration(configuration);
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static ListBucketInventoryConfigurationsResult parseListBucketInventoryConfigurations(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ListBucketInventoryConfigurationsResult result = new ListBucketInventoryConfigurationsResult();
            ArrayList<InventoryConfiguration> inventoryConfigurationList = null;
            if (root.getChild("InventoryConfiguration") != null) {
                inventoryConfigurationList = new ArrayList<InventoryConfiguration>();
                List configurationElems = root.getChildren("InventoryConfiguration");
                for (Element elem : configurationElems) {
                    InventoryConfiguration configuration = ResponseParsers.parseInventoryConfigurationElem(elem);
                    inventoryConfigurationList.add(configuration);
                }
                result.setInventoryConfigurationList(inventoryConfigurationList);
            }
            if (root.getChild("ContinuationToken") != null) {
                result.setContinuationToken(root.getChildText("ContinuationToken"));
            }
            if (root.getChild("IsTruncated") != null) {
                result.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            }
            if (root.getChild("NextContinuationToken") != null) {
                result.setNextContinuationToken(root.getChildText("NextContinuationToken"));
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<LifecycleRule> parseGetBucketLifecycle(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<LifecycleRule> lifecycleRules = new ArrayList<LifecycleRule>();
            List ruleElements = root.getChildren("Rule");
            for (Element ruleElem : ruleElements) {
                Element filterElems;
                List tagElems;
                LifecycleRule rule = new LifecycleRule();
                if (ruleElem.getChild("ID") != null) {
                    rule.setId(ruleElem.getChildText("ID"));
                }
                if (ruleElem.getChild("Prefix") != null) {
                    rule.setPrefix(ruleElem.getChildText("Prefix"));
                }
                if (ruleElem.getChild("AtimeBase") != null) {
                    rule.setaTimeBase(ruleElem.getChildText("AtimeBase"));
                }
                if ((tagElems = ruleElem.getChildren("Tag")) != null) {
                    for (Element tagElem : tagElems) {
                        String key = null;
                        Iterator value = null;
                        if (tagElem.getChild("Key") != null) {
                            key = tagElem.getChildText("Key");
                        }
                        if (tagElem.getChild("Value") != null) {
                            value = tagElem.getChildText("Value");
                        }
                        rule.addTag(key, (String)((Object)value));
                    }
                }
                if ((filterElems = ruleElem.getChild("Filter")) != null) {
                    LifecycleFilter lifecycleFilter = new LifecycleFilter();
                    if (filterElems.getChild("ObjectSizeGreaterThan") != null) {
                        lifecycleFilter.setObjectSizeGreaterThan(Long.valueOf(filterElems.getChildText("ObjectSizeGreaterThan")));
                    }
                    if (filterElems.getChild("ObjectSizeLessThan") != null) {
                        lifecycleFilter.setObjectSizeLessThan(Long.valueOf(filterElems.getChildText("ObjectSizeLessThan")));
                    }
                    ArrayList<LifecycleNot> notList = new ArrayList<LifecycleNot>();
                    for (Element notEle : filterElems.getChildren("Not")) {
                        LifecycleNot lifecycleNot = new LifecycleNot();
                        lifecycleNot.setPrefix(notEle.getChildText("Prefix"));
                        if (notEle.getChild("Tag") != null) {
                            Tag tag = new Tag(notEle.getChild("Tag").getChildText("Key"), notEle.getChild("Tag").getChildText("Value"));
                            lifecycleNot.setTag(tag);
                        }
                        notList.add(lifecycleNot);
                    }
                    lifecycleFilter.setNotList(notList);
                    rule.setFilter(lifecycleFilter);
                }
                if (ruleElem.getChild("Status") != null) {
                    rule.setStatus(LifecycleRule.RuleStatus.valueOf(ruleElem.getChildText("Status")));
                }
                if (ruleElem.getChild("Expiration") != null) {
                    if (ruleElem.getChild("Expiration").getChild("Date") != null) {
                        Date expirationDate = DateUtil.parseIso8601Date(ruleElem.getChild("Expiration").getChildText("Date"));
                        rule.setExpirationTime(expirationDate);
                    } else if (ruleElem.getChild("Expiration").getChild("Days") != null) {
                        rule.setExpirationDays(Integer.parseInt(ruleElem.getChild("Expiration").getChildText("Days")));
                    } else if (ruleElem.getChild("Expiration").getChild("CreatedBeforeDate") != null) {
                        Date createdBeforeDate = DateUtil.parseIso8601Date(ruleElem.getChild("Expiration").getChildText("CreatedBeforeDate"));
                        rule.setCreatedBeforeDate(createdBeforeDate);
                    } else if (ruleElem.getChild("Expiration").getChild("ExpiredObjectDeleteMarker") != null) {
                        rule.setExpiredDeleteMarker(Boolean.valueOf(ruleElem.getChild("Expiration").getChildText("ExpiredObjectDeleteMarker")));
                    }
                }
                if (ruleElem.getChild("AbortMultipartUpload") != null) {
                    LifecycleRule.AbortMultipartUpload abortMultipartUpload = new LifecycleRule.AbortMultipartUpload();
                    if (ruleElem.getChild("AbortMultipartUpload").getChild("Days") != null) {
                        abortMultipartUpload.setExpirationDays(Integer.parseInt(ruleElem.getChild("AbortMultipartUpload").getChildText("Days")));
                    } else {
                        Date createdBeforeDate = DateUtil.parseIso8601Date(ruleElem.getChild("AbortMultipartUpload").getChildText("CreatedBeforeDate"));
                        abortMultipartUpload.setCreatedBeforeDate(createdBeforeDate);
                    }
                    rule.setAbortMultipartUpload(abortMultipartUpload);
                }
                List transitionElements = ruleElem.getChildren("Transition");
                ArrayList<LifecycleRule.StorageTransition> storageTransitions = new ArrayList<LifecycleRule.StorageTransition>();
                for (Element transitionElem : transitionElements) {
                    LifecycleRule.StorageTransition storageTransition = new LifecycleRule.StorageTransition();
                    if (transitionElem.getChild("Days") != null) {
                        storageTransition.setExpirationDays(Integer.parseInt(transitionElem.getChildText("Days")));
                    } else {
                        Date createdBeforeDate = DateUtil.parseIso8601Date(transitionElem.getChildText("CreatedBeforeDate"));
                        storageTransition.setCreatedBeforeDate(createdBeforeDate);
                    }
                    if (transitionElem.getChild("StorageClass") != null) {
                        storageTransition.setStorageClass(StorageClass.parse(transitionElem.getChildText("StorageClass")));
                    }
                    if (transitionElem.getChild("IsAccessTime") != null) {
                        storageTransition.setIsAccessTime(Boolean.valueOf(transitionElem.getChildText("IsAccessTime")));
                    }
                    if (transitionElem.getChild("ReturnToStdWhenVisit") != null) {
                        storageTransition.setReturnToStdWhenVisit(Boolean.valueOf(transitionElem.getChildText("ReturnToStdWhenVisit")));
                    }
                    if (transitionElem.getChild("AllowSmallFile") != null) {
                        storageTransition.setAllowSmallFile(Boolean.valueOf(transitionElem.getChildText("AllowSmallFile")));
                    }
                    storageTransitions.add(storageTransition);
                }
                rule.setStorageTransition(storageTransitions);
                if (ruleElem.getChild("NoncurrentVersionExpiration") != null) {
                    LifecycleRule.NoncurrentVersionExpiration expiration = new LifecycleRule.NoncurrentVersionExpiration();
                    if (ruleElem.getChild("NoncurrentVersionExpiration").getChild("NoncurrentDays") != null) {
                        expiration.setNoncurrentDays(Integer.parseInt(ruleElem.getChild("NoncurrentVersionExpiration").getChildText("NoncurrentDays")));
                        rule.setNoncurrentVersionExpiration(expiration);
                    }
                }
                List versionTansitionElements = ruleElem.getChildren("NoncurrentVersionTransition");
                ArrayList<LifecycleRule.NoncurrentVersionStorageTransition> noncurrentVersionTransitions = new ArrayList<LifecycleRule.NoncurrentVersionStorageTransition>();
                for (Element transitionElem : versionTansitionElements) {
                    LifecycleRule.NoncurrentVersionStorageTransition transition = new LifecycleRule.NoncurrentVersionStorageTransition();
                    if (transitionElem.getChild("NoncurrentDays") != null) {
                        transition.setNoncurrentDays(Integer.parseInt(transitionElem.getChildText("NoncurrentDays")));
                    }
                    if (transitionElem.getChild("StorageClass") != null) {
                        transition.setStorageClass(StorageClass.parse(transitionElem.getChildText("StorageClass")));
                    }
                    if (transitionElem.getChild("IsAccessTime") != null) {
                        transition.setIsAccessTime(Boolean.valueOf(transitionElem.getChildText("IsAccessTime")));
                    }
                    if (transitionElem.getChild("ReturnToStdWhenVisit") != null) {
                        transition.setReturnToStdWhenVisit(Boolean.valueOf(transitionElem.getChildText("ReturnToStdWhenVisit")));
                    }
                    if (transitionElem.getChild("AllowSmallFile") != null) {
                        transition.setAllowSmallFile(Boolean.valueOf(transitionElem.getChildText("AllowSmallFile")));
                    }
                    noncurrentVersionTransitions.add(transition);
                }
                rule.setNoncurrentVersionStorageTransitions(noncurrentVersionTransitions);
                lifecycleRules.add(rule);
            }
            return lifecycleRules;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<CnameConfiguration> parseGetBucketCname(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<CnameConfiguration> cnames = new ArrayList<CnameConfiguration>();
            List cnameElements = root.getChildren("Cname");
            for (Element cnameElem : cnameElements) {
                Element certElem;
                CnameConfiguration cname = new CnameConfiguration();
                cname.setDomain(cnameElem.getChildText("Domain"));
                cname.setStatus(CnameConfiguration.CnameStatus.valueOf(cnameElem.getChildText("Status")));
                cname.setLastMofiedTime(DateUtil.parseIso8601Date(cnameElem.getChildText("LastModified")));
                if (cnameElem.getChildText("IsPurgeCdnCache") != null) {
                    boolean purgeCdnCache = Boolean.valueOf(cnameElem.getChildText("IsPurgeCdnCache"));
                    cname.setPurgeCdnCache(purgeCdnCache);
                }
                if ((certElem = cnameElem.getChild("Certificate")) != null) {
                    cname.setCertType(CnameConfiguration.CertType.parse(certElem.getChildText("Type")));
                    cname.setCertStatus(CnameConfiguration.CertStatus.parse(certElem.getChildText("Status")));
                    cname.setCertId(certElem.getChildText("CertId"));
                    cname.setCreationDate(certElem.getChildText("CreationDate"));
                    cname.setFingerprint(certElem.getChildText("Fingerprint"));
                    cname.setValidStartDate(certElem.getChildText("ValidStartDate"));
                    cname.setValidEndDate(certElem.getChildText("ValidEndDate"));
                }
                cnames.add(cname);
            }
            return cnames;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static CreateBucketCnameTokenResult parseCreateBucketCnameToken(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            String bucket = root.getChildText("Bucket");
            String cname = root.getChildText("Cname");
            String token = root.getChildText("Token");
            String expireTime = root.getChildText("ExpireTime");
            CreateBucketCnameTokenResult result = new CreateBucketCnameTokenResult();
            result.setBucket(bucket);
            result.setCname(cname);
            result.setToken(token);
            result.setExpireTime(expireTime);
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetBucketCnameTokenResult parseGetBucketCnameToken(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            String bucket = root.getChildText("Bucket");
            String cname = root.getChildText("Cname");
            String token = root.getChildText("Token");
            String expireTime = root.getChildText("ExpireTime");
            GetBucketCnameTokenResult result = new GetBucketCnameTokenResult();
            result.setBucket(bucket);
            result.setCname(cname);
            result.setToken(token);
            result.setExpireTime(expireTime);
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static SetAsyncFetchTaskResult parseSetAsyncFetchTaskResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            SetAsyncFetchTaskResult setAsyncFetchTaskResult = new SetAsyncFetchTaskResult();
            setAsyncFetchTaskResult.setTaskId(root.getChildText("TaskId"));
            return setAsyncFetchTaskResult;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    private static AsyncFetchTaskConfiguration parseAsyncFetchTaskInfo(Element taskInfoEle) {
        if (taskInfoEle == null) {
            return null;
        }
        AsyncFetchTaskConfiguration configuration = new AsyncFetchTaskConfiguration();
        configuration.setUrl(taskInfoEle.getChildText("Url"));
        configuration.setObjectName(taskInfoEle.getChildText("Object"));
        configuration.setHost(taskInfoEle.getChildText("Host"));
        configuration.setContentMd5(taskInfoEle.getChildText("ContentMD5"));
        configuration.setCallback(taskInfoEle.getChildText("Callback"));
        if (taskInfoEle.getChild("IgnoreSameKey") != null) {
            configuration.setIgnoreSameKey(Boolean.valueOf(taskInfoEle.getChildText("IgnoreSameKey")));
        }
        return configuration;
    }

    public static GetAsyncFetchTaskResult parseGetAsyncFetchTaskResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            GetAsyncFetchTaskResult getAsyncFetchTaskResult = new GetAsyncFetchTaskResult();
            getAsyncFetchTaskResult.setTaskId(root.getChildText("TaskId"));
            getAsyncFetchTaskResult.setAsyncFetchTaskState(AsyncFetchTaskState.parse(root.getChildText("State")));
            getAsyncFetchTaskResult.setErrorMsg(root.getChildText("ErrorMsg"));
            AsyncFetchTaskConfiguration configuration = ResponseParsers.parseAsyncFetchTaskInfo(root.getChild("TaskInfo"));
            getAsyncFetchTaskResult.setAsyncFetchTaskConfiguration(configuration);
            return getAsyncFetchTaskResult;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static Vpcip parseGetCreateVpcipResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            Vpcip vpcip = new Vpcip();
            if (root.getChild("Region") != null) {
                vpcip.setRegion(root.getChildText("Region"));
            }
            if (root.getChild("VpcId") != null) {
                vpcip.setVpcId(root.getChildText("VpcId"));
            }
            if (root.getChild("Vip") != null) {
                vpcip.setVip(root.getChildText("Vip"));
            }
            if (root.getChild("Label") != null) {
                vpcip.setLabel(root.getChildText("Label"));
            }
            return vpcip;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<Vpcip> parseListVpcipResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<Vpcip> vpcipList = new ArrayList<Vpcip>();
            List vpcips = root.getChildren("Vpcip");
            for (Element e : vpcips) {
                Vpcip vpcipInfo = new Vpcip();
                vpcipInfo.setRegion(e.getChildText("Region"));
                vpcipInfo.setVpcId(e.getChildText("VpcId"));
                vpcipInfo.setVip(e.getChildText("Vip"));
                vpcipInfo.setLabel(e.getChildText("Label"));
                vpcipList.add(vpcipInfo);
            }
            return vpcipList;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<VpcPolicy> parseListVpcPolicyResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<VpcPolicy> vpcipList = new ArrayList<VpcPolicy>();
            List vpcips = root.getChildren("Vpcip");
            for (Element e : vpcips) {
                VpcPolicy vpcipInfo = new VpcPolicy();
                vpcipInfo.setRegion(e.getChildText("Region"));
                vpcipInfo.setVpcId(e.getChildText("VpcId"));
                vpcipInfo.setVip(e.getChildText("Vip"));
                vpcipList.add(vpcipInfo);
            }
            return vpcipList;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static InitiateBucketWormResult parseInitiateBucketWormResponseHeader(Map<String, String> headers) throws ResponseParseException {
        try {
            InitiateBucketWormResult result = new InitiateBucketWormResult();
            result.setWormId(headers.get("x-oss-worm-id"));
            return result;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetBucketWormResult parseWormConfiguration(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            GetBucketWormResult result = new GetBucketWormResult();
            result.setWormId(root.getChildText("WormId"));
            result.setWormState(root.getChildText("State"));
            result.setRetentionPeriodInDays(Integer.parseInt(root.getChildText("RetentionPeriodInDays")));
            result.setCreationDate(DateUtil.parseIso8601Date(root.getChildText("CreationDate")));
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static DeleteDirectoryResult parseDeleteDirectoryResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            DeleteDirectoryResult result = new DeleteDirectoryResult();
            result.setDeleteNumber(Integer.valueOf(root.getChildText("DeleteNumber")));
            result.setDirectoryName(root.getChildText("DirectoryName"));
            if (root.getChild("NextDeleteToken") != null) {
                result.setNextDeleteToken(root.getChildText("NextDeleteToken"));
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetBucketResourceGroupResult parseResourceGroupConfiguration(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            GetBucketResourceGroupResult result = new GetBucketResourceGroupResult();
            result.setResourceGroupId(root.getChildText("ResourceGroupId"));
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetBucketDataRedundancyTransitionResult parseBucketDataRedundancyTransitionResult(Element element) {
        GetBucketDataRedundancyTransitionResult result = new GetBucketDataRedundancyTransitionResult();
        result.setTaskId(element.getChildText("TaskId"));
        result.setCreateTime(element.getChildText("CreateTime"));
        if (null != element.getChild("StartTime")) {
            result.setStartTime(element.getChildText("StartTime"));
        }
        if (null != element.getChild("EndTime")) {
            result.setEndTime(element.getChildText("EndTime"));
        }
        result.setStatus(element.getChildText("Status"));
        if (null != element.getChild("EstimatedRemainingTime")) {
            result.setEstimatedRemainingTime(Integer.parseInt(element.getChildText("EstimatedRemainingTime")));
        }
        if (null != element.getChild("ProcessPercentage")) {
            result.setProcessPercentage(Integer.parseInt(element.getChildText("ProcessPercentage")));
        }
        if (null != element.getChild("Bucket")) {
            result.setBucket(element.getChildText("Bucket"));
        }
        return result;
    }

    public static final class ListAccessPointsResponseParser
    implements ResponseParser<ListAccessPointsResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListAccessPointsResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                ListAccessPointsResult result = this.parseListAccessPoint(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                ListAccessPointsResult listAccessPointsResult = result;
                return listAccessPointsResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private ListAccessPointsResult parseListAccessPoint(InputStream inputStream) throws ResponseParseException {
            ListAccessPointsResult listAccessPointsResult = new ListAccessPointsResult();
            if (inputStream == null) {
                return listAccessPointsResult;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                if (root.getChildText("IsTruncated") != null) {
                    listAccessPointsResult.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
                }
                listAccessPointsResult.setNextContinuationToken(root.getChildText("NextContinuationToken"));
                listAccessPointsResult.setAccountId(root.getChildText("AccountId"));
                if (root.getChild("AccessPoints") != null) {
                    List accessElems = root.getChild("AccessPoints").getChildren("AccessPoint");
                    ArrayList<AccessPoint> accessPoints = new ArrayList<AccessPoint>();
                    for (Element e : accessElems) {
                        AccessPoint accessPoint = new AccessPoint();
                        accessPoint.setBucket(e.getChildText("Bucket"));
                        accessPoint.setAccessPointName(e.getChildText("AccessPointName"));
                        accessPoint.setAlias(e.getChildText("Alias"));
                        accessPoint.setNetworkOrigin(e.getChildText("NetworkOrigin"));
                        accessPoint.setStatus(e.getChildText("Status"));
                        if (e.getChild("VpcConfiguration").getChildText("VpcId") != null) {
                            AccessPointVpcConfiguration accessPointVpcConfiguration = new AccessPointVpcConfiguration();
                            accessPointVpcConfiguration.setVpcId(e.getChild("VpcConfiguration").getChildText("VpcId"));
                            accessPoint.setVpc(accessPointVpcConfiguration);
                        }
                        accessPoints.add(accessPoint);
                    }
                    listAccessPointsResult.setAccessPoints(accessPoints);
                }
                return listAccessPointsResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class GetAccessPointPolicyResponseParser
    implements ResponseParser<GetAccessPointPolicyResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetAccessPointPolicyResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetAccessPointPolicyResult result = this.parseGetAccessPointPolicy(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                GetAccessPointPolicyResult getAccessPointPolicyResult = result;
                return getAccessPointPolicyResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private GetAccessPointPolicyResult parseGetAccessPointPolicy(InputStream inputStream) throws ResponseParseException {
            GetAccessPointPolicyResult getAccessPointPolicyResult = new GetAccessPointPolicyResult();
            if (inputStream == null) {
                return getAccessPointPolicyResult;
            }
            try {
                String s;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder sb = new StringBuilder();
                while ((s = reader.readLine()) != null) {
                    sb.append(s);
                }
                getAccessPointPolicyResult.setAccessPointPolicy(sb.toString());
                return getAccessPointPolicyResult;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class GetAccessPointResponseParser
    implements ResponseParser<GetAccessPointResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetAccessPointResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetAccessPointResult result = this.parseGetAccessPoint(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                GetAccessPointResult getAccessPointResult = result;
                return getAccessPointResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private GetAccessPointResult parseGetAccessPoint(InputStream inputStream) throws ResponseParseException {
            GetAccessPointResult getAccessPointResult = new GetAccessPointResult();
            if (inputStream == null) {
                return getAccessPointResult;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                getAccessPointResult.setAccessPointName(root.getChildText("AccessPointName"));
                getAccessPointResult.setBucket(root.getChildText("Bucket"));
                getAccessPointResult.setAccountId(root.getChildText("AccountId"));
                getAccessPointResult.setNetworkOrigin(root.getChildText("NetworkOrigin"));
                if (root.getChild("VpcConfiguration").getChildText("VpcId") != null) {
                    AccessPointVpcConfiguration accessPointVpcConfiguration = new AccessPointVpcConfiguration();
                    accessPointVpcConfiguration.setVpcId(root.getChild("VpcConfiguration").getChildText("VpcId"));
                    getAccessPointResult.setVpc(accessPointVpcConfiguration);
                }
                getAccessPointResult.setAccessPointArn(root.getChildText("AccessPointArn"));
                if (root.getChildText("CreationDate") != null) {
                    getAccessPointResult.setCreationDate(root.getChildText("CreationDate"));
                }
                getAccessPointResult.setAlias(root.getChildText("Alias"));
                getAccessPointResult.setStatus(root.getChildText("Status"));
                if (root.getChild("Endpoints") != null) {
                    AccessPointEndpoints accessPointEndpoints = new AccessPointEndpoints();
                    if (root.getChild("Endpoints").getChildText("PublicEndpoint") != null) {
                        accessPointEndpoints.setPublicEndpoint(root.getChild("Endpoints").getChildText("PublicEndpoint"));
                    }
                    if (root.getChild("Endpoints").getChildText("InternalEndpoint") != null) {
                        accessPointEndpoints.setInternalEndpoint(root.getChild("Endpoints").getChildText("InternalEndpoint"));
                    }
                    getAccessPointResult.setEndpoints(accessPointEndpoints);
                }
                return getAccessPointResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class CreateAccessPointResponseParser
    implements ResponseParser<CreateAccessPointResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CreateAccessPointResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CreateAccessPointResult result = this.parseCreateAccessPoint(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                CreateAccessPointResult createAccessPointResult = result;
                return createAccessPointResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private CreateAccessPointResult parseCreateAccessPoint(InputStream inputStream) throws ResponseParseException {
            CreateAccessPointResult createAccessPointResult = new CreateAccessPointResult();
            if (inputStream == null) {
                return createAccessPointResult;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                createAccessPointResult.setAccessPointArn(root.getChildText("AccessPointArn"));
                createAccessPointResult.setAlias(root.getChildText("Alias"));
                return createAccessPointResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class GetBucketPolicyStatusResponseParser
    implements ResponseParser<GetBucketPolicyStatusResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketPolicyStatusResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketPolicyStatusResult result = this.parseGetBucketPolicyStatus(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                GetBucketPolicyStatusResult getBucketPolicyStatusResult = result;
                return getBucketPolicyStatusResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private GetBucketPolicyStatusResult parseGetBucketPolicyStatus(InputStream inputStream) throws ResponseParseException {
            GetBucketPolicyStatusResult getBucketPolicyStatusResult = new GetBucketPolicyStatusResult();
            if (inputStream == null) {
                return getBucketPolicyStatusResult;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                if (root.getChildText("IsPublic") != null) {
                    getBucketPolicyStatusResult.setPublic(Boolean.valueOf(root.getChildText("IsPublic")));
                }
                return getBucketPolicyStatusResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class GetBucketPublicAccessBlockResponseParser
    implements ResponseParser<GetBucketPublicAccessBlockResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketPublicAccessBlockResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketPublicAccessBlockResult result = this.parseGetBucketPublicAccessBlock(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                GetBucketPublicAccessBlockResult getBucketPublicAccessBlockResult = result;
                return getBucketPublicAccessBlockResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private GetBucketPublicAccessBlockResult parseGetBucketPublicAccessBlock(InputStream inputStream) throws ResponseParseException {
            GetBucketPublicAccessBlockResult getBucketPublicAccessBlockResult = new GetBucketPublicAccessBlockResult();
            if (inputStream == null) {
                return getBucketPublicAccessBlockResult;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                if (root.getChildText("BlockPublicAccess") != null) {
                    getBucketPublicAccessBlockResult.setBlockPublicAccess(Boolean.valueOf(root.getChildText("BlockPublicAccess")));
                }
                return getBucketPublicAccessBlockResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class GetPublicAccessBlockResponseParser
    implements ResponseParser<GetPublicAccessBlockResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetPublicAccessBlockResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetPublicAccessBlockResult result = this.parseGetPublicAccessBlock(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                GetPublicAccessBlockResult getPublicAccessBlockResult = result;
                return getPublicAccessBlockResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private GetPublicAccessBlockResult parseGetPublicAccessBlock(InputStream inputStream) throws ResponseParseException {
            GetPublicAccessBlockResult getPublicAccessBlockResult = new GetPublicAccessBlockResult();
            if (inputStream == null) {
                return getPublicAccessBlockResult;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                if (root.getChildText("BlockPublicAccess") != null) {
                    getPublicAccessBlockResult.setBlockPublicAccess(Boolean.valueOf(root.getChildText("BlockPublicAccess")));
                }
                return getPublicAccessBlockResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class GetBucketHttpsConfigResponseParser
    implements ResponseParser<GetBucketHttpsConfigResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketHttpsConfigResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketHttpsConfigResult result = this.parseGetBucketHttpsConfig(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                GetBucketHttpsConfigResult getBucketHttpsConfigResult = result;
                return getBucketHttpsConfigResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private GetBucketHttpsConfigResult parseGetBucketHttpsConfig(InputStream inputStream) throws ResponseParseException {
            GetBucketHttpsConfigResult result = new GetBucketHttpsConfigResult();
            if (inputStream == null) {
                return result;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                Element tlsElem = root.getChild("TLS");
                if (tlsElem != null) {
                    result.setEnable(Boolean.parseBoolean(tlsElem.getChildText("Enable")));
                    ArrayList<String> tlsVersion = new ArrayList<String>();
                    List tlsVersionElem = tlsElem.getChildren("TLSVersion");
                    if (!tlsVersionElem.isEmpty()) {
                        for (Element elem : tlsVersionElem) {
                            String version = elem.getValue();
                            tlsVersion.add(version);
                        }
                        result.setTlsVersion(tlsVersion);
                    }
                }
                return result;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class ListUserDataRedundancyTransitionResponseParser
    implements ResponseParser<ListUserDataRedundancyTransitionResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListUserDataRedundancyTransitionResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                ListUserDataRedundancyTransitionResult result = this.parseListDataRedundancyTransition(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                ListUserDataRedundancyTransitionResult listUserDataRedundancyTransitionResult = result;
                return listUserDataRedundancyTransitionResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private ListUserDataRedundancyTransitionResult parseListDataRedundancyTransition(InputStream inputStream) throws ResponseParseException {
            ListUserDataRedundancyTransitionResult listUserDataRedundancyTransitionResult = new ListUserDataRedundancyTransitionResult();
            ArrayList<GetBucketDataRedundancyTransitionResult> bucketDataRedundancyTransitionResultList = new ArrayList<GetBucketDataRedundancyTransitionResult>();
            if (inputStream == null) {
                return listUserDataRedundancyTransitionResult;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                if (root.getChildText("IsTruncated") != null) {
                    listUserDataRedundancyTransitionResult.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
                }
                listUserDataRedundancyTransitionResult.setNextContinuationToken(root.getChildText("NextContinuationToken"));
                List bucketDataRedundancyTransitions = root.getChildren("BucketDataRedundancyTransition");
                for (Element e : bucketDataRedundancyTransitions) {
                    GetBucketDataRedundancyTransitionResult getBucketDataRedundancyTransitionResult = ResponseParsers.parseBucketDataRedundancyTransitionResult(e);
                    bucketDataRedundancyTransitionResultList.add(getBucketDataRedundancyTransitionResult);
                }
                listUserDataRedundancyTransitionResult.setBucketDataRedundancyTransition(bucketDataRedundancyTransitionResultList);
                return listUserDataRedundancyTransitionResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class ListBucketDataRedundancyTransitionResponseParser
    implements ResponseParser<List<GetBucketDataRedundancyTransitionResult>> {
        @Override
        public List<GetBucketDataRedundancyTransitionResult> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<GetBucketDataRedundancyTransitionResult> list = this.parseListBucketDataRedundancyTransitionResult(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private List<GetBucketDataRedundancyTransitionResult> parseListBucketDataRedundancyTransitionResult(InputStream responseBody) throws ResponseParseException {
            try {
                Element root = ResponseParsers.getXmlRootElement(responseBody);
                ArrayList<GetBucketDataRedundancyTransitionResult> result = new ArrayList<GetBucketDataRedundancyTransitionResult>();
                List bucketDataRedundancyTransitions = root.getChildren("BucketDataRedundancyTransition");
                for (Element e : bucketDataRedundancyTransitions) {
                    GetBucketDataRedundancyTransitionResult getBucketDataRedundancyTransitionResult = ResponseParsers.parseBucketDataRedundancyTransitionResult(e);
                    result.add(getBucketDataRedundancyTransitionResult);
                }
                return result;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class GetBucketDataRedundancyTransitionResponseParser
    implements ResponseParser<GetBucketDataRedundancyTransitionResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketDataRedundancyTransitionResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketDataRedundancyTransitionResult result = this.parseGetBucketDataRedundancyTransition(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                GetBucketDataRedundancyTransitionResult getBucketDataRedundancyTransitionResult = result;
                return getBucketDataRedundancyTransitionResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private GetBucketDataRedundancyTransitionResult parseGetBucketDataRedundancyTransition(InputStream responseBody) throws ResponseParseException {
            try {
                Element root = ResponseParsers.getXmlRootElement(responseBody);
                return ResponseParsers.parseBucketDataRedundancyTransitionResult(root);
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class CreateBucketDataRedundancyTransitionResponseParser
    implements ResponseParser<CreateBucketDataRedundancyTransitionResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CreateBucketDataRedundancyTransitionResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CreateBucketDataRedundancyTransitionResult result = this.parseCreateBucketDataRedundancyTransition(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                CreateBucketDataRedundancyTransitionResult createBucketDataRedundancyTransitionResult = result;
                return createBucketDataRedundancyTransitionResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private CreateBucketDataRedundancyTransitionResult parseCreateBucketDataRedundancyTransition(InputStream inputStream) throws ResponseParseException {
            CreateBucketDataRedundancyTransitionResult createBucketDataRedundancyTransitionResult = new CreateBucketDataRedundancyTransitionResult();
            if (inputStream == null) {
                return createBucketDataRedundancyTransitionResult;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                createBucketDataRedundancyTransitionResult.setTaskId(root.getChildText("TaskId"));
                return createBucketDataRedundancyTransitionResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class GetBucketArchiveDirectReadResponseParser
    implements ResponseParser<GetBucketArchiveDirectReadResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketArchiveDirectReadResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketArchiveDirectReadResult result = this.parseGetArchiveDirectRead(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                GetBucketArchiveDirectReadResult getBucketArchiveDirectReadResult = result;
                return getBucketArchiveDirectReadResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private GetBucketArchiveDirectReadResult parseGetArchiveDirectRead(InputStream inputStream) throws ResponseParseException {
            GetBucketArchiveDirectReadResult getBucketArchiveDirectReadResult = new GetBucketArchiveDirectReadResult();
            if (inputStream == null) {
                return getBucketArchiveDirectReadResult;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                if (root.getChildText("Enabled") != null) {
                    getBucketArchiveDirectReadResult.setEnabled(Boolean.valueOf(root.getChildText("Enabled")));
                }
                return getBucketArchiveDirectReadResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class AsyncProcessObjectResponseParser
    implements ResponseParser<AsyncProcessObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AsyncProcessObjectResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                AsyncProcessObjectResult result = this.parseAsyncProcessObject(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                AsyncProcessObjectResult asyncProcessObjectResult = result;
                return asyncProcessObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private AsyncProcessObjectResult parseAsyncProcessObject(InputStream inputStream) throws ResponseParseException {
            AsyncProcessObjectResult asyncProcessObjectResult = new AsyncProcessObjectResult();
            if (inputStream == null) {
                return asyncProcessObjectResult;
            }
            try {
                String jsonStr = IOUtils.readStreamAsString(inputStream, "UTF-8");
                JSONObject jsonObject = new JSONObject(jsonStr);
                asyncProcessObjectResult.setAsyncRequestId(jsonObject.getString("RequestId"));
                asyncProcessObjectResult.setEventId(jsonObject.getString("EventId"));
                asyncProcessObjectResult.setTaskId(jsonObject.getString("TaskId"));
                return asyncProcessObjectResult;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class GetBucketCallbackPolicyResponseParser
    implements ResponseParser<GetBucketCallbackPolicyResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketCallbackPolicyResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketCallbackPolicyResult result = this.parseGetBucketCallbackPolicy(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                GetBucketCallbackPolicyResult getBucketCallbackPolicyResult = result;
                return getBucketCallbackPolicyResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private GetBucketCallbackPolicyResult parseGetBucketCallbackPolicy(InputStream inputStream) throws ResponseParseException {
            GetBucketCallbackPolicyResult result = new GetBucketCallbackPolicyResult();
            if (inputStream == null) {
                return result;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                List fileElem = root.getChildren();
                ArrayList<PolicyCallbackItem> policyCallbackItems = new ArrayList<PolicyCallbackItem>();
                for (Element elem : fileElem) {
                    PolicyCallbackItem policyCallbackItem = new PolicyCallbackItem(elem.getChildText("PolicyName"), elem.getChildText("Callback"));
                    policyCallbackItem.setCallbackVar(elem.getChildText("CallbackVar"));
                    policyCallbackItems.add(policyCallbackItem);
                }
                result.setPolicyCallbackItems(policyCallbackItems);
                return result;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class DescribeRegionsResponseParser
    implements ResponseParser<DescribeRegionsResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DescribeRegionsResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                DescribeRegionsResult result = this.parseDescribeRegionsResult(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                DescribeRegionsResult describeRegionsResult = result;
                return describeRegionsResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private DescribeRegionsResult parseDescribeRegionsResult(InputStream inputStream) throws ResponseParseException {
            DescribeRegionsResult describeRegionsResult = new DescribeRegionsResult();
            if (inputStream == null) {
                return describeRegionsResult;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                ArrayList<RegionInfo> regionInfoList = new ArrayList<RegionInfo>();
                List regionListElems = root.getChildren("RegionInfo");
                for (Element elem : regionListElems) {
                    RegionInfo regionInfo = new RegionInfo();
                    regionInfo.setRegion(elem.getChildText("Region"));
                    regionInfo.setInternetEndpoint(elem.getChildText("InternetEndpoint"));
                    regionInfo.setInternalEndpoint(elem.getChildText("InternalEndpoint"));
                    regionInfo.setAccelerateEndpoint(elem.getChildText("AccelerateEndpoint"));
                    regionInfoList.add(regionInfo);
                }
                describeRegionsResult.setRegionInfoList(regionInfoList);
                return describeRegionsResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class DoMetaQueryResponseParser
    implements ResponseParser<DoMetaQueryResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DoMetaQueryResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                DoMetaQueryResult result = this.parseDoMetaQueryResult(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                DoMetaQueryResult doMetaQueryResult = result;
                return doMetaQueryResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private DoMetaQueryResult parseDoMetaQueryResult(InputStream inputStream) throws ResponseParseException {
            DoMetaQueryResult doMetaQueryResult = new DoMetaQueryResult();
            if (inputStream == null) {
                return doMetaQueryResult;
            }
            try {
                Element elem;
                Element filesElem;
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                if (root.getChildText("NextToken") != null) {
                    doMetaQueryResult.setNextToken(root.getChildText("NextToken"));
                }
                if ((filesElem = root.getChild("Files")) != null) {
                    ObjectFiles objectFiles = new ObjectFiles();
                    List fileElem = filesElem.getChildren();
                    ArrayList<ObjectFile> fileList = new ArrayList<ObjectFile>();
                    for (Element elem2 : fileElem) {
                        Element ossUserMetaElem;
                        Element ossTaggingElem;
                        ObjectFile objectFile = new ObjectFile();
                        objectFile.setFilename(elem2.getChildText("Filename"));
                        if (!StringUtils.isNullOrEmpty(elem2.getChildText("Size"))) {
                            objectFile.setSize(Long.parseLong(elem2.getChildText("Size")));
                        }
                        objectFile.setFileModifiedTime(elem2.getChildText("FileModifiedTime"));
                        objectFile.setFileCreateTime(elem2.getChildText("FileCreateTime"));
                        objectFile.setFileAccessTime(elem2.getChildText("FileAccessTime"));
                        objectFile.setOssObjectType(elem2.getChildText("OSSObjectType"));
                        objectFile.setOssStorageClass(elem2.getChildText("OSSStorageClass"));
                        objectFile.setObjectACL(elem2.getChildText("ObjectACL"));
                        objectFile.setETag(elem2.getChildText("ETag"));
                        objectFile.setOssCRC64(elem2.getChildText("OSSCRC64"));
                        if (!StringUtils.isNullOrEmpty(elem2.getChildText("OSSTaggingCount"))) {
                            objectFile.setOssTaggingCount(Integer.parseInt(elem2.getChildText("OSSTaggingCount")));
                        }
                        if ((ossTaggingElem = elem2.getChild("OSSTagging")) != null) {
                            OSSTagging ossTagging = new OSSTagging();
                            List taggingElem = ossTaggingElem.getChildren();
                            ArrayList<Tagging> taggingList = new ArrayList<Tagging>();
                            for (Element ele : taggingElem) {
                                Tagging tagging = new Tagging();
                                tagging.setKey(ele.getChildText("Key"));
                                tagging.setValue(ele.getChildText("Value"));
                                taggingList.add(tagging);
                            }
                            ossTagging.setTagging(taggingList);
                            objectFile.setOssTagging(ossTagging);
                        }
                        if ((ossUserMetaElem = elem2.getChild("OSSUserMeta")) != null) {
                            Element ele;
                            OSSUserMeta ossUserMeta = new OSSUserMeta();
                            List userMetaElem = ossUserMetaElem.getChildren();
                            ArrayList<UserMeta> userMetaList = new ArrayList<UserMeta>();
                            ele = userMetaElem.iterator();
                            while (ele.hasNext()) {
                                Element ele2 = (Element)ele.next();
                                UserMeta userMeta = new UserMeta();
                                userMeta.setKey(ele2.getChildText("Key"));
                                userMeta.setValue(ele2.getChildText("Value"));
                                userMetaList.add(userMeta);
                            }
                            ossUserMeta.setUserMeta(userMetaList);
                            objectFile.setOssUserMeta(ossUserMeta);
                        }
                        fileList.add(objectFile);
                    }
                    objectFiles.setFile(fileList);
                    doMetaQueryResult.setFiles(objectFiles);
                }
                if ((elem = root.getChild("Aggregations")) != null) {
                    ArrayList<Aggregation> aggregationList = new ArrayList<Aggregation>();
                    Aggregations aggregations = new Aggregations();
                    for (Element el : elem.getChildren()) {
                        Element elemGroup;
                        Aggregation aggregation = new Aggregation();
                        aggregation.setField(el.getChildText("Field"));
                        aggregation.setOperation(el.getChildText("Operation"));
                        if (!StringUtils.isNullOrEmpty(el.getChildText("Value"))) {
                            aggregation.setValue(Double.parseDouble(el.getChildText("Value")));
                        }
                        if ((elemGroup = el.getChild("Groups")) != null) {
                            ArrayList<AggregationGroup> groupList = new ArrayList<AggregationGroup>();
                            AggregationGroups aggregationGroups = new AggregationGroups();
                            for (Element e : elemGroup.getChildren()) {
                                AggregationGroup aggregationGroup = new AggregationGroup();
                                aggregationGroup.setValue(e.getChildText("Value"));
                                if (!StringUtils.isNullOrEmpty(e.getChildText("Count"))) {
                                    aggregationGroup.setCount(Integer.parseInt(e.getChildText("Count")));
                                }
                                groupList.add(aggregationGroup);
                            }
                            aggregationGroups.setGroup(groupList);
                            aggregation.setGroups(aggregationGroups);
                        }
                        aggregationList.add(aggregation);
                    }
                    aggregations.setAggregation(aggregationList);
                    doMetaQueryResult.setAggregations(aggregations);
                }
                return doMetaQueryResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class GetMetaQueryStatusResponseParser
    implements ResponseParser<GetMetaQueryStatusResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetMetaQueryStatusResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetMetaQueryStatusResult result = this.parseGetMetaQueryStatusResult(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                GetMetaQueryStatusResult getMetaQueryStatusResult = result;
                return getMetaQueryStatusResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private GetMetaQueryStatusResult parseGetMetaQueryStatusResult(InputStream inputStream) throws ResponseParseException {
            GetMetaQueryStatusResult getMetaQueryStatusResult = new GetMetaQueryStatusResult();
            if (inputStream == null) {
                return getMetaQueryStatusResult;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                if (root.getChildText("State") != null) {
                    getMetaQueryStatusResult.setState(root.getChildText("State"));
                }
                if (root.getChildText("Phase") != null) {
                    getMetaQueryStatusResult.setPhase(root.getChildText("Phase"));
                }
                if (root.getChildText("CreateTime") != null) {
                    getMetaQueryStatusResult.setCreateTime(root.getChildText("CreateTime"));
                }
                if (root.getChildText("UpdateTime") != null) {
                    getMetaQueryStatusResult.setUpdateTime(root.getChildText("UpdateTime"));
                }
                return getMetaQueryStatusResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class GetBucketAccessMonitorResponseParser
    implements ResponseParser<AccessMonitor> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AccessMonitor parse(ResponseMessage response) throws ResponseParseException {
            try {
                AccessMonitor result = this.parseAccessMonitor(response.getContent());
                ResponseParsers.setResultParameter(result, response);
                AccessMonitor accessMonitor = result;
                return accessMonitor;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private AccessMonitor parseAccessMonitor(InputStream inputStream) throws ResponseParseException {
            AccessMonitor accessMonitor = new AccessMonitor(AccessMonitor.AccessMonitorStatus.Disabled.toString());
            if (inputStream == null) {
                return accessMonitor;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                if (root.getChildText("Status") != null) {
                    accessMonitor.setStatus(root.getChildText("Status"));
                }
                return accessMonitor;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class GetBucketTransferAccelerationResponseParser
    implements ResponseParser<TransferAcceleration> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TransferAcceleration parse(ResponseMessage response) throws ResponseParseException {
            try {
                TransferAcceleration result = this.parseTransferAcceleration(response.getContent());
                result.setRequestId(response.getRequestId());
                TransferAcceleration transferAcceleration = result;
                return transferAcceleration;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        private TransferAcceleration parseTransferAcceleration(InputStream inputStream) throws ResponseParseException {
            TransferAcceleration transferAcceleration = new TransferAcceleration(Boolean.FALSE);
            if (inputStream == null) {
                return transferAcceleration;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                if (root.getChildText("Enabled") != null) {
                    transferAcceleration.setEnabled(Boolean.valueOf(root.getChildText("Enabled")));
                }
                return transferAcceleration;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class DeleteDirectoryResponseParser
    implements ResponseParser<DeleteDirectoryResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DeleteDirectoryResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                DeleteDirectoryResult result = ResponseParsers.parseDeleteDirectoryResult(response.getContent());
                result.setResponse(response);
                result.setRequestId(response.getRequestId());
                DeleteDirectoryResult deleteDirectoryResult = result;
                return deleteDirectoryResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListVpcPolicyResultResponseParser
    implements ResponseParser<List<VpcPolicy>> {
        @Override
        public List<VpcPolicy> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<VpcPolicy> list = ResponseParsers.parseListVpcPolicyResult(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListVpcipResultResponseParser
    implements ResponseParser<List<Vpcip>> {
        @Override
        public List<Vpcip> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<Vpcip> list = ResponseParsers.parseListVpcipResult(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CreateVpcipResultResponseParser
    implements ResponseParser<Vpcip> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Vpcip parse(ResponseMessage response) throws ResponseParseException {
            try {
                Vpcip result = ResponseParsers.parseGetCreateVpcipResult(response.getContent());
                result.setRequestId(response.getRequestId());
                Vpcip vpcip = result;
                return vpcip;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketResourceGroupResponseParser
    implements ResponseParser<GetBucketResourceGroupResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketResourceGroupResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketResourceGroupResult result = ResponseParsers.parseResourceGroupConfiguration(response.getContent());
                result.setRequestId(response.getRequestId());
                GetBucketResourceGroupResult getBucketResourceGroupResult = result;
                return getBucketResourceGroupResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketWormResponseParser
    implements ResponseParser<GetBucketWormResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketWormResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketWormResult result = ResponseParsers.parseWormConfiguration(response.getContent());
                result.setRequestId(response.getRequestId());
                GetBucketWormResult getBucketWormResult = result;
                return getBucketWormResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class InitiateBucketWormResponseParser
    implements ResponseParser<InitiateBucketWormResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InitiateBucketWormResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                InitiateBucketWormResult result = ResponseParsers.parseInitiateBucketWormResponseHeader(response.getHeaders());
                result.setRequestId(response.getRequestId());
                InitiateBucketWormResult initiateBucketWormResult = result;
                return initiateBucketWormResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetSymbolicLinkResponseParser
    implements ResponseParser<OSSSymlink> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OSSSymlink parse(ResponseMessage response) throws ResponseParseException {
            try {
                OSSSymlink result = ResponseParsers.parseSymbolicLink(response);
                result.setRequestId(response.getRequestId());
                OSSSymlink oSSSymlink = result;
                return oSSSymlink;
            }
            finally {
                OSSUtils.mandatoryCloseResponse(response);
            }
        }
    }

    public static final class UploadPartCopyResponseParser
    implements ResponseParser<UploadPartCopyResult> {
        private int partNumber;

        public UploadPartCopyResponseParser(int partNumber) {
            this.partNumber = partNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UploadPartCopyResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                UploadPartCopyResult result = new UploadPartCopyResult();
                result.setPartNumber(this.partNumber);
                result.setETag(OSSUtils.trimQuotes(ResponseParsers.parseUploadPartCopy(response.getContent())));
                result.setRequestId(response.getRequestId());
                result.setResponse(response);
                UploadPartCopyResult uploadPartCopyResult = result;
                return uploadPartCopyResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListPartsResponseParser
    implements ResponseParser<PartListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                PartListing result = ResponseParsers.parseListParts(response.getContent());
                result.setRequestId(response.getRequestId());
                PartListing partListing = result;
                return partListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListMultipartUploadsResponseParser
    implements ResponseParser<MultipartUploadListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MultipartUploadListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                MultipartUploadListing result = ResponseParsers.parseListMultipartUploads(response.getContent());
                result.setRequestId(response.getRequestId());
                MultipartUploadListing multipartUploadListing = result;
                return multipartUploadListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class InitiateMultipartUploadResponseParser
    implements ResponseParser<InitiateMultipartUploadResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InitiateMultipartUploadResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                InitiateMultipartUploadResult result = ResponseParsers.parseInitiateMultipartUpload(response.getContent());
                result.setRequestId(response.getRequestId());
                result.setResponse(response);
                InitiateMultipartUploadResult initiateMultipartUploadResult = result;
                return initiateMultipartUploadResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CompleteMultipartUploadProcessResponseParser
    implements ResponseParser<CompleteMultipartUploadResult> {
        @Override
        public CompleteMultipartUploadResult parse(ResponseMessage response) throws ResponseParseException {
            CompleteMultipartUploadResult result = new CompleteMultipartUploadResult();
            result.setVersionId(response.getHeaders().get("x-oss-version-id"));
            result.setRequestId(response.getRequestId());
            result.setCallbackResponseBody(response.getContent());
            result.setResponse(response);
            return result;
        }
    }

    public static final class CompleteMultipartUploadResponseParser
    implements ResponseParser<CompleteMultipartUploadResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompleteMultipartUploadResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CompleteMultipartUploadResult result = ResponseParsers.parseCompleteMultipartUpload(response.getContent());
                result.setVersionId(response.getHeaders().get("x-oss-version-id"));
                result.setRequestId(response.getRequestId());
                ResponseParsers.setServerCRC(result, response);
                CompleteMultipartUploadResult completeMultipartUploadResult = result;
                return completeMultipartUploadResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class DeleteVersionsResponseParser
    implements ResponseParser<DeleteVersionsResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DeleteVersionsResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                DeleteVersionsResult result = null;
                result = response.getContentLength() == 0L ? new DeleteVersionsResult(new ArrayList<DeleteVersionsResult.DeletedVersion>()) : ResponseParsers.parseDeleteVersionsResult(response.getContent());
                result.setRequestId(response.getRequestId());
                DeleteVersionsResult deleteVersionsResult = result;
                return deleteVersionsResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class DeleteObjectsResponseParser
    implements ResponseParser<DeleteObjectsResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DeleteObjectsResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                DeleteObjectsResult result = null;
                result = response.getContentLength() == 0L ? new DeleteObjectsResult(null) : ResponseParsers.parseDeleteObjectsResult(response.getContent());
                result.setRequestId(response.getRequestId());
                DeleteObjectsResult deleteObjectsResult = result;
                return deleteObjectsResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CopyObjectResponseParser
    implements ResponseParser<CopyObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CopyObjectResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CopyObjectResult result = ResponseParsers.parseCopyObjectResult(response.getContent());
                result.setVersionId(response.getHeaders().get("x-oss-version-id"));
                result.setRequestId(response.getRequestId());
                result.setResponse(response);
                CopyObjectResult copyObjectResult = result;
                return copyObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class HeadObjectResponseParser
    implements ResponseParser<ObjectMetadata> {
        @Override
        public ObjectMetadata parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectMetadata objectMetadata = ResponseParsers.parseObjectMetadata(response.getHeaders());
                return objectMetadata;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetObjectMetadataResponseParser
    implements ResponseParser<ObjectMetadata> {
        @Override
        public ObjectMetadata parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectMetadata objectMetadata = ResponseParsers.parseObjectMetadata(response.getHeaders());
                return objectMetadata;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ProcessObjectResponseParser
    implements ResponseParser<GenericResult> {
        @Override
        public GenericResult parse(ResponseMessage response) throws ResponseParseException {
            PutObjectResult result = new PutObjectResult();
            result.setRequestId(response.getRequestId());
            result.setResponse(response);
            return result;
        }
    }

    public static final class RestoreObjectResponseParser
    implements ResponseParser<RestoreObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RestoreObjectResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                RestoreObjectResult result = new RestoreObjectResult(response.getStatusCode());
                result.setRequestId(response.getRequestId());
                result.setVersionId(response.getHeaders().get("x-oss-version-id"));
                RestoreObjectResult restoreObjectResult = result;
                return restoreObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetSimplifiedObjectMetaResponseParser
    implements ResponseParser<SimplifiedObjectMeta> {
        @Override
        public SimplifiedObjectMeta parse(ResponseMessage response) throws ResponseParseException {
            try {
                SimplifiedObjectMeta simplifiedObjectMeta = ResponseParsers.parseSimplifiedObjectMeta(response.getHeaders());
                return simplifiedObjectMeta;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetObjectAclResponseParser
    implements ResponseParser<ObjectAcl> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectAcl parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectAcl result = ResponseParsers.parseGetObjectAcl(response.getContent());
                result.setRequestId(response.getRequestId());
                result.setVersionId(response.getHeaders().get("x-oss-version-id"));
                ObjectAcl objectAcl = result;
                return objectAcl;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetObjectResponseParser
    implements ResponseParser<OSSObject> {
        private String bucketName;
        private String key;

        public GetObjectResponseParser(String bucketName, String key) {
            this.bucketName = bucketName;
            this.key = key;
        }

        @Override
        public OSSObject parse(ResponseMessage response) throws ResponseParseException {
            OSSObject ossObject = new OSSObject();
            ossObject.setBucketName(this.bucketName);
            ossObject.setKey(this.key);
            ossObject.setObjectContent(response.getContent());
            ossObject.setRequestId(response.getRequestId());
            ossObject.setResponse(response);
            try {
                ossObject.setObjectMetadata(ResponseParsers.parseObjectMetadata(response.getHeaders()));
                ResponseParsers.setServerCRC(ossObject, response);
                return ossObject;
            }
            catch (ResponseParseException e) {
                OSSUtils.safeCloseResponse(response);
                throw e;
            }
        }
    }

    public static final class AppendObjectResponseParser
    implements ResponseParser<AppendObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppendObjectResult parse(ResponseMessage response) throws ResponseParseException {
            AppendObjectResult result = new AppendObjectResult();
            result.setRequestId(response.getRequestId());
            try {
                String nextPosition = response.getHeaders().get("x-oss-next-append-position");
                if (nextPosition != null) {
                    result.setNextPosition(Long.valueOf(nextPosition));
                }
                result.setObjectCRC(response.getHeaders().get("x-oss-hash-crc64ecma"));
                result.setResponse(response);
                ResponseParsers.setCRC(result, response);
                AppendObjectResult appendObjectResult = result;
                return appendObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class PutObjectProcessReponseParser
    implements ResponseParser<PutObjectResult> {
        @Override
        public PutObjectResult parse(ResponseMessage response) throws ResponseParseException {
            PutObjectResult result = new PutObjectResult();
            result.setRequestId(response.getRequestId());
            result.setETag(OSSUtils.trimQuotes(response.getHeaders().get("ETag")));
            result.setVersionId(response.getHeaders().get("x-oss-version-id"));
            result.setCallbackResponseBody(response.getContent());
            result.setResponse(response);
            return result;
        }
    }

    public static final class PutObjectReponseParser
    implements ResponseParser<PutObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PutObjectResult parse(ResponseMessage response) throws ResponseParseException {
            PutObjectResult result = new PutObjectResult();
            try {
                result.setETag(OSSUtils.trimQuotes(response.getHeaders().get("ETag")));
                result.setVersionId(response.getHeaders().get("x-oss-version-id"));
                result.setRequestId(response.getRequestId());
                ResponseParsers.setCRC(result, response);
                PutObjectResult putObjectResult = result;
                return putObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListVersionsReponseParser
    implements ResponseParser<VersionListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VersionListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                VersionListing result = ResponseParsers.parseListVersions(response.getContent());
                result.setRequestId(response.getRequestId());
                VersionListing versionListing = result;
                return versionListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListObjectsV2ResponseParser
    implements ResponseParser<ListObjectsV2Result> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListObjectsV2Result parse(ResponseMessage response) throws ResponseParseException {
            try {
                ListObjectsV2Result result = ResponseParsers.parseListObjectsV2(response.getContent());
                result.setRequestId(response.getRequestId());
                ListObjectsV2Result listObjectsV2Result = result;
                return listObjectsV2Result;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListObjectsReponseParser
    implements ResponseParser<ObjectListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectListing result = ResponseParsers.parseListObjects(response.getContent());
                result.setRequestId(response.getRequestId());
                ObjectListing objectListing = result;
                return objectListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketReplicationLocationResponseParser
    implements ResponseParser<List<String>> {
        @Override
        public List<String> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<String> list = ResponseParsers.parseGetBucketReplicationLocation(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketReplicationProgressResponseParser
    implements ResponseParser<BucketReplicationProgress> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketReplicationProgress parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketReplicationProgress result = ResponseParsers.parseGetBucketReplicationProgress(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketReplicationProgress bucketReplicationProgress = result;
                return bucketReplicationProgress;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketReplicationResponseParser
    implements ResponseParser<List<ReplicationRule>> {
        @Override
        public List<ReplicationRule> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<ReplicationRule> list = ResponseParsers.parseGetBucketReplication(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetTaggingResponseParser
    implements ResponseParser<TagSet> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TagSet parse(ResponseMessage response) throws ResponseParseException {
            try {
                TagSet result = ResponseParsers.parseGetBucketTagging(response.getContent());
                result.setRequestId(response.getRequestId());
                TagSet tagSet = result;
                return tagSet;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketCorsResponseParser
    implements ResponseParser<CORSConfiguration> {
        @Override
        public CORSConfiguration parse(ResponseMessage response) throws ResponseParseException {
            try {
                CORSConfiguration cORSConfiguration = ResponseParsers.parseListBucketCORS(response.getContent());
                return cORSConfiguration;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListLiveChannelsReponseParser
    implements ResponseParser<LiveChannelListing> {
        @Override
        public LiveChannelListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                LiveChannelListing liveChannelListing = ResponseParsers.parseListLiveChannels(response.getContent());
                return liveChannelListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetLiveChannelHistoryResponseParser
    implements ResponseParser<List<LiveRecord>> {
        @Override
        public List<LiveRecord> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<LiveRecord> list = ResponseParsers.parseGetLiveChannelHistory(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetLiveChannelStatResponseParser
    implements ResponseParser<LiveChannelStat> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LiveChannelStat parse(ResponseMessage response) throws ResponseParseException {
            try {
                LiveChannelStat result = ResponseParsers.parseGetLiveChannelStat(response.getContent());
                result.setRequestId(response.getRequestId());
                LiveChannelStat liveChannelStat = result;
                return liveChannelStat;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetLiveChannelInfoResponseParser
    implements ResponseParser<LiveChannelInfo> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LiveChannelInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                LiveChannelInfo result = ResponseParsers.parseGetLiveChannelInfo(response.getContent());
                result.setRequestId(response.getRequestId());
                LiveChannelInfo liveChannelInfo = result;
                return liveChannelInfo;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CreateLiveChannelResponseParser
    implements ResponseParser<CreateLiveChannelResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CreateLiveChannelResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CreateLiveChannelResult result = ResponseParsers.parseCreateLiveChannel(response.getContent());
                result.setRequestId(response.getRequestId());
                CreateLiveChannelResult createLiveChannelResult = result;
                return createLiveChannelResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListBucketInventoryConfigurationsParser
    implements ResponseParser<ListBucketInventoryConfigurationsResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListBucketInventoryConfigurationsResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                ListBucketInventoryConfigurationsResult result = ResponseParsers.parseListBucketInventoryConfigurations(response.getContent());
                result.setRequestId(response.getRequestId());
                ListBucketInventoryConfigurationsResult listBucketInventoryConfigurationsResult = result;
                return listBucketInventoryConfigurationsResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketInventoryConfigurationParser
    implements ResponseParser<GetBucketInventoryConfigurationResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketInventoryConfigurationResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketInventoryConfigurationResult result = ResponseParsers.parseGetBucketInventoryConfig(response.getContent());
                result.setRequestId(response.getRequestId());
                GetBucketInventoryConfigurationResult getBucketInventoryConfigurationResult = result;
                return getBucketInventoryConfigurationResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetAsyncFetchTaskResponseParser
    implements ResponseParser<GetAsyncFetchTaskResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetAsyncFetchTaskResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetAsyncFetchTaskResult result = ResponseParsers.parseGetAsyncFetchTaskResult(response.getContent());
                result.setRequestId(response.getRequestId());
                GetAsyncFetchTaskResult getAsyncFetchTaskResult = result;
                return getAsyncFetchTaskResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class SetAsyncFetchTaskResponseParser
    implements ResponseParser<SetAsyncFetchTaskResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SetAsyncFetchTaskResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                SetAsyncFetchTaskResult result = ResponseParsers.parseSetAsyncFetchTaskResult(response.getContent());
                result.setRequestId(response.getRequestId());
                SetAsyncFetchTaskResult setAsyncFetchTaskResult = result;
                return setAsyncFetchTaskResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketQosInfoResponseParser
    implements ResponseParser<BucketQosInfo> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketQosInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketQosInfo result = ResponseParsers.parseGetBucketQosInfo(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketQosInfo bucketQosInfo = result;
                return bucketQosInfo;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetUSerQosInfoResponseParser
    implements ResponseParser<UserQosInfo> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UserQosInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                UserQosInfo result = ResponseParsers.parseGetUserQosInfo(response.getContent());
                result.setRequestId(response.getRequestId());
                UserQosInfo userQosInfo = result;
                return userQosInfo;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketRequestPaymentResponseParser
    implements ResponseParser<GetBucketRequestPaymentResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketRequestPaymentResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketRequestPaymentResult result = ResponseParsers.parseGetBucketRequestPayment(response.getContent());
                result.setRequestId(response.getRequestId());
                GetBucketRequestPaymentResult getBucketRequestPaymentResult = result;
                return getBucketRequestPaymentResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketPolicyResponseParser
    implements ResponseParser<GetBucketPolicyResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketPolicyResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketPolicyResult result = ResponseParsers.parseGetBucketPolicy(response.getContent());
                result.setRequestId(response.getRequestId());
                GetBucketPolicyResult getBucketPolicyResult = result;
                return getBucketPolicyResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketEncryptionResponseParser
    implements ResponseParser<ServerSideEncryptionConfiguration> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServerSideEncryptionConfiguration parse(ResponseMessage response) throws ResponseParseException {
            try {
                ServerSideEncryptionConfiguration result;
                ServerSideEncryptionConfiguration serverSideEncryptionConfiguration = result = ResponseParsers.parseGetBucketEncryption(response.getContent());
                return serverSideEncryptionConfiguration;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketVersioningResponseParser
    implements ResponseParser<BucketVersioningConfiguration> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketVersioningConfiguration parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketVersioningConfiguration result;
                BucketVersioningConfiguration bucketVersioningConfiguration = result = ResponseParsers.parseGetBucketVersioning(response.getContent());
                return bucketVersioningConfiguration;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketQosResponseParser
    implements ResponseParser<UserQos> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UserQos parse(ResponseMessage response) throws ResponseParseException {
            try {
                UserQos result = ResponseParsers.parseGetUserQos(response.getContent());
                result.setRequestId(response.getRequestId());
                UserQos userQos = result;
                return userQos;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketStatResponseParser
    implements ResponseParser<BucketStat> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketStat parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketStat result = ResponseParsers.parseGetBucketStat(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketStat bucketStat = result;
                return bucketStat;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketInfoResponseParser
    implements ResponseParser<BucketInfo> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketInfo result = ResponseParsers.parseGetBucketInfo(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketInfo bucketInfo = result;
                return bucketInfo;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketCnameTokenResponseParser
    implements ResponseParser<GetBucketCnameTokenResult> {
        @Override
        public GetBucketCnameTokenResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketCnameTokenResult getBucketCnameTokenResult = ResponseParsers.parseGetBucketCnameToken(response.getContent());
                return getBucketCnameTokenResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CreateBucketCnameTokenResponseParser
    implements ResponseParser<CreateBucketCnameTokenResult> {
        @Override
        public CreateBucketCnameTokenResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CreateBucketCnameTokenResult createBucketCnameTokenResult = ResponseParsers.parseCreateBucketCnameToken(response.getContent());
                return createBucketCnameTokenResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketCnameResponseParser
    implements ResponseParser<List<CnameConfiguration>> {
        @Override
        public List<CnameConfiguration> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<CnameConfiguration> list = ResponseParsers.parseGetBucketCname(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class AddBucketCnameResponseParser
    implements ResponseParser<AddBucketCnameResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AddBucketCnameResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                AddBucketCnameResult result = new AddBucketCnameResult();
                result.setCertId(response.getHeaders().get("x-oss-yundun-certificate-id"));
                result.setRequestId(response.getRequestId());
                result.setResponse(response);
                AddBucketCnameResult addBucketCnameResult = result;
                return addBucketCnameResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketLifecycleResponseParser
    implements ResponseParser<List<LifecycleRule>> {
        @Override
        public List<LifecycleRule> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<LifecycleRule> list = ResponseParsers.parseGetBucketLifecycle(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketWebsiteResponseParser
    implements ResponseParser<BucketWebsiteResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketWebsiteResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketWebsiteResult result = ResponseParsers.parseBucketWebsite(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketWebsiteResult bucketWebsiteResult = result;
                return bucketWebsiteResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketImageProcessConfResponseParser
    implements ResponseParser<BucketProcess> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketProcess parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketProcess result = ResponseParsers.parseGetBucketImageProcessConf(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketProcess bucketProcess = result;
                return bucketProcess;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetImageStyleResponseParser
    implements ResponseParser<GetImageStyleResult> {
        @Override
        public GetImageStyleResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetImageStyleResult getImageStyleResult = ResponseParsers.parseImageStyle(response.getContent());
                return getImageStyleResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketImageResponseParser
    implements ResponseParser<GetBucketImageResult> {
        @Override
        public GetBucketImageResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketImageResult getBucketImageResult = ResponseParsers.parseBucketImage(response.getContent());
                return getBucketImageResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketLoggingResponseParser
    implements ResponseParser<BucketLoggingResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketLoggingResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketLoggingResult result = ResponseParsers.parseBucketLogging(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketLoggingResult bucketLoggingResult = result;
                return bucketLoggingResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketLocationResponseParser
    implements ResponseParser<String> {
        @Override
        public String parse(ResponseMessage response) throws ResponseParseException {
            try {
                String string = ResponseParsers.parseGetBucketLocation(response.getContent());
                return string;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketMetadataResponseParser
    implements ResponseParser<BucketMetadata> {
        @Override
        public BucketMetadata parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketMetadata bucketMetadata = ResponseParsers.parseBucketMetadata(response.getHeaders());
                return bucketMetadata;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketAclResponseParser
    implements ResponseParser<AccessControlList> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AccessControlList parse(ResponseMessage response) throws ResponseParseException {
            try {
                AccessControlList result = ResponseParsers.parseGetBucketAcl(response.getContent());
                result.setRequestId(response.getRequestId());
                AccessControlList accessControlList = result;
                return accessControlList;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketRefererResponseParser
    implements ResponseParser<BucketReferer> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketReferer parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketReferer result = ResponseParsers.parseGetBucketReferer(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketReferer bucketReferer = result;
                return bucketReferer;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListImageStyleResponseParser
    implements ResponseParser<List<Style>> {
        @Override
        public List<Style> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<Style> list = ResponseParsers.parseListImageStyle(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListBucketResponseParser
    implements ResponseParser<BucketList> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketList parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketList result = ResponseParsers.parseListBucket(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketList bucketList = result;
                return bucketList;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class RequestIdResponseParser
    implements ResponseParser<VoidResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VoidResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                VoidResult result = new VoidResult();
                result.setResponse(response);
                result.setRequestId(response.getRequestId());
                VoidResult voidResult = result;
                return voidResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ErrorResponseParser
    implements ResponseParser<OSSErrorResult> {
        @Override
        public OSSErrorResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                OSSErrorResult oSSErrorResult = this.parseErrorResponse(response.getContent());
                return oSSErrorResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }

        OSSErrorResult parseErrorResponse(InputStream inputStream) throws ResponseParseException {
            OSSErrorResult ossErrorResult = new OSSErrorResult();
            if (inputStream == null) {
                return ossErrorResult;
            }
            try {
                Element root = ResponseParsers.getXmlRootElement(inputStream);
                ossErrorResult.Code = root.getChildText("Code");
                ossErrorResult.Message = root.getChildText("Message");
                ossErrorResult.RequestId = root.getChildText("RequestId");
                ossErrorResult.HostId = root.getChildText("HostId");
                ossErrorResult.ResourceType = root.getChildText("ResourceType");
                ossErrorResult.Method = root.getChildText("Method");
                ossErrorResult.Header = root.getChildText("Header");
                ossErrorResult.EC = root.getChildText("EC");
                return ossErrorResult;
            }
            catch (JDOMParseException e) {
                throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static final class EmptyResponseParser
    implements ResponseParser<ResponseMessage> {
        @Override
        public ResponseMessage parse(ResponseMessage response) throws ResponseParseException {
            OSSUtils.safeCloseResponse(response);
            return response;
        }
    }
}

