/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.teaopenapi;

import com.aliyun.gateway.spi.models.AttributeMap;
import com.aliyun.gateway.spi.models.InterceptorContext;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import com.aliyun.tea.interceptor.InterceptorChain;
import com.aliyun.tea.interceptor.RequestInterceptor;
import com.aliyun.tea.interceptor.ResponseInterceptor;
import com.aliyun.tea.interceptor.RuntimeOptionsInterceptor;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teaopenapi.models.GlobalParameters;
import com.aliyun.teaopenapi.models.OpenApiRequest;
import com.aliyun.teaopenapi.models.Params;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class Client {
    private static final InterceptorChain interceptorChain = InterceptorChain.create();
    public String _endpoint;
    public String _regionId;
    public String _protocol;
    public String _method;
    public String _userAgent;
    public String _endpointRule;
    public Map<String, String> _endpointMap;
    public String _suffix;
    public Integer _readTimeout;
    public Integer _connectTimeout;
    public String _httpProxy;
    public String _httpsProxy;
    public String _socks5Proxy;
    public String _socks5NetWork;
    public String _noProxy;
    public String _network;
    public String _productId;
    public Integer _maxIdleConns;
    public String _endpointType;
    public String _openPlatformEndpoint;
    public com.aliyun.credentials.Client _credential;
    public String _signatureVersion;
    public String _signatureAlgorithm;
    public Map<String, String> _headers;
    public com.aliyun.gateway.spi.Client _spi;
    public GlobalParameters _globalParameters;

    public Client(Config config) throws Exception {
        if (Common.isUnset((Object)TeaModel.buildMap((TeaModel)config))) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config' can not be unset")}));
        }
        if (!Common.empty((String)config.accessKeyId) && !Common.empty((String)config.accessKeySecret)) {
            config.type = !Common.empty((String)config.securityToken) ? "sts" : "access_key";
            com.aliyun.credentials.models.Config credentialConfig = com.aliyun.credentials.models.Config.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("accessKeyId", (Object)config.accessKeyId), new TeaPair("type", (Object)config.type), new TeaPair("accessKeySecret", (Object)config.accessKeySecret), new TeaPair("securityToken", (Object)config.securityToken)}));
            this._credential = new com.aliyun.credentials.Client(credentialConfig);
        } else if (!Common.isUnset((Object)config.credential)) {
            this._credential = config.credential;
        }
        this._endpoint = config.endpoint;
        this._endpointType = config.endpointType;
        this._network = config.network;
        this._suffix = config.suffix;
        this._protocol = config.protocol;
        this._method = config.method;
        this._regionId = config.regionId;
        this._userAgent = config.userAgent;
        this._readTimeout = config.readTimeout;
        this._connectTimeout = config.connectTimeout;
        this._httpProxy = config.httpProxy;
        this._httpsProxy = config.httpsProxy;
        this._noProxy = config.noProxy;
        this._socks5Proxy = config.socks5Proxy;
        this._socks5NetWork = config.socks5NetWork;
        this._maxIdleConns = config.maxIdleConns;
        this._signatureVersion = config.signatureVersion;
        this._signatureAlgorithm = config.signatureAlgorithm;
        this._globalParameters = config.globalParameters;
    }

    public Map<String, ?> doRPCRequest(String action, String version, String protocol, String method, String authType, String bodyType, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams((TeaModel)request, (String)"request");
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("socks5Proxy", (Object)Common.defaultString((String)runtime.socks5Proxy, (String)this._socks5Proxy)), new TeaPair("socks5NetWork", (Object)Common.defaultString((String)runtime.socks5NetWork, (String)this._socks5NetWork)), new TeaPair("maxIdleConns", (Object)Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        TeaResponse _lastResponse = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                Map err;
                TeaResponse response_;
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)protocol);
                request_.method = method;
                request_.pathname = "/";
                request_.query = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("Action", (Object)action), new TeaPair("Format", (Object)"json"), new TeaPair("Version", (Object)version), new TeaPair("Timestamp", (Object)com.aliyun.openapiutil.Client.getTimestamp()), new TeaPair("SignatureNonce", (Object)Common.getNonce())}), request.query});
                Map<String, String> headers = this.getRpcHeaders();
                request_.headers = Common.isUnset(headers) ? TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)this._endpoint), new TeaPair("x-acs-version", (Object)version), new TeaPair("x-acs-action", (Object)action), new TeaPair("user-agent", (Object)this.getUserAgent())}) : TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)this._endpoint), new TeaPair("x-acs-version", (Object)version), new TeaPair("x-acs-action", (Object)action), new TeaPair("user-agent", (Object)this.getUserAgent())}), headers});
                if (!Common.isUnset((Object)request.body)) {
                    Map m = Common.assertAsMap((Object)request.body);
                    Map tmp = Common.anyifyMapValue((Map)com.aliyun.openapiutil.Client.query((Map)m));
                    request_.body = Tea.toReadable((String)Common.toFormString((Map)tmp));
                    request_.headers.put("content-type", "application/x-www-form-urlencoded");
                }
                if (!Common.equalString((String)authType, (String)"Anonymous")) {
                    String accessKeyId = this.getAccessKeyId();
                    String accessKeySecret = this.getAccessKeySecret();
                    String securityToken = this.getSecurityToken();
                    if (!Common.empty((String)securityToken)) {
                        request_.query.put("SecurityToken", securityToken);
                    }
                    request_.query.put("SignatureMethod", "HMAC-SHA1");
                    request_.query.put("SignatureVersion", "1.0");
                    request_.query.put("AccessKeyId", accessKeyId);
                    Map t = null;
                    if (!Common.isUnset((Object)request.body)) {
                        t = Common.assertAsMap((Object)request.body);
                    }
                    Map signedParam = TeaConverter.merge(String.class, (Map[])new Map[]{request_.query, com.aliyun.openapiutil.Client.query((Map)t)});
                    request_.query.put("Signature", com.aliyun.openapiutil.Client.getRPCSignature((Map)signedParam, (String)request_.method, (String)accessKeySecret));
                }
                _lastRequest = request_;
                _lastResponse = response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_, (InterceptorChain)interceptorChain);
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    Object _res = Common.readAsJSON((InputStream)response_.body);
                    err = Common.assertAsMap((Object)_res);
                    Object requestId = Client.defaultAny(err.get("RequestId"), err.get("requestId"));
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)("" + Client.defaultAny(err.get("Code"), err.get("code")) + "")), new TeaPair("message", (Object)("code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " request id: " + requestId + "")), new TeaPair("data", (Object)err)}));
                }
                if (Common.equalString((String)bodyType, (String)"binary")) {
                    Map resp;
                    err = resp = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)response_.body), new TeaPair("headers", (Object)response_.headers)});
                    return err;
                }
                if (Common.equalString((String)bodyType, (String)"byte")) {
                    byte[] byt = Common.readAsBytes((InputStream)response_.body);
                    err = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)byt), new TeaPair("headers", (Object)response_.headers)});
                    return err;
                }
                if (Common.equalString((String)bodyType, (String)"string")) {
                    String str = Common.readAsString((InputStream)response_.body);
                    err = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)str), new TeaPair("headers", (Object)response_.headers)});
                    return err;
                }
                if (Common.equalString((String)bodyType, (String)"json")) {
                    Object obj = Common.readAsJSON((InputStream)response_.body);
                    Map res = Common.assertAsMap((Object)obj);
                    Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)res), new TeaPair("headers", (Object)response_.headers)});
                    return map;
                }
                if (Common.equalString((String)bodyType, (String)"array")) {
                    Object arr = Common.readAsJSON((InputStream)response_.body);
                    Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", arr), new TeaPair("headers", (Object)response_.headers)});
                    return map;
                }
                Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
                return map;
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
            finally {
                if (Common.isUnset(_lastResponse) || Common.isUnset((Object)_lastResponse.response) || Common.isUnset((Object)_lastResponse.response.body())) continue;
                _lastResponse.response.close();
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public Map<String, ?> doROARequest(String action, String version, String protocol, String method, String authType, String pathname, String bodyType, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams((TeaModel)request, (String)"request");
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("socks5Proxy", (Object)Common.defaultString((String)runtime.socks5Proxy, (String)this._socks5Proxy)), new TeaPair("socks5NetWork", (Object)Common.defaultString((String)runtime.socks5NetWork, (String)this._socks5NetWork)), new TeaPair("maxIdleConns", (Object)Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        TeaResponse _lastResponse = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                Map err;
                TeaResponse response_;
                Object accessKeySecret;
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)protocol);
                request_.method = method;
                request_.pathname = pathname;
                request_.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("date", (Object)Common.getDateUTCString()), new TeaPair("host", (Object)this._endpoint), new TeaPair("accept", (Object)"application/json"), new TeaPair("x-acs-signature-nonce", (Object)Common.getNonce()), new TeaPair("x-acs-signature-method", (Object)"HMAC-SHA1"), new TeaPair("x-acs-signature-version", (Object)"1.0"), new TeaPair("x-acs-version", (Object)version), new TeaPair("x-acs-action", (Object)action), new TeaPair("user-agent", (Object)Common.getUserAgent((String)this._userAgent))}), request.headers});
                if (!Common.isUnset((Object)request.body)) {
                    request_.body = Tea.toReadable((String)Common.toJSONString((Object)request.body));
                    request_.headers.put("content-type", "application/json; charset=utf-8");
                }
                if (!Common.isUnset(request.query)) {
                    request_.query = request.query;
                }
                if (!Common.equalString((String)authType, (String)"Anonymous")) {
                    String accessKeyId = this.getAccessKeyId();
                    accessKeySecret = this.getAccessKeySecret();
                    String securityToken = this.getSecurityToken();
                    if (!Common.empty((String)securityToken)) {
                        request_.headers.put("x-acs-accesskey-id", accessKeyId);
                        request_.headers.put("x-acs-security-token", securityToken);
                    }
                    String stringToSign = com.aliyun.openapiutil.Client.getStringToSign((TeaRequest)request_);
                    request_.headers.put("authorization", "acs " + accessKeyId + ":" + com.aliyun.openapiutil.Client.getROASignature((String)stringToSign, (String)accessKeySecret) + "");
                }
                _lastRequest = request_;
                _lastResponse = response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_, (InterceptorChain)interceptorChain);
                if (Common.equalNumber((Number)response_.statusCode, (Number)204)) {
                    accessKeySecret = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
                    return accessKeySecret;
                }
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    Object _res = Common.readAsJSON((InputStream)response_.body);
                    err = Common.assertAsMap((Object)_res);
                    Object requestId = Client.defaultAny(err.get("RequestId"), err.get("requestId"));
                    requestId = Client.defaultAny(requestId, err.get("requestid"));
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)("" + Client.defaultAny(err.get("Code"), err.get("code")) + "")), new TeaPair("message", (Object)("code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " request id: " + requestId + "")), new TeaPair("data", (Object)err)}));
                }
                if (Common.equalString((String)bodyType, (String)"binary")) {
                    Map resp;
                    err = resp = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)response_.body), new TeaPair("headers", (Object)response_.headers)});
                    return err;
                }
                if (Common.equalString((String)bodyType, (String)"byte")) {
                    byte[] byt = Common.readAsBytes((InputStream)response_.body);
                    err = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)byt), new TeaPair("headers", (Object)response_.headers)});
                    return err;
                }
                if (Common.equalString((String)bodyType, (String)"string")) {
                    String str = Common.readAsString((InputStream)response_.body);
                    err = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)str), new TeaPair("headers", (Object)response_.headers)});
                    return err;
                }
                if (Common.equalString((String)bodyType, (String)"json")) {
                    Object obj = Common.readAsJSON((InputStream)response_.body);
                    Map res = Common.assertAsMap((Object)obj);
                    Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)res), new TeaPair("headers", (Object)response_.headers)});
                    return map;
                }
                if (Common.equalString((String)bodyType, (String)"array")) {
                    Object arr = Common.readAsJSON((InputStream)response_.body);
                    Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", arr), new TeaPair("headers", (Object)response_.headers)});
                    return map;
                }
                Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
                return map;
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
            finally {
                if (Common.isUnset(_lastResponse) || Common.isUnset((Object)_lastResponse.response) || Common.isUnset((Object)_lastResponse.response.body())) continue;
                _lastResponse.response.close();
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public Map<String, ?> doROARequestWithForm(String action, String version, String protocol, String method, String authType, String pathname, String bodyType, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams((TeaModel)request, (String)"request");
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("socks5Proxy", (Object)Common.defaultString((String)runtime.socks5Proxy, (String)this._socks5Proxy)), new TeaPair("socks5NetWork", (Object)Common.defaultString((String)runtime.socks5NetWork, (String)this._socks5NetWork)), new TeaPair("maxIdleConns", (Object)Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        TeaResponse _lastResponse = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                Map err;
                TeaResponse response_;
                Object accessKeySecret;
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)protocol);
                request_.method = method;
                request_.pathname = pathname;
                request_.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("date", (Object)Common.getDateUTCString()), new TeaPair("host", (Object)this._endpoint), new TeaPair("accept", (Object)"application/json"), new TeaPair("x-acs-signature-nonce", (Object)Common.getNonce()), new TeaPair("x-acs-signature-method", (Object)"HMAC-SHA1"), new TeaPair("x-acs-signature-version", (Object)"1.0"), new TeaPair("x-acs-version", (Object)version), new TeaPair("x-acs-action", (Object)action), new TeaPair("user-agent", (Object)Common.getUserAgent((String)this._userAgent))}), request.headers});
                if (!Common.isUnset((Object)request.body)) {
                    Map m = Common.assertAsMap((Object)request.body);
                    request_.body = Tea.toReadable((String)com.aliyun.openapiutil.Client.toForm((Map)m));
                    request_.headers.put("content-type", "application/x-www-form-urlencoded");
                }
                if (!Common.isUnset(request.query)) {
                    request_.query = request.query;
                }
                if (!Common.equalString((String)authType, (String)"Anonymous")) {
                    String accessKeyId = this.getAccessKeyId();
                    accessKeySecret = this.getAccessKeySecret();
                    String securityToken = this.getSecurityToken();
                    if (!Common.empty((String)securityToken)) {
                        request_.headers.put("x-acs-accesskey-id", accessKeyId);
                        request_.headers.put("x-acs-security-token", securityToken);
                    }
                    String stringToSign = com.aliyun.openapiutil.Client.getStringToSign((TeaRequest)request_);
                    request_.headers.put("authorization", "acs " + accessKeyId + ":" + com.aliyun.openapiutil.Client.getROASignature((String)stringToSign, (String)accessKeySecret) + "");
                }
                _lastRequest = request_;
                _lastResponse = response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_, (InterceptorChain)interceptorChain);
                if (Common.equalNumber((Number)response_.statusCode, (Number)204)) {
                    accessKeySecret = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
                    return accessKeySecret;
                }
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    Object _res = Common.readAsJSON((InputStream)response_.body);
                    err = Common.assertAsMap((Object)_res);
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)("" + Client.defaultAny(err.get("Code"), err.get("code")) + "")), new TeaPair("message", (Object)("code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " request id: " + Client.defaultAny(err.get("RequestId"), err.get("requestId")) + "")), new TeaPair("data", (Object)err)}));
                }
                if (Common.equalString((String)bodyType, (String)"binary")) {
                    Map resp;
                    err = resp = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)response_.body), new TeaPair("headers", (Object)response_.headers)});
                    return err;
                }
                if (Common.equalString((String)bodyType, (String)"byte")) {
                    byte[] byt = Common.readAsBytes((InputStream)response_.body);
                    err = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)byt), new TeaPair("headers", (Object)response_.headers)});
                    return err;
                }
                if (Common.equalString((String)bodyType, (String)"string")) {
                    String str = Common.readAsString((InputStream)response_.body);
                    err = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)str), new TeaPair("headers", (Object)response_.headers)});
                    return err;
                }
                if (Common.equalString((String)bodyType, (String)"json")) {
                    Object obj = Common.readAsJSON((InputStream)response_.body);
                    Map res = Common.assertAsMap((Object)obj);
                    Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)res), new TeaPair("headers", (Object)response_.headers)});
                    return map;
                }
                if (Common.equalString((String)bodyType, (String)"array")) {
                    Object arr = Common.readAsJSON((InputStream)response_.body);
                    Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", arr), new TeaPair("headers", (Object)response_.headers)});
                    return map;
                }
                Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
                return map;
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
            finally {
                if (Common.isUnset(_lastResponse) || Common.isUnset((Object)_lastResponse.response) || Common.isUnset((Object)_lastResponse.response.body())) continue;
                _lastResponse.response.close();
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public Map<String, ?> doRequest(Params params, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams((TeaModel)params, (String)"params");
        TeaModel.validateParams((TeaModel)request, (String)"request");
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("socks5Proxy", (Object)Common.defaultString((String)runtime.socks5Proxy, (String)this._socks5Proxy)), new TeaPair("socks5NetWork", (Object)Common.defaultString((String)runtime.socks5NetWork, (String)this._socks5NetWork)), new TeaPair("maxIdleConns", (Object)Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        TeaResponse _lastResponse = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                Object _res;
                TeaResponse response_;
                Map<String, String> headers;
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)params.protocol);
                request_.method = params.method;
                request_.pathname = params.pathname;
                Map<Object, Object> globalQueries = new HashMap();
                Map<Object, Object> globalHeaders = new HashMap();
                if (!Common.isUnset((Object)TeaModel.buildMap((TeaModel)this._globalParameters))) {
                    GlobalParameters globalParams = this._globalParameters;
                    if (!Common.isUnset(globalParams.queries)) {
                        globalQueries = globalParams.queries;
                    }
                    if (!Common.isUnset(globalParams.headers)) {
                        globalHeaders = globalParams.headers;
                    }
                }
                request_.query = TeaConverter.merge(String.class, (Map[])new Map[]{globalQueries, request.query});
                request_.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)this._endpoint), new TeaPair("x-acs-version", (Object)params.version), new TeaPair("x-acs-action", (Object)params.action), new TeaPair("user-agent", (Object)this.getUserAgent()), new TeaPair("x-acs-date", (Object)com.aliyun.openapiutil.Client.getTimestamp()), new TeaPair("x-acs-signature-nonce", (Object)Common.getNonce()), new TeaPair("accept", (Object)"application/json")}), globalHeaders, request.headers});
                if (Common.equalString((String)params.style, (String)"RPC") && !Common.isUnset(headers = this.getRpcHeaders())) {
                    request_.headers = TeaConverter.merge(String.class, (Map[])new Map[]{request_.headers, headers});
                }
                String signatureAlgorithm = Common.defaultString((String)this._signatureAlgorithm, (String)"ACS3-HMAC-SHA256");
                String hashedRequestPayload = com.aliyun.openapiutil.Client.hexEncode((byte[])com.aliyun.openapiutil.Client.hash((byte[])Common.toBytes((String)""), (String)signatureAlgorithm));
                if (!Common.isUnset((Object)request.stream)) {
                    byte[] tmp = Common.readAsBytes((InputStream)request.stream);
                    hashedRequestPayload = com.aliyun.openapiutil.Client.hexEncode((byte[])com.aliyun.openapiutil.Client.hash((byte[])tmp, (String)signatureAlgorithm));
                    request_.body = Tea.toReadable((byte[])tmp);
                    request_.headers.put("content-type", "application/octet-stream");
                } else if (!Common.isUnset((Object)request.body)) {
                    if (Common.equalString((String)params.reqBodyType, (String)"json")) {
                        String jsonObj = Common.toJSONString((Object)request.body);
                        hashedRequestPayload = com.aliyun.openapiutil.Client.hexEncode((byte[])com.aliyun.openapiutil.Client.hash((byte[])Common.toBytes((String)jsonObj), (String)signatureAlgorithm));
                        request_.body = Tea.toReadable((String)jsonObj);
                        request_.headers.put("content-type", "application/json; charset=utf-8");
                    } else {
                        Map m = Common.assertAsMap((Object)request.body);
                        String formObj = com.aliyun.openapiutil.Client.toForm((Map)m);
                        hashedRequestPayload = com.aliyun.openapiutil.Client.hexEncode((byte[])com.aliyun.openapiutil.Client.hash((byte[])Common.toBytes((String)formObj), (String)signatureAlgorithm));
                        request_.body = Tea.toReadable((String)formObj);
                        request_.headers.put("content-type", "application/x-www-form-urlencoded");
                    }
                }
                request_.headers.put("x-acs-content-sha256", hashedRequestPayload);
                if (!Common.equalString((String)params.authType, (String)"Anonymous")) {
                    String authType = this.getType();
                    if (Common.equalString((String)authType, (String)"bearer")) {
                        String bearerToken = this.getBearerToken();
                        request_.headers.put("x-acs-bearer-token", bearerToken);
                    } else {
                        String accessKeyId = this.getAccessKeyId();
                        String accessKeySecret = this.getAccessKeySecret();
                        String securityToken = this.getSecurityToken();
                        if (!Common.empty((String)securityToken)) {
                            request_.headers.put("x-acs-accesskey-id", accessKeyId);
                            request_.headers.put("x-acs-security-token", securityToken);
                        }
                        request_.headers.put("Authorization", com.aliyun.openapiutil.Client.getAuthorization((TeaRequest)request_, (String)signatureAlgorithm, (String)hashedRequestPayload, (String)accessKeyId, (String)accessKeySecret));
                    }
                }
                _lastRequest = request_;
                _lastResponse = response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_, (InterceptorChain)interceptorChain);
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    Map<String, Integer> err = new HashMap();
                    if (!Common.isUnset(response_.headers.get("content-type")) && Common.equalString((String)((String)response_.headers.get("content-type")), (String)"text/xml;charset=utf-8")) {
                        String _str = Common.readAsString((InputStream)response_.body);
                        Map respMap = com.aliyun.teaxml.Client.parseXml((String)_str, null);
                        err = Common.assertAsMap(respMap.get("Error"));
                    } else {
                        _res = Common.readAsJSON((InputStream)response_.body);
                        err = Common.assertAsMap((Object)_res);
                    }
                    err.put("statusCode", response_.statusCode);
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)("" + Client.defaultAny(err.get("Code"), err.get("code")) + "")), new TeaPair("message", (Object)("code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " request id: " + Client.defaultAny(err.get("RequestId"), err.get("requestId")) + "")), new TeaPair("data", err)}));
                }
                if (Common.equalString((String)params.bodyType, (String)"binary")) {
                    Map resp = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)response_.body), new TeaPair("headers", (Object)response_.headers), new TeaPair("statusCode", (Object)response_.statusCode)});
                    _res = resp;
                    return _res;
                }
                if (Common.equalString((String)params.bodyType, (String)"byte")) {
                    byte[] byt = Common.readAsBytes((InputStream)response_.body);
                    _res = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)byt), new TeaPair("headers", (Object)response_.headers), new TeaPair("statusCode", (Object)response_.statusCode)});
                    return _res;
                }
                if (Common.equalString((String)params.bodyType, (String)"string")) {
                    String str = Common.readAsString((InputStream)response_.body);
                    _res = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)str), new TeaPair("headers", (Object)response_.headers), new TeaPair("statusCode", (Object)response_.statusCode)});
                    return _res;
                }
                if (Common.equalString((String)params.bodyType, (String)"json")) {
                    Object obj = Common.readAsJSON((InputStream)response_.body);
                    Map res = Common.assertAsMap((Object)obj);
                    Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)res), new TeaPair("headers", (Object)response_.headers), new TeaPair("statusCode", (Object)response_.statusCode)});
                    return map;
                }
                if (Common.equalString((String)params.bodyType, (String)"array")) {
                    Object arr = Common.readAsJSON((InputStream)response_.body);
                    Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", arr), new TeaPair("headers", (Object)response_.headers), new TeaPair("statusCode", (Object)response_.statusCode)});
                    return map;
                }
                Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers), new TeaPair("statusCode", (Object)response_.statusCode)});
                return map;
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
            finally {
                if (Common.isUnset(_lastResponse) || Common.isUnset((Object)_lastResponse.response) || Common.isUnset((Object)_lastResponse.response.body())) continue;
                _lastResponse.response.close();
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public Map<String, ?> execute(Params params, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams((TeaModel)params, (String)"params");
        TeaModel.validateParams((TeaModel)request, (String)"request");
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("socks5Proxy", (Object)Common.defaultString((String)runtime.socks5Proxy, (String)this._socks5Proxy)), new TeaPair("socks5NetWork", (Object)Common.defaultString((String)runtime.socks5NetWork, (String)this._socks5NetWork)), new TeaPair("maxIdleConns", (Object)Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                InterceptorContext.InterceptorContextResponse responseContext;
                TeaRequest request_ = new TeaRequest();
                Map<String, String> headers = this.getRpcHeaders();
                Map<Object, Object> globalQueries = new HashMap();
                Map<Object, Object> globalHeaders = new HashMap();
                if (!Common.isUnset((Object)TeaModel.buildMap((TeaModel)this._globalParameters))) {
                    GlobalParameters globalParams = this._globalParameters;
                    if (!Common.isUnset(globalParams.queries)) {
                        globalQueries = globalParams.queries;
                    }
                    if (!Common.isUnset(globalParams.headers)) {
                        globalHeaders = globalParams.headers;
                    }
                }
                InterceptorContext.InterceptorContextRequest requestContext = InterceptorContext.InterceptorContextRequest.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)TeaConverter.merge(String.class, (Map[])new Map[]{globalHeaders, request.headers, headers})), new TeaPair("query", (Object)TeaConverter.merge(String.class, (Map[])new Map[]{globalQueries, request.query})), new TeaPair("body", request.body), new TeaPair("stream", (Object)request.stream), new TeaPair("hostMap", request.hostMap), new TeaPair("pathname", (Object)params.pathname), new TeaPair("productId", (Object)this._productId), new TeaPair("action", (Object)params.action), new TeaPair("version", (Object)params.version), new TeaPair("protocol", (Object)Common.defaultString((String)this._protocol, (String)params.protocol)), new TeaPair("method", (Object)Common.defaultString((String)this._method, (String)params.method)), new TeaPair("authType", (Object)params.authType), new TeaPair("bodyType", (Object)params.bodyType), new TeaPair("reqBodyType", (Object)params.reqBodyType), new TeaPair("style", (Object)params.style), new TeaPair("credential", (Object)this._credential), new TeaPair("signatureVersion", (Object)this._signatureVersion), new TeaPair("signatureAlgorithm", (Object)this._signatureAlgorithm), new TeaPair("userAgent", (Object)this.getUserAgent())}));
                InterceptorContext.InterceptorContextConfiguration configurationContext = InterceptorContext.InterceptorContextConfiguration.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("regionId", (Object)this._regionId), new TeaPair("endpoint", (Object)Common.defaultString((String)request.endpointOverride, (String)this._endpoint)), new TeaPair("endpointRule", (Object)this._endpointRule), new TeaPair("endpointMap", this._endpointMap), new TeaPair("endpointType", (Object)this._endpointType), new TeaPair("network", (Object)this._network), new TeaPair("suffix", (Object)this._suffix)}));
                InterceptorContext interceptorContext = InterceptorContext.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("request", (Object)requestContext), new TeaPair("configuration", (Object)configurationContext)}));
                AttributeMap attributeMap = new AttributeMap();
                this._spi.modifyConfiguration(interceptorContext, attributeMap);
                this._spi.modifyRequest(interceptorContext, attributeMap);
                request_.protocol = interceptorContext.request.protocol;
                request_.method = interceptorContext.request.method;
                request_.pathname = interceptorContext.request.pathname;
                request_.query = interceptorContext.request.query;
                request_.body = interceptorContext.request.stream;
                request_.headers = interceptorContext.request.headers;
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_, (InterceptorChain)interceptorChain);
                interceptorContext.response = responseContext = InterceptorContext.InterceptorContextResponse.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("statusCode", (Object)response_.statusCode), new TeaPair("headers", (Object)response_.headers), new TeaPair("body", (Object)response_.body)}));
                this._spi.modifyResponse(interceptorContext, attributeMap);
                return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)interceptorContext.response.headers), new TeaPair("statusCode", (Object)interceptorContext.response.statusCode), new TeaPair("body", interceptorContext.response.deserializedBody)});
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public void addRuntimeOptionsInterceptor(RuntimeOptionsInterceptor interceptor) {
        interceptorChain.addRuntimeOptionsInterceptor(interceptor);
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        interceptorChain.addRequestInterceptor(interceptor);
    }

    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        interceptorChain.addResponseInterceptor(interceptor);
    }

    public Map<String, ?> callApi(Params params, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        if (Common.isUnset((Object)TeaModel.buildMap((TeaModel)params))) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'params' can not be unset")}));
        }
        if (Common.isUnset((Object)this._signatureAlgorithm) || !Common.equalString((String)this._signatureAlgorithm, (String)"v2")) {
            return this.doRequest(params, request, runtime);
        }
        if (Common.equalString((String)params.style, (String)"ROA") && Common.equalString((String)params.reqBodyType, (String)"json")) {
            return this.doROARequest(params.action, params.version, params.protocol, params.method, params.authType, params.pathname, params.bodyType, request, runtime);
        }
        if (Common.equalString((String)params.style, (String)"ROA")) {
            return this.doROARequestWithForm(params.action, params.version, params.protocol, params.method, params.authType, params.pathname, params.bodyType, request, runtime);
        }
        return this.doRPCRequest(params.action, params.version, params.protocol, params.method, params.authType, params.bodyType, request, runtime);
    }

    public String getUserAgent() throws Exception {
        String userAgent = Common.getUserAgent((String)this._userAgent);
        return userAgent;
    }

    public String getAccessKeyId() throws Exception {
        if (Common.isUnset((Object)this._credential)) {
            return "";
        }
        String accessKeyId = this._credential.getAccessKeyId();
        return accessKeyId;
    }

    public String getAccessKeySecret() throws Exception {
        if (Common.isUnset((Object)this._credential)) {
            return "";
        }
        String secret = this._credential.getAccessKeySecret();
        return secret;
    }

    public String getSecurityToken() throws Exception {
        if (Common.isUnset((Object)this._credential)) {
            return "";
        }
        String token = this._credential.getSecurityToken();
        return token;
    }

    public String getBearerToken() throws Exception {
        if (Common.isUnset((Object)this._credential)) {
            return "";
        }
        String token = this._credential.getBearerToken();
        return token;
    }

    public String getType() throws Exception {
        if (Common.isUnset((Object)this._credential)) {
            return "";
        }
        String authType = this._credential.getType();
        return authType;
    }

    public static Object defaultAny(Object inputValue, Object defaultValue) throws Exception {
        if (Common.isUnset((Object)inputValue)) {
            return defaultValue;
        }
        return inputValue;
    }

    public void checkConfig(Config config) throws Exception {
        if (Common.empty((String)this._endpointRule) && Common.empty((String)config.endpoint)) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config.endpoint' can not be empty")}));
        }
    }

    public void setRpcHeaders(Map<String, String> headers) throws Exception {
        this._headers = headers;
    }

    public Map<String, String> getRpcHeaders() throws Exception {
        Map<String, String> headers = this._headers;
        this._headers = null;
        return headers;
    }
}

