/*
 * Decompiled with CFR 0.152.
 */
package com.allenliu.badgeview;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class BadgeView
extends View {
    private Paint numberPaint;
    private Paint backgroundPaint;
    public static final int SHAPE_CIRCLE = 1;
    public static final int SHAPE_RECTANGLE = 2;
    public static final int SHAPE_OVAL = 3;
    public static final int SHAPTE_ROUND_RECTANGLE = 4;
    public static final int SHAPE_SQUARE = 5;
    private int currentShape = 1;
    private int defaultTextColor = -1;
    private int defaultTextSize;
    private int defaultBackgroundColor = -65536;
    private String showText = "";
    private int badgeGravity = 53;
    private int leftMargin = 0;
    private int topMargin = 0;
    private int bottomMargin = 0;
    private int rightMargin = 0;
    private boolean hasBind = false;
    private int horiontalSpace = 0;
    private int verticalSpace = 0;

    public BadgeView(Context context) {
        super(context);
        this.init(context);
    }

    public BadgeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public BadgeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @TargetApi(value=21)
    public BadgeView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.defaultTextSize = this.dip2px(context, 1);
        this.numberPaint = new Paint(1);
        this.numberPaint.setColor(this.defaultTextColor);
        this.numberPaint.setStyle(Paint.Style.FILL);
        this.numberPaint.setTextSize((float)this.defaultTextSize);
        this.numberPaint.setTextAlign(Paint.Align.CENTER);
        this.backgroundPaint = new Paint(1);
        this.backgroundPaint.setColor(this.defaultBackgroundColor);
        this.backgroundPaint.setStyle(Paint.Style.FILL);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = this.badgeGravity;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        RectF rectF = new RectF(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight());
        Paint.FontMetrics fontMetrics = this.numberPaint.getFontMetrics();
        float textH = fontMetrics.descent - fontMetrics.ascent;
        switch (this.currentShape) {
            case 1: {
                canvas.drawCircle((float)this.getMeasuredWidth() / 2.0f, (float)this.getMeasuredHeight() / 2.0f, (float)(this.getMeasuredWidth() / 2), this.backgroundPaint);
                canvas.drawText(this.showText, (float)this.getMeasuredWidth() / 2.0f, (float)this.getMeasuredHeight() / 2.0f + (textH / 2.0f - fontMetrics.descent), this.numberPaint);
                break;
            }
            case 3: {
                canvas.drawOval(rectF, this.backgroundPaint);
                canvas.drawText(this.showText, (float)this.getMeasuredWidth() / 2.0f, (float)this.getMeasuredHeight() / 2.0f + (textH / 2.0f - fontMetrics.descent), this.numberPaint);
                break;
            }
            case 2: {
                canvas.drawRect(rectF, this.backgroundPaint);
                canvas.drawText(this.showText, (float)this.getMeasuredWidth() / 2.0f, (float)this.getMeasuredHeight() / 2.0f + (textH / 2.0f - fontMetrics.descent), this.numberPaint);
                break;
            }
            case 5: {
                int sideLength = Math.min(this.getMeasuredHeight(), this.getMeasuredWidth());
                RectF squareF = new RectF(0.0f, 0.0f, (float)sideLength, (float)sideLength);
                canvas.drawRect(squareF, this.backgroundPaint);
                canvas.drawText(this.showText, (float)sideLength / 2.0f, (float)sideLength / 2.0f + (textH / 2.0f - fontMetrics.descent), this.numberPaint);
                break;
            }
            case 4: {
                canvas.drawRoundRect(rectF, (float)this.dip2px(this.getContext(), 5), (float)this.dip2px(this.getContext(), 5), this.backgroundPaint);
                canvas.drawText(this.showText, (float)this.getMeasuredWidth() / 2.0f, (float)this.getMeasuredHeight() / 2.0f + (textH / 2.0f - fontMetrics.descent), this.numberPaint);
            }
        }
    }

    private int dip2px(Context context, int dip) {
        return (int)((float)dip * this.getContext().getResources().getDisplayMetrics().density + 0.5f);
    }

    private int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public BadgeView setShape(int shape) {
        this.currentShape = shape;
        this.invalidate();
        return this;
    }

    public BadgeView setWidthAndHeight(int w, int h) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        params.width = this.dip2px(this.getContext(), w);
        params.height = this.dip2px(this.getContext(), h);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        return this;
    }

    public BadgeView setWidth(int sp) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        params.width = this.dip2px(this.getContext(), sp);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        return this;
    }

    public BadgeView setHeight(int sp) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        params.height = this.dip2px(this.getContext(), sp);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        return this;
    }

    @Deprecated
    public BadgeView setMargin(int left, int top, int right, int bottom) {
        this.leftMargin = this.dip2px(this.getContext(), left);
        this.bottomMargin = this.dip2px(this.getContext(), bottom);
        this.topMargin = this.dip2px(this.getContext(), top);
        this.rightMargin = this.dip2px(this.getContext(), right);
        this.invalidate();
        return this;
    }

    public BadgeView setSpace(int horitontal, int vertical) {
        this.horiontalSpace = this.dip2px(this.getContext(), horitontal);
        this.verticalSpace = this.dip2px(this.getContext(), vertical);
        this.invalidate();
        return this;
    }

    public BadgeView setTextSize(int sp) {
        this.defaultTextSize = this.sp2px(this.getContext(), sp);
        this.numberPaint.setTextSize((float)this.sp2px(this.getContext(), sp));
        this.invalidate();
        return this;
    }

    public BadgeView setTextColor(int color) {
        this.defaultTextColor = color;
        this.numberPaint.setColor(color);
        this.invalidate();
        return this;
    }

    public BadgeView setBadgeBackground(int color) {
        this.defaultBackgroundColor = color;
        this.backgroundPaint.setColor(color);
        this.invalidate();
        return this;
    }

    public BadgeView setBadgeCount(int count) {
        this.showText = String.valueOf(count);
        this.invalidate();
        return this;
    }

    public BadgeView setBadgeCount(String count) {
        this.showText = count;
        this.invalidate();
        return this;
    }

    public BadgeView setBadgeGravity(int gravity) {
        this.badgeGravity = gravity;
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        params.gravity = gravity;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        return this;
    }

    public BadgeView bind(View view) {
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        if (view == null) {
            return this;
        }
        if (view.getParent() instanceof FrameLayout && this.hasBind) {
            ((FrameLayout)view.getParent()).addView((View)this);
            return this;
        }
        if (view.getParent() instanceof ViewGroup) {
            ViewGroup parentContainer = (ViewGroup)view.getParent();
            int viewIndex = ((ViewGroup)view.getParent()).indexOfChild(view);
            ((ViewGroup)view.getParent()).removeView(view);
            FrameLayout container = new FrameLayout(this.getContext());
            ViewGroup.LayoutParams containerParams = view.getLayoutParams();
            int origionHeight = containerParams.height;
            int origionWidth = containerParams.width;
            FrameLayout.LayoutParams viewLayoutParams = new FrameLayout.LayoutParams(origionWidth, origionHeight);
            if (origionHeight == -2) {
                containerParams.height = -2;
                viewLayoutParams.topMargin = this.topMargin;
                viewLayoutParams.bottomMargin = this.bottomMargin;
            } else {
                containerParams.height = origionHeight + this.topMargin + this.bottomMargin + this.verticalSpace;
            }
            if (origionWidth == -2) {
                containerParams.width = -2;
                viewLayoutParams.leftMargin = this.leftMargin;
                viewLayoutParams.rightMargin = this.rightMargin;
            } else {
                containerParams.width = origionWidth + this.rightMargin + this.horiontalSpace + this.leftMargin;
            }
            container.setLayoutParams(containerParams);
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
            if (params.gravity == 53 || params.gravity == 5 || params.gravity == 48) {
                view.setPadding(0, this.verticalSpace, this.horiontalSpace, 0);
                viewLayoutParams.gravity = 83;
            } else if (params.gravity == 51 || params.gravity == 3 || params.gravity == 48) {
                view.setPadding(this.horiontalSpace, this.verticalSpace, 0, 0);
                viewLayoutParams.gravity = 85;
            } else if (params.gravity == 83) {
                view.setPadding(this.horiontalSpace, 0, 0, this.verticalSpace);
                viewLayoutParams.gravity = 53;
            } else if (params.gravity == 85) {
                view.setPadding(0, 0, this.horiontalSpace, this.verticalSpace);
                viewLayoutParams.gravity = 51;
            } else {
                view.setPadding(0, this.verticalSpace, this.horiontalSpace, 0);
                viewLayoutParams.gravity = 83;
            }
            view.setLayoutParams((ViewGroup.LayoutParams)viewLayoutParams);
            container.setId(view.getId());
            container.addView(view);
            container.addView((View)this);
            parentContainer.addView((View)container, viewIndex);
            this.hasBind = true;
        } else if (view.getParent() == null) {
            Log.e((String)"badgeview", (String)"View must have a parent");
        }
        return this;
    }

    public boolean unbind() {
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
            return true;
        }
        return false;
    }

    public String getBadgeCount() {
        return this.showText;
    }
}

