/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.GLTFOverlayOptionsCreator;
import com.amap.api.maps.model.GLTFResourceIterm;
import com.amap.api.maps.model.LatLng;
import com.autonavi.base.amap.mapcore.jbinding.JBindingExclude;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.ArrayList;
import java.util.List;

@JBindingInclude
public class GLTFOverlayOptions
extends BaseOptions
implements Parcelable,
Cloneable {
    private LatLng mLatLng = new LatLng(0.0, 0.0);
    private double mZDegree = 0.0;
    private double mXDegree = 0.0;
    private double mYDegree = 0.0;
    private double mAltitude = 0.0;
    private double mScale = 1.0;
    private byte[] mModelData;
    private List<GLTFResourceIterm> mUriResources = new ArrayList<GLTFResourceIterm>();
    private boolean isClickable = false;
    private boolean isDraggable = false;
    private BitmapDescriptor infoWindowView;
    private boolean isClick = false;
    private String title;
    private int currentAnimationIndex = 0;
    private float minZoom = 3.0f;
    private float maxZoom = 20.0f;
    private boolean isGlbFormat = false;
    private float zIndex = 0.0f;
    @JBindingExclude
    public static final GLTFOverlayOptionsCreator CREATOR = new GLTFOverlayOptionsCreator();

    public GLTFOverlayOptions() {
        this.type = "GLTFOverlayOptions";
    }

    @JBindingExclude
    GLTFOverlayOptions(LatLng latLng, double d2, double d3, String string2, List<GLTFResourceIterm> list) {
        this.mLatLng = latLng;
        this.mAltitude = d2;
        this.mScale = d3;
        this.mModelData = string2 != null ? string2.getBytes() : "".getBytes();
        this.mUriResources = list;
    }

    public GLTFOverlayOptions latLng(LatLng latLng) {
        this.mLatLng = latLng;
        return this;
    }

    public GLTFOverlayOptions rotationDegree(double d2, double d3, double d4) {
        this.mXDegree = d2;
        this.mYDegree = d3;
        this.mZDegree = d4;
        return this;
    }

    public GLTFOverlayOptions altitude(double d2) {
        this.mAltitude = d2;
        return this;
    }

    public GLTFOverlayOptions scale(double d2) {
        this.mScale = d2;
        return this;
    }

    public GLTFOverlayOptions modelData(byte[] byArray) {
        if (byArray != null) {
            this.mModelData = byArray;
        }
        return this;
    }

    public void glbFormat(boolean bl2) {
        this.isGlbFormat = bl2;
    }

    public boolean isGlbFormat() {
        return this.isGlbFormat;
    }

    public GLTFOverlayOptions uriResources(List<GLTFResourceIterm> list) {
        this.mUriResources = list;
        return this;
    }

    public LatLng getLatLng() {
        return this.mLatLng;
    }

    public double getZDegree() {
        return this.mZDegree;
    }

    public double getXDegree() {
        return this.mXDegree;
    }

    public double getYDegree() {
        return this.mYDegree;
    }

    public double getAltitude() {
        return this.mAltitude;
    }

    public double getScale() {
        return this.mScale;
    }

    public byte[] getModelData() {
        return this.mModelData;
    }

    public List<GLTFResourceIterm> getUriResources() {
        return this.mUriResources;
    }

    public void setClickable(boolean bl2) {
        this.isClickable = bl2;
    }

    public boolean isClickable() {
        return this.isClickable;
    }

    public void setDraggable(boolean bl2) {
        this.isDraggable = bl2;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    public void infoWindowView(BitmapDescriptor bitmapDescriptor) {
        this.infoWindowView = bitmapDescriptor;
    }

    public BitmapDescriptor getInfoWindowView() {
        return this.infoWindowView;
    }

    public void tapClick() {
        this.isClick = !this.isClick;
    }

    public boolean isInfoWindowShow() {
        return this.isClick;
    }

    public void setCurrentAnimationIndex(int n2) {
        this.currentAnimationIndex = n2;
    }

    public int getCurrentAnimationIndex() {
        return this.currentAnimationIndex;
    }

    public void setZoomRange(float f2, float f3) {
        this.minZoom = f2;
        this.maxZoom = f3;
    }

    public float getMinZoom() {
        return this.minZoom;
    }

    public float getMaxZoom() {
        return this.maxZoom;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(float f2) {
        this.zIndex = f2;
    }

    @JBindingExclude
    protected GLTFOverlayOptions(Parcel parcel) {
        this.mLatLng = (LatLng)parcel.readParcelable(LatLng.class.getClassLoader());
        this.mZDegree = parcel.readDouble();
        this.mXDegree = parcel.readDouble();
        this.mYDegree = parcel.readDouble();
        this.mAltitude = parcel.readDouble();
        this.mScale = parcel.readDouble();
        parcel.readByteArray(this.mModelData);
        this.mUriResources = parcel.readArrayList(GLTFResourceIterm.class.getClassLoader());
        boolean[] blArray = new boolean[3];
        parcel.readBooleanArray(blArray);
        this.isClickable = blArray[0];
        this.isDraggable = blArray[1];
        this.isGlbFormat = blArray[2];
        this.infoWindowView = (BitmapDescriptor)parcel.readParcelable(BitmapDescriptor.class.getClassLoader());
        this.title = parcel.readString();
        this.currentAnimationIndex = parcel.readInt();
        this.minZoom = parcel.readFloat();
        this.maxZoom = parcel.readFloat();
        this.zIndex = parcel.readFloat();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeParcelable((Parcelable)this.mLatLng, n2);
        parcel.writeDouble(this.mZDegree);
        parcel.writeDouble(this.mXDegree);
        parcel.writeDouble(this.mYDegree);
        parcel.writeDouble(this.mAltitude);
        parcel.writeDouble(this.mScale);
        parcel.writeByteArray(this.mModelData);
        parcel.writeList(this.mUriResources);
        boolean[] blArray = new boolean[]{this.isClickable, this.isDraggable, this.isGlbFormat};
        parcel.writeBooleanArray(blArray);
        if (this.infoWindowView != null) {
            parcel.writeParcelable((Parcelable)this.infoWindowView, n2);
        }
        if (this.title != null) {
            parcel.writeString(this.title);
        }
        parcel.writeInt(this.currentAnimationIndex);
        parcel.writeFloat(this.minZoom);
        parcel.writeFloat(this.maxZoom);
        parcel.writeFloat(this.zIndex);
    }

    public GLTFOverlayOptions clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        GLTFOverlayOptions gLTFOverlayOptions = new GLTFOverlayOptions();
        new GLTFOverlayOptions().mLatLng = this.mLatLng.clone();
        gLTFOverlayOptions.mZDegree = this.mZDegree;
        gLTFOverlayOptions.mXDegree = this.mXDegree;
        gLTFOverlayOptions.mYDegree = this.mYDegree;
        gLTFOverlayOptions.mAltitude = this.mAltitude;
        gLTFOverlayOptions.mScale = this.mScale;
        gLTFOverlayOptions.mModelData = this.mModelData;
        gLTFOverlayOptions.mUriResources = this.mUriResources;
        gLTFOverlayOptions.isClickable = this.isClickable;
        gLTFOverlayOptions.isDraggable = this.isDraggable;
        if (this.infoWindowView != null) {
            gLTFOverlayOptions.infoWindowView = this.infoWindowView.clone();
        }
        if (this.title != null) {
            gLTFOverlayOptions.title = this.title;
        }
        gLTFOverlayOptions.currentAnimationIndex = this.currentAnimationIndex;
        gLTFOverlayOptions.minZoom = this.minZoom;
        gLTFOverlayOptions.maxZoom = this.maxZoom;
        gLTFOverlayOptions.isGlbFormat = this.isGlbFormat;
        gLTFOverlayOptions.zIndex = this.zIndex;
        return gLTFOverlayOptions;
    }
}

