/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import android.util.Log;
import com.amap.api.col.3sl.dz;
import com.amap.api.col.3sl.mb;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.interfaces.INativeOverlayLayer;
import com.amap.api.maps.model.BasePointOverlay;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.animation.Animation;
import com.autonavi.amap.mapcore.DPoint;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.VirtualEarthProjection;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public final class Marker
extends BasePointOverlay {
    private MarkerOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;
    private WeakReference<INativeOverlayLayer> nativeOverlayLayerRef;
    private Object object;
    private IPoint geoPoint;
    private boolean isRemoved = false;
    private DPoint viewModeLatLngDp = new DPoint();
    private LatLng viewModeLatLng = null;
    private boolean isUseAnimation = false;
    private Animation mCurAnimation = null;
    private Animation.AnimationListener mCurAnimationListener = null;
    private a mCurInnerAnimationListener = null;
    private boolean isClickable = true;
    private boolean isInfoWindowEnable = true;

    public Marker(IGlOverlayLayer iGlOverlayLayer, INativeOverlayLayer iNativeOverlayLayer, MarkerOptions markerOptions, String string2) {
        super(string2);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.nativeOverlayLayerRef = new WeakReference<INativeOverlayLayer>(iNativeOverlayLayer);
        this.options = markerOptions;
    }

    public final void setPeriod(int n2) {
        try {
            this.options.period(n2);
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final int getPeriod() {
        try {
            return this.options.getPeriod();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public final void setIcons(ArrayList<BitmapDescriptor> arrayList) {
        try {
            this.options.icons(arrayList);
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final ArrayList<BitmapDescriptor> getIcons() {
        try {
            return this.options.getIcons();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Override
    public final void remove() {
        try {
            if (this.isInfoWindowShown()) {
                this.hideInfoWindow();
            }
            if (this.isIconView()) {
                INativeOverlayLayer iNativeOverlayLayer = (INativeOverlayLayer)this.nativeOverlayLayerRef.get();
                if (iNativeOverlayLayer != null) {
                    iNativeOverlayLayer.removeNativeOverlay(this.overlayName);
                }
            } else {
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (iGlOverlayLayer != null) {
                    iGlOverlayLayer.removeOverlay(this.overlayName);
                }
            }
            this.isRemoved = true;
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final void destroy() {
        try {
            this.remove();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final String getId() {
        try {
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setPerspective(boolean bl2) {
    }

    public final boolean isPerspective() {
        return false;
    }

    @Override
    public final void setPosition(LatLng latLng) {
        try {
            if (this.options != null) {
                this.options.position(latLng);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final LatLng getPosition() {
        try {
            if (this.options != null) {
                Object object;
                if (this.isViewMode()) {
                    ((IGlOverlayLayer)this.glOverlayLayerRef.get()).getMap().getPixel2LatLng(this.options.getScreenX(), this.options.getScreenY(), this.viewModeLatLngDp);
                    if (this.viewModeLatLng != null && this.viewModeLatLng.latitude == this.viewModeLatLngDp.y && this.viewModeLatLng.longitude == this.viewModeLatLngDp.x) {
                        return this.viewModeLatLng;
                    }
                    return new LatLng(this.viewModeLatLngDp.y, this.viewModeLatLngDp.x);
                }
                if (this.isUseAnimation && (object = this.a("getPosition", null)) != null) {
                    return (LatLng)object;
                }
                return this.options.getPosition();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    @Override
    public final void setTitle(String string2) {
        try {
            if (this.options != null) {
                this.options.title(string2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final String getTitle() {
        try {
            if (this.options != null) {
                return this.options.getTitle();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    @Override
    public final void setSnippet(String string2) {
        try {
            if (this.options != null) {
                this.options.snippet(string2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final String getSnippet() {
        try {
            if (this.options != null) {
                return this.options.getSnippet();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public final void setIcon(BitmapDescriptor bitmapDescriptor) {
        try {
            if (bitmapDescriptor != null && this.options != null) {
                this.options.icon(bitmapDescriptor);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final void setAnchor(float f2, float f3) {
        try {
            if (this.options != null) {
                this.options.anchor(f2, f3);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final void setDraggable(boolean bl2) {
        try {
            if (this.options != null) {
                this.options.draggable(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final boolean isDraggable() {
        if (this.options != null) {
            return this.options.isDraggable();
        }
        return false;
    }

    @Override
    public final void showInfoWindow() {
        try {
            if (this.isIconView()) {
                INativeOverlayLayer iNativeOverlayLayer = (INativeOverlayLayer)this.nativeOverlayLayerRef.get();
                if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iNativeOverlayLayer != null) {
                    iNativeOverlayLayer.showInfoWindow(this.overlayName);
                }
                return;
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.showInfoWindow(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final void hideInfoWindow() {
        try {
            if (this.isIconView()) {
                INativeOverlayLayer iNativeOverlayLayer = (INativeOverlayLayer)this.nativeOverlayLayerRef.get();
                if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iNativeOverlayLayer != null) {
                    iNativeOverlayLayer.hideInfoWindow(this.overlayName);
                }
                return;
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.hideInfoWindow(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final boolean isInfoWindowShown() {
        if (this.isIconView()) {
            INativeOverlayLayer iNativeOverlayLayer = (INativeOverlayLayer)this.nativeOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iNativeOverlayLayer != null) {
                return iNativeOverlayLayer.isInfoWindowShown(this.overlayName);
            }
        } else {
            Object object = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && object != null && (object = this.a("isInfoWindowShown", null)) instanceof Boolean) {
                return (Boolean)object;
            }
        }
        return false;
    }

    public final void setAltitude(float f2) {
        try {
            if (this.options != null) {
                this.options.altitude(f2);
                this.a();
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public final float getAltitude() {
        try {
            if (this.options != null) {
                return this.options.getAltitude();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0.0f;
    }

    @Override
    public final void setVisible(boolean bl2) {
        try {
            if (this.options != null) {
                this.options.visible(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final boolean isVisible() {
        try {
            if (this.options != null) {
                return this.options.isVisible();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Marker)) {
            return false;
        }
        try {
            if (this.options != null) {
                return this.options.equals(((Marker)object).options) && this.overlayName.equals(((Marker)object).overlayName);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public final int hashCode() {
        if (this.options != null) {
            int n2 = 31 + (this.overlayName == null ? 0 : this.overlayName.hashCode());
            return 31 * n2 + this.options.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public final void setObject(Object object) {
        this.object = object;
    }

    @Override
    public final Object getObject() {
        return this.object;
    }

    @Override
    public final void setRotateAngle(float f2) {
        try {
            if (this.options != null) {
                this.options.rotateAngle(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final float getRotateAngle() {
        if (this.options != null) {
            if (this.isUseAnimation) {
                Object object = this.a("getRotateAngle", null);
                Log.e((String)"mapcore", (String)"getRotateAngle ".concat(String.valueOf(object)));
                if (object != null) {
                    return ((Double)object).floatValue();
                }
            }
            return this.options.getRotateAngle();
        }
        return 0.0f;
    }

    public final void setToTop() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.set2Top(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final void setGeoPoint(IPoint object) {
        this.geoPoint = object;
        if (object != null) {
            object = VirtualEarthProjection.pixelsToLatLong(((IPoint)object).x, ((IPoint)object).y, 20);
            LatLng latLng = new LatLng(((DPoint)object).y, ((DPoint)object).x, false);
            ((DPoint)object).recycle();
            this.options.position(latLng);
            this.a();
        }
    }

    public final IPoint getGeoPoint() {
        LatLng latLng;
        if (this.geoPoint == null) {
            this.geoPoint = new IPoint();
        }
        if ((latLng = this.getPosition()) != null) {
            VirtualEarthProjection.latLongToPixels(latLng.latitude, latLng.longitude, 20, this.geoPoint);
        }
        return this.geoPoint;
    }

    public final void setFlat(boolean bl2) {
        try {
            if (this.options != null) {
                this.options.setFlat(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final boolean isFlat() {
        if (this.options != null) {
            return this.options.isFlat();
        }
        return false;
    }

    public final void setPositionByPixels(int n2, int n3) {
        if (this.options != null) {
            this.options.setScreenPosition(n2, n3);
            this.a();
        }
    }

    public final void setZIndex(float f2) {
        if (this.options != null) {
            this.options.zIndex(f2);
            this.a();
        }
    }

    public final float getZIndex() {
        if (this.options != null) {
            return this.options.getZIndex();
        }
        return 0.0f;
    }

    @Override
    public final void setAnimation(Animation animation) {
        try {
            if (animation != null && this.mCurAnimationListener != null) {
                animation.setAnimationListener(this.mCurAnimationListener);
            }
            this.mCurAnimation = animation;
            this.isUseAnimation = animation != null;
            this.a("setAnimation", new Object[]{animation});
            if (animation != null) {
                animation.resetUpdateFlags();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    @Override
    public final boolean startAnimation() {
        Object object = this.a("startAnimation", null);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public final void setAnimationListener(Animation.AnimationListener animationListener) {
        this.mCurAnimationListener = animationListener;
        this.mCurInnerAnimationListener = new a(animationListener, 0);
        if (this.mCurAnimation != null) {
            this.a("setAnimationListener", new Object[]{this.mCurInnerAnimationListener});
        }
    }

    public final float getAlpha() {
        if (this.options != null) {
            Object object;
            if (this.isUseAnimation && (object = this.a("getAlpha", null)) != null) {
                return ((Double)object).floatValue();
            }
            return this.options.getAlpha();
        }
        return 1.0f;
    }

    public final void setAlpha(float f2) {
        if (this.options != null) {
            this.options.alpha(f2);
            this.a();
        }
    }

    public final int getDisplayLevel() {
        return 5;
    }

    public final MarkerOptions getOptions() {
        if (this.options != null) {
            return this.options;
        }
        return null;
    }

    public final boolean isClickable() {
        Object object = this.a("isClickable", null);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return this.isClickable;
    }

    public final boolean isInfoWindowAutoOverturn() {
        return false;
    }

    @Override
    public final boolean isInfoWindowEnable() {
        if (this.options != null) {
            return this.options.isInfoWindowEnable();
        }
        return this.isInfoWindowEnable;
    }

    public final void setInfoWindowEnable(boolean bl2) {
        this.isInfoWindowEnable = bl2;
        if (this.options != null) {
            this.options.infoWindowEnable(bl2);
            this.a();
        }
    }

    public final void setMarkerOptions(MarkerOptions markerOptions) {
        this.options = markerOptions;
        this.a();
    }

    public final void setAutoOverturnInfoWindow(boolean bl2) {
    }

    public final void setClickable(boolean bl2) {
        this.isClickable = bl2;
        this.a("setClickable", new Object[]{bl2});
    }

    public final void setDisplayLevel(int n2) {
    }

    public final void setFixingPointEnable(boolean bl2) {
    }

    public final boolean isRemoved() {
        return this.isRemoved;
    }

    public final void setPositionNotUpdate(LatLng latLng) {
        this.setPosition(latLng);
    }

    public final void setRotateAngleNotUpdate(float f2) {
    }

    public final void setBelowMaskLayer(boolean bl2) {
        if (this.options != null) {
            this.options.belowMaskLayer(bl2);
            this.a();
        }
    }

    public final float getAnchorU() {
        if (this.options != null) {
            return this.options.getAnchorU();
        }
        return 0.0f;
    }

    public final float getAnchorV() {
        if (this.options != null) {
            return this.options.getAnchorV();
        }
        return 0.0f;
    }

    private Object a(String string2, Object[] objectArray) {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                return iGlOverlayLayer.getNativeProperties(this.overlayName, string2, objectArray);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private void a() {
        try {
            if (this.isIconView()) {
                INativeOverlayLayer iNativeOverlayLayer = (INativeOverlayLayer)this.nativeOverlayLayerRef.get();
                if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iNativeOverlayLayer != null) {
                    iNativeOverlayLayer.updateOverlayOption(this.overlayName, this.options);
                }
                return;
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.updateOption(this.overlayName, this.options);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public final boolean isViewMode() {
        if (this.options != null) {
            return this.options.isViewMode();
        }
        return false;
    }

    public final boolean isIconView() {
        if (this.options != null) {
            return this.options.getIconView() != null;
        }
        return false;
    }

    private final class a
    implements Animation.AnimationListener {
        private final mb b;
        private final mb c;

        private a(final Animation.AnimationListener animationListener) {
            this.b = new mb(){

                @Override
                public final void runTask() {
                    try {
                        if (animationListener != null) {
                            animationListener.onAnimationStart();
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }
            };
            this.c = new mb(){

                @Override
                public final void runTask() {
                    try {
                        if (animationListener != null) {
                            animationListener.onAnimationEnd();
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }
            };
        }

        @Override
        public final void onAnimationStart() {
            dz.a().a(this.b);
        }

        @Override
        public final void onAnimationEnd() {
            dz.a().a(this.c);
        }

        /* synthetic */ a(Animation.AnimationListener animationListener, byte by2) {
            this(animationListener);
        }
    }
}

