/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseHoleOptions;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.PolygonOptions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public final class Polygon
extends BaseOverlay {
    private PolygonOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;

    public Polygon(IGlOverlayLayer iGlOverlayLayer, PolygonOptions polygonOptions, String string2) {
        super(string2);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = polygonOptions;
    }

    public final void remove() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final String getId() {
        try {
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setPoints(List<LatLng> list) {
        try {
            this.options.setPoints(list);
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final List<LatLng> getPoints() {
        try {
            if (this.options != null) {
                return this.options.getPoints();
            }
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setHoleOptions(List<BaseHoleOptions> list) {
        try {
            if (list == null) {
                list = new ArrayList<BaseHoleOptions>();
            }
            this.options.setHoleOptions(list);
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final List<BaseHoleOptions> getHoleOptions() {
        try {
            if (this.options != null) {
                return this.options.getHoleOptions();
            }
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setStrokeWidth(float f2) {
        try {
            this.options.strokeWidth(f2);
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final float getStrokeWidth() {
        try {
            if (this.options != null) {
                return this.options.getStrokeWidth();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public final void setStrokeColor(int n2) {
        try {
            if (this.options != null) {
                this.options.strokeColor(n2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final int getStrokeColor() {
        try {
            if (this.options != null) {
                return this.options.getStrokeColor();
            }
            return 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public final void setFillColor(int n2) {
        try {
            if (this.options != null) {
                this.options.fillColor(n2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final int getFillColor() {
        try {
            if (this.options != null) {
                return this.options.getFillColor();
            }
            return 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public final void setZIndex(float f2) {
        try {
            if (this.options != null) {
                this.options.zIndex(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final float getZIndex() {
        try {
            if (this.options != null) {
                return this.options.getZIndex();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public final void setVisible(boolean bl2) {
        try {
            if (this.options != null) {
                this.options.visible(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final boolean isVisible() {
        try {
            if (this.options != null) {
                return this.options.isVisible();
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public final boolean contains(LatLng latLng) {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                return iGlOverlayLayer.IsPolygonContainsPoint(this.options, latLng);
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Polygon)) {
            return false;
        }
        try {
            return super.equals(object) || ((Polygon)object).getId() == this.getId();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public final int hashCode() {
        try {
            return super.hashCode();
        }
        catch (Throwable throwable) {
            return super.hashCode();
        }
    }

    private void a() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.updateOption(this.overlayName, this.options);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }
}

