/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore.maploader;

import android.content.Context;
import android.text.TextUtils;
import com.amap.api.col.3sl.df;
import com.amap.api.col.3sl.eb;
import com.amap.api.col.3sl.ec;
import com.amap.api.col.3sl.ed;
import com.amap.api.col.3sl.ee;
import com.amap.api.col.3sl.il;
import com.amap.api.col.3sl.io;
import com.amap.api.col.3sl.ip;
import com.amap.api.col.3sl.iq;
import com.amap.api.col.3sl.it;
import com.amap.api.col.3sl.iu;
import com.amap.api.col.3sl.ix;
import com.amap.api.col.3sl.iy;
import com.amap.api.col.3sl.jv;
import com.amap.api.col.3sl.kv;
import com.amap.api.maps.MapsInitializer;
import com.autonavi.base.ae.gmap.NetworkProxyManager;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class AMapLoader
implements kv.a {
    private Context context;
    private ADataRequestParam mDataRequestParam;
    private static final int GET_METHOD = 0;
    private volatile boolean isCanceled = false;
    private kv downloadManager;
    private NetworkProxyManager networkProxyManager;
    private static final String NETWORK_RESPONSE_CODE_STRING = "\u7f51\u7edc\u5f02\u5e38\u72b6\u6001\u7801\uff1a";
    private long requestMapDataTimestamp = 0L;
    private long requestMapDataPackageSize = 0L;

    @Override
    public void onDownload(byte[] byArray, long l2) {
        if (byArray != null && this.mDataRequestParam != null) {
            this.networkProxyManager.receiveNetData(this.mDataRequestParam.handler, byArray, byArray.length);
        }
    }

    @Override
    public void onStop() {
        if (this.mDataRequestParam != null) {
            this.networkProxyManager.netStop(this.mDataRequestParam.handler, -1);
        }
        this.staticNetworkPerformance();
    }

    @Override
    public void onFinish() {
        if (this.mDataRequestParam != null) {
            this.networkProxyManager.finishDownLoad(this.mDataRequestParam.handler);
        }
        this.staticNetworkPerformance();
    }

    @Override
    public void onException(Throwable throwable) {
        int n2 = -1;
        try {
            int n3;
            String string2 = new String(throwable.getMessage().getBytes("UTF-8"), "UTF-8");
            if (!TextUtils.isEmpty((CharSequence)string2) && (n3 = string2.indexOf(NETWORK_RESPONSE_CODE_STRING)) != -1) {
                n2 = Integer.parseInt(string2.substring(n3 + 8));
            }
            if (this.mDataRequestParam != null) {
                this.networkProxyManager.netError(this.mDataRequestParam.handler, -1, n2);
            }
        }
        catch (Throwable throwable2) {
            if (this.mDataRequestParam != null) {
                this.networkProxyManager.netError(this.mDataRequestParam.handler, -1, -1);
            }
        }
        catch (Throwable throwable3) {
            if (this.mDataRequestParam != null) {
                this.networkProxyManager.netError(this.mDataRequestParam.handler, -1, -1);
            }
            throw throwable3;
        }
        jv.c(throwable, "AMapLoader", "download onException");
        ee.b(ed.e, "map loader exception " + throwable.getMessage());
    }

    public AMapLoader(Context context, ADataRequestParam aDataRequestParam, NetworkProxyManager networkProxyManager) {
        this.context = context.getApplicationContext();
        this.mDataRequestParam = aDataRequestParam;
        this.networkProxyManager = networkProxyManager;
        this.isCanceled = false;
    }

    public void doRequest() {
        if (iu.a((Context)this.context, (ix)eb.a()).a != iu.c.a) {
            if (this.mDataRequestParam != null) {
                this.networkProxyManager.netError(this.mDataRequestParam.handler, -1, -1);
            }
            return;
        }
        if (this.isCanceled) {
            if (this.mDataRequestParam != null) {
                this.networkProxyManager.netError(this.mDataRequestParam.handler, -1, -1);
            }
            return;
        }
        if (MapsInitializer.isLoadWorldVectorMap() && this.networkProxyManager.isLocationOversea() && !this.networkProxyManager.isOverseaAuthed()) {
            if (this.mDataRequestParam != null) {
                this.networkProxyManager.netError(this.mDataRequestParam.handler, -1, -1);
            }
            return;
        }
        String string2 = this.mDataRequestParam.requestBaseUrl;
        AMapDownloadRequest aMapDownloadRequest = null;
        if (string2.contains("http://mpsapi.amap.com/")) {
            aMapDownloadRequest = new AMapMpsDownloadRequest(this.context, this.networkProxyManager.getUserAgent(), this.mDataRequestParam);
        } else if (string2.contains("http://m5.amap.com")) {
            aMapDownloadRequest = new AMapM5DownloadRequest(this.context, this.networkProxyManager.getUserAgent(), this.mDataRequestParam);
        } else if (string2.contains("http://render.amap.com/")) {
            aMapDownloadRequest = new AMapRenderDownloadRequest(this.context, this.networkProxyManager.getUserAgent(), this.mDataRequestParam);
        } else if (string2.contains("http://restsdk.amap.com/")) {
            aMapDownloadRequest = new AMapRestRequest(this.context, this.networkProxyManager.getUserAgent(), this.mDataRequestParam);
        }
        if (aMapDownloadRequest == null) {
            if (this.mDataRequestParam != null) {
                this.networkProxyManager.netError(this.mDataRequestParam.handler, -1, -1);
            }
            return;
        }
        try {
            aMapDownloadRequest.setConnectionTimeout(30000);
            aMapDownloadRequest.setSoTimeout(30000);
            this.requestMapDataTimestamp = System.currentTimeMillis();
            this.requestMapDataPackageSize = aMapDownloadRequest.getEntityBytes() == null ? 0L : (long)aMapDownloadRequest.getEntityBytes().length;
            this.downloadManager = new kv(aMapDownloadRequest, 0L, -1L, MapsInitializer.getProtocol() == 2);
            this.downloadManager.a(this);
            return;
        }
        catch (Throwable throwable) {
            this.onException(throwable);
            return;
        }
        finally {
            this.doCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancel() {
        if (this.downloadManager != null && !this.isCanceled) {
            kv kv2 = this.downloadManager;
            synchronized (kv2) {
                try {
                    this.isCanceled = true;
                    this.downloadManager.a();
                }
                catch (Throwable throwable) {
                    jv.c(throwable, "AMapLoader", "doCancel");
                }
                return;
            }
        }
    }

    public void doCancelAndNotify() {
        this.onCancel();
        this.doCancel();
    }

    private void onCancel() {
        if (this.mDataRequestParam != null) {
            this.networkProxyManager.netCancel(this.mDataRequestParam.handler, -1);
        }
    }

    private static String getEncodeRequestParams(String string2) {
        String string3 = null;
        try {
            string3 = URLEncoder.encode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string3;
    }

    private static String generateAosSign(List<String> object, String object2) {
        String string2 = iy.c("QMTA3MWEyYTRlM2d0ZTJVYzMyY1kzYTk4VGYzM0gxYzRHYzIzZg==");
        ArrayList<String> arrayList = new ArrayList<String>();
        object2 = eb.a((String)object2, "=");
        object = object.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            if (!object2.containsKey(string3)) continue;
            arrayList.add((String)object2.get(string3));
        }
        return AMapLoader.generateAosSignInternal(arrayList, string2);
    }

    private static String generateAosSignInternal(List<String> object, String string2) {
        StringBuilder stringBuilder = new StringBuilder("");
        String string3 = "";
        try {
            object = object.iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                stringBuilder.append(string4);
            }
            stringBuilder.append("@");
            stringBuilder.append(string2);
            string3 = it.c(stringBuilder.toString());
        }
        catch (Throwable throwable) {
            jv.c(throwable, "AbstractProtocalHandler", "generateAosSignInternal");
        }
        return string3;
    }

    private static String generateQueryString(Context context, String charSequence) {
        charSequence = new StringBuffer((String)charSequence);
        String string2 = il.f(context);
        try {
            string2 = URLEncoder.encode(string2, "UTF-8");
        }
        catch (Throwable throwable) {}
        ((StringBuffer)charSequence).append("&key=").append(string2);
        ((StringBuffer)charSequence).append("&dip=16300");
        string2 = AMapLoader.sortReEncoderParams(((StringBuffer)charSequence).toString());
        String string3 = io.a();
        ((StringBuffer)charSequence).append("&ts=".concat(String.valueOf(string3)));
        ((StringBuffer)charSequence).append("&scode=" + io.a(context, string3, string2));
        return ((StringBuffer)charSequence).toString();
    }

    private static String sortReEncoderParams(String string2) {
        Object object = string2.split("&");
        Arrays.sort((Object[])object);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = ((Object[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = AMapLoader.strReEncoder((String)object[i2]);
            stringBuffer.append(string3);
            stringBuffer.append("&");
        }
        object = stringBuffer.toString();
        if (((String)object).length() > 1) {
            return (String)((String)object).subSequence(0, ((String)object).length() - 1);
        }
        return string2;
    }

    private static String strReEncoder(String string2) {
        if (string2 == null) {
            return string2;
        }
        try {
            return URLDecoder.decode(string2, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            jv.c(unsupportedEncodingException, "AbstractProtocalHandler", "strReEncoder");
        }
        catch (Exception exception) {
            jv.c(exception, "AbstractProtocalHandler", "strReEncoderException");
        }
        return "";
    }

    private String getNetworkFailedReason(String string2) {
        if (!this.networkProxyManager.isNetworkConnected()) {
            return "\u65e0\u7f51\u7edc";
        }
        return string2;
    }

    private void staticNetworkPerformance() {
    }

    private static abstract class AMapDownloadRequest
    extends df {
        protected final Context context;
        protected String url;
        protected String userAgent;
        protected ADataRequestParam dataRequestParam;
        protected byte[] postEntityBytes;

        public AMapDownloadRequest(Context context, String string2, ADataRequestParam aDataRequestParam) {
            this.context = context;
            this.userAgent = string2;
            this.dataRequestParam = aDataRequestParam;
            this.url = this.buildUrl();
            this.postEntityBytes = this.buildParams();
            this.isPostFlag = aDataRequestParam.nRequestType == RequestType.POST.ordinal();
        }

        public abstract byte[] buildParams();

        public abstract String buildUrl();

        @Override
        public Map<String, String> getRequestHead() {
            Object object = eb.a();
            String string2 = null;
            if (object != null) {
                string2 = ((ix)object).b();
            }
            object = il.f(this.context);
            try {
                object = URLEncoder.encode((String)object, "UTF-8");
            }
            catch (Throwable throwable) {}
            Hashtable<String, String> hashtable = new Hashtable<String, String>(16);
            hashtable.put("User-Agent", this.userAgent);
            hashtable.put("platinfo", String.format(Locale.US, "platform=Android&sdkversion=%s&product=%s", string2, "3dmap"));
            hashtable.put("x-INFO", io.a(this.context));
            hashtable.put("key", (String)object);
            hashtable.put("logversion", "2.1");
            hashtable.putAll(this.dataRequestParam.headers);
            return hashtable;
        }

        @Override
        public Map<String, String> getParams() {
            return null;
        }

        @Override
        public String getURL() {
            return this.url;
        }

        @Override
        public String getIPV6URL() {
            return eb.a(this.getURL());
        }

        @Override
        public boolean isSupportIPV6() {
            return true;
        }

        @Override
        public byte[] getEntityBytes() {
            return this.postEntityBytes;
        }
    }

    private static class AMapRenderDownloadRequest
    extends AMapDownloadRequest {
        public AMapRenderDownloadRequest(Context context, String string2, ADataRequestParam aDataRequestParam) {
            super(context, string2, aDataRequestParam);
        }

        @Override
        public byte[] buildParams() {
            if (this.dataRequestParam.bodyType == RequestBodyType.CUSTOM.ordinal()) {
                byte[] byArray = ec.a(new String(this.dataRequestParam.requestUrl).getBytes(), iy.c("KTFhsdldhb3NNY0pDSndWbg==").getBytes());
                if (byArray != null) {
                    return iq.b(byArray).getBytes(StandardCharsets.UTF_8);
                }
            } else {
                RequestBodyType.FORM.ordinal();
            }
            return new byte[0];
        }

        @Override
        public String buildUrl() {
            String string2 = this.dataRequestParam.requestBaseUrl;
            if (!string2.endsWith("?")) {
                string2 = string2 + "?";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.dataRequestParam.nRequestType == RequestType.POST.ordinal()) {
                stringBuilder.append("csid=").append(UUID.randomUUID().toString());
            }
            if (this.dataRequestParam.bodyType == RequestBodyType.CUSTOM.ordinal()) {
                CharSequence charSequence = new StringBuilder();
                charSequence.append("channel=amap7&div=GNaviMap");
                charSequence.append("&diu=").append(ip.a(this.context));
                String string3 = AMapLoader.generateAosSign(this.dataRequestParam.signs, charSequence.toString());
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    charSequence.append("&sign=").append(string3.toUpperCase());
                }
                charSequence = iq.b(ec.a(charSequence.toString().getBytes(), iy.c("KTFhsdldhb3NNY0pDSndWbg==").getBytes()));
                string3 = null;
                try {
                    string3 = URLEncoder.encode((String)charSequence, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                if (string3 != null) {
                    stringBuilder.append("&in=").append(string3);
                }
                stringBuilder.append("&ent=2");
                string2 = string2 + AMapLoader.generateQueryString(this.context, stringBuilder.toString());
            }
            return string2;
        }
    }

    private static class AMapM5DownloadRequest
    extends AMapDownloadRequest {
        public AMapM5DownloadRequest(Context context, String string2, ADataRequestParam aDataRequestParam) {
            super(context, string2, aDataRequestParam);
        }

        @Override
        public byte[] buildParams() {
            String string2 = new String(this.dataRequestParam.requestUrl).replaceAll(";", AMapLoader.getEncodeRequestParams(";"));
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.append("&channel=amap7&div=GNaviMap");
            stringBuilder.append("&diu=").append(ip.a(this.context));
            if (!string2.contains("&sign=") && !TextUtils.isEmpty((CharSequence)(string2 = AMapLoader.generateAosSign(this.dataRequestParam.signs, stringBuilder.toString())))) {
                stringBuilder.append("&sign=").append(string2.toUpperCase());
            }
            return stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public String buildUrl() {
            String string2 = this.dataRequestParam.requestBaseUrl;
            if (!string2.endsWith("?")) {
                string2 = string2 + "?";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.dataRequestParam.nRequestType == RequestType.POST.ordinal()) {
                stringBuilder.append("csid=").append(UUID.randomUUID().toString());
            }
            return string2 + AMapLoader.generateQueryString(this.context, stringBuilder.toString());
        }
    }

    private static class AMapMpsDownloadRequest
    extends AMapDownloadRequest {
        public AMapMpsDownloadRequest(Context context, String string2, ADataRequestParam aDataRequestParam) {
            super(context, string2, aDataRequestParam);
        }

        @Override
        public byte[] buildParams() {
            CharSequence charSequence = new String(this.dataRequestParam.requestUrl).replaceAll(";", AMapLoader.getEncodeRequestParams(";"));
            charSequence = new StringBuilder((String)charSequence);
            ((StringBuilder)charSequence).append("&div=GNaviMap");
            ((StringBuilder)charSequence).append("&channel=amapapi");
            ((StringBuilder)charSequence).append("&diu=").append(ip.a(this.context));
            String string2 = AMapLoader.generateAosSign(this.dataRequestParam.signs, ((StringBuilder)charSequence).toString());
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                ((StringBuilder)charSequence).append("&sign=").append(string2.toUpperCase());
            }
            return ((StringBuilder)charSequence).toString().getBytes();
        }

        @Override
        public String buildUrl() {
            String string2 = this.dataRequestParam.requestBaseUrl;
            if (!string2.endsWith("?")) {
                string2 = string2 + "?";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.dataRequestParam.nRequestType == RequestType.POST.ordinal()) {
                stringBuilder.append("csid=").append(UUID.randomUUID().toString());
            }
            return string2 + AMapLoader.generateQueryString(this.context, stringBuilder.toString());
        }
    }

    private static class AMapRestRequest
    extends AMapDownloadRequest {
        public AMapRestRequest(Context context, String string2, ADataRequestParam aDataRequestParam) {
            super(context, string2, aDataRequestParam);
        }

        @Override
        public Map<String, String> getRequestHead() {
            return super.getRequestHead();
        }

        @Override
        public byte[] buildParams() {
            return this.dataRequestParam.requestUrl;
        }

        @Override
        public String buildUrl() {
            String string2;
            String string3 = "";
            String[] stringArray = this.dataRequestParam.requestBaseUrl.split("\\?");
            if (stringArray.length > 1) {
                string2 = stringArray[0];
                string3 = stringArray[1];
            } else {
                string2 = stringArray[0];
            }
            string3 = string3 + "&adiu=" + ip.a(this.context);
            string3 = string3 + "&div=GNaviMap";
            string3 = AMapLoader.generateQueryString(this.context, string3);
            return string2 + "?" + string3;
        }
    }

    private static enum RequestBodyType {
        CUSTOM,
        FORM;

    }

    private static enum RequestType {
        GET,
        POST;

    }

    public static class ADataRequestParam {
        public String requestBaseUrl;
        public byte[] requestUrl;
        public Map<String, String> headers = new HashMap<String, String>();
        public Map<String, String> queries = new HashMap<String, String>();
        public List<String> signs = new ArrayList<String>();
        public long handler;
        public int nRequestType;
        public byte[] enCodeString;
        public int nCompress;
        public int bodyType;

        public String toString() {
            return "ADataRequestParam{requestBaseUrl='" + this.requestBaseUrl + '\'' + ", requestUrl='" + this.requestUrl + '\'' + ", headers=" + this.headers + ", queries=" + this.queries + ", signs=" + this.signs + ", handler=" + this.handler + ", nRequestType=" + this.nRequestType + ", enCodeString=" + Arrays.toString(this.enCodeString) + ", nCompress=" + this.nCompress + ", bodyType=" + this.bodyType + '}';
        }
    }
}

