/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore.tools;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import com.amap.api.col.3sl.eb;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class TextTextureGenerator {
    private int TEXT_FONTSIZE = -1;
    private int TEXT_FONTSIZE_TRUE = -1;
    static final int AN_LABEL_MAXCHARINLINE = 7;
    static final int AN_LABEL_MULITYLINE_SPAN = 2;
    private static final int ALIGNCENTER = 51;
    private static final int ALIGNLEFT = 49;
    private static final int ALIGNRIGHT = 50;
    private float base_line = 0.0f;
    private float start_x = 0.0f;
    private Paint text_paint = null;

    public static int GetNearstSize2N(int n2) {
        int n3 = 1;
        while (n2 > n3) {
            n3 *= 2;
        }
        return n3;
    }

    public TextTextureGenerator() {
        this.createTextParam();
    }

    private void createTextParam() {
        float f2;
        this.TEXT_FONTSIZE_TRUE = this.TEXT_FONTSIZE - 2;
        this.text_paint = TextTextureGenerator.newPaint(null, this.TEXT_FONTSIZE_TRUE, 49);
        this.start_x = f2 = (float)(this.TEXT_FONTSIZE - this.TEXT_FONTSIZE_TRUE) / 2.0f;
        float f3 = 7.3242188f;
        float f4 = -27.832031f;
        try {
            Paint.FontMetrics fontMetrics = this.text_paint.getFontMetrics();
            f3 = fontMetrics.descent;
            f4 = fontMetrics.ascent;
            float cfr_ignored_0 = fontMetrics.top;
            float cfr_ignored_1 = fontMetrics.bottom;
            float cfr_ignored_2 = fontMetrics.leading;
        }
        catch (Exception exception) {}
        this.base_line = ((float)this.TEXT_FONTSIZE_TRUE - (f3 + f4)) / 2.0f + f2 + 0.5f;
    }

    public byte[] getTextPixelBuffer(int n2, int n3) {
        if (this.TEXT_FONTSIZE != n3) {
            this.TEXT_FONTSIZE = n3;
            this.createTextParam();
        }
        try {
            char[] cArray = new char[1];
            char[] cArray2 = cArray;
            cArray[0] = (char)n2;
            float f2 = this.base_line;
            Bitmap bitmap = Bitmap.createBitmap((int)this.TEXT_FONTSIZE, (int)this.TEXT_FONTSIZE, (Bitmap.Config)Bitmap.Config.ALPHA_8);
            Canvas canvas = new Canvas(bitmap);
            byte[] byArray = new byte[this.TEXT_FONTSIZE * this.TEXT_FONTSIZE];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            float f3 = this.text_paint.measureText(String.valueOf((char)n2));
            if (cArray2[0] > '\u0000' && cArray2[0] < '\u0100') {
                f2 -= 1.5f;
            }
            Paint.Align align = this.text_paint.getTextAlign();
            float f4 = this.text_paint.getTextSize();
            f3 -= (float)this.TEXT_FONTSIZE_TRUE;
            if (align != Paint.Align.CENTER && f3 >= 4.0f) {
                this.text_paint.setTextAlign(Paint.Align.CENTER);
                this.text_paint.setTextSize((float)this.TEXT_FONTSIZE_TRUE - f3);
                canvas.drawText(cArray2, 0, 1, ((float)this.TEXT_FONTSIZE_TRUE - f3) / 2.0f, f2, this.text_paint);
                this.text_paint.setTextAlign(align);
                this.text_paint.setTextSize(f4);
            } else {
                canvas.drawText(cArray2, 0, 1, this.start_x, f2, this.text_paint);
            }
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            eb.a(bitmap);
            return byArray;
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {}
        return null;
    }

    public byte[] getCharsWidths(int[] nArray) {
        int n2 = nArray.length;
        byte[] byArray = new byte[n2];
        float[] fArray = new float[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[0] = this.text_paint.measureText("" + (char)nArray[i2]);
            byArray[i2] = (byte)(fArray[0] + (float)(this.TEXT_FONTSIZE - this.TEXT_FONTSIZE_TRUE));
        }
        return byArray;
    }

    private static Paint newPaint(String string2, int n2, int n3) {
        string2 = new TextPaint();
        string2.setColor(-1);
        string2.setTextSize((float)n2);
        string2.setAntiAlias(true);
        string2.setFilterBitmap(true);
        string2.setTypeface(Typeface.DEFAULT_BOLD);
        switch (n3) {
            case 51: {
                string2.setTextAlign(Paint.Align.CENTER);
                break;
            }
            case 49: {
                string2.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 50: {
                string2.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                string2.setTextAlign(Paint.Align.LEFT);
            }
        }
        return string2;
    }

    public static float getFontlength(Paint paint, String string2) {
        return paint.measureText(string2);
    }

    public static float getFontHeight(Paint paint) {
        paint = paint.getFontMetrics();
        return paint.descent - paint.ascent;
    }
}

