/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Protocol;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.handlers.CredentialsRequestHandler;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.ec2.model.CopySnapshotRequest;
import com.amazonaws.services.ec2.model.transform.CopySnapshotRequestMarshaller;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.HttpUtils;
import com.amazonaws.util.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;

public class GeneratePreSignUrlRequestHandler
extends CredentialsRequestHandler {
    public void beforeRequest(Request<?> request) {
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest instanceof CopySnapshotRequest) {
            CopySnapshotRequest originalCopySnapshotRequest = (CopySnapshotRequest)originalRequest;
            if (originalCopySnapshotRequest.getPresignedUrl() != null) {
                return;
            }
            String serviceName = "ec2";
            String sourceRegion = originalCopySnapshotRequest.getSourceRegion();
            String sourceSnapshotId = originalCopySnapshotRequest.getSourceSnapshotId();
            URI endPointDestination = request.getEndpoint();
            String destinationRegion = originalCopySnapshotRequest.getDestinationRegion() != null ? originalCopySnapshotRequest.getDestinationRegion() : AwsHostNameUtils.parseRegionName((String)endPointDestination.getHost(), null);
            URI endPointSource = this.createEndpoint(sourceRegion, serviceName);
            Request<CopySnapshotRequest> requestForPresigning = this.generateRequestForPresigning(sourceSnapshotId, sourceRegion, destinationRegion);
            requestForPresigning.setEndpoint(endPointSource);
            requestForPresigning.setHttpMethod(HttpMethodName.GET);
            AWS4Signer signer = new AWS4Signer();
            signer.setServiceName(serviceName);
            signer.presignRequest(requestForPresigning, this.awsCredentials, null);
            originalCopySnapshotRequest.setPresignedUrl(this.generateUrl(requestForPresigning));
            originalCopySnapshotRequest.setDestinationRegion(destinationRegion);
            request.addParameter("DestinationRegion", StringUtils.fromString((String)originalCopySnapshotRequest.getDestinationRegion()));
            request.addParameter("PresignedUrl", StringUtils.fromString((String)originalCopySnapshotRequest.getPresignedUrl()));
        }
    }

    private Request<CopySnapshotRequest> generateRequestForPresigning(String sourceSnapshotId, String sourceRegion, String destinationRegion) {
        CopySnapshotRequest copySnapshotRequest = new CopySnapshotRequest().withSourceSnapshotId(sourceSnapshotId).withSourceRegion(sourceRegion).withDestinationRegion(destinationRegion);
        return new CopySnapshotRequestMarshaller().marshall(copySnapshotRequest);
    }

    private String generateUrl(Request<?> request) {
        URI endpoint = request.getEndpoint();
        String uri = HttpUtils.appendUri((String)endpoint.toString(), (String)request.getResourcePath(), (boolean)true);
        String encodedParams = HttpUtils.encodeParameters(request);
        if (encodedParams != null) {
            uri = uri + "?" + encodedParams;
        }
        return uri;
    }

    private URI createEndpoint(String regionName, String serviceName) {
        Region region = RegionUtils.getRegion((String)regionName);
        if (region == null || !region.isServiceSupported(serviceName)) {
            throw new AmazonClientException("{" + serviceName + ", " + regionName + "} was not " + "found in region metadata. Update to latest version of SDK and try again.");
        }
        return this.toURI(region.getServiceEndpoint(serviceName));
    }

    private URI toURI(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            endpoint = Protocol.HTTPS + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void afterResponse(Request<?> request, Response<?> response) {
    }

    public void afterError(Request<?> request, Response<?> response, Exception e) {
    }
}

