/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.RegisterActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.transform.TaskListJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RegisterActivityTypeRequestMarshaller
implements Marshaller<Request<RegisterActivityTypeRequest>, RegisterActivityTypeRequest> {
    public Request<RegisterActivityTypeRequest> marshall(RegisterActivityTypeRequest registerActivityTypeRequest) {
        if (registerActivityTypeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerActivityTypeRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.RegisterActivityType");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.0");
            jsonGenerator.writeStartObject();
            if (registerActivityTypeRequest.getDomain() != null) {
                jsonGenerator.writeFieldName("domain").writeValue(registerActivityTypeRequest.getDomain());
            }
            if (registerActivityTypeRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(registerActivityTypeRequest.getName());
            }
            if (registerActivityTypeRequest.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(registerActivityTypeRequest.getVersion());
            }
            if (registerActivityTypeRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(registerActivityTypeRequest.getDescription());
            }
            if (registerActivityTypeRequest.getDefaultTaskStartToCloseTimeout() != null) {
                jsonGenerator.writeFieldName("defaultTaskStartToCloseTimeout").writeValue(registerActivityTypeRequest.getDefaultTaskStartToCloseTimeout());
            }
            if (registerActivityTypeRequest.getDefaultTaskHeartbeatTimeout() != null) {
                jsonGenerator.writeFieldName("defaultTaskHeartbeatTimeout").writeValue(registerActivityTypeRequest.getDefaultTaskHeartbeatTimeout());
            }
            if (registerActivityTypeRequest.getDefaultTaskList() != null) {
                jsonGenerator.writeFieldName("defaultTaskList");
                TaskListJsonMarshaller.getInstance().marshall(registerActivityTypeRequest.getDefaultTaskList(), jsonGenerator);
            }
            if (registerActivityTypeRequest.getDefaultTaskPriority() != null) {
                jsonGenerator.writeFieldName("defaultTaskPriority").writeValue(registerActivityTypeRequest.getDefaultTaskPriority());
            }
            if (registerActivityTypeRequest.getDefaultTaskScheduleToStartTimeout() != null) {
                jsonGenerator.writeFieldName("defaultTaskScheduleToStartTimeout").writeValue(registerActivityTypeRequest.getDefaultTaskScheduleToStartTimeout());
            }
            if (registerActivityTypeRequest.getDefaultTaskScheduleToCloseTimeout() != null) {
                jsonGenerator.writeFieldName("defaultTaskScheduleToCloseTimeout").writeValue(registerActivityTypeRequest.getDefaultTaskScheduleToCloseTimeout());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

