/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.BindingBuildInfo;
import android.databinding.annotationprocessor.ProcessDataBinding;
import android.databinding.repacked.apache.commons.io.FileUtils;
import android.databinding.repacked.apache.commons.io.IOUtils;
import android.databinding.repacked.google.common.base.Joiner;
import android.databinding.tool.CompilerChef;
import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.reflection.SdkUtil;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.GenerationalClassUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.StringUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class ProcessExpressions
extends ProcessDataBinding.ProcessingStep {
    @Override
    public boolean onHandleStep(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) throws JAXBException {
        SdkUtil.initialize(buildInfo.minSdk(), new File(buildInfo.sdkRoot()));
        ResourceBundle resourceBundle = new ResourceBundle(buildInfo.modulePackage());
        List<IntermediateV2> intermediateList = this.loadDependencyIntermediates();
        for (Intermediate intermediate : intermediateList) {
            try {
                intermediate.appendTo(resourceBundle);
            }
            catch (Throwable throwable) {
                L.e(throwable, "unable to prepare resource bundle", new Object[0]);
            }
        }
        IntermediateV2 mine = this.createIntermediateFromLayouts(buildInfo.layoutInfoDir(), intermediateList);
        if (mine != null) {
            mine.updateOverridden(resourceBundle);
            intermediateList.add(mine);
            this.saveIntermediate(processingEnvironment, buildInfo, mine);
            mine.appendTo(resourceBundle);
        }
        try {
            this.writeResourceBundle(resourceBundle, buildInfo.isLibrary(), buildInfo.minSdk(), buildInfo.exportClassListTo());
        }
        catch (Throwable throwable) {
            L.e(throwable, "cannot generate view binders", new Object[0]);
        }
        return true;
    }

    private List<IntermediateV2> loadDependencyIntermediates() {
        List<Intermediate> original = GenerationalClassUtil.loadObjects(GenerationalClassUtil.ExtensionFilter.LAYOUT);
        ArrayList<IntermediateV2> upgraded = new ArrayList<IntermediateV2>(original.size());
        for (Intermediate intermediate : original) {
            Intermediate updatedIntermediate = intermediate.upgrade();
            Preconditions.check(updatedIntermediate instanceof IntermediateV2, "Incompatible data binding dependency. Please update your dependencies or recompile them with application module's data binding version.", new Object[0]);
            upgraded.add((IntermediateV2)updatedIntermediate);
        }
        return upgraded;
    }

    private void saveIntermediate(ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo, IntermediateV2 intermediate) {
        GenerationalClassUtil.writeIntermediateFile(processingEnvironment, buildInfo.modulePackage(), buildInfo.modulePackage() + GenerationalClassUtil.ExtensionFilter.LAYOUT.getExtension(), intermediate);
    }

    @Override
    public void onProcessingOver(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) {
    }

    private IntermediateV2 createIntermediateFromLayouts(String layoutInfoFolderPath, List<IntermediateV2> intermediateList) {
        final HashSet excludeList = new HashSet();
        for (IntermediateV2 lib : intermediateList) {
            excludeList.addAll(lib.mLayoutInfoMap.keySet());
        }
        File layoutInfoFolder = new File(layoutInfoFolderPath);
        if (!layoutInfoFolder.isDirectory()) {
            L.d("layout info folder does not exist, skipping for %s", layoutInfoFolderPath);
            return null;
        }
        IntermediateV2 result = new IntermediateV2();
        for (File layoutFile : layoutInfoFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml") && !excludeList.contains(name);
            }
        })) {
            try {
                result.addEntry(layoutFile.getName(), FileUtils.readFileToString(layoutFile));
            }
            catch (IOException e) {
                L.e(e, "cannot load layout file information. Try a clean build", new Object[0]);
            }
        }
        return result;
    }

    private void writeResourceBundle(ResourceBundle resourceBundle, boolean forLibraryModule, int minSdk, String exportClassNamesTo) throws JAXBException {
        CompilerChef compilerChef = CompilerChef.createChef(resourceBundle, this.getWriter());
        compilerChef.sealModels();
        compilerChef.writeComponent();
        if (compilerChef.hasAnythingToGenerate()) {
            compilerChef.writeViewBinderInterfaces(forLibraryModule);
            if (!forLibraryModule) {
                compilerChef.writeViewBinders(minSdk);
            }
        }
        if (forLibraryModule && exportClassNamesTo == null) {
            L.e("When compiling a library module, build info must include exportClassListTo path", new Object[0]);
        }
        if (forLibraryModule) {
            Set<String> classNames = compilerChef.getWrittenClassNames();
            String out = Joiner.on(StringUtils.LINE_SEPARATOR).join(classNames);
            L.d("Writing list of classes to %s . \nList:%s", exportClassNamesTo, out);
            try {
                FileUtils.write(new File(exportClassNamesTo), out);
            }
            catch (IOException e) {
                L.e(e, "Cannot create list of written classes", new Object[0]);
            }
        }
        this.mCallback.onChefReady(compilerChef, forLibraryModule, minSdk);
    }

    public static class IntermediateV2
    extends IntermediateV1 {
        private static final long serialVersionUID = 2L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendTo(ResourceBundle resourceBundle) throws JAXBException {
            for (Map.Entry entry : this.mLayoutInfoMap.entrySet()) {
                InputStream is = IOUtils.toInputStream((String)entry.getValue());
                try {
                    ResourceBundle.LayoutFileBundle bundle = ResourceBundle.LayoutFileBundle.fromXML(is);
                    resourceBundle.addLayoutBundle(bundle);
                    L.d("loaded layout info file %s", bundle);
                }
                finally {
                    IOUtils.closeQuietly(is);
                }
            }
        }

        public void updateOverridden(ResourceBundle bundle) throws JAXBException {
            HashMap<String, List<ResourceBundle.LayoutFileBundle>> bundles = bundle.getLayoutBundles();
            for (Map.Entry info : this.mLayoutInfoMap.entrySet()) {
                String key = LayoutXmlProcessor.exportLayoutNameFromInfoFileName((String)info.getKey());
                List<ResourceBundle.LayoutFileBundle> existingList = bundles.get(key);
                if (existingList == null || existingList.isEmpty()) continue;
                ResourceBundle.LayoutFileBundle myBundle = ResourceBundle.LayoutFileBundle.fromXML(IOUtils.toInputStream((String)info.getValue()));
                ResourceBundle.LayoutFileBundle inheritFrom = existingList.get(0);
                myBundle.inheritConfigurationFrom(inheritFrom);
                L.d("inheriting data for %s (%s) from %s", info.getKey(), key, inheritFrom);
                this.mLayoutInfoMap.put(info.getKey(), myBundle.toXML());
            }
        }
    }

    public static class IntermediateV1
    implements Intermediate {
        transient Unmarshaller mUnmarshaller;
        Map<String, String> mLayoutInfoMap = new HashMap<String, String>();

        @Override
        public Intermediate upgrade() {
            IntermediateV2 updated = new IntermediateV2();
            updated.mLayoutInfoMap = this.mLayoutInfoMap;
            updated.mUnmarshaller = this.mUnmarshaller;
            return updated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendTo(ResourceBundle resourceBundle) throws JAXBException {
            if (this.mUnmarshaller == null) {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ResourceBundle.LayoutFileBundle.class});
                this.mUnmarshaller = context.createUnmarshaller();
            }
            for (String content : this.mLayoutInfoMap.values()) {
                InputStream is = IOUtils.toInputStream(content);
                try {
                    ResourceBundle.LayoutFileBundle bundle = (ResourceBundle.LayoutFileBundle)this.mUnmarshaller.unmarshal(is);
                    resourceBundle.addLayoutBundle(bundle);
                    L.d("loaded layout info file %s", bundle);
                }
                finally {
                    IOUtils.closeQuietly(is);
                }
            }
        }

        public void addEntry(String name, String contents) {
            this.mLayoutInfoMap.put(name, contents);
        }

        public void removeOverridden(List<Intermediate> existing) {
        }
    }

    public static interface Intermediate
    extends Serializable {
        public Intermediate upgrade();

        public void appendTo(ResourceBundle var1) throws Throwable;
    }
}

