/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.repacked.kotlin.collections;

import android.databinding.repacked.kotlin.Metadata;
import android.databinding.repacked.kotlin.collections.ArrayAsCollection;
import android.databinding.repacked.kotlin.collections.ArraysKt;
import android.databinding.repacked.kotlin.collections.CollectionsKt;
import android.databinding.repacked.kotlin.collections.EmptyList;
import android.databinding.repacked.kotlin.comparisons.ComparisonsKt;
import android.databinding.repacked.kotlin.internal.InlineOnly;
import android.databinding.repacked.kotlin.jvm.functions.Function1;
import android.databinding.repacked.kotlin.jvm.internal.Intrinsics;
import android.databinding.repacked.kotlin.ranges.IntRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=5, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a+\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\f\"\u0004\b\u0000\u0010\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000e\"\u0002H\u0007\u00a2\u0006\u0002\u0010\u000f\u001a\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007\u001a\u0015\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007H\u0087\b\u001a!\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u00072\u0006\u0010\u0012\u001a\u0002H\u0007H\u0007\u00a2\u0006\u0002\u0010\u0013\u001a+\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000e\"\u0002H\u0007\u00a2\u0006\u0002\u0010\u0014\u001a%\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\b\b\u0000\u0010\u0007*\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\u0013\u001a3\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\b\b\u0000\u0010\u0007*\u00020\u00162\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00070\u000e\"\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\u0014\u001a+\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0018\"\u0004\b\u0000\u0010\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000e\"\u0002H\u0007\u00a2\u0006\u0002\u0010\u0014\u001a \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002\u001a%\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0002\"\u0004\b\u0000\u0010\u0007*\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000eH\u0000\u00a2\u0006\u0002\u0010\u001f\u001aG\u0010 \u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0012\u001a\u0002H\u00072\u000e\u0010!\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00070\"2\b\b\u0002\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\u001d\u001a\u00020\u0006\u00a2\u0006\u0002\u0010#\u001a>\u0010 \u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\b\b\u0002\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\u001d\u001a\u00020\u00062\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060%\u001aE\u0010 \u001a\u00020\u0006\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070&*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00070\b2\b\u0010\u0012\u001a\u0004\u0018\u0001H\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\u001d\u001a\u00020\u0006\u00a2\u0006\u0002\u0010'\u001ad\u0010(\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007\"\u000e\b\u0001\u0010)*\b\u0012\u0004\u0012\u0002H)0&*\b\u0012\u0004\u0012\u0002H\u00070\b2\b\u0010*\u001a\u0004\u0018\u0001H)2\b\b\u0002\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\u001d\u001a\u00020\u00062\u0016\b\u0004\u0010+\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\u0012\u0004\u0018\u0001H)0%H\u0086\b\u00a2\u0006\u0002\u0010,\u001a,\u0010-\u001a\u00020.\"\t\b\u0000\u0010\u0007\u00a2\u0006\u0002\b/*\b\u0012\u0004\u0012\u0002H\u00070\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0002H\u0087\b\u001a\u0019\u00100\u001a\u00020.\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u0002H\u0087\b\u001a!\u00101\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0002\"\u0004\b\u0000\u0010\u0007*\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u0002H\u0087\b\u001a!\u00101\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007*\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\bH\u0087\b\u001a\u001f\u00102\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u000703H\u0087\b\u001a'\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u000e\"\u0004\b\u0000\u0010\u0007*\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000eH\u0003\u00a2\u0006\u0002\u00105\"\u0019\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"!\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u00066"}, d2={"indices", "Lkotlin/ranges/IntRange;", "", "getIndices", "(Ljava/util/Collection;)Lkotlin/ranges/IntRange;", "lastIndex", "", "T", "", "getLastIndex", "(Ljava/util/List;)I", "arrayListOf", "Ljava/util/ArrayList;", "elements", "", "([Ljava/lang/Object;)Ljava/util/ArrayList;", "emptyList", "listOf", "element", "(Ljava/lang/Object;)Ljava/util/List;", "([Ljava/lang/Object;)Ljava/util/List;", "listOfNotNull", "", "mutableListOf", "", "rangeCheck", "", "size", "fromIndex", "toIndex", "asCollection", "([Ljava/lang/Object;)Ljava/util/Collection;", "binarySearch", "comparator", "Ljava/util/Comparator;", "(Ljava/util/List;Ljava/lang/Object;Ljava/util/Comparator;II)I", "comparison", "Lkotlin/Function1;", "", "(Ljava/util/List;Ljava/lang/Comparable;II)I", "binarySearchBy", "K", "key", "selector", "(Ljava/util/List;Ljava/lang/Comparable;IILkotlin/jvm/functions/Function1;)I", "containsAll", "", "Lkotlin/internal/OnlyInputTypes;", "isNotEmpty", "orEmpty", "toList", "Ljava/util/Enumeration;", "varargToArrayOfAny", "([Ljava/lang/Object;)[Ljava/lang/Object;", "kotlin-stdlib"}, xs="android/databinding/repacked/kotlin/collections/CollectionsKt")
final class CollectionsKt__CollectionsKt {
    @NotNull
    public static final <T> Collection<T> asCollection(T[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new ArrayAsCollection<T>($receiver);
    }

    @NotNull
    public static final <T> List<T> emptyList() {
        return EmptyList.INSTANCE;
    }

    @NotNull
    public static final <T> List<T> listOf(T ... elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return elements.length > 0 ? ArraysKt.asList(elements) : CollectionsKt.emptyList();
    }

    @InlineOnly
    private static final <T> List<T> listOf() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final <T> List<T> listOf(T element) {
        List<T> list = Collections.singletonList(element);
        Intrinsics.checkExpressionValueIsNotNull(list, "Collections.singletonList(element)");
        return list;
    }

    @NotNull
    public static final <T> List<T> mutableListOf(T ... elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return elements.length == 0 ? (List)new ArrayList() : (List)new ArrayList((Collection)new ArrayAsCollection<T>(elements));
    }

    @NotNull
    public static final <T> ArrayList<T> arrayListOf(T ... elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return elements.length == 0 ? new ArrayList() : new ArrayList((Collection)new ArrayAsCollection<T>(elements));
    }

    @NotNull
    public static final <T> List<T> listOfNotNull(@Nullable T element) {
        return element != null ? CollectionsKt.listOf(element) : CollectionsKt.emptyList();
    }

    @NotNull
    public static final <T> List<T> listOfNotNull(T ... elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return ArraysKt.filterNotNull(elements);
    }

    @NotNull
    public static final IntRange getIndices(Collection<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new IntRange(0, $receiver.size() - 1);
    }

    public static final <T> int getLastIndex(List<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.size() - 1;
    }

    @InlineOnly
    private static final <T> boolean isNotEmpty(Collection<? extends T> $receiver) {
        return !$receiver.isEmpty();
    }

    @InlineOnly
    private static final <T> Collection<T> orEmpty(Collection<? extends T> $receiver) {
        Collection collection = $receiver;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @InlineOnly
    private static final <T> List<T> orEmpty(List<? extends T> $receiver) {
        List<Object> list = $receiver;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @InlineOnly
    private static final <T> List<T> toList(Enumeration<T> $receiver) {
        List list = Collections.list($receiver);
        Intrinsics.checkExpressionValueIsNotNull(list, "Collections.list(this)");
        return list;
    }

    @InlineOnly
    private static final <T> boolean containsAll(Collection<? extends T> $receiver, Collection<? extends T> elements) {
        return $receiver.containsAll(elements);
    }

    private static final <T> Object[] varargToArrayOfAny(T[] $receiver) {
        Object[] objectArray = Arrays.copyOf($receiver, $receiver.length, Object[].class);
        Intrinsics.checkExpressionValueIsNotNull(objectArray, "Arrays.copyOf(this, this\u2026 Array<Any?>::class.java)");
        return objectArray;
    }

    public static final <T extends Comparable<? super T>> int binarySearch(List<? extends T> $receiver, @Nullable T element, int fromIndex, int toIndex) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        CollectionsKt__CollectionsKt.rangeCheck($receiver.size(), fromIndex, toIndex);
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Comparable midVal = (Comparable)$receiver.get(mid);
            int cmp = ComparisonsKt.compareValues(midVal, element);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static /* bridge */ /* synthetic */ int binarySearch$default(List list, Comparable comparable, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: binarySearch");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = list.size();
        }
        return CollectionsKt.binarySearch(list, comparable, n, n2);
    }

    public static final <T> int binarySearch(List<? extends T> $receiver, T element, @NotNull Comparator<? super T> comparator, int fromIndex, int toIndex) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(comparator, "comparator");
        CollectionsKt__CollectionsKt.rangeCheck($receiver.size(), fromIndex, toIndex);
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = $receiver.get(mid);
            int cmp = comparator.compare(midVal, element);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static /* bridge */ /* synthetic */ int binarySearch$default(List list, Object object, Comparator comparator, int n, int n2, int n3, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: binarySearch");
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = list.size();
        }
        return CollectionsKt.binarySearch(list, object, comparator, n, n2);
    }

    public static final <T, K extends Comparable<? super K>> int binarySearchBy(List<? extends T> $receiver, @Nullable K key, int fromIndex, int toIndex, @NotNull Function1<? super T, ? extends K> selector) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(selector, "selector");
        return CollectionsKt.binarySearch($receiver, fromIndex, toIndex, new Function1<T, Integer>(selector, key){
            final /* synthetic */ Function1 $selector;
            final /* synthetic */ Comparable $key;

            public final int invoke(T it) {
                return ComparisonsKt.compareValues((Comparable)this.$selector.invoke(it), this.$key);
            }
            {
                this.$selector = function1;
                this.$key = comparable;
                super(1);
            }
        });
    }

    public static /* bridge */ /* synthetic */ int binarySearchBy$default(List list, Comparable comparable, int n, int n2, Function1 function1, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: binarySearchBy");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = list.size();
        }
        return CollectionsKt.binarySearch(list, n, n2, new /* invalid duplicate definition of identical inner class */);
    }

    public static final <T> int binarySearch(List<? extends T> $receiver, int fromIndex, int toIndex, @NotNull Function1<? super T, Integer> comparison) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(comparison, "comparison");
        CollectionsKt__CollectionsKt.rangeCheck($receiver.size(), fromIndex, toIndex);
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = $receiver.get(mid);
            int cmp = ((Number)comparison.invoke(midVal)).intValue();
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static /* bridge */ /* synthetic */ int binarySearch$default(List list, int n, int n2, Function1 function1, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: binarySearch");
        }
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = list.size();
        }
        return CollectionsKt.binarySearch(list, n, n2, function1);
    }

    private static final void rangeCheck(int size, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw (Throwable)new IllegalArgumentException("fromIndex (" + fromIndex + ") is greater than toIndex (" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw (Throwable)new IndexOutOfBoundsException("fromIndex (" + fromIndex + ") is less than zero.");
        }
        if (toIndex > size) {
            throw (Throwable)new IndexOutOfBoundsException("toIndex (" + toIndex + ") is greater than size (" + size + ").");
        }
    }

    @NotNull
    public static final /* synthetic */ Object[] access$varargToArrayOfAny(Object[] $receiver) {
        return CollectionsKt__CollectionsKt.varargToArrayOfAny($receiver);
    }
}

