/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.repacked.org.antlr.v4.codegen;

import android.databinding.repacked.org.antlr.v4.Tool;
import android.databinding.repacked.org.antlr.v4.codegen.model.ModelElement;
import android.databinding.repacked.org.antlr.v4.codegen.model.OutputModelObject;
import android.databinding.repacked.org.antlr.v4.tool.ErrorType;
import android.databinding.repacked.stringtemplate.v4.ST;
import android.databinding.repacked.stringtemplate.v4.STGroup;
import android.databinding.repacked.stringtemplate.v4.compiler.FormalArgument;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OutputModelWalker {
    Tool tool;
    STGroup templates;

    public OutputModelWalker(Tool tool, STGroup templates) {
        this.tool = tool;
        this.templates = templates;
    }

    public ST walk(OutputModelObject omo) {
        Field[] fields;
        Class<?> cl = omo.getClass();
        String templateName = cl.getSimpleName();
        if (templateName == null) {
            this.tool.errMgr.toolError(ErrorType.NO_MODEL_TO_TEMPLATE_MAPPING, cl.getSimpleName());
            return new ST("[" + templateName + " invalid]");
        }
        ST st = this.templates.getInstanceOf(templateName);
        if (st == null) {
            this.tool.errMgr.toolError(ErrorType.CODE_GEN_TEMPLATES_INCOMPLETE, templateName);
            return new ST("[" + templateName + " invalid]");
        }
        if (st.impl.formalArguments == null) {
            this.tool.errMgr.toolError(ErrorType.CODE_TEMPLATE_ARG_ISSUE, templateName, "<none>");
            return st;
        }
        Map<String, FormalArgument> formalArgs = st.impl.formalArguments;
        Set<String> argNames = formalArgs.keySet();
        Iterator<String> arg_it = argNames.iterator();
        String modelArgName = arg_it.next();
        st.add(modelArgName, omo);
        HashSet<String> usedFieldNames = new HashSet<String>();
        for (Field fi : fields = cl.getFields()) {
            ModelElement annotation = fi.getAnnotation(ModelElement.class);
            if (annotation == null) continue;
            String fieldName2 = fi.getName();
            if (!usedFieldNames.add(fieldName2)) {
                this.tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, "Model object " + omo.getClass().getSimpleName() + " has multiple fields named '" + fieldName2 + "'");
                continue;
            }
            if (formalArgs.get(fieldName2) == null) continue;
            try {
                List<OutputModelObject> o = fi.get(omo);
                if (o instanceof OutputModelObject) {
                    OutputModelObject nestedOmo = (OutputModelObject)((Object)o);
                    ST nestedST = this.walk(nestedOmo);
                    st.add(fieldName2, nestedST);
                    continue;
                }
                if (o instanceof Collection || o instanceof OutputModelObject[]) {
                    if (o instanceof OutputModelObject[]) {
                        o = Arrays.asList((OutputModelObject[])o);
                    }
                    Collection nestedOmos = o;
                    for (Object nestedOmo : nestedOmos) {
                        if (nestedOmo == null) continue;
                        ST nestedST = this.walk((OutputModelObject)nestedOmo);
                        st.add(fieldName2, nestedST);
                    }
                    continue;
                }
                if (o instanceof Map) {
                    Map nestedOmoMap = (Map)((Object)o);
                    LinkedHashMap m = new LinkedHashMap();
                    for (Map.Entry entry : nestedOmoMap.entrySet()) {
                        ST nestedST = this.walk((OutputModelObject)entry.getValue());
                        m.put(entry.getKey(), nestedST);
                    }
                    st.add(fieldName2, m);
                    continue;
                }
                if (o == null) continue;
                this.tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, "not recognized nested model element: " + fieldName2);
            }
            catch (IllegalAccessException iae) {
                this.tool.errMgr.toolError(ErrorType.CODE_TEMPLATE_ARG_ISSUE, templateName, fieldName2);
            }
        }
        return st;
    }
}

