/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.repacked.org.antlr.v4.semantics;

import android.databinding.repacked.org.antlr.v4.automata.LexerATNFactory;
import android.databinding.repacked.org.antlr.v4.semantics.SymbolCollector;
import android.databinding.repacked.org.antlr.v4.tool.Alternative;
import android.databinding.repacked.org.antlr.v4.tool.Attribute;
import android.databinding.repacked.org.antlr.v4.tool.AttributeDict;
import android.databinding.repacked.org.antlr.v4.tool.ErrorManager;
import android.databinding.repacked.org.antlr.v4.tool.ErrorType;
import android.databinding.repacked.org.antlr.v4.tool.Grammar;
import android.databinding.repacked.org.antlr.v4.tool.LabelElementPair;
import android.databinding.repacked.org.antlr.v4.tool.LexerGrammar;
import android.databinding.repacked.org.antlr.v4.tool.Rule;
import android.databinding.repacked.org.antlr.v4.tool.ast.GrammarAST;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SymbolChecks {
    Grammar g;
    SymbolCollector collector;
    Map<String, Rule> nameToRuleMap = new HashMap<String, Rule>();
    Set<String> tokenIDs = new HashSet<String>();
    Map<String, Set<String>> actionScopeToActionNames = new HashMap<String, Set<String>>();
    public ErrorManager errMgr;
    protected final Set<String> reservedNames = new HashSet<String>();

    public SymbolChecks(Grammar g, SymbolCollector collector) {
        this.reservedNames.addAll(LexerATNFactory.getCommonConstants());
        this.g = g;
        this.collector = collector;
        this.errMgr = g.tool.errMgr;
        for (GrammarAST tokenId : collector.tokenIDRefs) {
            this.tokenIDs.add(tokenId.getText());
        }
    }

    public void process() {
        if (this.g.rules != null) {
            for (Rule r : this.g.rules.values()) {
                this.nameToRuleMap.put(r.name, r);
            }
        }
        this.checkReservedNames(this.g.rules.values());
        this.checkActionRedefinitions(this.collector.namedActions);
        this.checkForTokenConflicts(this.collector.tokenIDRefs);
        this.checkForLabelConflicts(this.g.rules.values());
    }

    public void checkActionRedefinitions(List<GrammarAST> actions) {
        if (actions == null) {
            return;
        }
        String scope = this.g.getDefaultActionScope();
        for (GrammarAST ampersandAST : actions) {
            String name;
            GrammarAST nameNode = (GrammarAST)ampersandAST.getChild(0);
            if (ampersandAST.getChildCount() == 2) {
                name = nameNode.getText();
            } else {
                scope = nameNode.getText();
                name = ampersandAST.getChild(1).getText();
            }
            Set<String> scopeActions = this.actionScopeToActionNames.get(scope);
            if (scopeActions == null) {
                scopeActions = new HashSet<String>();
                this.actionScopeToActionNames.put(scope, scopeActions);
            }
            if (!scopeActions.contains(name)) {
                scopeActions.add(name);
                continue;
            }
            this.errMgr.grammarError(ErrorType.ACTION_REDEFINITION, this.g.fileName, nameNode.token, name);
        }
    }

    public void checkForTokenConflicts(List<GrammarAST> tokenIDRefs) {
    }

    public void checkForLabelConflicts(Collection<Rule> rules) {
        for (Rule r : rules) {
            this.checkForAttributeConflicts(r);
            HashMap<String, LabelElementPair> labelNameSpace = new HashMap<String, LabelElementPair>();
            for (int i = 1; i <= r.numberOfAlts; ++i) {
                if (r.hasAltSpecificContexts()) {
                    labelNameSpace.clear();
                }
                Alternative a = r.alt[i];
                for (List pairs : a.labelDefs.values()) {
                    for (LabelElementPair p : pairs) {
                        this.checkForLabelConflict(r, p.label);
                        String name = p.label.getText();
                        LabelElementPair prev = (LabelElementPair)labelNameSpace.get(name);
                        if (prev == null) {
                            labelNameSpace.put(name, p);
                            continue;
                        }
                        this.checkForTypeMismatch(prev, p);
                    }
                }
            }
        }
    }

    void checkForTypeMismatch(LabelElementPair prevLabelPair, LabelElementPair labelPair) {
        if (prevLabelPair.type != labelPair.type) {
            String typeMismatchExpr = (Object)((Object)labelPair.type) + "!=" + (Object)((Object)prevLabelPair.type);
            this.errMgr.grammarError(ErrorType.LABEL_TYPE_CONFLICT, this.g.fileName, labelPair.label.token, labelPair.label.getText(), typeMismatchExpr);
        }
    }

    public void checkForLabelConflict(Rule r, GrammarAST labelID) {
        ErrorType etype;
        String name = labelID.getText();
        if (this.nameToRuleMap.containsKey(name)) {
            etype = ErrorType.LABEL_CONFLICTS_WITH_RULE;
            this.errMgr.grammarError(etype, this.g.fileName, labelID.token, name, r.name);
        }
        if (this.tokenIDs.contains(name)) {
            etype = ErrorType.LABEL_CONFLICTS_WITH_TOKEN;
            this.errMgr.grammarError(etype, this.g.fileName, labelID.token, name, r.name);
        }
        if (r.args != null && r.args.get(name) != null) {
            etype = ErrorType.LABEL_CONFLICTS_WITH_ARG;
            this.errMgr.grammarError(etype, this.g.fileName, labelID.token, name, r.name);
        }
        if (r.retvals != null && r.retvals.get(name) != null) {
            etype = ErrorType.LABEL_CONFLICTS_WITH_RETVAL;
            this.errMgr.grammarError(etype, this.g.fileName, labelID.token, name, r.name);
        }
        if (r.locals != null && r.locals.get(name) != null) {
            etype = ErrorType.LABEL_CONFLICTS_WITH_LOCAL;
            this.errMgr.grammarError(etype, this.g.fileName, labelID.token, name, r.name);
        }
    }

    public void checkForAttributeConflicts(Rule r) {
        this.checkDeclarationRuleConflicts(r, r.args, this.nameToRuleMap.keySet(), ErrorType.ARG_CONFLICTS_WITH_RULE);
        this.checkDeclarationRuleConflicts(r, r.args, this.tokenIDs, ErrorType.ARG_CONFLICTS_WITH_TOKEN);
        this.checkDeclarationRuleConflicts(r, r.retvals, this.nameToRuleMap.keySet(), ErrorType.RETVAL_CONFLICTS_WITH_RULE);
        this.checkDeclarationRuleConflicts(r, r.retvals, this.tokenIDs, ErrorType.RETVAL_CONFLICTS_WITH_TOKEN);
        this.checkDeclarationRuleConflicts(r, r.locals, this.nameToRuleMap.keySet(), ErrorType.LOCAL_CONFLICTS_WITH_RULE);
        this.checkDeclarationRuleConflicts(r, r.locals, this.tokenIDs, ErrorType.LOCAL_CONFLICTS_WITH_TOKEN);
        this.checkLocalConflictingDeclarations(r, r.retvals, r.args, ErrorType.RETVAL_CONFLICTS_WITH_ARG);
        this.checkLocalConflictingDeclarations(r, r.locals, r.args, ErrorType.LOCAL_CONFLICTS_WITH_ARG);
        this.checkLocalConflictingDeclarations(r, r.locals, r.retvals, ErrorType.LOCAL_CONFLICTS_WITH_RETVAL);
    }

    protected void checkDeclarationRuleConflicts(Rule r, AttributeDict attributes, Set<String> ruleNames, ErrorType errorType) {
        if (attributes == null) {
            return;
        }
        for (Attribute attribute : attributes.attributes.values()) {
            if (!ruleNames.contains(attribute.name)) continue;
            this.errMgr.grammarError(errorType, this.g.fileName, attribute.token != null ? attribute.token : ((GrammarAST)r.ast.getChild((int)0)).token, attribute.name, r.name);
        }
    }

    protected void checkLocalConflictingDeclarations(Rule r, AttributeDict attributes, AttributeDict referenceAttributes, ErrorType errorType) {
        if (attributes == null || referenceAttributes == null) {
            return;
        }
        Set<String> conflictingKeys = attributes.intersection(referenceAttributes);
        for (String key : conflictingKeys) {
            this.errMgr.grammarError(errorType, this.g.fileName, attributes.get((String)key).token != null ? attributes.get((String)key).token : ((GrammarAST)r.ast.getChild((int)0)).token, key, r.name);
        }
    }

    protected void checkReservedNames(Collection<Rule> rules) {
        for (Rule rule : rules) {
            if (!this.reservedNames.contains(rule.name)) continue;
            this.errMgr.grammarError(ErrorType.RESERVED_RULE_NAME, this.g.fileName, ((GrammarAST)rule.ast.getChild(0)).getToken(), rule.name);
        }
    }

    public void checkForModeConflicts(Grammar g) {
        if (g.isLexer()) {
            LexerGrammar lexerGrammar = (LexerGrammar)g;
            for (String modeName : lexerGrammar.modes.keySet()) {
                Rule rule;
                if (!modeName.equals("DEFAULT_MODE") && this.reservedNames.contains(modeName)) {
                    rule = (Rule)((List)lexerGrammar.modes.get(modeName)).iterator().next();
                    g.tool.errMgr.grammarError(ErrorType.MODE_CONFLICTS_WITH_COMMON_CONSTANTS, g.fileName, rule.ast.parent.getToken(), modeName);
                }
                if (g.getTokenType(modeName) == 0) continue;
                rule = (Rule)((List)lexerGrammar.modes.get(modeName)).iterator().next();
                g.tool.errMgr.grammarError(ErrorType.MODE_CONFLICTS_WITH_TOKEN, g.fileName, rule.ast.parent.getToken(), modeName);
            }
        }
    }

    public void checkRuleArgs(Grammar g, List<GrammarAST> rulerefs) {
        if (rulerefs == null) {
            return;
        }
        for (GrammarAST ref : rulerefs) {
            String ruleName = ref.getText();
            Rule r = g.getRule(ruleName);
            GrammarAST arg = (GrammarAST)ref.getFirstChildWithType(8);
            if (arg != null && (r == null || r.args == null)) {
                this.errMgr.grammarError(ErrorType.RULE_HAS_NO_ARGS, g.fileName, ref.token, ruleName);
                continue;
            }
            if (arg != null || r == null || r.args == null) continue;
            this.errMgr.grammarError(ErrorType.MISSING_RULE_ARGS, g.fileName, ref.token, ruleName);
        }
    }

    public void checkForQualifiedRuleIssues(Grammar g, List<GrammarAST> qualifiedRuleRefs) {
        for (GrammarAST dot : qualifiedRuleRefs) {
            GrammarAST grammar = (GrammarAST)dot.getChild(0);
            GrammarAST rule = (GrammarAST)dot.getChild(1);
            g.tool.log("semantics", grammar.getText() + "." + rule.getText());
            Grammar delegate = g.getImportedGrammar(grammar.getText());
            if (delegate == null) {
                this.errMgr.grammarError(ErrorType.NO_SUCH_GRAMMAR_SCOPE, g.fileName, grammar.token, grammar.getText(), rule.getText());
                continue;
            }
            if (g.getRule(grammar.getText(), rule.getText()) != null) continue;
            this.errMgr.grammarError(ErrorType.NO_SUCH_RULE_IN_SCOPE, g.fileName, rule.token, grammar.getText(), rule.getText());
        }
    }
}

