/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver;

import android.support.constraint.solver.ArrayRow;
import android.support.constraint.solver.Cache;
import android.support.constraint.solver.Goal;
import android.support.constraint.solver.SolverVariable;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import java.util.Arrays;
import java.util.HashMap;

public class LinearSystem {
    private static final boolean DEBUG = false;
    private static int POOL_SIZE = 1000;
    int mVariablesID = 0;
    private HashMap<String, SolverVariable> mVariables = null;
    private Goal mGoal = new Goal();
    private int TABLE_SIZE;
    private int mMaxColumns = this.TABLE_SIZE = 32;
    private ArrayRow[] mRows = null;
    private boolean[] mAlreadyTestedCandidates = new boolean[this.TABLE_SIZE];
    int mNumColumns = 1;
    private int mNumRows = 0;
    private int mMaxRows = this.TABLE_SIZE;
    final Cache mCache;
    private SolverVariable[] mPoolVariables = new SolverVariable[POOL_SIZE];
    private int mPoolVariablesCount = 0;
    private ArrayRow[] tempClientsCopy = new ArrayRow[this.TABLE_SIZE];

    public LinearSystem() {
        this.mRows = new ArrayRow[this.TABLE_SIZE];
        this.releaseRows();
        this.mCache = new Cache();
    }

    private void increaseTableSize() {
        this.TABLE_SIZE *= 2;
        this.mRows = Arrays.copyOf(this.mRows, this.TABLE_SIZE);
        this.mCache.mIndexedVariables = Arrays.copyOf(this.mCache.mIndexedVariables, this.TABLE_SIZE);
        this.mAlreadyTestedCandidates = new boolean[this.TABLE_SIZE];
        this.mMaxColumns = this.TABLE_SIZE;
        this.mMaxRows = this.TABLE_SIZE;
        this.mGoal.variables.clear();
    }

    private void releaseRows() {
        for (int i = 0; i < this.mRows.length; ++i) {
            ArrayRow row = this.mRows[i];
            if (row != null) {
                this.mCache.arrayRowPool.release(row);
            }
            this.mRows[i] = null;
        }
    }

    public void reset() {
        int i;
        for (i = 0; i < this.mCache.mIndexedVariables.length; ++i) {
            SolverVariable variable = this.mCache.mIndexedVariables[i];
            if (variable == null) continue;
            variable.reset();
        }
        this.mCache.solverVariablePool.releaseAll((SolverVariable[])this.mPoolVariables, this.mPoolVariablesCount);
        this.mPoolVariablesCount = 0;
        Arrays.fill(this.mCache.mIndexedVariables, null);
        if (this.mVariables != null) {
            this.mVariables.clear();
        }
        this.mVariablesID = 0;
        this.mGoal.variables.clear();
        this.mNumColumns = 1;
        for (i = 0; i < this.mNumRows; ++i) {
            this.mRows[i].used = false;
        }
        this.releaseRows();
        this.mNumRows = 0;
    }

    public SolverVariable createObjectVariable(Object anchor) {
        if (anchor == null) {
            return null;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = null;
        if (anchor instanceof ConstraintAnchor) {
            variable = ((ConstraintAnchor)anchor).getSolverVariable();
            if (variable == null) {
                ((ConstraintAnchor)anchor).resetSolverVariable(this.mCache);
                variable = ((ConstraintAnchor)anchor).getSolverVariable();
            }
            if (variable.id == -1 || variable.id > this.mVariablesID || this.mCache.mIndexedVariables[variable.id] == null) {
                if (variable.id != -1) {
                    variable.reset();
                }
                ++this.mVariablesID;
                ++this.mNumColumns;
                variable.id = this.mVariablesID;
                variable.mType = SolverVariable.Type.UNRESTRICTED;
                this.mCache.mIndexedVariables[this.mVariablesID] = variable;
            }
        }
        return variable;
    }

    public ArrayRow createRow() {
        ArrayRow row = this.mCache.arrayRowPool.acquire();
        if (row == null) {
            row = new ArrayRow(this.mCache);
        } else {
            row.reset();
        }
        return row;
    }

    public SolverVariable createSlackVariable() {
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.SLACK);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        return variable;
    }

    private void addError(ArrayRow row) {
        SolverVariable error1 = this.createErrorVariable();
        SolverVariable error2 = this.createErrorVariable();
        row.addError(error1, error2);
    }

    private void addSingleError(ArrayRow row, int sign) {
        SolverVariable error = this.createErrorVariable();
        row.addSingleError(error, sign);
    }

    private SolverVariable createVariable(String name, SolverVariable.Type type) {
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(type);
        variable.setName(name);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        if (this.mVariables == null) {
            this.mVariables = new HashMap();
        }
        this.mVariables.put(name, variable);
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        return variable;
    }

    public SolverVariable createErrorVariable() {
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.ERROR);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        return variable;
    }

    private SolverVariable acquireSolverVariable(SolverVariable.Type type) {
        SolverVariable variable = this.mCache.solverVariablePool.acquire();
        if (variable == null) {
            variable = new SolverVariable(type);
        } else {
            variable.reset();
            variable.setType(type);
        }
        if (this.mPoolVariablesCount >= POOL_SIZE) {
            this.mPoolVariables = Arrays.copyOf(this.mPoolVariables, POOL_SIZE *= 2);
        }
        this.mPoolVariables[this.mPoolVariablesCount++] = variable;
        return variable;
    }

    Goal getGoal() {
        return this.mGoal;
    }

    ArrayRow getRow(int n) {
        return this.mRows[n];
    }

    float getValueFor(String name) {
        SolverVariable v = this.getVariable(name, SolverVariable.Type.UNRESTRICTED);
        if (v == null) {
            return 0.0f;
        }
        return v.computedValue;
    }

    public int getObjectVariableValue(Object anchor) {
        SolverVariable variable = ((ConstraintAnchor)anchor).getSolverVariable();
        if (variable != null) {
            return (int)(variable.computedValue + 0.5f);
        }
        return 0;
    }

    SolverVariable getVariable(String name, SolverVariable.Type type) {
        SolverVariable variable;
        if (this.mVariables == null) {
            this.mVariables = new HashMap();
        }
        if ((variable = this.mVariables.get(name)) == null) {
            variable = this.createVariable(name, type);
        }
        return variable;
    }

    void rebuildGoalFromErrors() {
        this.mGoal.updateFromSystem(this);
    }

    public void minimize() throws Exception {
        this.minimizeGoal(this.mGoal);
    }

    void minimizeGoal(Goal goal) throws Exception {
        goal.updateFromSystem(this);
        this.enforceBFS(goal);
        this.optimize(goal);
        this.computeValues();
    }

    private void updateRowFromVariables(ArrayRow row) {
        if (this.mNumRows > 0) {
            row.variables.updateFromSystem(row, this.mRows);
            if (row.variables.currentSize == 0) {
                row.isSimpleDefinition = true;
            }
        }
    }

    public void addConstraint(ArrayRow row) {
        if (row == null) {
            return;
        }
        if (this.mNumRows + 1 >= this.mMaxRows || this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        if (!row.isSimpleDefinition) {
            this.updateRowFromVariables(row);
            row.ensurePositiveConstant();
            row.pickRowVariable();
            if (!row.hasKeyVariable()) {
                return;
            }
        }
        if (this.mRows[this.mNumRows] != null) {
            this.mCache.arrayRowPool.release(this.mRows[this.mNumRows]);
        }
        if (!row.isSimpleDefinition) {
            row.updateClientEquations();
        }
        this.mRows[this.mNumRows] = row;
        row.variable.definitionId = this.mNumRows++;
        int count = row.variable.mClientEquationsCount;
        if (count > 0) {
            int i;
            while (this.tempClientsCopy.length < count) {
                this.tempClientsCopy = new ArrayRow[this.tempClientsCopy.length * 2];
            }
            ArrayRow[] clients = this.tempClientsCopy;
            for (i = 0; i < count; ++i) {
                clients[i] = row.variable.mClientEquations[i];
            }
            for (i = 0; i < count; ++i) {
                ArrayRow client = clients[i];
                if (client == row) continue;
                client.variables.updateFromRow(client, row);
                client.updateClientEquations();
            }
        }
    }

    private int optimize(Goal goal) {
        boolean done = false;
        int tries = 0;
        for (int i = 0; i < this.mNumColumns; ++i) {
            this.mAlreadyTestedCandidates[i] = false;
        }
        int tested = 0;
        while (!done) {
            ++tries;
            SolverVariable pivotCandidate = goal.getPivotCandidate();
            if (pivotCandidate != null) {
                if (this.mAlreadyTestedCandidates[pivotCandidate.id]) {
                    pivotCandidate = null;
                } else {
                    this.mAlreadyTestedCandidates[pivotCandidate.id] = true;
                    if (++tested >= this.mNumColumns) {
                        done = true;
                    }
                }
            }
            if (pivotCandidate != null) {
                float min = Float.MAX_VALUE;
                int pivotRowIndex = -1;
                for (int i = 0; i < this.mNumRows; ++i) {
                    float value;
                    float a_j;
                    ArrayRow current = this.mRows[i];
                    SolverVariable variable = current.variable;
                    if (variable.mType == SolverVariable.Type.UNRESTRICTED || !current.hasVariable(pivotCandidate) || !((a_j = current.variables.get(pivotCandidate)) < 0.0f) || !((value = -current.constantValue / a_j) < min)) continue;
                    min = value;
                    pivotRowIndex = i;
                }
                if (pivotRowIndex > -1) {
                    ArrayRow pivotEquation = this.mRows[pivotRowIndex];
                    pivotEquation.variable.definitionId = -1;
                    pivotEquation.pivot(pivotCandidate);
                    pivotEquation.variable.definitionId = pivotRowIndex;
                    for (int i = 0; i < this.mNumRows; ++i) {
                        this.mRows[i].updateRowWithEquation(pivotEquation);
                    }
                    goal.updateFromSystem(this);
                    try {
                        this.enforceBFS(goal);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        return tries;
    }

    private int enforceBFS(Goal goal) throws Exception {
        SolverVariable variable;
        int i;
        int tries = 0;
        boolean infeasibleSystem = false;
        for (i = 0; i < this.mNumRows; ++i) {
            variable = this.mRows[i].variable;
            if (variable.mType == SolverVariable.Type.UNRESTRICTED || !(this.mRows[i].constantValue < 0.0f)) continue;
            infeasibleSystem = true;
            break;
        }
        if (infeasibleSystem) {
            boolean done = false;
            tries = 0;
            while (!done) {
                ++tries;
                float min = Float.MAX_VALUE;
                int strength = 0;
                int pivotRowIndex = -1;
                int pivotColumnIndex = -1;
                for (int i2 = 0; i2 < this.mNumRows; ++i2) {
                    ArrayRow current = this.mRows[i2];
                    SolverVariable variable2 = current.variable;
                    if (variable2.mType == SolverVariable.Type.UNRESTRICTED || !(current.constantValue < 0.0f)) continue;
                    for (int j = 1; j < this.mNumColumns; ++j) {
                        SolverVariable candidate = this.mCache.mIndexedVariables[j];
                        float a_j = current.variables.get(candidate);
                        if (a_j <= 0.0f) continue;
                        for (int k = 0; k < 6; ++k) {
                            float value = candidate.strengthVector[k] / a_j;
                            if (!(value < min && k == strength) && k <= strength) continue;
                            min = value;
                            pivotRowIndex = i2;
                            pivotColumnIndex = j;
                            strength = k;
                        }
                    }
                }
                if (pivotRowIndex != -1) {
                    ArrayRow pivotEquation = this.mRows[pivotRowIndex];
                    pivotEquation.variable.definitionId = -1;
                    pivotEquation.pivot(this.mCache.mIndexedVariables[pivotColumnIndex]);
                    pivotEquation.variable.definitionId = pivotRowIndex;
                    for (int i3 = 0; i3 < this.mNumRows; ++i3) {
                        this.mRows[i3].updateRowWithEquation(pivotEquation);
                    }
                    goal.updateFromSystem(this);
                    continue;
                }
                done = true;
            }
        }
        infeasibleSystem = false;
        for (i = 0; i < this.mNumRows; ++i) {
            variable = this.mRows[i].variable;
            if (variable.mType == SolverVariable.Type.UNRESTRICTED || !(this.mRows[i].constantValue < 0.0f)) continue;
            infeasibleSystem = true;
            break;
        }
        return tries;
    }

    private void computeValues() {
        for (int i = 0; i < this.mNumRows; ++i) {
            ArrayRow row = this.mRows[i];
            row.variable.computedValue = row.constantValue;
        }
    }

    private void displayRows() {
        this.displaySolverVariables();
        String s = "";
        for (int i = 0; i < this.mNumRows; ++i) {
            s = s + this.mRows[i];
            s = s + "\n";
        }
        if (this.mGoal.variables.size() != 0) {
            s = s + this.mGoal + "\n";
        }
        System.out.println(s);
    }

    void displayReadableRows() {
        this.displaySolverVariables();
        String s = "";
        for (int i = 0; i < this.mNumRows; ++i) {
            s = s + this.mRows[i].toReadableString();
            s = s + "\n";
        }
        if (this.mGoal != null) {
            s = s + this.mGoal + "\n";
        }
        System.out.println(s);
    }

    public void displayVariablesReadableRows() {
        this.displaySolverVariables();
        String s = "";
        for (int i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i].variable.mType != SolverVariable.Type.UNRESTRICTED) continue;
            s = s + this.mRows[i].toReadableString();
            s = s + "\n";
        }
        if (this.mGoal.variables.size() != 0) {
            s = s + this.mGoal + "\n";
        }
        System.out.println(s);
    }

    public int getMemoryUsed() {
        int actualRowSize = 0;
        for (int i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i] == null) continue;
            actualRowSize += this.mRows[i].sizeInBytes();
        }
        return actualRowSize;
    }

    public int getNumEquations() {
        return this.mNumRows;
    }

    public int getNumVariables() {
        return this.mVariablesID;
    }

    void displaySystemInformations() {
        int count = 0;
        int rowSize = 0;
        for (int i = 0; i < this.TABLE_SIZE; ++i) {
            if (this.mRows[i] == null) continue;
            rowSize += this.mRows[i].sizeInBytes();
        }
        int actualRowSize = 0;
        for (int i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i] == null) continue;
            actualRowSize += this.mRows[i].sizeInBytes();
        }
        System.out.println("Linear System -> Table size: " + this.TABLE_SIZE + " (" + this.getDisplaySize(this.TABLE_SIZE * this.TABLE_SIZE) + ") -- row sizes: " + this.getDisplaySize(rowSize) + ", actual size: " + this.getDisplaySize(actualRowSize) + " rows: " + this.mNumRows + "/" + this.mMaxRows + " cols: " + this.mNumColumns + "/" + this.mMaxColumns + " " + count + " occupied cells, " + this.getDisplaySize(count));
    }

    private void displaySolverVariables() {
        String s = "Display Rows (" + this.mNumRows + "x" + this.mNumColumns + ") :\n\t | C | ";
        for (int i = 1; i <= this.mNumColumns; ++i) {
            SolverVariable v = this.mCache.mIndexedVariables[i];
            s = s + v;
            s = s + " | ";
        }
        s = s + "\n";
        System.out.println(s);
    }

    private String getDisplaySize(int n) {
        int mb = n * 4 / 1024 / 1024;
        if (mb > 0) {
            return "" + mb + " Mb";
        }
        int kb = n * 4 / 1024;
        if (kb > 0) {
            return "" + kb + " Kb";
        }
        return "" + n * 4 + " bytes";
    }

    public Cache getCache() {
        return this.mCache;
    }

    public void addGreaterThan(SolverVariable a, SolverVariable b, int margin, int strength) {
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.strength = strength;
        row.createRowGreaterThan(a, b, slack, margin);
        this.addConstraint(row);
    }

    public void addLowerThan(SolverVariable a, SolverVariable b, int margin, int strength) {
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.strength = strength;
        row.createRowLowerThan(a, b, slack, margin);
        this.addConstraint(row);
    }

    public void addCentering(SolverVariable a, SolverVariable b, int m1, float bias, SolverVariable c, SolverVariable d, int m2, int strength) {
        ArrayRow row = this.createRow();
        row.createRowCentering(a, b, m1, bias, c, d, m2);
        SolverVariable error1 = this.createErrorVariable();
        SolverVariable error2 = this.createErrorVariable();
        error1.strength = strength;
        error2.strength = strength;
        row.addError(error1, error2);
        this.addConstraint(row);
    }

    public ArrayRow addEquality(SolverVariable a, SolverVariable b, int margin, int strength) {
        ArrayRow row = this.createRow();
        row.createRowEquals(a, b, margin);
        SolverVariable error1 = this.createErrorVariable();
        SolverVariable error2 = this.createErrorVariable();
        error1.strength = strength;
        error2.strength = strength;
        row.addError(error1, error2);
        this.addConstraint(row);
        return row;
    }

    public void addEquality(SolverVariable a, int value) {
        int idx = a.definitionId;
        if (a.definitionId != -1) {
            ArrayRow row = this.mRows[idx];
            if (row.isSimpleDefinition) {
                row.constantValue = value;
            } else {
                ArrayRow newRow = this.createRow();
                newRow.createRowEquals(a, value);
                this.addConstraint(newRow);
            }
        } else {
            ArrayRow row = this.createRow();
            row.createRowDefinition(a, value);
            this.addConstraint(row);
        }
    }

    public static ArrayRow createRowEquals(LinearSystem linearSystem, SolverVariable variableA, SolverVariable variableB, int margin, boolean withError) {
        ArrayRow row = linearSystem.createRow();
        row.createRowEquals(variableA, variableB, margin);
        if (withError) {
            linearSystem.addSingleError(row, 1);
        }
        return row;
    }

    public static ArrayRow createRowDimensionPercent(LinearSystem linearSystem, SolverVariable variableA, SolverVariable variableB, SolverVariable variableC, float percent, boolean withError) {
        ArrayRow row = linearSystem.createRow();
        if (withError) {
            linearSystem.addError(row);
        }
        return row.createRowDimensionPercent(variableA, variableB, variableC, percent);
    }

    public static ArrayRow createRowGreaterThan(LinearSystem linearSystem, SolverVariable variableA, SolverVariable variableB, int margin, boolean withError) {
        SolverVariable slack = linearSystem.createSlackVariable();
        ArrayRow row = linearSystem.createRow();
        row.createRowGreaterThan(variableA, variableB, slack, margin);
        if (withError) {
            float slackValue = row.variables.get(slack);
            linearSystem.addSingleError(row, (int)(-1.0f * slackValue));
        }
        return row;
    }

    public static ArrayRow createRowLowerThan(LinearSystem linearSystem, SolverVariable variableA, SolverVariable variableB, int margin, boolean withError) {
        SolverVariable slack = linearSystem.createSlackVariable();
        ArrayRow row = linearSystem.createRow();
        row.createRowLowerThan(variableA, variableB, slack, margin);
        if (withError) {
            float slackValue = row.variables.get(slack);
            linearSystem.addSingleError(row, (int)(-1.0f * slackValue));
        }
        return row;
    }

    public static ArrayRow createRowCentering(LinearSystem linearSystem, SolverVariable variableA, SolverVariable variableB, int marginA, float bias, SolverVariable variableC, SolverVariable variableD, int marginB, boolean withError) {
        ArrayRow row = linearSystem.createRow();
        row.createRowCentering(variableA, variableB, marginA, bias, variableC, variableD, marginB);
        if (withError) {
            SolverVariable error1 = linearSystem.createErrorVariable();
            SolverVariable error2 = linearSystem.createErrorVariable();
            error1.strength = 4;
            error2.strength = 4;
            row.addError(error1, error2);
        }
        return row;
    }
}

