/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver;

import android.support.constraint.solver.ArrayRow;
import android.support.constraint.solver.Cache;
import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.SolverVariable;
import java.util.Arrays;

public class ArrayVariables {
    private static final boolean DEBUG = false;
    int currentSize = 0;
    private final ArrayRow mRow;
    private final Cache mCache;
    private int ROW_SIZE = 8;
    private int[] mArrayIndices = new int[this.ROW_SIZE];
    private float[] mArrayValues = new float[this.ROW_SIZE];
    private boolean[] mArrayValid = new boolean[this.ROW_SIZE];

    ArrayVariables(ArrayRow arrayRow, Cache cache) {
        this.mRow = arrayRow;
        this.mCache = cache;
    }

    public final void put(SolverVariable variable, float value) {
        for (int i = 0; i < this.currentSize; ++i) {
            if (this.mArrayIndices[i] != variable.id) continue;
            this.mArrayValues[i] = value;
            if (value == 0.0f) {
                this.mArrayValid[i] = false;
                variable.removeFromRow(this.mRow);
            }
            return;
        }
        if (this.currentSize >= this.mArrayIndices.length) {
            this.ROW_SIZE *= 2;
            this.mArrayValues = Arrays.copyOf(this.mArrayValues, this.ROW_SIZE);
            this.mArrayIndices = Arrays.copyOf(this.mArrayIndices, this.ROW_SIZE);
            this.mArrayValid = Arrays.copyOf(this.mArrayValid, this.ROW_SIZE);
        }
        this.mArrayIndices[this.currentSize] = variable.id;
        this.mArrayValues[this.currentSize] = value;
        this.mArrayValid[this.currentSize] = true;
        if (value == 0.0f) {
            variable.removeFromRow(this.mRow);
            this.mArrayValid[this.currentSize] = false;
        }
        ++variable.usageInRowCount;
        variable.addToRow(this.mRow);
        ++this.currentSize;
    }

    final void add(SolverVariable variable, float value, boolean removeFromDefinition) {
        if (value == 0.0f) {
            return;
        }
        for (int i = 0; i < this.currentSize; ++i) {
            if (this.mArrayIndices[i] != variable.id) continue;
            int n = i;
            this.mArrayValues[n] = this.mArrayValues[n] + value;
            return;
        }
        if (this.currentSize >= this.mArrayIndices.length) {
            this.ROW_SIZE *= 2;
            this.mArrayValues = Arrays.copyOf(this.mArrayValues, this.ROW_SIZE);
            this.mArrayIndices = Arrays.copyOf(this.mArrayIndices, this.ROW_SIZE);
            this.mArrayValid = Arrays.copyOf(this.mArrayValid, this.ROW_SIZE);
        }
        this.mArrayIndices[this.currentSize] = variable.id;
        int n = this.currentSize;
        this.mArrayValues[n] = this.mArrayValues[n] + value;
        this.mArrayValid[this.currentSize] = true;
        ++variable.usageInRowCount;
        variable.addToRow(this.mRow);
        if (this.mArrayValues[this.currentSize] == 0.0f) {
            --variable.usageInRowCount;
            variable.removeFromRow(this.mRow);
            this.mArrayValid[this.currentSize] = false;
        }
        ++this.currentSize;
    }

    public final float remove(SolverVariable variable, boolean removeFromDefinition) {
        for (int i = 0; i < this.currentSize; ++i) {
            if (this.mArrayIndices[i] != variable.id) continue;
            float value = this.mArrayValues[i];
            this.mArrayValues[i] = 0.0f;
            this.mArrayValid[i] = false;
            if (removeFromDefinition) {
                --variable.usageInRowCount;
                variable.removeFromRow(this.mRow);
            }
            return value;
        }
        return 0.0f;
    }

    public final void clear() {
        for (int i = 0; i < this.currentSize; ++i) {
            SolverVariable variable = this.mCache.mIndexedVariables[this.mArrayIndices[i]];
            if (variable == null) continue;
            variable.removeFromRow(this.mRow);
        }
        this.currentSize = 0;
    }

    final boolean containsKey(SolverVariable variable) {
        for (int i = 0; i < this.currentSize; ++i) {
            if (!this.mArrayValid[i] || this.mArrayIndices[i] != variable.id) continue;
            return true;
        }
        return false;
    }

    boolean hasAtLeastOnePositiveVariable() {
        for (int i = 0; i < this.currentSize; ++i) {
            if (!this.mArrayValid[i] || !(this.mArrayValues[i] > 0.0f)) continue;
            return true;
        }
        return false;
    }

    void invert() {
        for (int i = 0; i < this.currentSize; ++i) {
            if (!this.mArrayValid[i]) continue;
            int n = i;
            this.mArrayValues[n] = this.mArrayValues[n] * -1.0f;
        }
    }

    void divideByAmount(float amount) {
        for (int i = 0; i < this.currentSize; ++i) {
            if (!this.mArrayValid[i]) continue;
            int n = i;
            this.mArrayValues[n] = this.mArrayValues[n] / amount;
        }
    }

    private boolean isNew(SolverVariable variable, LinearSystem system) {
        return variable.mClientEquationsCount <= 1;
    }

    SolverVariable chooseSubject(LinearSystem system) {
        SolverVariable restrictedCandidate = null;
        SolverVariable unrestrictedCandidate = null;
        float unrestrictedCandidateAmount = 0.0f;
        float restrictedCandidateAmount = 0.0f;
        boolean unrestrictedCandidateIsNew = false;
        boolean restrictedCandidateIsNew = false;
        for (int i = 0; i < this.currentSize; ++i) {
            if (!this.mArrayValid[i]) continue;
            float amount = this.mArrayValues[i];
            float epsilon = 0.001f;
            SolverVariable variable = this.mCache.mIndexedVariables[this.mArrayIndices[i]];
            if (amount < 0.0f) {
                if (amount > -epsilon) {
                    this.mArrayValues[i] = 0.0f;
                    amount = 0.0f;
                    this.mArrayValid[i] = false;
                    variable.removeFromRow(this.mRow);
                }
            } else if (amount < epsilon) {
                this.mArrayValues[i] = 0.0f;
                amount = 0.0f;
                this.mArrayValid[i] = false;
                variable.removeFromRow(this.mRow);
            }
            if (amount == 0.0f) continue;
            if (variable.mType == SolverVariable.Type.UNRESTRICTED) {
                if (unrestrictedCandidate == null) {
                    unrestrictedCandidate = variable;
                    unrestrictedCandidateAmount = amount;
                    unrestrictedCandidateIsNew = this.isNew(variable, system);
                    continue;
                }
                if (unrestrictedCandidateAmount > amount) {
                    unrestrictedCandidate = variable;
                    unrestrictedCandidateAmount = amount;
                    unrestrictedCandidateIsNew = this.isNew(variable, system);
                    continue;
                }
                if (unrestrictedCandidateIsNew || !this.isNew(variable, system)) continue;
                unrestrictedCandidate = variable;
                unrestrictedCandidateAmount = amount;
                unrestrictedCandidateIsNew = true;
                continue;
            }
            if (unrestrictedCandidate != null || !(amount < 0.0f)) continue;
            if (restrictedCandidate == null) {
                restrictedCandidate = variable;
                restrictedCandidateAmount = amount;
                restrictedCandidateIsNew = this.isNew(variable, system);
                continue;
            }
            if (restrictedCandidateAmount > amount) {
                restrictedCandidate = variable;
                restrictedCandidateAmount = amount;
                restrictedCandidateIsNew = this.isNew(variable, system);
                continue;
            }
            if (restrictedCandidateIsNew || !this.isNew(variable, system)) continue;
            restrictedCandidate = variable;
            restrictedCandidateAmount = amount;
            restrictedCandidateIsNew = true;
        }
        if (unrestrictedCandidate != null) {
            return unrestrictedCandidate;
        }
        return restrictedCandidate;
    }

    final void updateFromRow(ArrayRow self, ArrayRow definition, boolean removeFromDefinition) {
        for (int i = 0; i < this.currentSize; ++i) {
            float value;
            if (!this.mArrayValid[i] || this.mArrayIndices[i] != definition.variable.id || (value = this.mArrayValues[i]) == 0.0f) continue;
            this.mArrayValues[i] = 0.0f;
            this.mArrayValid[i] = false;
            if (removeFromDefinition) {
                definition.variable.removeFromRow(this.mRow);
            }
            ArrayVariables definitionVariables = (ArrayVariables)((Object)definition.variables);
            for (int j = 0; j < definitionVariables.currentSize; ++j) {
                SolverVariable definitionVariable = this.mCache.mIndexedVariables[definitionVariables.mArrayIndices[j]];
                float definitionValue = definitionVariables.mArrayValues[j];
                this.add(definitionVariable, definitionValue * value, removeFromDefinition);
            }
            self.constantValue += definition.constantValue * value;
            if (!removeFromDefinition) continue;
            definition.variable.removeFromRow(self);
        }
    }

    void updateFromSystem(ArrayRow self, ArrayRow[] rows) {
        for (int i = 0; i < this.currentSize; ++i) {
            if (!this.mArrayValid[i]) continue;
            SolverVariable variable = this.mCache.mIndexedVariables[this.mArrayIndices[i]];
            if (variable.definitionId == -1) continue;
            float value = this.mArrayValues[i];
            this.mArrayValues[i] = 0.0f;
            this.mArrayValid[i] = false;
            variable.removeFromRow(this.mRow);
            ArrayRow definition = rows[variable.definitionId];
            if (!definition.isSimpleDefinition) {
                ArrayVariables definitionVariables = (ArrayVariables)((Object)definition.variables);
                for (int j = 0; j < definitionVariables.currentSize; ++j) {
                    SolverVariable definitionVariable = this.mCache.mIndexedVariables[definitionVariables.mArrayIndices[j]];
                    float definitionValue = definitionVariables.mArrayValues[j];
                    this.add(definitionVariable, definitionValue * value, true);
                }
            }
            self.constantValue += definition.constantValue * value;
            definition.variable.removeFromRow(self);
        }
    }

    SolverVariable getPivotCandidate() {
        SolverVariable pivot = null;
        for (int i = 0; i < this.currentSize; ++i) {
            if (!this.mArrayValid[i] || !(this.mArrayValues[i] < 0.0f)) continue;
            SolverVariable v = this.mCache.mIndexedVariables[this.mArrayIndices[i]];
            if (pivot != null && pivot.strength >= v.strength) continue;
            pivot = v;
        }
        return pivot;
    }

    SolverVariable getPivotCandidate(boolean[] avoid, SolverVariable exclude) {
        SolverVariable pivot = null;
        float value = 0.0f;
        for (int i = 0; i < this.currentSize; ++i) {
            float currentValue;
            if (!this.mArrayValid[i] || !(this.mArrayValues[i] < 0.0f)) continue;
            SolverVariable v = this.mCache.mIndexedVariables[this.mArrayIndices[i]];
            if (avoid != null && avoid[v.id] || v == exclude || v.mType != SolverVariable.Type.SLACK && v.mType != SolverVariable.Type.ERROR || !((currentValue = this.mArrayValues[i]) < value)) continue;
            value = currentValue;
            pivot = v;
        }
        return pivot;
    }

    final SolverVariable getVariable(int index) {
        if (index < this.currentSize) {
            return this.mCache.mIndexedVariables[this.mArrayIndices[index]];
        }
        return null;
    }

    final float getVariableValue(int index) {
        if (index < this.currentSize) {
            return this.mArrayValues[index];
        }
        return 0.0f;
    }

    public final float get(SolverVariable v) {
        for (int i = 0; i < this.currentSize; ++i) {
            if (!this.mArrayValid[i] || this.mArrayIndices[i] != v.id) continue;
            return this.mArrayValues[i];
        }
        return 0.0f;
    }

    int sizeInBytes() {
        int size = 0;
        size += 3 * (this.mArrayIndices.length * 4);
        return size += 36;
    }

    public void display() {
        int count = this.currentSize;
        System.out.print("{ ");
        for (int i = 0; i < count; ++i) {
            SolverVariable v;
            if (!this.mArrayValid[i] || (v = this.getVariable(i)) == null) continue;
            System.out.print(v + " = " + this.getVariableValue(i) + " ");
        }
        System.out.println(" }");
    }

    public String toString() {
        String result = "";
        for (int i = 0; i < this.currentSize; ++i) {
            float value;
            if (!this.mArrayValid[i] || (value = this.mArrayValues[i]) == 0.0f) continue;
            result = result + " -> ";
            result = result + this.mArrayValues[i] + " : ";
            result = result + this.mCache.mIndexedVariables[this.mArrayIndices[i]];
        }
        return result;
    }
}

