/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.rule;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.test.InstrumentationRegistry;
import android.support.test.internal.runner.junit4.statement.UiThreadStatement;
import android.support.test.internal.util.Checks;
import android.support.test.runner.MonitoringInstrumentation;
import android.support.test.runner.intercepting.InterceptingActivityFactory;
import android.support.test.runner.intercepting.SingleActivityFactory;
import android.util.Log;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ActivityTestRule<T extends Activity>
implements TestRule {
    private static final String TAG = "ActivityTestRule";
    private static final int NO_FLAGS_SET = 0;
    private final Class<T> mActivityClass;
    private final String mTargetPackage;
    private final int mLaunchFlags;
    private Instrumentation mInstrumentation = InstrumentationRegistry.getInstrumentation();
    private boolean mInitialTouchMode = false;
    private boolean mLaunchActivity = false;
    private T mActivity;
    private SingleActivityFactory<T> mActivityFactory;

    public ActivityTestRule(Class<T> activityClass) {
        this(activityClass, false);
    }

    public ActivityTestRule(Class<T> activityClass, boolean initialTouchMode) {
        this(activityClass, initialTouchMode, true);
    }

    public ActivityTestRule(Class<T> activityClass, boolean initialTouchMode, boolean launchActivity) {
        this(activityClass, InstrumentationRegistry.getTargetContext().getPackageName(), 0x10000000, initialTouchMode, launchActivity);
    }

    public ActivityTestRule(SingleActivityFactory<T> activityFactory, boolean initialTouchMode, boolean launchActivity) {
        this(activityFactory.getActivityClassToIntercept(), initialTouchMode, launchActivity);
        this.mActivityFactory = activityFactory;
    }

    public ActivityTestRule(Class<T> activityClass, @NonNull String targetPackage, int launchFlags, boolean initialTouchMode, boolean launchActivity) {
        this.mActivityClass = activityClass;
        this.mTargetPackage = (String)Checks.checkNotNull((Object)targetPackage, (Object)"targetPackage cannot be null!");
        this.mLaunchFlags = launchFlags;
        this.mInitialTouchMode = initialTouchMode;
        this.mLaunchActivity = launchActivity;
    }

    protected Intent getActivityIntent() {
        return null;
    }

    protected void beforeActivityLaunched() {
    }

    protected void afterActivityLaunched() {
    }

    protected void afterActivityFinished() {
    }

    public T getActivity() {
        if (this.mActivity == null) {
            Log.w((String)TAG, (String)"Activity wasn't created yet");
        }
        return this.mActivity;
    }

    public Statement apply(Statement base, Description description) {
        return new ActivityStatement(base);
    }

    public T launchActivity(@Nullable Intent startIntent) {
        this.mInstrumentation.setInTouchMode(this.mInitialTouchMode);
        if (null == startIntent && null == (startIntent = this.getActivityIntent())) {
            Log.w((String)TAG, (String)"getActivityIntent() returned null using default: Intent(Intent.ACTION_MAIN)");
            startIntent = new Intent("android.intent.action.MAIN");
        }
        if (null == startIntent.getComponent()) {
            startIntent.setClassName(this.mTargetPackage, this.mActivityClass.getName());
        }
        if (0 == startIntent.getFlags()) {
            startIntent.addFlags(this.mLaunchFlags);
        }
        Log.i((String)TAG, (String)String.format("Launching activity: %s", startIntent.getComponent()));
        this.beforeActivityLaunched();
        this.mActivity = (Activity)this.mActivityClass.cast(this.mInstrumentation.startActivitySync(startIntent));
        this.mInstrumentation.waitForIdleSync();
        if (this.mActivity != null) {
            this.afterActivityLaunched();
        } else {
            String errorMessage = String.format("Activity %s, failed to launch", startIntent.getComponent());
            Bundle bundle = new Bundle();
            bundle.putString("stream", "ActivityTestRule " + errorMessage);
            this.mInstrumentation.sendStatus(0, bundle);
            Log.e((String)TAG, (String)errorMessage);
        }
        return this.mActivity;
    }

    void setInstrumentation(Instrumentation instrumentation) {
        this.mInstrumentation = (Instrumentation)Checks.checkNotNull((Object)instrumentation, (Object)"instrumentation cannot be null!");
    }

    void finishActivity() {
        if (this.mActivity != null) {
            this.mActivity.finish();
            this.afterActivityFinished();
            this.mActivity = null;
        }
    }

    public void runOnUiThread(Runnable runnable) throws Throwable {
        UiThreadStatement.runOnUiThread((Runnable)runnable);
    }

    private class ActivityStatement
    extends Statement {
        private final Statement mBase;

        public ActivityStatement(Statement base) {
            this.mBase = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            MonitoringInstrumentation instrumentation = ActivityTestRule.this.mInstrumentation instanceof MonitoringInstrumentation ? (MonitoringInstrumentation)ActivityTestRule.this.mInstrumentation : null;
            try {
                if (ActivityTestRule.this.mActivityFactory != null && instrumentation != null) {
                    instrumentation.interceptActivityUsing((InterceptingActivityFactory)ActivityTestRule.this.mActivityFactory);
                }
                if (ActivityTestRule.this.mLaunchActivity) {
                    ActivityTestRule.this.mActivity = ActivityTestRule.this.launchActivity(ActivityTestRule.this.getActivityIntent());
                }
                this.mBase.evaluate();
            }
            finally {
                if (instrumentation != null) {
                    instrumentation.useDefaultInterceptingActivityFactory();
                }
                ActivityTestRule.this.finishActivity();
            }
        }
    }
}

