/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.SymbolIo;
import com.android.builder.symbols.SymbolTable;
import com.android.utils.Pair;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class RGeneration {
    private RGeneration() {
    }

    public static void generateRForLibraries(SymbolTable main, Collection<SymbolTable> libraries, File out, boolean finalIds) {
        Preconditions.checkArgument((boolean)out.isDirectory(), (Object)"!out.iDirectory");
        Pair mainP = Pair.of((Object)main.getTablePackage(), (Object)main.getTableName());
        HashMap<Pair, SymbolTable> toWrite = new HashMap<Pair, SymbolTable>();
        for (SymbolTable st2 : libraries) {
            Pair p = Pair.of((Object)st2.getTablePackage(), (Object)st2.getTableName());
            if (p.equals((Object)mainP)) continue;
            SymbolTable existing = (SymbolTable)toWrite.get(p);
            if (existing != null) {
                toWrite.put(p, existing.merge(st2));
                continue;
            }
            toWrite.put(p, st2);
        }
        for (Pair k : new HashSet(toWrite.keySet())) {
            SymbolTable st3 = (SymbolTable)toWrite.get(k);
            st3 = main.filter(st3).rename(st3.getTablePackage(), st3.getTableName());
            toWrite.put(k, st3);
        }
        toWrite.values().forEach(st -> SymbolIo.exportToJava(st, out, finalIds));
    }
}

