/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Commands;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.AbstractSizeAggregator;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.model.ConfigurationSizes;
import com.android.tools.build.bundletool.model.GetSizeRequest;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;

public class AssetModuleSizeAggregator
extends AbstractSizeAggregator {
    private final Collection<Commands.AssetSliceSet> assetModules;
    private final Targeting.VariantTargeting variantTargeting;

    public AssetModuleSizeAggregator(Collection<Commands.AssetSliceSet> assetModules, Targeting.VariantTargeting variantTargeting, ImmutableMap<String, Long> sizeByApkPaths, GetSizeRequest getSizeRequest) {
        super(sizeByApkPaths, getSizeRequest);
        this.assetModules = assetModules;
        this.variantTargeting = variantTargeting;
    }

    @Override
    public ConfigurationSizes getSize() {
        ImmutableList apkDescriptions = (ImmutableList)this.assetModules.stream().flatMap(assetModule -> assetModule.getApkDescriptionList().stream()).collect(ImmutableList.toImmutableList());
        ImmutableSet sdkVersionTargetingOptions = this.variantTargeting.hasSdkVersionTargeting() ? ImmutableSet.of((Object)this.variantTargeting.getSdkVersionTargeting()) : this.getAllSdkVersionTargetings((ImmutableList<Commands.ApkDescription>)apkDescriptions);
        ImmutableSet abiTargetingOptions = this.variantTargeting.hasAbiTargeting() ? ImmutableSet.of((Object)this.variantTargeting.getAbiTargeting()) : this.getAllAbiTargetings((ImmutableList<Commands.ApkDescription>)apkDescriptions);
        ImmutableSet<Targeting.LanguageTargeting> languageTargetingOptions = this.getAllLanguageTargetings((ImmutableList<Commands.ApkDescription>)apkDescriptions);
        ImmutableSet screenDensityTargetingOptions = this.variantTargeting.hasScreenDensityTargeting() ? ImmutableSet.of((Object)this.variantTargeting.getScreenDensityTargeting()) : this.getAllScreenDensityTargetings((ImmutableList<Commands.ApkDescription>)apkDescriptions);
        ImmutableSet textureCompressionFormatTargetingOptions = this.variantTargeting.hasTextureCompressionFormatTargeting() ? ImmutableSet.of((Object)this.variantTargeting.getTextureCompressionFormatTargeting()) : this.getAllTextureCompressionFormatTargetings((ImmutableList<Commands.ApkDescription>)apkDescriptions);
        return this.getSizesPerConfiguration((ImmutableSet<Targeting.SdkVersionTargeting>)sdkVersionTargetingOptions, (ImmutableSet<Targeting.AbiTargeting>)abiTargetingOptions, languageTargetingOptions, (ImmutableSet<Targeting.ScreenDensityTargeting>)screenDensityTargetingOptions, (ImmutableSet<Targeting.TextureCompressionFormatTargeting>)textureCompressionFormatTargetingOptions);
    }

    @Override
    protected ImmutableList<ZipPath> getMatchingApks(Targeting.SdkVersionTargeting sdkVersionTargeting, Targeting.AbiTargeting abiTargeting, Targeting.ScreenDensityTargeting screenDensityTargeting, Targeting.LanguageTargeting languageTargeting, Targeting.TextureCompressionFormatTargeting textureTargeting) {
        return new ApkMatcher(this.getDeviceSpec(this.getSizeRequest.getDeviceSpec(), sdkVersionTargeting, abiTargeting, screenDensityTargeting, languageTargeting, textureTargeting), this.getSizeRequest.getModules(), this.getSizeRequest.getInstant()).getMatchingApksFromAssetModules(this.assetModules);
    }
}

