/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResourceUsageAnalyzer {
    private static final String ANDROID_RES = "android_res/";
    public static final boolean TWO_PASS_AAPT = false;
    public static final int TYPICAL_RESOURCE_COUNT = 200;
    private static final String ATTR_KEEP = "keep";
    private static final String ATTR_DISCARD = "discard";
    private static final String ATTR_SHRINK_MODE = "shrinkMode";
    private static final String VALUE_STRICT = "strict";
    private static final String VALUE_SAFE = "safe";
    static final String NO_MATCH = "-nomatch-";
    private final File mResourceClassDir;
    private final File mProguardMapping;
    private final File mClassesJar;
    private final File mMergedManifest;
    private final File mMergedResourceDir;
    private boolean mVerbose;
    private boolean mDebug;
    private boolean mDryRun;
    private List<Resource> mUnused;
    private List<Resource> mResources = Lists.newArrayListWithExpectedSize((int)200);
    private Map<Integer, Resource> mValueToResource = Maps.newHashMapWithExpectedSize((int)200);
    private Map<ResourceType, Map<String, Resource>> mTypeToName = Maps.newEnumMap(ResourceType.class);
    private Map<String, ResourceType> mResourceClassOwners = Maps.newHashMapWithExpectedSize((int)20);
    private boolean mGuessKeep = true;
    private static byte[] sAndroidResBytes;
    private Set<String> mStrings;
    private boolean mFoundGetIdentifier;
    private boolean mFoundWebContent;

    public ResourceUsageAnalyzer(@NonNull File rDir, @NonNull File classesJar, @NonNull File manifest, @Nullable File mapping, @NonNull File resources) {
        this.mResourceClassDir = rDir;
        this.mProguardMapping = mapping;
        this.mClassesJar = classesJar;
        this.mMergedManifest = manifest;
        this.mMergedResourceDir = resources;
    }

    public void analyze() throws IOException, ParserConfigurationException, SAXException {
        this.gatherResourceValues(this.mResourceClassDir);
        this.recordMapping(this.mProguardMapping);
        this.recordUsages(this.mClassesJar);
        this.recordManifestUsages(this.mMergedManifest);
        this.recordResources(this.mMergedResourceDir);
        this.keepPossiblyReferencedResources();
        this.dumpReferences();
        this.findUnused();
    }

    public boolean isDryRun() {
        return this.mDryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.mDryRun = dryRun;
    }

    public boolean isVerbose() {
        return this.mVerbose;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public boolean isDebug() {
        return this.mDebug;
    }

    public void setDebug(boolean verbose) {
        this.mDebug = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteResourceZip(@NonNull File source, @NonNull File dest) throws IOException {
        boolean deleted;
        if (dest.exists() && !(deleted = dest.delete())) {
            throw new IOException("Could not delete " + dest);
        }
        JarInputStream zis = null;
        try {
            FileInputStream fis = new FileInputStream(source);
            try {
                FileOutputStream fos = new FileOutputStream(dest);
                zis = new JarInputStream(fis);
                JarOutputStream zos = new JarOutputStream(fos);
                try {
                    zos.setLevel(9);
                    ZipEntry entry = zis.getNextEntry();
                    while (entry != null) {
                        String name = entry.getName();
                        boolean directory = entry.isDirectory();
                        Resource resource = this.getResourceByJarPath(name);
                        if (resource == null || resource.reachable) {
                            byte[] bytes;
                            JarEntry outEntry = new JarEntry(entry.getName());
                            if (entry.getTime() != -1L) {
                                outEntry.setTime(entry.getTime());
                            }
                            int method = entry.getMethod();
                            outEntry.setMethod(method);
                            if (method == 0) {
                                outEntry.setCompressedSize(entry.getCompressedSize());
                                outEntry.setSize(entry.getSize());
                                outEntry.setCrc(entry.getCrc());
                            }
                            zos.putNextEntry(outEntry);
                            if (!directory && (bytes = ByteStreams.toByteArray((InputStream)zis)) != null) {
                                zos.write(bytes);
                            }
                            zos.closeEntry();
                        } else if (this.isVerbose()) {
                            System.out.println("Skipped unused resource " + name + ": " + entry.getSize() + " bytes");
                        }
                        entry = zis.getNextEntry();
                    }
                    zos.flush();
                }
                finally {
                    Closeables.close((Closeable)zos, (boolean)false);
                }
            }
            finally {
                Closeables.close((Closeable)fis, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            Closeables.close(zis, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)zis, (boolean)false);
    }

    public void removeUnused(@Nullable File destination) throws IOException, ParserConfigurationException, SAXException {
        assert (false);
    }

    private static void filteredCopy(File source, File destination, Set<File> skip, Map<File, String> replace) throws IOException {
        assert (false);
    }

    private void stripUnused(Element element, List<String> removed) {
        assert (false);
    }

    private static String getFieldName(Element element) {
        return ResourceUsageAnalyzer.getFieldName(element.getAttribute("name"));
    }

    @Nullable
    private Resource getResource(Element element) {
        ResourceType type = ResourceUsageAnalyzer.getResourceType(element);
        if (type != null) {
            String name = ResourceUsageAnalyzer.getFieldName(element);
            return this.getResource(type, name);
        }
        return null;
    }

    @Nullable
    private Resource getResourceByJarPath(String path) {
        int nameStart;
        int nameEnd;
        String folderName;
        ResourceFolderType folderType;
        int folderStart;
        int folderEnd;
        if (path.startsWith("res/") && (folderEnd = path.indexOf(47, folderStart = 4)) != -1 && (folderType = ResourceFolderType.getFolderType((String)(folderName = path.substring(folderStart, folderEnd)))) != null && (nameEnd = path.indexOf(46, nameStart = folderEnd + 1)) != -1) {
            String name = path.substring(nameStart, nameEnd);
            List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
            for (ResourceType type : types) {
                Resource resource;
                if (type == ResourceType.ID || (resource = this.getResource(type, name)) == null) continue;
                return resource;
            }
        }
        return null;
    }

    private static ResourceType getResourceType(Element element) {
        String tagName = element.getTagName();
        if (tagName.equals("item")) {
            String typeName = element.getAttribute("type");
            if (!typeName.isEmpty()) {
                return ResourceType.getEnum((String)typeName);
            }
        } else {
            if ("string-array".equals(tagName) || "integer-array".equals(tagName)) {
                return ResourceType.ARRAY;
            }
            return ResourceType.getEnum((String)tagName);
        }
        return null;
    }

    private void findUnused() {
        ArrayList roots = Lists.newArrayList();
        for (Resource resource : this.mResources) {
            if (!resource.reachable || resource.type == ResourceType.ID || resource.type == ResourceType.ATTR) continue;
            roots.add(resource);
        }
        if (this.mDebug) {
            System.out.println("The root reachable resources are: " + Joiner.on((String)",\n   ").join((Iterable)roots));
        }
        IdentityHashMap<Resource, Boolean> seen = new IdentityHashMap<Resource, Boolean>(this.mResources.size());
        for (Resource root : roots) {
            ResourceUsageAnalyzer.visit(root, seen);
        }
        ArrayList unused = Lists.newArrayListWithExpectedSize((int)this.mResources.size());
        for (Resource resource : this.mResources) {
            if (resource.reachable || !resource.isRelevantType()) continue;
            unused.add(resource);
        }
        this.mUnused = unused;
        if (this.mDebug) {
            System.out.println(this.dumpResourceModel());
        }
    }

    private static void visit(Resource root, Map<Resource, Boolean> seen) {
        if (seen.containsKey(root)) {
            return;
        }
        seen.put(root, Boolean.TRUE);
        root.reachable = true;
        if (root.references != null) {
            for (Resource referenced : root.references) {
                ResourceUsageAnalyzer.visit(referenced, seen);
            }
        }
    }

    private void dumpReferences() {
        if (this.mDebug) {
            System.out.println("Resource Reference Graph:");
            for (Resource resource : this.mResources) {
                if (resource.references == null) continue;
                System.out.println(resource + " => " + resource.references);
            }
        }
    }

    private void keepPossiblyReferencedResources() {
        if (!this.mFoundGetIdentifier && !this.mFoundWebContent || this.mStrings == null) {
            return;
        }
        if (!this.mGuessKeep) {
            return;
        }
        if (this.mDebug) {
            ArrayList<String> strings = new ArrayList<String>(this.mStrings);
            Collections.sort(strings);
            System.out.println("android.content.res.Resources#getIdentifier present: " + this.mFoundGetIdentifier);
            System.out.println("Web content present: " + this.mFoundWebContent);
            System.out.println("Referenced Strings:");
            for (String s : strings) {
                if ((s = s.trim().replace("\n", "\\n")).length() > 40) {
                    s = s.substring(0, 37) + "...";
                } else if (s.isEmpty()) continue;
                System.out.println("  " + s);
            }
        }
        int shortest = Integer.MAX_VALUE;
        HashSet names = Sets.newHashSetWithExpectedSize((int)50);
        for (Map<String, Resource> map : this.mTypeToName.values()) {
            for (String name : map.keySet()) {
                names.add(name);
                int length = name.length();
                if (length >= shortest) continue;
                shortest = length;
            }
        }
        for (String string : this.mStrings) {
            String name;
            if (string.length() < shortest) continue;
            if (this.mFoundWebContent) {
                int dot;
                String name2;
                Resource resource = this.getResourceFromFilePath(string);
                if (resource != null) {
                    ResourceUsageAnalyzer.markReachable(resource);
                    continue;
                }
                int start = 0;
                int slash = string.lastIndexOf(47);
                if (slash != -1) {
                    start = slash + 1;
                }
                if (names.contains(name2 = string.substring(start, (dot = string.indexOf(46, start)) != -1 ? dot : string.length()))) {
                    for (Map<String, Resource> map : this.mTypeToName.values()) {
                        resource = map.get(name2);
                        if (this.mDebug && resource != null) {
                            System.out.println("Marking " + resource + " used because it " + "matches string pool constant " + string);
                        }
                        ResourceUsageAnalyzer.markReachable(resource);
                    }
                }
            }
            int n = string.length();
            boolean justName = true;
            boolean formatting = false;
            boolean haveSlash = false;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '/') {
                    haveSlash = true;
                    justName = false;
                    continue;
                }
                if (c == '.' || c == ':' || c == '%') {
                    justName = false;
                    if (c != '%') continue;
                    formatting = true;
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) continue;
                assert (false) : string;
                break;
            }
            if (justName) {
                name = string;
                for (Map<String, Resource> map : this.mTypeToName.values()) {
                    for (Resource resource : map.values()) {
                        if (!resource.name.startsWith(name)) continue;
                        if (this.mDebug) {
                            System.out.println("Marking " + resource + " used because its " + "prefix matches string pool constant " + string);
                        }
                        ResourceUsageAnalyzer.markReachable(resource);
                    }
                }
            } else {
                if (!haveSlash) {
                    if (!formatting) continue;
                    try {
                        Pattern pattern = Pattern.compile(ResourceUsageAnalyzer.convertFormatStringToRegexp(string));
                        for (Map<String, Resource> map : this.mTypeToName.values()) {
                            for (Resource resource : map.values()) {
                                if (!pattern.matcher(resource.name).matches()) continue;
                                if (this.mDebug) {
                                    System.out.println("Marking " + resource + " used because " + "it format-string matches string pool constant " + string);
                                }
                                ResourceUsageAnalyzer.markReachable(resource);
                            }
                        }
                        continue;
                    }
                    catch (PatternSyntaxException ignored) {
                        continue;
                    }
                }
                int slash = string.indexOf(47);
                assert (slash != -1);
                name = string.substring(slash + 1);
                if (name.isEmpty() || !names.contains(name)) continue;
                if (slash > 0) {
                    Resource resource;
                    int colon = string.indexOf(58);
                    String typeName = string.substring(colon != -1 ? colon + 1 : 0, slash);
                    ResourceType type = ResourceType.getEnum((String)typeName);
                    if (type == null) continue;
                    resource = this.getResource(type, name);
                    if (this.mDebug && resource != null) {
                        System.out.println("Marking " + resource + " used because it " + "matches string pool constant " + string);
                    }
                    ResourceUsageAnalyzer.markReachable(resource);
                    continue;
                }
            }
            if (names.contains(name)) {
                for (Map<String, Resource> map : this.mTypeToName.values()) {
                    Resource resource = map.get(name);
                    if (this.mDebug && resource != null) {
                        System.out.println("Marking " + resource + " used because it " + "matches string pool constant " + string);
                    }
                    ResourceUsageAnalyzer.markReachable(resource);
                }
                continue;
            }
            if (!Character.isDigit(name.charAt(0))) continue;
            try {
                int id = Integer.parseInt(name);
                if (id == 0) continue;
                ResourceUsageAnalyzer.markReachable(this.mValueToResource.get(id));
            }
            catch (NumberFormatException e) {
            }
        }
    }

    static String convertFormatStringToRegexp(String formatString) {
        StringBuilder regexp = new StringBuilder();
        int from = 0;
        boolean hasEscapedLetters = false;
        Matcher matcher = StringFormatDetector.FORMAT.matcher(formatString);
        int length = formatString.length();
        while (matcher.find(from)) {
            int regexLength;
            int start = matcher.start();
            int end = matcher.end();
            if (start == 0 && end == length) {
                return NO_MATCH;
            }
            if (start > from) {
                hasEscapedLetters |= ResourceUsageAnalyzer.appendEscapedPattern(formatString, regexp, from, start);
            }
            if ((regexLength = regexp.length()) < 2 || regexp.charAt(regexLength - 1) != '*' || regexp.charAt(regexLength - 2) != '.') {
                regexp.append(".*");
            }
            from = end;
        }
        if (from < length) {
            hasEscapedLetters |= ResourceUsageAnalyzer.appendEscapedPattern(formatString, regexp, from, length);
        }
        if (!hasEscapedLetters) {
            return NO_MATCH;
        }
        return regexp.toString();
    }

    private static boolean appendEscapedPattern(@NonNull String formatString, @NonNull StringBuilder regexp, int from, int to) {
        regexp.append(Pattern.quote(formatString.substring(from, to)));
        for (int i = from; i < to; ++i) {
            if (!Character.isLetter(formatString.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private void recordResources(File resDir) throws IOException, SAXException, ParserConfigurationException {
        File[] resourceFolders = resDir.listFiles();
        if (resourceFolders != null) {
            for (File folder : resourceFolders) {
                ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folder.getName());
                if (folderType == null) continue;
                this.recordResources(folderType, folder);
            }
        }
    }

    private void recordResources(@NonNull ResourceFolderType folderType, File folder) throws ParserConfigurationException, SAXException, IOException {
        File[] files = folder.listFiles();
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)folder.getName());
        boolean isDefaultFolder = false;
        if (config != null) {
            isDefaultFolder = true;
            int n = FolderConfiguration.getQualifierCount();
            for (int i = 0; i < n; ++i) {
                ResourceQualifier qualifier = config.getQualifier(i);
                if (qualifier == null || qualifier instanceof DensityQualifier) continue;
                isDefaultFolder = false;
                break;
            }
        }
        if (files != null) {
            for (File file : files) {
                String path = file.getPath();
                boolean isXml = SdkUtils.endsWithIgnoreCase((String)path, (String)".xml");
                Resource from = null;
                if (folderType != ResourceFolderType.VALUES && (isXml || SdkUtils.endsWith((CharSequence)path, (CharSequence)".png") || SdkUtils.endsWith((CharSequence)path, (CharSequence)".jpg") || SdkUtils.endsWith((CharSequence)path, (CharSequence)".gif") || SdkUtils.endsWith((CharSequence)path, (CharSequence)".jpeg"))) {
                    List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                    ResourceType type = (ResourceType)types.get(0);
                    assert (type != ResourceType.ID) : folderType;
                    String name = file.getName();
                    Resource resource = this.getResource(type, name = name.substring(0, name.indexOf(46)));
                    if (resource != null) {
                        resource.addLocation(file);
                        if (isDefaultFolder) {
                            resource.hasDefault = true;
                        }
                        from = resource;
                    }
                }
                if (isXml) {
                    this.recordXmlResourcesUsages(file, isDefaultFolder, from);
                    if (folderType != ResourceFolderType.XML) continue;
                    this.tokenizeUnknownText(Files.toString((File)file, (Charset)Charsets.UTF_8));
                    continue;
                }
                if (folderType != ResourceFolderType.RAW) continue;
                if (SdkUtils.endsWithIgnoreCase((String)path, (String)".html") || SdkUtils.endsWithIgnoreCase((String)path, (String)".htm")) {
                    this.tokenizeHtml(from, Files.toString((File)file, (Charset)Charsets.UTF_8));
                    continue;
                }
                if (SdkUtils.endsWithIgnoreCase((String)path, (String)".css")) {
                    this.tokenizeCss(from, Files.toString((File)file, (Charset)Charsets.UTF_8));
                    continue;
                }
                if (SdkUtils.endsWithIgnoreCase((String)path, (String)".js")) {
                    this.tokenizeJs(from, Files.toString((File)file, (Charset)Charsets.UTF_8));
                    continue;
                }
                if (!file.isFile() || LintUtils.isBitmapFile((File)file)) continue;
                this.tokenizeUnknownBinary(file);
            }
        }
    }

    private void recordMapping(@Nullable File mapping) throws IOException {
        if (mapping == null || !mapping.exists()) {
            return;
        }
        String ARROW = " -> ";
        String RESOURCE = ".R$";
        for (String line : Files.readLines((File)mapping, (Charset)Charsets.UTF_8)) {
            String typeName;
            ResourceType type;
            int arrow;
            int index;
            if (line.startsWith(" ") || line.startsWith("\t") || (index = line.indexOf(".R$")) == -1 || (arrow = line.indexOf(" -> ", index + 3)) == -1 || (type = ResourceType.getEnum((String)(typeName = line.substring(index + ".R$".length(), arrow)))) == null) continue;
            int end = line.indexOf(58, arrow + " -> ".length());
            if (end == -1) {
                end = line.length();
            }
            String target = line.substring(arrow + " -> ".length(), end).trim();
            String ownerName = target.replace('.', '/');
            this.mResourceClassOwners.put(ownerName, type);
        }
    }

    private void recordManifestUsages(File manifest) throws IOException, ParserConfigurationException, SAXException {
        String xml = Files.toString((File)manifest, (Charset)Charsets.UTF_8);
        Document document = XmlUtils.parseDocument((String)xml, (boolean)true);
        this.recordManifestUsages(document.getDocumentElement());
    }

    private void recordXmlResourcesUsages(@NonNull File file, boolean isDefaultFolder, @Nullable Resource from) throws IOException, ParserConfigurationException, SAXException {
        String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
        Document document = XmlUtils.parseDocument((String)xml, (boolean)true);
        this.recordResourceReferences(file, isDefaultFolder, document.getDocumentElement(), from);
    }

    private void tokenizeHtml(@Nullable Resource from, @NonNull String html) {
        int length = html.length();
        boolean STATE_TEXT = true;
        int STATE_SLASH = 2;
        int STATE_ATTRIBUTE_NAME = 3;
        int STATE_BEFORE_TAG = 4;
        int STATE_IN_TAG = 5;
        int STATE_BEFORE_ATTRIBUTE = 6;
        int STATE_ATTRIBUTE_BEFORE_EQUALS = 7;
        int STATE_ATTRIBUTE_AFTER_EQUALS = 8;
        int STATE_ATTRIBUTE_VALUE_NONE = 9;
        int STATE_ATTRIBUTE_VALUE_SINGLE = 10;
        int STATE_ATTRIBUTE_VALUE_DOUBLE = 11;
        int STATE_CLOSE_TAG = 12;
        int state = 1;
        int offset = 0;
        int valueStart = 0;
        int tagStart = 0;
        String tag = null;
        String attribute = null;
        int attributeStart = 0;
        int prev = -1;
        block14: while (offset < length) {
            if (offset == prev) {
                // empty if block
            }
            prev = ++offset;
            char c = html.charAt(offset);
            switch (state) {
                case 1: {
                    if (c == '<') {
                        state = 2;
                        ++offset;
                        continue block14;
                    }
                    ++offset;
                    continue block14;
                }
                case 2: {
                    int end;
                    if (c == '!') {
                        if (html.startsWith("!--", offset)) {
                            end = html.indexOf("-->", offset + 3);
                            if (end == -1) {
                                offset = length;
                                continue block14;
                            }
                            offset = end + 3;
                            continue block14;
                        }
                        if (html.startsWith("![CDATA[", offset)) {
                            end = html.indexOf("]]>", offset + 8);
                            if (end == -1) {
                                offset = length;
                                continue block14;
                            }
                            offset = end + 3;
                            continue block14;
                        }
                    } else {
                        if (c == '/') {
                            state = 12;
                            ++offset;
                            continue block14;
                        }
                        if (c == '?') {
                            end = html.indexOf(62, offset + 2);
                            if (end == -1) {
                                offset = length;
                                continue block14;
                            }
                            offset = end + 1;
                            continue block14;
                        }
                    }
                    state = 5;
                    tagStart = offset;
                    continue block14;
                }
                case 12: {
                    if (c == '>') {
                        state = 1;
                    }
                    ++offset;
                    continue block14;
                }
                case 4: {
                    if (!Character.isWhitespace(c)) {
                        state = 5;
                        tagStart = offset;
                    }
                    ++offset;
                    continue block14;
                }
                case 5: {
                    if (Character.isWhitespace(c)) {
                        state = 6;
                        tag = html.substring(tagStart, offset).trim();
                    } else if (c == '>') {
                        tag = html.substring(tagStart, offset).trim();
                        this.endHtmlTag(from, html, offset, tag);
                        state = 1;
                    }
                    ++offset;
                    continue block14;
                }
                case 6: {
                    if (c == '>') {
                        this.endHtmlTag(from, html, offset, tag);
                        state = 1;
                    } else if (c != '/' && !Character.isWhitespace(c)) {
                        state = 3;
                        attributeStart = offset;
                    }
                    ++offset;
                    continue block14;
                }
                case 3: {
                    if (c == '>') {
                        this.endHtmlTag(from, html, offset, tag);
                        state = 1;
                    } else if (c == '=') {
                        attribute = html.substring(attributeStart, offset);
                        state = 8;
                    } else if (Character.isWhitespace(c)) {
                        attribute = html.substring(attributeStart, offset);
                        state = 7;
                    }
                    ++offset;
                    continue block14;
                }
                case 7: {
                    if (c == '=') {
                        state = 8;
                    } else if (c == '>') {
                        this.endHtmlTag(from, html, offset, tag);
                        state = 1;
                    } else if (!Character.isWhitespace(c)) {
                        state = 3;
                        attributeStart = offset;
                    }
                    ++offset;
                    continue block14;
                }
                case 8: {
                    if (c == '\'') {
                        state = 10;
                        valueStart = offset + 1;
                    } else if (c == '\"') {
                        state = 11;
                        valueStart = offset + 1;
                    } else if (!Character.isWhitespace(c)) {
                        state = 9;
                        valueStart = offset + 1;
                    }
                    ++offset;
                    continue block14;
                }
                case 10: {
                    if (c == '\'') {
                        state = 6;
                        this.recordHtmlAttributeValue(from, tag, attribute, html.substring(valueStart, offset));
                    }
                    ++offset;
                    continue block14;
                }
                case 11: {
                    if (c == '\"') {
                        state = 6;
                        this.recordHtmlAttributeValue(from, tag, attribute, html.substring(valueStart, offset));
                    }
                    ++offset;
                    continue block14;
                }
                case 9: {
                    if (c == '>') {
                        this.recordHtmlAttributeValue(from, tag, attribute, html.substring(valueStart, offset));
                        this.endHtmlTag(from, html, offset, tag);
                        state = 1;
                    } else if (Character.isWhitespace(c)) {
                        state = 6;
                        this.recordHtmlAttributeValue(from, tag, attribute, html.substring(valueStart, offset));
                    }
                    ++offset;
                    continue block14;
                }
            }
            assert (false) : state;
        }
    }

    private void endHtmlTag(@Nullable Resource from, @NonNull String html, int offset, @Nullable String tag) {
        int end;
        if ("script".equals(tag)) {
            int end2 = html.indexOf("</script>", offset + 1);
            if (end2 != -1) {
                String js = html.substring(offset + 1, end2);
                this.tokenizeJs(from, js);
            }
        } else if ("style".equals(tag) && (end = html.indexOf("</style>", offset + 1)) != -1) {
            String css = html.substring(offset + 1, end);
            this.tokenizeCss(from, css);
        }
    }

    private void tokenizeJs(@Nullable Resource from, @NonNull String js) {
        int length = js.length();
        boolean STATE_INIT = true;
        int STATE_SLASH = 2;
        int STATE_STRING_DOUBLE = 3;
        int STATE_STRING_DOUBLE_QUOTED = 4;
        int STATE_STRING_SINGLE = 5;
        int STATE_STRING_SINGLE_QUOTED = 6;
        int state = 1;
        int offset = 0;
        int stringStart = 0;
        int prev = -1;
        block8: while (offset < length) {
            if (offset == prev) {
                // empty if block
            }
            prev = ++offset;
            char c = js.charAt(offset);
            switch (state) {
                case 1: {
                    if (c == '/') {
                        state = 2;
                    } else if (c == '\"') {
                        stringStart = offset + 1;
                        state = 3;
                    } else if (c == '\'') {
                        stringStart = offset + 1;
                        state = 5;
                    }
                    ++offset;
                    continue block8;
                }
                case 2: {
                    int end;
                    if (c == '*') {
                        state = 1;
                        end = js.indexOf("*/", offset + 1);
                        if (end == -1) {
                            offset = length;
                            continue block8;
                        }
                        offset = end + 2;
                        continue block8;
                    }
                    if (c == '/') {
                        state = 1;
                        end = js.indexOf(10, offset + 1);
                        if (end == -1) {
                            offset = length;
                            continue block8;
                        }
                        offset = end + 1;
                        continue block8;
                    }
                    state = 1;
                    ++offset;
                    continue block8;
                }
                case 3: {
                    if (c == '\"') {
                        this.recordJsString(js.substring(stringStart, offset));
                        state = 1;
                    } else if (c == '\\') {
                        state = 4;
                    }
                    ++offset;
                    continue block8;
                }
                case 4: {
                    state = 3;
                    ++offset;
                    continue block8;
                }
                case 5: {
                    if (c == '\'') {
                        this.recordJsString(js.substring(stringStart, offset));
                        state = 1;
                    } else if (c == '\\') {
                        state = 6;
                    }
                    ++offset;
                    continue block8;
                }
                case 6: {
                    state = 5;
                    ++offset;
                    continue block8;
                }
            }
            assert (false) : state;
        }
    }

    private void tokenizeCss(@Nullable Resource from, @NonNull String css) {
        int length = css.length();
        boolean STATE_INIT = true;
        int STATE_SLASH = 2;
        int state = 1;
        int offset = 0;
        int prev = -1;
        block4: while (offset < length) {
            if (offset == prev) {
                // empty if block
            }
            prev = ++offset;
            char c = css.charAt(offset);
            switch (state) {
                case 1: {
                    char prevChar;
                    if (c == '/') {
                        state = 2;
                    } else if (c == 'u' && css.startsWith("url(", offset) && offset > 0 && (Character.isWhitespace(prevChar = css.charAt(offset - 1)) || prevChar == ':')) {
                        int end = css.indexOf(41, offset);
                        offset += 4;
                        while (offset < length && Character.isWhitespace(css.charAt(offset))) {
                            ++offset;
                        }
                        if (end != -1 && end > offset + 1) {
                            while (end > offset && Character.isWhitespace(css.charAt(end - 1))) {
                                --end;
                            }
                            if (css.charAt(offset) == '\"' && css.charAt(end - 1) == '\"' || css.charAt(offset) == '\'' && css.charAt(end - 1) == '\'') {
                                ++offset;
                                --end;
                            }
                            this.recordCssUrl(from, css.substring(offset, end).trim());
                        }
                        offset = end + 1;
                        continue block4;
                    }
                    ++offset;
                    continue block4;
                }
                case 2: {
                    if (c == '*') {
                        int end = css.indexOf("*/", offset + 1);
                        if (end == -1) {
                            offset = length;
                            continue block4;
                        }
                        offset = end + 2;
                        continue block4;
                    }
                    state = 1;
                    ++offset;
                    continue block4;
                }
            }
            assert (false) : state;
        }
    }

    private void tokenizeUnknownBinary(@NonNull File file) {
        try {
            if (sAndroidResBytes == null) {
                sAndroidResBytes = ANDROID_RES.getBytes("UTF-8");
            }
            byte[] bytes = Files.toByteArray((File)file);
            int index = 0;
            block2: while (index != -1) {
                int begin;
                if ((index = ResourceUsageAnalyzer.indexOf(bytes, sAndroidResBytes, index)) == -1) continue;
                for (int end = begin = (index += sAndroidResBytes.length); end < bytes.length; ++end) {
                    byte c = bytes[end];
                    if (c == 47 || Character.isJavaIdentifierPart((char)c)) continue;
                    String url = "@" + new String(bytes, begin, end - begin, Charsets.UTF_8);
                    ResourceUsageAnalyzer.markReachable(this.getResourceFromUrl(url));
                    continue block2;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static int indexOf(byte[] array, byte[] target, int fromIndex) {
        block0: for (int i = fromIndex; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    private void tokenizeUnknownText(@NonNull String text) {
        int index = 0;
        block0: while (index != -1) {
            int begin;
            if ((index = text.indexOf(ANDROID_RES, index)) == -1) continue;
            int length = text.length();
            for (int end = begin = (index += ANDROID_RES.length()); end < length; ++end) {
                char c = text.charAt(end);
                if (c == '/' || Character.isJavaIdentifierPart(c)) continue;
                ResourceUsageAnalyzer.markReachable(this.getResourceFromUrl("@" + text.substring(begin, end)));
                continue block0;
            }
        }
    }

    private void recordCssUrl(@Nullable Resource from, @NonNull String value) {
        if (!this.referencedUrl(from, value)) {
            this.referencedString(value);
            this.mFoundWebContent = true;
        }
    }

    private boolean referencedUrl(@Nullable Resource from, @NonNull String url) {
        Resource resource = this.getResourceFromFilePath(url);
        if (resource != null) {
            if (from != null) {
                from.addReference(resource);
            } else {
                ResourceUsageAnalyzer.markReachable(resource);
            }
            return true;
        }
        return false;
    }

    private void recordHtmlAttributeValue(@Nullable Resource from, @Nullable String tagName, @Nullable String attribute, @NonNull String value) {
        if ("href".equals(attribute) || "src".equals(attribute)) {
            if (!this.referencedUrl(from, value)) {
                this.referencedString(value);
                this.mFoundWebContent = true;
            }
            if (from != null) {
                from.addReference(this.getResourceFromFilePath(attribute));
            }
        }
    }

    private void recordJsString(@NonNull String string) {
        this.referencedString(string);
    }

    @Nullable
    private Resource getResource(@NonNull ResourceType type, @NonNull String name) {
        Map<String, Resource> nameMap = this.mTypeToName.get(type);
        if (nameMap != null) {
            return nameMap.get(ResourceUsageAnalyzer.getFieldName(name));
        }
        return null;
    }

    @Nullable
    private Resource getResourceFromUrl(@NonNull String possibleUrlReference) {
        ResourceUrl url = ResourceUrl.parse((String)possibleUrlReference);
        if (url != null && !url.framework) {
            return this.getResource(url.type, url.name);
        }
        return null;
    }

    @Nullable
    private Resource getResourceFromFilePath(@NonNull String url) {
        List types;
        String folderName;
        ResourceFolderType folderType;
        int slash;
        int nameSlash = url.lastIndexOf(47);
        if (nameSlash == -1) {
            return null;
        }
        int androidRes = url.indexOf(ANDROID_RES);
        if (androidRes != -1 && (slash = url.indexOf(47, androidRes += ANDROID_RES.length())) != -1 && (folderType = ResourceFolderType.getFolderType((String)(folderName = url.substring(androidRes, slash)))) != null && !(types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)).isEmpty()) {
            int nameBegin;
            ResourceType type = (ResourceType)types.get(0);
            int dot = url.indexOf(46, nameBegin = slash + 1);
            String name = url.substring(nameBegin, dot != -1 ? dot : url.length());
            return this.getResource(type, name);
        }
        int typeSlash = url.lastIndexOf(47, nameSlash - 1);
        ResourceType type = ResourceType.getEnum((String)url.substring(typeSlash + 1, nameSlash));
        if (type != null) {
            int nameBegin;
            int dot = url.indexOf(46, nameBegin = nameSlash + 1);
            String name = url.substring(nameBegin, dot != -1 ? dot : url.length());
            return this.getResource(type, name);
        }
        return null;
    }

    private void recordManifestUsages(Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 1) {
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)attributes.item(i);
                ResourceUsageAnalyzer.markReachable(this.getResourceFromUrl(attr.getValue()));
            }
        } else if (nodeType == 3) {
            String text = node.getNodeValue().trim();
            ResourceUsageAnalyzer.markReachable(this.getResourceFromUrl(text));
        }
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            this.recordManifestUsages(child);
        }
    }

    private void recordResourceReferences(@NonNull File file, boolean isDefaultFolder, @NonNull Node node, @Nullable Resource from) {
        block18: {
            String text;
            Resource textResource;
            short nodeType;
            block15: {
                String name;
                String tagName;
                Resource definition;
                Element element;
                block16: {
                    int index;
                    block17: {
                        Resource ps;
                        nodeType = node.getNodeType();
                        if (nodeType != 1) break block15;
                        element = (Element)node;
                        if (from != null) {
                            NamedNodeMap attributes = element.getAttributes();
                            int n = attributes.getLength();
                            for (int i = 0; i < n; ++i) {
                                Attr attr = (Attr)attributes.item(i);
                                if ("http://schemas.android.com/tools".equals(attr.getNamespaceURI())) {
                                    this.handleToolsAttribute(attr);
                                    continue;
                                }
                                Resource resource = this.getResourceFromUrl(attr.getValue());
                                if (resource == null) continue;
                                from.addReference(resource);
                            }
                            if ("rawPathResId".equals(element.getTagName())) {
                                StringBuilder sb = new StringBuilder();
                                NodeList children = node.getChildNodes();
                                int n2 = children.getLength();
                                for (int i = 0; i < n2; ++i) {
                                    Node child = children.item(i);
                                    if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
                                    sb.append(child.getNodeValue());
                                }
                                if (sb.length() > 0) {
                                    Resource resource = this.getResource(ResourceType.RAW, sb.toString().trim());
                                    from.addReference(resource);
                                }
                            }
                        } else {
                            this.handleToolsAttribute(element.getAttributeNodeNS("http://schemas.android.com/tools", ATTR_KEEP));
                            this.handleToolsAttribute(element.getAttributeNodeNS("http://schemas.android.com/tools", ATTR_DISCARD));
                            this.handleToolsAttribute(element.getAttributeNodeNS("http://schemas.android.com/tools", ATTR_SHRINK_MODE));
                        }
                        definition = this.getResource(element);
                        if (definition != null) {
                            from = definition;
                            definition.addLocation(file);
                            if (isDefaultFolder) {
                                definition.hasDefault = true;
                            }
                        }
                        if (!"style".equals(tagName = element.getTagName())) break block16;
                        if (!element.hasAttribute("parent")) break block17;
                        String parent = element.getAttribute("parent");
                        if (parent.isEmpty() || parent.startsWith("@android:style/") || parent.startsWith("android:")) break block16;
                        String parentStyle = parent;
                        if (!parentStyle.startsWith("@style/")) {
                            parentStyle = "@style/" + parentStyle;
                        }
                        if ((ps = this.getResourceFromUrl(ResourceUsageAnalyzer.getFieldName(parentStyle))) == null || definition == null) break block16;
                        definition.addReference(ps);
                        break block16;
                    }
                    String name2 = ResourceUsageAnalyzer.getFieldName(element);
                    while ((index = name2.lastIndexOf(95)) != -1) {
                        name2 = name2.substring(0, index);
                        Resource ps = this.getResourceFromUrl("@style/" + ResourceUsageAnalyzer.getFieldName(name2));
                        if (ps == null || definition == null) continue;
                        definition.addReference(ps);
                    }
                }
                if ("item".equals(tagName) && element.getParentNode() != null && element.getParentNode().getNodeName().equals("style") && !(name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty() && !name.startsWith("android:")) {
                    Element style;
                    Resource resource = this.getResource(ResourceType.ATTR, name);
                    if (definition == null && (definition = this.getResource(style = (Element)element.getParentNode())) != null) {
                        from = definition;
                        definition.addReference(resource);
                    }
                }
                break block18;
            }
            if ((nodeType == 3 || nodeType == 4) && (textResource = this.getResourceFromUrl(ResourceUsageAnalyzer.getFieldName(text = node.getNodeValue().trim()))) != null && from != null) {
                from.addReference(textResource);
            }
        }
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            this.recordResourceReferences(file, isDefaultFolder, child, from);
        }
    }

    private void handleToolsAttribute(@Nullable Attr attr) {
        if (attr == null) {
            return;
        }
        String localName = attr.getLocalName();
        String value = attr.getValue();
        if (ATTR_KEEP.equals(localName)) {
            this.handleKeepAttribute(value);
        } else if (ATTR_DISCARD.equals(localName)) {
            this.handleRemoveAttribute(value);
        } else if (ATTR_SHRINK_MODE.equals(localName)) {
            if (VALUE_STRICT.equals(value)) {
                this.mGuessKeep = false;
            } else if (VALUE_SAFE.equals(value)) {
                this.mGuessKeep = true;
            } else if (this.mDebug) {
                System.out.println("Ignoring unknown shrinkMode " + value);
            }
            if (this.mDebug) {
                System.out.println("Setting shrink mode to " + value);
            }
        }
    }

    public static String getFieldName(@NonNull String styleName) {
        return styleName.replace('.', '_').replace('-', '_').replace(':', '_');
    }

    private static void markReachable(@Nullable Resource resource) {
        if (resource != null) {
            resource.reachable = true;
        }
    }

    private static void markUnreachable(@Nullable Resource resource) {
        if (resource != null) {
            resource.reachable = false;
        }
    }

    private void handleKeepAttribute(@NonNull String value) {
        block12: {
            if (value.indexOf(44) != -1) {
                for (String portion : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value)) {
                    this.handleKeepAttribute(portion);
                }
                return;
            }
            ResourceUrl url = ResourceUrl.parse((String)value);
            if (url == null || url.framework) {
                return;
            }
            Resource resource = this.getResource(url.type, url.name);
            if (resource != null) {
                if (this.mDebug) {
                    System.out.println("Marking " + resource + " used because it " + "matches keep attribute " + value);
                }
                ResourceUsageAnalyzer.markReachable(resource);
            } else if (url.name.contains("*") || url.name.contains("?")) {
                String regexp = DefaultConfiguration.globToRegexp((String)ResourceUsageAnalyzer.getFieldName(url.name));
                try {
                    Pattern pattern = Pattern.compile(regexp);
                    Map<String, Resource> nameMap = this.mTypeToName.get(url.type);
                    if (nameMap != null) {
                        for (Resource r : nameMap.values()) {
                            if (!pattern.matcher(r.name).matches()) continue;
                            if (this.mDebug) {
                                System.out.println("Marking " + r + " used because it " + "matches keep globbing pattern " + url.name);
                            }
                            ResourceUsageAnalyzer.markReachable(r);
                        }
                    }
                }
                catch (PatternSyntaxException ignored) {
                    if (!this.mDebug) break block12;
                    System.out.println("Could not compute keep globbing pattern for " + url.name + ": tried regexp " + regexp + "(" + ignored + ")");
                }
            }
        }
    }

    private void handleRemoveAttribute(@NonNull String value) {
        block12: {
            if (value.indexOf(44) != -1) {
                for (String portion : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value)) {
                    this.handleRemoveAttribute(portion);
                }
                return;
            }
            ResourceUrl url = ResourceUrl.parse((String)value);
            if (url == null || url.framework) {
                return;
            }
            Resource resource = this.getResource(url.type, url.name);
            if (resource != null) {
                if (this.mDebug) {
                    System.out.println("Marking " + resource + " used because it " + "matches remove attribute " + value);
                }
                ResourceUsageAnalyzer.markUnreachable(resource);
            } else if (url.name.contains("*") || url.name.contains("?")) {
                String regexp = DefaultConfiguration.globToRegexp((String)ResourceUsageAnalyzer.getFieldName(url.name));
                try {
                    Pattern pattern = Pattern.compile(regexp);
                    Map<String, Resource> nameMap = this.mTypeToName.get(url.type);
                    if (nameMap != null) {
                        for (Resource r : nameMap.values()) {
                            if (!pattern.matcher(r.name).matches()) continue;
                            if (this.mDebug) {
                                System.out.println("Marking " + r + " used because it " + "matches remove globbing pattern " + url.name);
                            }
                            ResourceUsageAnalyzer.markUnreachable(r);
                        }
                    }
                }
                catch (PatternSyntaxException ignored) {
                    if (!this.mDebug) break block12;
                    System.out.println("Could not compute remove globbing pattern for " + url.name + ": tried regexp " + regexp + "(" + ignored + ")");
                }
            }
        }
    }

    private void referencedString(@NonNull String string) {
        if (string.isEmpty() || string.length() > 80) {
            return;
        }
        boolean haveIdentifierChar = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean identifierChar = Character.isJavaIdentifierPart(c);
            if (!identifierChar && c != '.' && c != ':' && c != '/' && c != '%') {
                return;
            }
            if (!identifierChar) continue;
            haveIdentifierChar = true;
        }
        if (!haveIdentifierChar) {
            return;
        }
        if (this.mStrings == null) {
            this.mStrings = Sets.newHashSetWithExpectedSize((int)300);
        }
        this.mStrings.add(string);
        if (!this.mFoundWebContent && string.contains(ANDROID_RES)) {
            this.mFoundWebContent = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordUsages(File jarFile) throws IOException {
        if (!jarFile.exists()) {
            return;
        }
        ZipInputStream zis = null;
        try {
            FileInputStream fis = new FileInputStream(jarFile);
            try {
                zis = new ZipInputStream(fis);
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    byte[] bytes;
                    String name = entry.getName();
                    if (name.endsWith(".class") && (bytes = ByteStreams.toByteArray((InputStream)zis)) != null) {
                        ClassReader classReader = new ClassReader(bytes);
                        classReader.accept((ClassVisitor)new UsageVisitor(), 6);
                    }
                    entry = zis.getNextEntry();
                }
            }
            finally {
                Closeables.close((Closeable)fis, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            Closeables.close(zis, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)zis, (boolean)true);
    }

    private void gatherResourceValues(File file) throws IOException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.gatherResourceValues(child);
                }
            }
        } else if (file.isFile() && file.getName().equals("R.java")) {
            this.parseResourceClass(file);
        }
    }

    private void parseResourceClass(File file) throws IOException {
        String typeName;
        ResourceType type;
        int start;
        int end;
        String s = Files.toString((File)file, (Charset)Charsets.UTF_8);
        String pkg = null;
        int index = s.indexOf("package ");
        if (index != -1) {
            int end2 = s.indexOf(59, index);
            pkg = s.substring(index + "package ".length(), end2).trim().replace('.', '/');
        }
        index = 0;
        int length = s.length();
        String classDeclaration = "public static final class ";
        block0: while ((index = s.indexOf(classDeclaration, index)) != -1 && (end = s.indexOf(32, start = index + classDeclaration.length())) != -1 && (type = ResourceType.getEnum((String)(typeName = s.substring(start, end)))) != null) {
            if (pkg != null) {
                this.mResourceClassOwners.put(pkg + "/R$" + type.getName(), type);
            }
            for (index = end; index < length - 1; ++index) {
                char c = s.charAt(index);
                if (Character.isWhitespace(c)) continue;
                if (c == '/') {
                    char next = s.charAt(index + 1);
                    if (next == '*') {
                        for (end = index + 2; end < length - 2; ++end) {
                            c = s.charAt(end);
                            if (c != '*' || s.charAt(end + 1) != '/') continue;
                            ++end;
                            break;
                        }
                        index = end;
                        continue;
                    }
                    if (next == '/' ? !$assertionsDisabled : !$assertionsDisabled) {
                        throw new AssertionError((Object)s.substring(index - 1, index + 50));
                    }
                    continue;
                }
                if (c == 'p' && s.startsWith("public ", index)) {
                    if (type == ResourceType.STYLEABLE) {
                        start = s.indexOf(" int", index);
                        if (s.startsWith(" int[] ", start)) {
                            end = s.indexOf(61, start);
                            assert (end != -1);
                            String styleable = s.substring(start, end).trim();
                            this.addResource(ResourceType.DECLARE_STYLEABLE, styleable, null);
                            continue;
                        }
                        if (!s.startsWith(" int ") || (index = s.indexOf(59, index)) != -1) continue;
                        continue block0;
                    }
                    start = s.indexOf(" int ", index);
                    if (start == -1) continue;
                    end = s.indexOf(61, start += " int ".length());
                    assert (end != -1);
                    String name = s.substring(start, end).trim();
                    start = end + 1;
                    end = s.indexOf(59, start);
                    assert (end != -1);
                    String value = s.substring(start, end).trim();
                    this.addResource(type, name, value);
                    continue;
                }
                if (c == '}') continue block0;
            }
        }
    }

    private void addResource(@NonNull ResourceType type, @NonNull String name, @Nullable String value) {
        HashMap nameMap;
        int realValue = value != null ? Integer.decode(value) : -1;
        Resource resource = this.getResource(type, name);
        if (resource != null) {
            if (value != null) {
                if (resource.value == -1) {
                    resource.value = realValue;
                } else assert (realValue == resource.value);
            }
            return;
        }
        resource = new Resource(type, name, realValue);
        this.mResources.add(resource);
        if (realValue != -1) {
            this.mValueToResource.put(realValue, resource);
        }
        if ((nameMap = this.mTypeToName.get(type)) == null) {
            nameMap = Maps.newHashMapWithExpectedSize((int)30);
            this.mTypeToName.put(type, nameMap);
        }
        nameMap.put(name, resource);
    }

    public int getUnusedResourceCount() {
        return this.mUnused.size();
    }

    List<Resource> getAllResources() {
        return this.mResources;
    }

    private void handleCodeConstant(@Nullable Object cst) {
        if (cst instanceof Integer) {
            Integer value = (Integer)cst;
            ResourceUsageAnalyzer.markReachable(this.mValueToResource.get(value));
        } else if (cst instanceof int[]) {
            int[] values;
            for (int value : values = (int[])cst) {
                ResourceUsageAnalyzer.markReachable(this.mValueToResource.get(value));
            }
        } else if (cst instanceof String) {
            String string = (String)cst;
            this.referencedString(string);
        }
    }

    String dumpResourceModel() {
        StringBuilder sb = new StringBuilder(1000);
        Collections.sort(this.mResources, new Comparator<Resource>(){

            @Override
            public int compare(Resource resource1, Resource resource2) {
                int delta = resource1.type.compareTo((Enum)resource2.type);
                if (delta != 0) {
                    return delta;
                }
                return resource1.name.compareTo(resource2.name);
            }
        });
        for (Resource resource : this.mResources) {
            sb.append(resource.getUrl()).append(" : reachable=").append(resource.reachable);
            sb.append("\n");
            if (resource.references == null) continue;
            for (Resource referenced : resource.references) {
                sb.append("    ");
                sb.append(referenced.getUrl());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private class AnnotationUsageVisitor
    extends AnnotationVisitor {
        public AnnotationUsageVisitor() {
            super(262144);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new AnnotationUsageVisitor();
        }

        public AnnotationVisitor visitArray(String name) {
            return new AnnotationUsageVisitor();
        }

        public void visit(String name, Object value) {
            ResourceUsageAnalyzer.this.handleCodeConstant(value);
            super.visit(name, value);
        }
    }

    private class UsageVisitor
    extends ClassVisitor {
        public UsageVisitor() {
            super(262144);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(262144){

                public void visitLdcInsn(Object cst) {
                    ResourceUsageAnalyzer.this.handleCodeConstant(cst);
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    Resource resource;
                    ResourceType type;
                    if (opcode == 178 && (type = (ResourceType)ResourceUsageAnalyzer.this.mResourceClassOwners.get(owner)) != null && (resource = ResourceUsageAnalyzer.this.getResource(type, name)) != null) {
                        ResourceUsageAnalyzer.markReachable(resource);
                    }
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    super.visitMethodInsn(opcode, owner, name, desc);
                    if (owner.equals("android/content/res/Resources") && name.equals("getIdentifier") && desc.equals("(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I")) {
                        ResourceUsageAnalyzer.this.mFoundGetIdentifier = true;
                    }
                    if (owner.equals("android/webkit/WebView") && name.startsWith("load")) {
                        ResourceUsageAnalyzer.this.mFoundWebContent = true;
                    }
                }

                public AnnotationVisitor visitAnnotationDefault() {
                    return new AnnotationUsageVisitor();
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return new AnnotationUsageVisitor();
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    return new AnnotationUsageVisitor();
                }
            };
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationUsageVisitor();
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ResourceUsageAnalyzer.this.handleCodeConstant(value);
            return new FieldVisitor(262144){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return new AnnotationUsageVisitor();
                }
            };
        }
    }

    public static class Resource {
        public ResourceType type;
        public String name;
        public int value;
        public boolean reachable;
        public boolean hasDefault;
        public List<Resource> references;
        public final List<File> declarations = Lists.newArrayList();

        private Resource(ResourceType type, String name, int value) {
            this.type = type;
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.type + ":" + this.name + ":" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resource resource = (Resource)o;
            if (this.name != null ? !this.name.equals(resource.name) : resource.name != null) {
                return false;
            }
            return this.type == resource.type;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public void addLocation(@NonNull File file) {
            this.declarations.add(file);
        }

        public void addReference(@Nullable Resource resource) {
            if (resource != null) {
                if (this.references == null) {
                    this.references = Lists.newArrayList();
                } else if (this.references.contains(resource)) {
                    return;
                }
                this.references.add(resource);
            }
        }

        public String getUrl() {
            return '@' + this.type.getName() + '/' + this.name;
        }

        public boolean isRelevantType() {
            return this.type != ResourceType.ID;
        }
    }
}

