/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp;

import com.android.ddmlib.JdwpHandshake;
import com.android.ddmlib.internal.jdwp.DdmCommandPacket;
import com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class JdwpConnectionReader {
    @VisibleForTesting
    static final String JDWP_DISCONNECT = "disconnect:";
    private ByteBuffer mReadBuffer;
    private SocketChannel mSocket;

    public JdwpConnectionReader(SocketChannel channelToReadFrom, int initialBufferSize) {
        this.mReadBuffer = ByteBuffer.allocate(initialBufferSize);
        this.mSocket = channelToReadFrom;
    }

    public int read() throws IOException {
        return this.mSocket.read(this.mReadBuffer);
    }

    public boolean isHostTransport() {
        return this.bufferOffsetStartsWith(4, "host:transport:");
    }

    public boolean isJdwpPid() {
        return this.bufferOffsetStartsWith(4, "jdwp:");
    }

    public boolean isDisconnect() {
        return this.bufferOffsetStartsWith(4, JDWP_DISCONNECT);
    }

    public boolean isHandshake() {
        return JdwpHandshake.findHandshake(this.mReadBuffer) == 1;
    }

    public DdmCommandPacket parseCommandPacket() {
        return new DdmCommandPacket(this.mReadBuffer);
    }

    public void consumeData(int length) {
        this.mReadBuffer.flip();
        this.mReadBuffer.position(length);
        this.mReadBuffer.compact();
    }

    public JdwpPacket readPacket() throws IOException {
        int packetLength = JdwpPacket.getPacketLength(this.mReadBuffer);
        if (packetLength <= 0) {
            return null;
        }
        if (this.mReadBuffer.capacity() < packetLength) {
            this.resizeBuffer(packetLength);
        }
        while (packetLength > this.mReadBuffer.position()) {
            this.mSocket.read(this.mReadBuffer);
        }
        JdwpPacket packet = JdwpPacket.findPacket(this.mReadBuffer);
        return packet;
    }

    private void resizeBuffer(int requestedSize) {
        ByteBuffer newBuffer = ByteBuffer.allocate(requestedSize);
        int currPosition = this.mReadBuffer.position();
        this.mReadBuffer.position(0);
        newBuffer.put(this.mReadBuffer);
        newBuffer.position(currPosition);
        this.mReadBuffer = newBuffer;
    }

    private boolean bufferOffsetStartsWith(int offset, String match) {
        int j = 0;
        for (int i = offset; j < match.length() && i < this.mReadBuffer.position(); ++i, ++j) {
            if (match.charAt(j) == this.mReadBuffer.get(i)) continue;
            return false;
        }
        return true;
    }
}

