/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForCompanionObjectInstanceFieldDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingField;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AccessorKind;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.AssertCodegenUtilKt;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PropertyCodegen;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.SourceInfo;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.DelegatingToPartContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.inline.DefaultSourceMapper;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public abstract class MemberCodegen<T extends KtPureElement>
implements InnerClassConsumer {
    public final GenerationState state;
    protected final T element;
    protected final FieldOwnerContext<?> context;
    public final ClassBuilder v;
    public final FunctionCodegen functionCodegen;
    public final PropertyCodegen propertyCodegen;
    public final KotlinTypeMapper typeMapper;
    public final BindingContext bindingContext;
    private final MemberCodegen<?> parentCodegen;
    private final ReifiedTypeParametersUsages reifiedTypeParametersUsages = new ReifiedTypeParametersUsages();
    private final Collection<ClassDescriptor> innerClasses = new LinkedHashSet<ClassDescriptor>();
    private ExpressionCodegen clInit;
    private NameGenerator inlineNameGenerator;
    private boolean jvmAssertFieldGenerated;
    private DefaultSourceMapper sourceMapper;

    public MemberCodegen(@NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen, @NotNull FieldOwnerContext context, T element, @NotNull ClassBuilder builder) {
        this.state = state2;
        this.typeMapper = state2.getTypeMapper();
        this.bindingContext = state2.getBindingContext();
        this.element = element;
        this.context = context;
        this.v = builder;
        this.functionCodegen = new FunctionCodegen(context, this.v, state2, this);
        this.propertyCodegen = new PropertyCodegen(context, this.v, this.functionCodegen, this);
        this.parentCodegen = parentCodegen;
        this.jvmAssertFieldGenerated = false;
    }

    protected MemberCodegen(@NotNull MemberCodegen<T> wrapped, T declaration, FieldOwnerContext codegenContext) {
        this(wrapped.state, wrapped.getParentCodegen(), codegenContext, declaration, wrapped.v);
    }

    public void generate() {
        boolean shouldGenerateSyntheticParts;
        this.generateDeclaration();
        boolean bl = shouldGenerateSyntheticParts = !(this.element instanceof KtClassOrObject) || this.state.getGenerateDeclaredClassFilter().shouldGenerateClassMembers((KtClassOrObject)this.element);
        if (shouldGenerateSyntheticParts) {
            this.generateSyntheticPartsBeforeBody();
        }
        this.generateBody();
        if (shouldGenerateSyntheticParts) {
            this.generateSyntheticPartsAfterBody();
        }
        if (this.state.getClassBuilderMode().generateMetadata) {
            this.generateKotlinMetadataAnnotation();
        }
        this.done();
    }

    protected abstract void generateDeclaration();

    protected void generateSyntheticPartsBeforeBody() {
    }

    protected abstract void generateBody();

    protected void generateSyntheticPartsAfterBody() {
    }

    protected abstract void generateKotlinMetadataAnnotation();

    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return null;
    }

    public static void markLineNumberForDescriptor(@Nullable ClassDescriptor declarationDescriptor, @NotNull InstructionAdapter v2) {
        if (declarationDescriptor == null) {
            return;
        }
        PsiElement classElement = DescriptorToSourceUtils.getSourceFromDescriptor(declarationDescriptor);
        if (classElement != null) {
            MemberCodegen.markLineNumberForElement(classElement, v2);
        }
    }

    public static void markLineNumberForElement(@NotNull PsiElement element, @NotNull InstructionAdapter v2) {
        Integer lineNumber = CodegenUtil.getLineNumberForElement(element, false);
        if (lineNumber != null) {
            Label label = new Label();
            v2.visitLabel(label);
            v2.visitLineNumber(lineNumber.intValue(), label);
        }
    }

    protected void done() {
        if (this.clInit != null) {
            this.clInit.v.visitInsn(177);
            FunctionCodegen.endVisit((MethodVisitor)this.clInit.v, "static initializer", this.element);
        }
        this.writeInnerClasses();
        if (this.sourceMapper != null) {
            SourceMapper.Companion.flushToClassBuilder(this.sourceMapper, this.v);
        }
        this.v.done();
    }

    public void genSimpleMember(@NotNull KtDeclaration declaration) {
        if (declaration instanceof KtNamedFunction) {
            try {
                this.functionCodegen.gen((KtNamedFunction)declaration);
            }
            catch (ProcessCanceledException | CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate function " + declaration.getName(), e, declaration);
            }
        } else if (declaration instanceof KtProperty) {
            try {
                this.propertyCodegen.gen((KtProperty)declaration);
            }
            catch (ProcessCanceledException | CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate property " + declaration.getName(), e, declaration);
            }
        } else if (declaration instanceof KtTypeAlias) {
            this.genTypeAlias((KtTypeAlias)declaration);
        } else if (declaration instanceof KtDestructuringDeclarationEntry) {
            try {
                this.propertyCodegen.genDestructuringDeclaration((KtDestructuringDeclarationEntry)declaration);
            }
            catch (ProcessCanceledException | CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate destructuring declaration entry " + declaration.getName(), e, declaration);
            }
        } else {
            throw new IllegalArgumentException("Unknown parameter: " + declaration);
        }
    }

    private void genTypeAlias(@NotNull KtTypeAlias typeAlias) {
        if (!this.state.getClassBuilderMode().generateMetadata) {
            return;
        }
        TypeAliasDescriptor typeAliasDescriptor = this.bindingContext.get(BindingContext.TYPE_ALIAS, typeAlias);
        if (typeAliasDescriptor == null) {
            throw ExceptionLogger.logDescriptorNotFound("Type alias " + typeAlias.getName() + " should have a descriptor", typeAlias);
        }
        this.genTypeAliasAnnotationsMethodIfRequired(typeAliasDescriptor);
    }

    private void genTypeAliasAnnotationsMethodIfRequired(TypeAliasDescriptor typeAliasDescriptor) {
        boolean isAnnotationsMethodOwner = CodegenContextUtil.isImplementationOwner(this.context, typeAliasDescriptor);
        Annotations annotations2 = typeAliasDescriptor.getAnnotations();
        if (!isAnnotationsMethodOwner || annotations2.isEmpty()) {
            return;
        }
        String name = JvmAbi.getSyntheticMethodNameForAnnotatedTypeAlias(typeAliasDescriptor.getName());
        this.generateSyntheticAnnotationsMethod(typeAliasDescriptor, new Method(name, "()V"), annotations2);
    }

    protected void generateSyntheticAnnotationsMethod(@NotNull MemberDescriptor descriptor2, @NotNull Method syntheticMethod, @NotNull Annotations annotations2) {
        int flags = 0x21008 | AsmUtil.getVisibilityAccessFlag(descriptor2);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(descriptor2), flags, syntheticMethod.getName(), syntheticMethod.getDescriptor(), null, null);
        AnnotationCodegen.forMethod(mv, this, this.state).genAnnotations(new AnnotatedImpl(annotations2), Type.VOID_TYPE);
        mv.visitCode();
        mv.visitInsn(177);
        mv.visitEnd();
    }

    public static void genClassOrObject(@NotNull CodegenContext parentContext, @NotNull KtClassOrObject aClass2, @NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen) {
        ClassDescriptor descriptor2 = state2.getBindingContext().get(BindingContext.CLASS, aClass2);
        if (descriptor2 == null || ErrorUtils.isError(descriptor2)) {
            MemberCodegen.badDescriptor(descriptor2, state2.getClassBuilderMode());
            return;
        }
        if (descriptor2.getName().equals(SpecialNames.NO_NAME_PROVIDED)) {
            MemberCodegen.badDescriptor(descriptor2, state2.getClassBuilderMode());
        }
        MemberCodegen.genClassOrObject(parentContext, aClass2, state2, parentCodegen, descriptor2);
    }

    private static void genClassOrObject(@NotNull CodegenContext parentContext, @NotNull KtPureClassOrObject aClass2, @NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen, @NotNull ClassDescriptor descriptor2) {
        Type classType = state2.getTypeMapper().mapClass(descriptor2);
        ClassBuilder classBuilder2 = state2.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOriginFromPure(aClass2, descriptor2), classType, (PsiFile)aClass2.getContainingKtFile());
        ClassContext classContext = parentContext.intoClass(descriptor2, OwnerKind.IMPLEMENTATION, state2);
        new ImplementationBodyCodegen(aClass2, classContext, classBuilder2, state2, parentCodegen, false).generate();
    }

    public static void badDescriptor(ClassDescriptor descriptor2, ClassBuilderMode mode) {
        if (mode.generateBodies) {
            throw new IllegalStateException("Generating bad descriptor in ClassBuilderMode = " + mode + ": " + descriptor2);
        }
    }

    public void genClassOrObject(KtClassOrObject aClass2) {
        MemberCodegen.genClassOrObject(this.context, aClass2, this.state, this);
    }

    public void genSyntheticClassOrObject(SyntheticClassOrObjectDescriptor descriptor2) {
        MemberCodegen.genClassOrObject(this.context, descriptor2.getSyntheticDeclaration(), this.state, this, descriptor2);
    }

    private void writeInnerClasses() {
        ClassDescriptor classDescriptor2 = this.classForInnerClassRecord();
        if (classDescriptor2 != null) {
            if (this.parentCodegen != null) {
                this.parentCodegen.innerClasses.add(classDescriptor2);
            }
            this.addParentsToInnerClassesIfNeeded(this.innerClasses);
        }
        for (ClassDescriptor innerClass : this.innerClasses) {
            this.writeInnerClass(innerClass);
        }
    }

    protected void addParentsToInnerClassesIfNeeded(@NotNull Collection<ClassDescriptor> innerClasses2) {
        MemberCodegen<?> parentCodegen;
        ClassDescriptor outerClass2 = this.classForInnerClassRecord();
        if (outerClass2 != null) {
            innerClasses2.add(outerClass2);
        }
        if ((parentCodegen = this.getParentCodegen()) != null) {
            parentCodegen.addParentsToInnerClassesIfNeeded(innerClasses2);
        }
    }

    @Override
    public void addInnerClassInfoFromAnnotation(@NotNull ClassDescriptor classDescriptor2) {
        for (DeclarationDescriptor current = classDescriptor2; current != null && !DescriptorUtils.isTopLevelDeclaration(current); current = current.getContainingDeclaration()) {
            if (!(current instanceof ClassDescriptor)) continue;
            this.innerClasses.add((ClassDescriptor)current);
        }
    }

    private void writeInnerClass(@NotNull ClassDescriptor innerClass) {
        if (!ErrorUtils.isError(innerClass)) {
            MemberCodegen.writeInnerClass(innerClass, this.typeMapper, this.v);
        }
    }

    public static void writeInnerClass(@NotNull ClassDescriptor innerClass, @NotNull KotlinTypeMapper typeMapper, @NotNull ClassBuilder v2) {
        DeclarationDescriptor containing = innerClass.getContainingDeclaration();
        String outerClassInternalName = null;
        if (containing instanceof ClassDescriptor) {
            outerClassInternalName = typeMapper.classInternalName((ClassDescriptor)containing);
        }
        String innerName = innerClass.getName().isSpecial() ? null : innerClass.getName().asString();
        String innerClassInternalName = typeMapper.classInternalName(innerClass);
        v2.visitInnerClass(innerClassInternalName, outerClassInternalName, innerName, AsmUtil.calculateInnerClassAccessFlags(innerClass));
    }

    protected void writeOuterClassAndEnclosingMethod() {
        CodegenContext context = this.context.getParentContext();
        while (context instanceof InlineLambdaContext) {
            context = context.getParentContext().getParentContext();
        }
        assert (context != null) : "Outermost context can't be null: " + this.context;
        Type enclosingAsmType = this.computeOuterClass(context);
        if (enclosingAsmType != null) {
            Method method = this.computeEnclosingMethod(context);
            this.v.visitOuterClass(enclosingAsmType.getInternalName(), method == null ? null : method.getName(), method == null ? null : method.getDescriptor());
        }
    }

    @Nullable
    private Type computeOuterClass(@NotNull CodegenContext<?> context) {
        CodegenContext<ClassOrPackageFragmentDescriptor> outermost = context.getClassOrPackageParentContext();
        if (outermost instanceof ClassContext) {
            FunctionDescriptor functionDescriptor;
            ClassDescriptor classDescriptor2 = (ClassDescriptor)((ClassContext)outermost).getContextDescriptor();
            if (context instanceof MethodContext && DescriptorUtils.isInterface((functionDescriptor = ((MethodContext)context).getFunctionDescriptor()).getContainingDeclaration()) && !JvmAnnotationUtilKt.hasJvmDefaultAnnotation(functionDescriptor)) {
                return this.typeMapper.mapDefaultImpls(classDescriptor2);
            }
            return this.typeMapper.mapClass(classDescriptor2);
        }
        if (outermost instanceof MultifileClassFacadeContext || outermost instanceof DelegatingToPartContext) {
            Type implementationOwnerType = CodegenContextUtil.getImplementationOwnerClassType(outermost);
            if (implementationOwnerType != null) {
                return implementationOwnerType;
            }
            return Type.getObjectType((String)JvmFileClassUtil.getFileClassInternalName(this.element.getContainingKtFile()));
        }
        return null;
    }

    @Nullable
    private Method computeEnclosingMethod(@NotNull CodegenContext context) {
        if (context instanceof MethodContext) {
            FunctionDescriptor functionDescriptor = ((MethodContext)context).getFunctionDescriptor();
            if ("<clinit>".equals(functionDescriptor.getName().asString())) {
                return null;
            }
            if (((MethodContext)context).isDefaultFunctionContext()) {
                return this.typeMapper.mapDefaultMethod(functionDescriptor, context.getContextKind());
            }
            return this.typeMapper.mapAsmMethod(functionDescriptor, context.getContextKind());
        }
        return null;
    }

    @NotNull
    public NameGenerator getInlineNameGenerator() {
        if (this.inlineNameGenerator == null) {
            String prefix = InlineCodegenUtilsKt.getInlineName(this.context, this.typeMapper);
            this.inlineNameGenerator = new NameGenerator(prefix);
        }
        return this.inlineNameGenerator;
    }

    @NotNull
    public final ExpressionCodegen createOrGetClInitCodegen() {
        if (this.clInit == null) {
            Object contextDescriptor = this.context.getContextDescriptor();
            SimpleFunctionDescriptorImpl clInitDescriptor = this.createClInitFunctionDescriptor((DeclarationDescriptor)contextDescriptor);
            MethodVisitor mv = this.createClInitMethodVisitor((DeclarationDescriptor)contextDescriptor);
            this.clInit = new ExpressionCodegen(mv, new FrameMap(), Type.VOID_TYPE, this.context.intoFunction(clInitDescriptor), this.state, this);
        }
        return this.clInit;
    }

    @NotNull
    public MethodVisitor createClInitMethodVisitor(@NotNull DeclarationDescriptor contextDescriptor) {
        return this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(contextDescriptor), 8, "<clinit>", "()V", null, null);
    }

    @NotNull
    private SimpleFunctionDescriptorImpl createClInitFunctionDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        SimpleFunctionDescriptorImpl clInit = SimpleFunctionDescriptorImpl.create(descriptor2, Annotations.Companion.getEMPTY(), Name.special("<clinit>"), CallableMemberDescriptor.Kind.SYNTHESIZED, KotlinSourceElementKt.toSourceElement(this.element));
        clInit.initialize((ReceiverParameterDescriptor)null, (ReceiverParameterDescriptor)null, Collections.emptyList(), Collections.emptyList(), (KotlinType)DescriptorUtilsKt.getModule(descriptor2).getBuiltIns().getUnitType(), (Modality)null, Visibilities.PRIVATE);
        return clInit;
    }

    protected void generateInitializers(@NotNull Function0<ExpressionCodegen> createCodegen) {
        NotNullLazyValue<ExpressionCodegen> codegen = LockBasedStorageManager.NO_LOCKS.createLazyValue(createCodegen);
        for (KtDeclaration declaration : ((KtDeclarationContainer)this.element).getDeclarations()) {
            KtExpression body;
            if (declaration instanceof KtProperty) {
                if (!this.shouldInitializeProperty((KtProperty)declaration)) continue;
                this.initializeProperty((ExpressionCodegen)codegen.invoke(), (KtProperty)declaration);
                continue;
            }
            if (declaration instanceof KtDestructuringDeclaration) {
                ((ExpressionCodegen)codegen.invoke()).initializeDestructuringDeclaration((KtDestructuringDeclaration)declaration, true);
                continue;
            }
            if (!(declaration instanceof KtAnonymousInitializer) || (body = ((KtAnonymousInitializer)declaration).getBody()) == null) continue;
            ((ExpressionCodegen)codegen.invoke()).gen(body, Type.VOID_TYPE);
        }
    }

    public void beforeMethodBody(@NotNull MethodVisitor mv) {
    }

    public void initializeProperty(@NotNull ExpressionCodegen codegen, @NotNull KtProperty property) {
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property);
        assert (propertyDescriptor != null);
        KtExpression initializer2 = property.getDelegateExpressionOrInitializer();
        assert (initializer2 != null) : "shouldInitializeProperty must return false if initializer is null";
        StackValue.Property propValue = codegen.intermediateValueForProperty(propertyDescriptor, true, false, null, true, StackValue.LOCAL_0, null, false);
        if (property.getDelegateExpression() == null) {
            propValue.store(codegen.gen(initializer2), codegen.v);
        } else {
            StackValue.Property delegate = propValue.getDelegateOrNull();
            assert (delegate != null) : "No delegate for delegated property: " + propertyDescriptor;
            ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall = this.bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor);
            if (provideDelegateResolvedCall == null) {
                delegate.store(codegen.gen(initializer2), codegen.v);
            } else {
                StackValue provideDelegateReceiver = codegen.gen(initializer2);
                StackValue delegateValue = PropertyCodegen.invokeDelegatedPropertyConventionMethod(codegen, provideDelegateResolvedCall, provideDelegateReceiver, propertyDescriptor);
                delegate.store(delegateValue, codegen.v);
            }
        }
    }

    public boolean shouldInitializeProperty(@NotNull KtProperty property) {
        ConstantValue<?> initializerValue2;
        if (!property.hasDelegateExpressionOrInitializer()) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property);
        assert (propertyDescriptor != null);
        if (propertyDescriptor.isConst()) {
            return false;
        }
        KtExpression initializer2 = property.getInitializer();
        ConstantValue<?> constantValue = initializerValue2 = initializer2 != null ? ExpressionCodegen.getCompileTimeConstant(initializer2, this.bindingContext, this.state.getShouldInlineConstVals()) : null;
        if (initializerValue2 == null) {
            return this.state.getClassBuilderMode().generateBodies;
        }
        KotlinType jetType = this.getPropertyOrDelegateType(property, propertyDescriptor);
        Type type2 = this.typeMapper.mapType(jetType);
        return !MemberCodegen.skipDefaultValue(propertyDescriptor, initializerValue2.getValue(), type2);
    }

    @NotNull
    private KotlinType getPropertyOrDelegateType(@NotNull KtProperty property, @NotNull PropertyDescriptor descriptor2) {
        KtExpression delegateExpression = property.getDelegateExpression();
        if (delegateExpression != null) {
            KotlinType delegateType = this.bindingContext.getType(delegateExpression);
            assert (delegateType != null) : "Type of delegate expression should be recorded";
            return delegateType;
        }
        return descriptor2.getType();
    }

    private static boolean skipDefaultValue(@NotNull PropertyDescriptor propertyDescriptor, Object value, @NotNull Type type2) {
        if (AsmUtil.isPrimitive(type2)) {
            if (!propertyDescriptor.getType().isMarkedNullable() && value instanceof Number) {
                if (type2 == Type.INT_TYPE && ((Number)value).intValue() == 0) {
                    return true;
                }
                if (type2 == Type.BYTE_TYPE && ((Number)value).byteValue() == 0) {
                    return true;
                }
                if (type2 == Type.LONG_TYPE && ((Number)value).longValue() == 0L) {
                    return true;
                }
                if (type2 == Type.SHORT_TYPE && ((Number)value).shortValue() == 0) {
                    return true;
                }
                if (type2 == Type.DOUBLE_TYPE && value.equals(0.0)) {
                    return true;
                }
                if (type2 == Type.FLOAT_TYPE && value.equals(Float.valueOf(0.0f))) {
                    return true;
                }
            }
            if (type2 == Type.BOOLEAN_TYPE && value instanceof Boolean && !((Boolean)value).booleanValue()) {
                return true;
            }
            if (type2 == Type.CHAR_TYPE && value instanceof Character && ((Character)value).charValue() == '\u0000') {
                return true;
            }
        } else if (value == null) {
            return true;
        }
        return false;
    }

    protected void generatePropertyMetadataArrayFieldIfNeeded(@NotNull Type thisAsmType) {
        List<VariableDescriptorWithAccessors> delegatedProperties = this.bindingContext.get(CodegenBinding.DELEGATED_PROPERTIES, thisAsmType);
        if (delegatedProperties == null || delegatedProperties.isEmpty()) {
            return;
        }
        this.v.newField(JvmDeclarationOrigin.NO_ORIGIN, 4120, "$$delegatedProperties", "[" + AsmTypes.K_PROPERTY_TYPE, null, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        InstructionAdapter iv = this.createOrGetClInitCodegen().v;
        iv.iconst(delegatedProperties.size());
        iv.newarray(AsmTypes.K_PROPERTY_TYPE);
        int size = delegatedProperties.size();
        for (int i = 0; i < size; ++i) {
            VariableDescriptorWithAccessors property = delegatedProperties.get(i);
            iv.dup();
            iv.iconst(i);
            int receiverCount = (property.getDispatchReceiverParameter() != null ? 1 : 0) + (property.getExtensionReceiverParameter() != null ? 1 : 0);
            Type implType = property.isVar() ? AsmTypes.MUTABLE_PROPERTY_REFERENCE_IMPL[receiverCount] : AsmTypes.PROPERTY_REFERENCE_IMPL[receiverCount];
            iv.anew(implType);
            iv.dup();
            ClosureCodegen.generateCallableReferenceDeclarationContainer(iv, property, this.state);
            iv.aconst((Object)property.getName().asString());
            PropertyReferenceCodegen.generateCallableReferenceSignature(iv, property, this.state);
            iv.invokespecial(implType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{AsmTypes.K_DECLARATION_CONTAINER_TYPE, AsmTypes.JAVA_STRING_TYPE, AsmTypes.JAVA_STRING_TYPE}), false);
            Method wrapper = PropertyReferenceCodegen.getWrapperMethodForPropertyReference(property, receiverCount);
            iv.invokestatic("kotlin/jvm/internal/Reflection", wrapper.getName(), wrapper.getDescriptor(), false);
            StackValue.onStack(implType).put(AsmTypes.K_PROPERTY_TYPE, iv);
            iv.astore(AsmTypes.K_PROPERTY_TYPE);
        }
        iv.putstatic(thisAsmType.getInternalName(), "$$delegatedProperties", "[" + AsmTypes.K_PROPERTY_TYPE);
    }

    public String getClassName() {
        return this.v.getThisName();
    }

    @NotNull
    public FieldOwnerContext<?> getContext() {
        return this.context;
    }

    @NotNull
    public ReifiedTypeParametersUsages getReifiedTypeParametersUsages() {
        return this.reifiedTypeParametersUsages;
    }

    public MemberCodegen<?> getParentCodegen() {
        return this.parentCodegen;
    }

    public String toString() {
        return this.context.toString();
    }

    @NotNull
    public DefaultSourceMapper getOrCreateSourceMapper() {
        if (this.sourceMapper == null) {
            this.sourceMapper = new DefaultSourceMapper(SourceInfo.Companion.createInfo((KtElement)this.element, this.getClassName()));
        }
        return this.sourceMapper;
    }

    protected void generateConstInstance(@NotNull Type thisAsmType, @NotNull Type fieldAsmType) {
        this.v.newField(JvmDeclarationOriginKt.OtherOriginFromPure(this.element), 25, "INSTANCE", fieldAsmType.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode().generateBodies) {
            InstructionAdapter iv = this.createOrGetClInitCodegen().v;
            iv.anew(thisAsmType);
            iv.dup();
            iv.invokespecial(thisAsmType.getInternalName(), "<init>", "()V", false);
            iv.putstatic(thisAsmType.getInternalName(), "INSTANCE", fieldAsmType.getDescriptor());
        }
    }

    protected final void generateSyntheticAccessors() {
        for (AccessorForCallableDescriptor<?> accessor : this.context.getAccessors()) {
            boolean hasJvmDefaultAnnotation = JvmAnnotationUtilKt.hasJvmDefaultAnnotation(accessor.getCalleeDescriptor());
            OwnerKind kind = this.context.getContextKind();
            if (DescriptorUtils.isInterface(this.context.getContextDescriptor()) && (!hasJvmDefaultAnnotation || kind != OwnerKind.IMPLEMENTATION) && (hasJvmDefaultAnnotation || kind != OwnerKind.DEFAULT_IMPLS)) continue;
            this.generateSyntheticAccessor(accessor);
        }
        AccessorForCompanionObjectInstanceFieldDescriptor accessorForCompanionObjectInstanceFieldDescriptor = this.context.getAccessorForCompanionObjectDescriptorIfRequired();
        if (accessorForCompanionObjectInstanceFieldDescriptor != null) {
            this.generateSyntheticAccessorForCompanionObject(accessorForCompanionObjectInstanceFieldDescriptor);
        }
    }

    private void generateSyntheticAccessorForCompanionObject(@NotNull AccessorForCompanionObjectInstanceFieldDescriptor accessor) {
        final ClassDescriptor companionObjectDescriptor2 = accessor.getCompanionObjectDescriptor();
        DeclarationDescriptor hostClassDescriptor = companionObjectDescriptor2.getContainingDeclaration();
        assert (hostClassDescriptor instanceof ClassDescriptor) : "Class descriptor expected: " + hostClassDescriptor;
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, companionObjectDescriptor2), accessor, new FunctionGenerationStrategy.CodegenBased(this.state){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                Type companionObjectType = MemberCodegen.this.typeMapper.mapClass(companionObjectDescriptor2);
                StackValue.singleton(companionObjectDescriptor2, MemberCodegen.this.typeMapper).put(companionObjectType, codegen.v);
                codegen.v.areturn(companionObjectType);
            }
        });
    }

    private void generateSyntheticAccessor(final @NotNull AccessorForCallableDescriptor<?> accessorForCallableDescriptor) {
        if (accessorForCallableDescriptor instanceof FunctionDescriptor) {
            final FunctionDescriptor accessor = (FunctionDescriptor)((Object)accessorForCallableDescriptor);
            final FunctionDescriptor original = (FunctionDescriptor)accessorForCallableDescriptor.getCalleeDescriptor();
            this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original), accessor, new FunctionGenerationStrategy.CodegenBased(this.state){

                @Override
                public boolean skipNotNullAssertionsForParameters() {
                    return true;
                }

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                    MemberCodegen.markLineNumberForElement((PsiElement)MemberCodegen.this.element.getPsiOrParent(), codegen.v);
                    if (accessorForCallableDescriptor.getAccessorKind() == AccessorKind.JVM_DEFAULT_COMPATIBILITY) {
                        FunctionDescriptor descriptor2 = DescriptorUtils.unwrapFakeOverrideToAnyDeclaration(original).getOriginal();
                        if (descriptor2 != original) {
                            descriptor2 = descriptor2.copy(original.getContainingDeclaration(), descriptor2.getModality(), descriptor2.getVisibility(), descriptor2.getKind(), false);
                        }
                        MemberCodegen.this.generateMethodCallTo(descriptor2, accessor, codegen.v).coerceTo(signature.getReturnType(), null, codegen.v);
                    } else {
                        MemberCodegen.this.generateMethodCallTo(original, accessor, codegen.v).coerceTo(signature.getReturnType(), null, codegen.v);
                    }
                    codegen.v.areturn(signature.getReturnType());
                }
            });
        } else if (accessorForCallableDescriptor instanceof AccessorForPropertyDescriptor) {
            class PropertyAccessorStrategy
            extends FunctionGenerationStrategy.CodegenBased {
                private final PropertyAccessorDescriptor callableDescriptor;

                PropertyAccessorStrategy(PropertyAccessorDescriptor callableDescriptor) {
                    super(MemberCodegen.this.state);
                    this.callableDescriptor = callableDescriptor;
                }

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                    if (accessorForCallableDescriptor.getAccessorKind() == AccessorKind.JVM_DEFAULT_COMPATIBILITY) {
                        boolean isGetter;
                        MemberCodegen.markLineNumberForElement((PsiElement)MemberCodegen.this.element.getPsiOrParent(), codegen.v);
                        PropertyDescriptor descriptor2 = DescriptorUtils.unwrapFakeOverrideToAnyDeclaration(original).getOriginal();
                        if (descriptor2 != original) {
                            descriptor2 = (PropertyDescriptor)descriptor2.copy(original.getContainingDeclaration(), descriptor2.getModality(), descriptor2.getVisibility(), descriptor2.getKind(), false);
                        }
                        PropertyAccessorDescriptor originalAccessor = (isGetter = this.callableDescriptor instanceof PropertyGetterDescriptor) ? descriptor2.getGetter() : descriptor2.getSetter();
                        PropertyAccessorDescriptor accessorDescriptor = isGetter ? accessor.getGetter() : accessor.getSetter();
                        MemberCodegen.this.generateMethodCallTo(originalAccessor, accessorDescriptor, codegen.v).coerceTo(signature.getReturnType(), null, codegen.v);
                        codegen.v.areturn(signature.getReturnType());
                        return;
                    }
                    AccessorKind fieldAccessorKind = accessor instanceof AccessorForPropertyBackingField ? accessor.getAccessorKind() : null;
                    boolean syntheticBackingField = fieldAccessorKind == AccessorKind.FIELD_FROM_LOCAL;
                    boolean forceFieldForCompanionProperty = JvmAbi.isPropertyWithBackingFieldInOuterClass(original) && !DescriptorUtils.isCompanionObject(accessor.getContainingDeclaration());
                    boolean forceField = forceFieldForCompanionProperty || syntheticBackingField || original.getVisibility() == JavaVisibilities.PROTECTED_STATIC_VISIBILITY;
                    StackValue.Property property = codegen.intermediateValueForProperty(original, forceField, syntheticBackingField, accessor.getSuperCallTarget(), forceFieldForCompanionProperty, StackValue.none(), null, fieldAccessorKind == AccessorKind.LATEINIT_INTRINSIC);
                    InstructionAdapter iv = codegen.v;
                    MemberCodegen.markLineNumberForElement((PsiElement)MemberCodegen.this.element.getPsiOrParent(), iv);
                    Type[] argTypes = signature.getAsmMethod().getArgumentTypes();
                    int reg = 0;
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        iv.load(reg, argType);
                        reg += argType.getSize();
                    }
                    if (this.callableDescriptor instanceof PropertyGetterDescriptor) {
                        property.put(signature.getReturnType(), iv);
                    } else {
                        ((StackValue)property).store(StackValue.onStack(property.type, property.kotlinType), iv, true);
                    }
                    iv.areturn(signature.getReturnType());
                }

                @Override
                public boolean skipNotNullAssertionsForParameters() {
                    return true;
                }
            }
            final AccessorForPropertyDescriptor accessor = (AccessorForPropertyDescriptor)accessorForCallableDescriptor;
            final PropertyDescriptor original = accessor.getCalleeDescriptor();
            if (accessor.isWithSyntheticGetterAccessor()) {
                PropertyGetterDescriptorImpl getter2 = accessor.getGetter();
                assert (getter2 != null);
                this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original.getGetter() != null ? original.getGetter() : original), getter2, new PropertyAccessorStrategy(getter2));
            }
            if (accessor.isVar() && accessor.isWithSyntheticSetterAccessor()) {
                PropertySetterDescriptor setter2 = accessor.getSetter();
                assert (setter2 != null);
                this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original.getSetter() != null ? original.getSetter() : original), setter2, new PropertyAccessorStrategy(setter2));
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected StackValue generateMethodCallTo(@NotNull FunctionDescriptor functionDescriptor, @Nullable FunctionDescriptor accessorDescriptor, @NotNull InstructionAdapter iv) {
        int reg;
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(functionDescriptor, accessorDescriptor instanceof AccessorForCallableDescriptor && (((AccessorForCallableDescriptor)((Object)accessorDescriptor)).getSuperCallTarget() != null || ((AccessorForCallableDescriptor)((Object)accessorDescriptor)).getAccessorKind() == AccessorKind.JVM_DEFAULT_COMPATIBILITY));
        boolean isJvmStaticInObjectOrClass = CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(functionDescriptor);
        boolean hasDispatchReceiver = !DescriptorUtils.isStaticDeclaration(functionDescriptor) && !JvmCodegenUtil.isNonDefaultInterfaceMember(functionDescriptor) && !isJvmStaticInObjectOrClass && !InlineClassesUtilsKt.isInlineClass(functionDescriptor.getContainingDeclaration());
        boolean accessorIsConstructor = accessorDescriptor instanceof AccessorForConstructorDescriptor;
        ReceiverParameterDescriptor dispatchReceiver = functionDescriptor.getDispatchReceiverParameter();
        Type dispatchReceiverType = dispatchReceiver != null ? this.typeMapper.mapType(dispatchReceiver.getType()) : AsmTypes.OBJECT_TYPE;
        int accessorParam = hasDispatchReceiver && !accessorIsConstructor ? 1 : 0;
        int n = reg = hasDispatchReceiver ? dispatchReceiverType.getSize() : 0;
        if (!accessorIsConstructor && functionDescriptor instanceof ConstructorDescriptor) {
            iv.anew(callableMethod.getOwner());
            iv.dup();
            reg = 0;
            accessorParam = 0;
        } else if (KotlinTypeMapper.isAccessor(accessorDescriptor) && (hasDispatchReceiver || accessorIsConstructor) && !isJvmStaticInObjectOrClass) {
            iv.load(0, dispatchReceiverType);
        }
        Type[] calleeParameterTypes = callableMethod.getParameterTypes();
        Type[] accessorParameterTypes = accessorDescriptor != null ? this.typeMapper.mapToCallableMethod(accessorDescriptor, false).getParameterTypes() : calleeParameterTypes;
        for (Type calleeArgType : calleeParameterTypes) {
            if (AsmTypes.DEFAULT_CONSTRUCTOR_MARKER.equals((Object)calleeArgType)) {
                iv.aconst(null);
            } else {
                Type accessorParameterType = accessorParameterTypes[accessorParam];
                iv.load(reg, accessorParameterType);
                StackValue.coerce(accessorParameterType, calleeArgType, iv);
                reg += accessorParameterType.getSize();
            }
            ++accessorParam;
        }
        callableMethod.genInvokeInstruction(iv);
        return StackValue.onStack(callableMethod.getReturnType(), functionDescriptor.getReturnType());
    }

    public void generateAssertField() {
        if (this.jvmAssertFieldGenerated) {
            return;
        }
        AssertCodegenUtilKt.generateAssertionsDisabledFieldInitialization(this);
        this.jvmAssertFieldGenerated = true;
    }
}

