/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmRuntimeTypes;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenProvider;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.NewAbstractResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewVariableAsFunctionResolvedCallImpl;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionsOnDeclarationBodyChecker;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.org.objectweb.asm.Type;

class CodegenAnnotatingVisitor
extends KtVisitorVoid {
    private static final TokenSet BINARY_OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{KtTokens.AUGMENTED_ASSIGNMENTS, TokenSet.create((IElementType[])new IElementType[]{KtTokens.PLUS, KtTokens.MINUS, KtTokens.MUL, KtTokens.DIV, KtTokens.PERC, KtTokens.RANGE, KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.IDENTIFIER})});
    private final Map<String, Integer> anonymousSubclassesCount = new HashMap<String, Integer>();
    private final Stack<ClassDescriptor> classStack = new Stack();
    private final Stack<String> nameStack = new Stack();
    private final Stack<FunctionDescriptor> functionsStack = new Stack();
    private final Set<ClassDescriptor> uninitializedClasses = new HashSet<ClassDescriptor>();
    private final BindingTrace bindingTrace;
    private final BindingContext bindingContext;
    private final GenerationState.GenerateClassFilter filter;
    private final JvmRuntimeTypes runtimeTypes;
    private final SwitchCodegenProvider switchCodegenProvider;
    private final LanguageVersionSettings languageVersionSettings;
    private final ClassBuilderMode classBuilderMode;

    public CodegenAnnotatingVisitor(@NotNull GenerationState state2) {
        this.bindingTrace = state2.getBindingTrace();
        this.bindingContext = state2.getBindingContext();
        this.filter = state2.getGenerateDeclaredClassFilter();
        this.runtimeTypes = state2.getJvmRuntimeTypes();
        this.switchCodegenProvider = new SwitchCodegenProvider(state2);
        this.languageVersionSettings = state2.getLanguageVersionSettings();
        this.classBuilderMode = state2.getClassBuilderMode();
    }

    @NotNull
    private ClassDescriptor recordClassForCallable(@NotNull KtElement element, @NotNull CallableDescriptor callableDescriptor, @NotNull Collection<KotlinType> supertypes2, @NotNull String name) {
        return this.recordClassForCallable(element, callableDescriptor, supertypes2, name, null);
    }

    @NotNull
    private ClassDescriptor recordClassForFunction(@NotNull KtElement element, @NotNull FunctionDescriptor functionDescriptor, @NotNull String name, @Nullable DeclarationDescriptor customContainer) {
        return this.recordClassForCallable(element, functionDescriptor, this.runtimeTypes.getSupertypesForClosure(functionDescriptor), name, customContainer);
    }

    @NotNull
    private ClassDescriptor recordClassForCallable(@NotNull KtElement element, @NotNull CallableDescriptor callableDescriptor, @NotNull Collection<KotlinType> supertypes2, @NotNull String name, @Nullable DeclarationDescriptor customContainer) {
        String simpleName = name.substring(name.lastIndexOf(47) + 1);
        SyntheticClassDescriptorForLambda classDescriptor2 = new SyntheticClassDescriptorForLambda(customContainer != null ? customContainer : this.correctContainerForLambda(callableDescriptor), Name.special("<closure-" + simpleName + ">"), supertypes2, element);
        this.bindingTrace.record(CodegenBinding.CLASS_FOR_CALLABLE, callableDescriptor, classDescriptor2);
        return classDescriptor2;
    }

    @NotNull
    private DeclarationDescriptor correctContainerForLambda(@NotNull CallableDescriptor descriptor2) {
        ClassDescriptor classDescriptor2;
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        while (container2 instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(classDescriptor2 = ((ConstructorDescriptor)container2).getConstructedClass()) && this.uninitializedClasses.contains(classDescriptor2)) {
            container2 = classDescriptor2.getContainingDeclaration();
        }
        return container2;
    }

    @NotNull
    private String inventAnonymousClassName() {
        String top = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Integer cnt = this.anonymousSubclassesCount.get(top);
        if (cnt == null) {
            cnt = 0;
        }
        this.anonymousSubclassesCount.put(top, cnt + 1);
        return top + "$" + (cnt + 1);
    }

    @Override
    public void visitKtElement(@NotNull KtElement element) {
        super.visitKtElement(element);
        if (!this.classBuilderMode.generateBodies) {
            KotlinFileStub stub;
            if (element instanceof KtFile && (stub = ((KtFile)element).getStub()) != null) {
                for (StubElement stubElement : stub.getChildrenStubs()) {
                    stubElement.getPsi().accept((PsiElementVisitor)this);
                }
                return;
            }
            if (element instanceof KtElementImplStub && ((KtElementImplStub)element).getStub() != null && (stub = ((KtElementImplStub)element).getStub()) != null) {
                for (StubElement stubElement : stub.getChildrenStubs()) {
                    stubElement.getPsi().accept((PsiElementVisitor)this);
                }
                return;
            }
        }
        element.acceptChildren(this);
    }

    @Override
    public void visitScript(@NotNull KtScript script) {
        ClassDescriptor scriptDescriptor = this.bindingContext.get(BindingContext.SCRIPT, script);
        if (scriptDescriptor == null) {
            return;
        }
        String scriptInternalName = AsmUtil.internalNameByFqNameWithoutInnerClasses(script.getFqName());
        this.recordClosure(scriptDescriptor, scriptInternalName);
        this.classStack.push((Object)scriptDescriptor);
        this.nameStack.push((Object)scriptInternalName);
        script.acceptChildren(this);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitKtFile(@NotNull KtFile file2) {
        this.nameStack.push((Object)AsmUtil.internalNameByFqNameWithoutInnerClasses(file2.getPackageFqName()));
        this.visitKtElement(file2);
        this.nameStack.pop();
    }

    @Override
    public void visitEnumEntry(@NotNull KtEnumEntry enumEntry) {
        if (enumEntry.getDeclarations().isEmpty()) {
            for (KtSuperTypeListEntry specifier : enumEntry.getSuperTypeListEntries()) {
                specifier.accept(this);
            }
            return;
        }
        ClassDescriptor descriptor2 = this.bindingContext.get(BindingContext.CLASS, enumEntry);
        if (descriptor2 == null) {
            return;
        }
        this.bindingTrace.record(CodegenBinding.ENUM_ENTRY_CLASS_NEED_SUBCLASS, descriptor2);
        super.visitEnumEntry(enumEntry);
    }

    @Override
    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        if (!this.filter.shouldAnnotateClass(declaration)) {
            return;
        }
        ClassDescriptor classDescriptor2 = this.bindingContext.get(BindingContext.CLASS, declaration);
        if (classDescriptor2 == null) {
            return;
        }
        String name = this.getName(classDescriptor2);
        this.recordClosure(classDescriptor2, name);
        this.classStack.push((Object)classDescriptor2);
        this.nameStack.push((Object)name);
        super.visitObjectDeclaration(declaration);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitClass(@NotNull KtClass klass2) {
        if (!this.filter.shouldAnnotateClass(klass2)) {
            return;
        }
        ClassDescriptor classDescriptor2 = this.bindingContext.get(BindingContext.CLASS, klass2);
        if (classDescriptor2 == null) {
            return;
        }
        String name = this.getName(classDescriptor2);
        this.recordClosure(classDescriptor2, name);
        this.classStack.push((Object)classDescriptor2);
        this.nameStack.push((Object)name);
        super.visitClass(klass2);
        this.nameStack.pop();
        this.classStack.pop();
    }

    private String getName(ClassDescriptor classDescriptor2) {
        String base = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Name descriptorName = SpecialNames.safeIdentifier(classDescriptor2.getName());
        if (DescriptorUtils.isTopLevelDeclaration(classDescriptor2)) {
            return base.isEmpty() ? descriptorName.asString() : base + '/' + descriptorName;
        }
        return base + "$" + descriptorName.asString();
    }

    @Override
    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
        KtObjectDeclaration object = expression2.getObjectDeclaration();
        ClassDescriptor classDescriptor2 = this.bindingContext.get(BindingContext.CLASS, object);
        if (classDescriptor2 == null) {
            super.visitObjectLiteralExpression(expression2);
            return;
        }
        String name = this.inventAnonymousClassName();
        this.recordClosure(classDescriptor2, name);
        KtSuperTypeList delegationSpecifierList = object.getSuperTypeList();
        if (delegationSpecifierList != null) {
            delegationSpecifierList.accept(this);
        }
        this.classStack.push((Object)classDescriptor2);
        this.nameStack.push((Object)CodegenBinding.getAsmType(this.bindingContext, classDescriptor2).getInternalName());
        KtClassBody body = object.getBody();
        if (body != null) {
            super.visitClassBody(body);
        }
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        KtFunctionLiteral functionLiteral = lambdaExpression.getFunctionLiteral();
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionLiteral);
        if (functionDescriptor == null) {
            return;
        }
        String name = this.inventAnonymousClassName();
        Collection<KotlinType> supertypes2 = this.runtimeTypes.getSupertypesForClosure(functionDescriptor);
        ClassDescriptor classDescriptor2 = this.recordClassForCallable(functionLiteral, functionDescriptor, supertypes2, name);
        MutableClosure closure = this.recordClosure(classDescriptor2, name);
        this.classStack.push((Object)classDescriptor2);
        this.nameStack.push((Object)name);
        if (CoroutineUtilKt.isSuspendLambda(functionDescriptor)) {
            this.createAndRecordSuspendFunctionView(closure, (SimpleFunctionDescriptor)functionDescriptor, true);
        }
        this.functionsStack.push((Object)functionDescriptor);
        super.visitLambdaExpression(lambdaExpression);
        this.functionsStack.pop();
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2) {
        SimpleFunctionDescriptor functionDescriptor;
        Collection<KotlinType> supertypes2;
        CallableDescriptor callableDescriptor;
        KotlinType receiverType;
        ResolvedCall<? extends CallableDescriptor> referencedFunction = CallUtilKt.getResolvedCall(expression2.getCallableReference(), this.bindingContext);
        if (referencedFunction == null) {
            return;
        }
        CallableDescriptor target = referencedFunction.getResultingDescriptor();
        ReceiverValue extensionReceiver2 = referencedFunction.getExtensionReceiver();
        ReceiverValue dispatchReceiver = referencedFunction.getDispatchReceiver();
        KotlinType kotlinType2 = dispatchReceiver != null && !(dispatchReceiver instanceof TransientReceiver) ? dispatchReceiver.getType() : (receiverType = extensionReceiver2 != null && !(extensionReceiver2 instanceof TransientReceiver) ? extensionReceiver2.getType() : null);
        if (target instanceof FunctionDescriptor) {
            callableDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression2);
            if (callableDescriptor == null) {
                return;
            }
            supertypes2 = this.runtimeTypes.getSupertypesForFunctionReference((FunctionDescriptor)target, (AnonymousFunctionDescriptor)callableDescriptor, receiverType != null);
        } else if (target instanceof PropertyDescriptor) {
            callableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, expression2);
            if (callableDescriptor == null) {
                return;
            }
            supertypes2 = Collections.singleton(this.runtimeTypes.getSupertypeForPropertyReference((PropertyDescriptor)target, ReflectionTypes.Companion.isNumberedKMutablePropertyType(callableDescriptor.getReturnType()), receiverType != null));
        } else {
            return;
        }
        String name = this.inventAnonymousClassName();
        ClassDescriptor classDescriptor2 = this.recordClassForCallable(expression2, callableDescriptor, supertypes2, name);
        MutableClosure closure = this.recordClosure(classDescriptor2, name);
        if (callableDescriptor instanceof SimpleFunctionDescriptor && (functionDescriptor = (SimpleFunctionDescriptor)callableDescriptor).isSuspend()) {
            this.createAndRecordSuspendFunctionView(closure, functionDescriptor, false);
        }
        if (receiverType != null) {
            closure.setCustomCapturedReceiverType(receiverType);
        }
        super.visitCallableReferenceExpression(expression2);
    }

    private SimpleFunctionDescriptor createAndRecordSuspendFunctionView(MutableClosure closure, SimpleFunctionDescriptor functionDescriptor, boolean isSuspendLambda) {
        SimpleFunctionDescriptor jvmSuspendFunctionView = CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(functionDescriptor, this.languageVersionSettings.supportsFeature(LanguageFeature.ReleaseCoroutines), this.bindingContext);
        this.bindingTrace.record(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, functionDescriptor, jvmSuspendFunctionView);
        closure.setSuspend(true);
        if (isSuspendLambda) {
            closure.setSuspendLambda();
        }
        return jvmSuspendFunctionView;
    }

    @NotNull
    private MutableClosure recordClosure(@NotNull ClassDescriptor classDescriptor2, @NotNull String name) {
        return CodegenBinding.recordClosure(this.bindingTrace, classDescriptor2, this.getProperEnclosingClass(), Type.getObjectType((String)name));
    }

    @Nullable
    private ClassDescriptor getProperEnclosingClass() {
        for (int i = this.classStack.size() - 1; i >= 0; --i) {
            ClassDescriptor fromStack = (ClassDescriptor)this.classStack.get(i);
            if (this.uninitializedClasses.contains(fromStack)) continue;
            return fromStack;
        }
        return null;
    }

    private void recordLocalVariablePropertyMetadata(LocalVariableDescriptor variableDescriptor) {
        KotlinType delegateType = JvmCodegenUtil.getPropertyDelegateType(variableDescriptor, this.bindingContext);
        if (delegateType == null) {
            return;
        }
        LocalVariableDescriptor metadataVariableDescriptor = new LocalVariableDescriptor(variableDescriptor.getContainingDeclaration(), Annotations.Companion.getEMPTY(), Name.identifier(variableDescriptor.getName().asString() + "$metadata"), ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule(variableDescriptor)), SourceElement.NO_SOURCE);
        this.bindingTrace.record(CodegenBinding.LOCAL_VARIABLE_PROPERTY_METADATA, variableDescriptor, metadataVariableDescriptor);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        String nameForClassOrPackageMember;
        DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property);
        if (descriptor2 == null) {
            return;
        }
        this.checkRuntimeAsserionsOnDeclarationBody(property, descriptor2);
        if (descriptor2 instanceof LocalVariableDescriptor) {
            this.recordLocalVariablePropertyMetadata((LocalVariableDescriptor)descriptor2);
        }
        if ((nameForClassOrPackageMember = this.getNameForClassOrPackageMember(descriptor2)) != null) {
            this.nameStack.push((Object)nameForClassOrPackageMember);
        } else {
            this.nameStack.push((Object)(CodegenAnnotatingVisitor.peekFromStack(this.nameStack) + '$' + SpecialNames.safeIdentifier(property.getNameAsSafeName()).asString()));
        }
        KtPropertyDelegate delegate = property.getDelegate();
        if (delegate != null && descriptor2 instanceof VariableDescriptorWithAccessors) {
            VariableDescriptorWithAccessors variableDescriptor = (VariableDescriptorWithAccessors)descriptor2;
            String name = this.inventAnonymousClassName();
            KotlinType supertype = this.runtimeTypes.getSupertypeForPropertyReference(variableDescriptor, variableDescriptor.isVar(), false);
            ClassDescriptor classDescriptor2 = this.recordClassForCallable(delegate, variableDescriptor, Collections.singleton(supertype), name);
            this.recordClosure(classDescriptor2, name);
            Type containerType = this.getMetadataOwner(property);
            List<VariableDescriptorWithAccessors> descriptors = this.bindingTrace.get(CodegenBinding.DELEGATED_PROPERTIES, containerType);
            if (descriptors == null) {
                descriptors = new ArrayList<VariableDescriptorWithAccessors>(1);
                this.bindingTrace.record(CodegenBinding.DELEGATED_PROPERTIES, containerType, descriptors);
            }
            descriptors.add(variableDescriptor);
            this.bindingTrace.record(CodegenBinding.DELEGATED_PROPERTY_METADATA_OWNER, variableDescriptor, containerType);
        }
        super.visitProperty(property);
        this.nameStack.pop();
    }

    private void checkRuntimeAsserionsOnDeclarationBody(@NotNull KtDeclaration declaration, DeclarationDescriptor descriptor2) {
        if (this.classBuilderMode.generateBodies) {
            RuntimeAssertionsOnDeclarationBodyChecker.check(declaration, descriptor2, this.bindingTrace, this.languageVersionSettings);
        }
    }

    @NotNull
    private Type getMetadataOwner(@NotNull KtProperty property) {
        for (int i = this.classStack.size() - 1; i >= 0; --i) {
            ClassDescriptor descriptor2 = (ClassDescriptor)this.classStack.get(i);
            if (descriptor2 instanceof SyntheticClassDescriptorForLambda) continue;
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)descriptor2);
            if (classId == null) {
                return CodegenBinding.getAsmType(this.bindingContext, descriptor2);
            }
            return AsmUtil.asmTypeByClassId(DescriptorUtils.isInterface(descriptor2) ? classId.createNestedClassId(Name.identifier("DefaultImpls")) : classId);
        }
        return Type.getObjectType((String)JvmFileClassUtil.getFileClassInternalName(property.getContainingKtFile()));
    }

    @Override
    public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
        PropertyAccessorDescriptor accessorDescriptor = this.bindingContext.get(BindingContext.PROPERTY_ACCESSOR, accessor);
        if (accessorDescriptor != null) {
            this.checkRuntimeAsserionsOnDeclarationBody(accessor, accessorDescriptor);
        }
        super.visitPropertyAccessor(accessor);
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
        if (functionDescriptor == null) {
            return;
        }
        this.checkRuntimeAsserionsOnDeclarationBody(function2, functionDescriptor);
        String nameForClassOrPackageMember = this.getNameForClassOrPackageMember(functionDescriptor);
        if (functionDescriptor instanceof SimpleFunctionDescriptor && functionDescriptor.isSuspend() && !functionDescriptor.getVisibility().equals(Visibilities.LOCAL)) {
            if (nameForClassOrPackageMember != null) {
                this.nameStack.push((Object)nameForClassOrPackageMember);
            }
            String name = this.inventAnonymousClassName();
            ClassDescriptor classDescriptor2 = this.recordClassForFunction(function2, functionDescriptor, name, functionDescriptor);
            MutableClosure closure = this.recordClosure(classDescriptor2, name);
            SimpleFunctionDescriptor jvmSuspendFunctionView = this.createAndRecordSuspendFunctionView(closure, (SimpleFunctionDescriptor)functionDescriptor, false);
            for (Pair parameterDescriptorPair : CollectionsKt.zip(functionDescriptor.getValueParameters(), jvmSuspendFunctionView.getValueParameters())) {
                this.bindingTrace.record(CodegenBinding.PARAMETER_SYNONYM, parameterDescriptorPair.getFirst(), parameterDescriptorPair.getSecond());
            }
            this.functionsStack.push((Object)functionDescriptor);
            super.visitNamedFunction(function2);
            this.functionsStack.pop();
            if (nameForClassOrPackageMember != null) {
                this.nameStack.pop();
            }
            return;
        }
        if (nameForClassOrPackageMember != null) {
            this.nameStack.push((Object)nameForClassOrPackageMember);
            this.functionsStack.push((Object)functionDescriptor);
            super.visitNamedFunction(function2);
            this.functionsStack.pop();
            this.nameStack.pop();
        } else {
            String name = this.inventAnonymousClassName();
            ClassDescriptor classDescriptor3 = this.recordClassForFunction(function2, functionDescriptor, name, null);
            MutableClosure closure = this.recordClosure(classDescriptor3, name);
            this.classStack.push((Object)classDescriptor3);
            this.nameStack.push((Object)name);
            if (functionDescriptor instanceof SimpleFunctionDescriptor && functionDescriptor.isSuspend()) {
                this.createAndRecordSuspendFunctionView(closure, (SimpleFunctionDescriptor)functionDescriptor, true);
            }
            this.functionsStack.push((Object)functionDescriptor);
            super.visitNamedFunction(function2);
            this.functionsStack.pop();
            this.nameStack.pop();
            this.classStack.pop();
        }
    }

    @Nullable
    private String getNameForClassOrPackageMember(@NotNull DeclarationDescriptor descriptor2) {
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        String peek = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        String name = SpecialNames.safeIdentifier(descriptor2.getName()).asString();
        if (containingDeclaration instanceof ClassDescriptor) {
            return peek + '$' + name;
        }
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
            assert (containingFile != null) : "File not found for " + descriptor2;
            return JvmFileClassUtil.getFileClassInternalName(containingFile) + '$' + name;
        }
        return null;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        super.visitCallExpression(expression2);
        this.checkSamCall(expression2);
        this.checkCrossinlineSuspendCall(expression2);
        this.recordSuspendFunctionTypeWrapperForArguments(expression2);
    }

    private void recordSuspendFunctionTypeWrapperForArguments(@NotNull KtCallExpression expression2) {
        ResolvedCall<? extends CallableDescriptor> call2 = CallUtilKt.getResolvedCall(expression2, this.bindingContext);
        if (call2 == null) {
            return;
        }
        CallableDescriptor descriptor2 = call2.getResultingDescriptor();
        if (!CodegenUtilKt.needsExperimentalCoroutinesWrapper(descriptor2)) {
            return;
        }
        List<ResolvedValueArgument> argumentsByIndex = call2.getValueArgumentsByIndex();
        if (argumentsByIndex == null) {
            return;
        }
        for (ValueParameterDescriptor parameter : descriptor2.getValueParameters()) {
            KtExpression argumentExpression;
            ValueArgument valueArgument;
            ResolvedValueArgument resolvedValueArgument = argumentsByIndex.get(parameter.getIndex());
            if (!(resolvedValueArgument instanceof ExpressionValueArgument) || (valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument()) == null || (argumentExpression = valueArgument.getArgumentExpression()) == null) continue;
            this.recordSuspendFunctionTypeWrapperForArgument(parameter, argumentExpression);
        }
        ReceiverValue receiver = call2.getExtensionReceiver();
        if (descriptor2.getExtensionReceiverParameter() != null && receiver instanceof ExpressionReceiver) {
            this.recordSuspendFunctionTypeWrapperForArgument(descriptor2.getExtensionReceiverParameter(), ((ExpressionReceiver)receiver).getExpression());
        }
    }

    private void recordSuspendFunctionTypeWrapperForArgument(ParameterDescriptor parameter, KtExpression argumentExpression) {
        if (FunctionTypesKt.isSuspendFunctionTypeOrSubtype(parameter.getType())) {
            int functionTypeArity = parameter.getType().getArguments().size();
            Type functionType = Type.getObjectType((String)("kotlin/jvm/functions/Function" + functionTypeArity));
            this.bindingTrace.record(CodegenBinding.FUNCTION_TYPE_FOR_SUSPEND_WRAPPER, argumentExpression, functionType);
        }
    }

    private void checkCrossinlineSuspendCall(@NotNull KtCallExpression expression2) {
        KtExpression callee = expression2.getCalleeExpression();
        Call call2 = this.bindingContext.get(BindingContext.CALL, callee);
        ResolvedCall<?> resolvedCall2 = this.bindingContext.get(BindingContext.RESOLVED_CALL, call2);
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            VariableAsFunctionResolvedCall variableAsFunction = (VariableAsFunctionResolvedCall)((Object)resolvedCall2);
            VariableDescriptor variableDescriptor = variableAsFunction.getVariableCall().getResultingDescriptor();
            Object callableDescriptor = ((ResolvedCall)((Object)variableAsFunction)).getResultingDescriptor();
            if (variableDescriptor instanceof ValueParameterDescriptor && ((ValueParameterDescriptor)variableDescriptor).isCrossinline() && callableDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)callableDescriptor).isSuspend()) {
                FunctionDescriptor enclosingDescriptor = this.bindingContext.get(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall());
                if (enclosingDescriptor == null) {
                    return;
                }
                DeclarationDescriptor functionWithCrossinlineParameter = variableDescriptor.getContainingDeclaration();
                for (int i = this.functionsStack.size() - 1; i >= 0; --i) {
                    if (((FunctionDescriptor)this.functionsStack.get(i)).isSuspend()) {
                        Boolean alreadyPutValue = this.bindingTrace.getBindingContext().get(CodegenBinding.CAPTURES_CROSSINLINE_SUSPEND_LAMBDA, this.functionsStack.get(i));
                        if (alreadyPutValue != null && alreadyPutValue.booleanValue()) {
                            return;
                        }
                        this.bindingTrace.record(CodegenBinding.CAPTURES_CROSSINLINE_SUSPEND_LAMBDA, this.functionsStack.get(i), true);
                    }
                    if (this.functionsStack.get(i) != functionWithCrossinlineParameter) continue;
                    return;
                }
            }
        }
    }

    private void checkSamCall(@NotNull KtCallElement expression2) {
        ResolvedCall<? extends CallableDescriptor> call2 = CallUtilKt.getResolvedCall(expression2, this.bindingContext);
        if (call2 == null) {
            return;
        }
        CallableDescriptor descriptor2 = call2.getResultingDescriptor();
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return;
        }
        this.recordSamValueForNewInference(call2);
        this.recordSamConstructorIfNeeded(expression2, call2);
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)descriptor2);
        if (original == null) {
            return;
        }
        SmartList valueParametersWithSAMConversion = new SmartList();
        for (ValueParameterDescriptor valueParameter : original.getValueParameters()) {
            ValueParameterDescriptor adaptedParameter = descriptor2.getValueParameters().get(valueParameter.getIndex());
            if (KotlinTypeChecker.DEFAULT.equalTypes(adaptedParameter.getType(), valueParameter.getType())) continue;
            valueParametersWithSAMConversion.add(valueParameter);
        }
        this.writeSamValueForValueParameters((Collection<ValueParameterDescriptor>)valueParametersWithSAMConversion, call2.getValueArgumentsByIndex());
    }

    private void recordSamValueForNewInference(@NotNull ResolvedCall<?> call2) {
        ResolvedCall newResolvedCall = null;
        if (call2 instanceof NewVariableAsFunctionResolvedCallImpl) {
            newResolvedCall = ((NewVariableAsFunctionResolvedCallImpl)call2).getFunctionCall();
        } else if (call2 instanceof NewResolvedCallImpl) {
            newResolvedCall = (NewResolvedCallImpl)call2;
        }
        if (newResolvedCall == null) {
            return;
        }
        SmartList valueParametersWithSAMConversion = new SmartList();
        Map<ValueParameterDescriptor, ResolvedValueArgument> arguments2 = ((NewAbstractResolvedCall)newResolvedCall).getValueArguments();
        for (ValueParameterDescriptor valueParameter : arguments2.keySet()) {
            ValueArgument valueArgument;
            ResolvedValueArgument argument = arguments2.get(valueParameter);
            if (!(argument instanceof ExpressionValueArgument) || (valueArgument = ((ExpressionValueArgument)argument).getValueArgument()) == null || ((NewResolvedCallImpl)newResolvedCall).getExpectedTypeForSamConvertedArgument(valueArgument) == null) continue;
            valueParametersWithSAMConversion.add(valueParameter.getOriginal());
        }
        this.writeSamValueForValueParameters((Collection<ValueParameterDescriptor>)valueParametersWithSAMConversion, ((NewAbstractResolvedCall)newResolvedCall).getValueArgumentsByIndex());
    }

    private void writeSamValueForValueParameters(@NotNull Collection<ValueParameterDescriptor> valueParametersWithSAMConversion, @Nullable List<ResolvedValueArgument> valueArguments) {
        if (valueArguments == null) {
            return;
        }
        for (ValueParameterDescriptor valueParameter : valueParametersWithSAMConversion) {
            SamType samType = SamType.createByValueParameter(valueParameter);
            if (samType == null) continue;
            ResolvedValueArgument resolvedValueArgument = valueArguments.get(valueParameter.getIndex());
            assert (resolvedValueArgument instanceof ExpressionValueArgument) : resolvedValueArgument;
            ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
            assert (valueArgument != null);
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            assert (argumentExpression != null) : valueArgument.asElement().getText();
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
        }
    }

    @Override
    public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call2) {
        if (!CodegenAnnotatingVisitor.isSuperTypeCallForAnonymousObject(call2)) {
            this.withinUninitializedClass(call2, () -> super.visitSuperTypeCallEntry(call2));
        } else {
            super.visitSuperTypeCallEntry(call2);
        }
        this.checkSamCall(call2);
    }

    private static boolean isSuperTypeCallForAnonymousObject(@NotNull KtSuperTypeCallEntry call2) {
        PsiElement parent2 = call2.getParent();
        if (!(parent2 instanceof KtSuperTypeList)) {
            return false;
        }
        if (!((parent2 = parent2.getParent()) instanceof KtObjectDeclaration)) {
            return false;
        }
        return (parent2 = parent2.getParent()) instanceof KtObjectLiteralExpression;
    }

    @Override
    public void visitConstructorDelegationCall(@NotNull KtConstructorDelegationCall call2) {
        this.withinUninitializedClass(call2, () -> super.visitConstructorDelegationCall(call2));
        this.checkSamCall(call2);
    }

    private void withinUninitializedClass(@NotNull KtElement element, @NotNull Runnable operation) {
        ClassDescriptor currentClass = CodegenAnnotatingVisitor.peekFromStack(this.classStack);
        assert (currentClass != null) : element.getClass().getSimpleName() + " should be inside a class: " + element.getText();
        assert (!this.uninitializedClasses.contains(currentClass)) : "Class entered twice: " + currentClass;
        this.uninitializedClasses.add(currentClass);
        operation.run();
        boolean removed2 = this.uninitializedClasses.remove(currentClass);
        assert (removed2) : "Inconsistent uninitialized class stack: " + currentClass;
    }

    private void recordSamConstructorIfNeeded(@NotNull KtCallElement expression2, @NotNull ResolvedCall<?> call2) {
        Object callableDescriptor = call2.getResultingDescriptor();
        if (!(callableDescriptor.getOriginal() instanceof SamConstructorDescriptor)) {
            return;
        }
        List<ResolvedValueArgument> valueArguments = call2.getValueArgumentsByIndex();
        if (valueArguments == null || valueArguments.size() != 1) {
            return;
        }
        ResolvedValueArgument valueArgument = valueArguments.get(0);
        if (!(valueArgument instanceof ExpressionValueArgument)) {
            return;
        }
        ValueArgument argument = ((ExpressionValueArgument)valueArgument).getValueArgument();
        if (argument == null) {
            return;
        }
        KtExpression argumentExpression = argument.getArgumentExpression();
        this.bindingTrace.record(CodegenBinding.SAM_CONSTRUCTOR_TO_ARGUMENT, expression2, argumentExpression);
        SamType samType = SamType.create(callableDescriptor.getReturnType());
        this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        super.visitBinaryExpression(expression2);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        SamType samType = SamType.createByValueParameter(original.getValueParameters().get(0));
        if (samType == null) {
            return;
        }
        IElementType token = expression2.getOperationToken();
        if (BINARY_OPERATIONS.contains(token)) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression2.getRight(), samType);
        } else if (token == KtTokens.IN_KEYWORD || token == KtTokens.NOT_IN) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression2.getLeft(), samType);
        }
    }

    @Override
    public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
        super.visitArrayAccessExpression(expression2);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        boolean isSetter = operationDescriptor.getName().asString().equals("set");
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        List<KtExpression> indexExpressions = expression2.getIndexExpressions();
        List<ValueParameterDescriptor> parameters2 = original.getValueParameters();
        for (ValueParameterDescriptor valueParameter : parameters2) {
            SamType samType = SamType.createByValueParameter(valueParameter);
            if (samType == null) continue;
            if (isSetter && valueParameter.getIndex() == parameters2.size() - 1) {
                PsiElement parent2 = expression2.getParent();
                if (!(parent2 instanceof KtBinaryExpression) || ((KtBinaryExpression)parent2).getOperationToken() != KtTokens.EQ) continue;
                KtExpression right = ((KtBinaryExpression)parent2).getRight();
                this.bindingTrace.record(CodegenBinding.SAM_VALUE, right, samType);
                continue;
            }
            KtExpression indexExpression = indexExpressions.get(valueParameter.getIndex());
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, indexExpression, samType);
        }
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
        super.visitWhenExpression(expression2);
        if (!this.isWhenWithEnums(expression2)) {
            return;
        }
        String currentClassName = this.getCurrentTopLevelClassOrPackagePartInternalName(expression2.getContainingKtFile());
        if (this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName) == null) {
            this.bindingTrace.record(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName, new ArrayList(1));
        }
        List<WhenByEnumsMapping> mappings = this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName);
        assert (mappings != null) : "guaranteed by contract";
        int fieldNumber = mappings.size();
        assert (expression2.getSubjectExpression() != null) : "subject expression should be not null in a valid when by enums";
        KotlinType type2 = WhenChecker.whenSubjectType(expression2, this.bindingContext);
        assert (type2 != null) : "should not be null in a valid when by enums";
        ClassDescriptor classDescriptor2 = (ClassDescriptor)type2.getConstructor().getDeclarationDescriptor();
        assert (classDescriptor2 != null) : "because it's enum";
        WhenByEnumsMapping mapping2 = new WhenByEnumsMapping(classDescriptor2, currentClassName, fieldNumber);
        for (ConstantValue<?> constant : this.switchCodegenProvider.getAllConstants(expression2)) {
            if (constant instanceof NullValue) continue;
            assert (constant instanceof EnumValue) : "expression in when should be EnumValue";
            mapping2.putFirstTime((EnumValue)constant, mapping2.size() + 1);
        }
        mappings.add(mapping2);
        this.bindingTrace.record(CodegenBinding.MAPPING_FOR_WHEN_BY_ENUM, expression2, mapping2);
    }

    private boolean isWhenWithEnums(@NotNull KtWhenExpression expression2) {
        ClassId enumClassId = WhenChecker.getClassIdForEnumSubject(expression2, this.bindingContext);
        if (enumClassId == null) {
            return false;
        }
        return this.switchCodegenProvider.checkAllItemsAreConstantsSatisfying(expression2, constant -> CodegenAnnotatingVisitor.isEnumEntryOrNull(enumClassId, constant));
    }

    private static boolean isEnumEntryOrNull(ClassId enumClassId, ConstantValue<?> constant) {
        return constant instanceof EnumValue && ((EnumValue)constant).getEnumClassId().equals(enumClassId) || constant instanceof NullValue;
    }

    @NotNull
    private String getCurrentTopLevelClassOrPackagePartInternalName(@NotNull KtFile file2) {
        ListIterator iterator2 = this.classStack.listIterator(this.classStack.size());
        while (iterator2.hasPrevious()) {
            ClassDescriptor previous = (ClassDescriptor)iterator2.previous();
            if (!DescriptorUtils.isTopLevelOrInnerClass(previous)) continue;
            return CodegenBinding.getAsmType(this.bindingContext, previous).getInternalName();
        }
        return JvmFileClassUtil.getFacadeClassInternalName(file2);
    }

    private static <T> T peekFromStack(@NotNull Stack<T> stack) {
        return (T)(stack.empty() ? null : stack.peek());
    }
}

