/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedCallableDescriptor;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedTypeParameterDescriptor;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedValueParameterDescriptor;
import org.jetbrains.kotlin.backend.common.lower.BOUND_VALUE_PARAMETER;
import org.jetbrains.kotlin.backend.common.utils.KotlinTypeBasedUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.CallableReferenceKey;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrTypeParameterImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrValueParameterImpl;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetVariableImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrTypeParameterSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001IB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010%\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0018\u0010)\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0007H\u0002J\u0010\u0010+\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0013H\u0002J6\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010\"\u001a\u00020\u000b2\u001e\u0010-\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002000\u0016\u0012\u0004\u0012\u0002010/0.H\u0002J6\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00162\u0006\u00104\u001a\u00020 2\u0006\u00105\u001a\u00020 2\u0006\u00106\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u00107\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016J\u0018\u0010<\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020 2\u0006\u0010=\u001a\u00020>H\u0002J\u0018\u0010?\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020DH\u0002J\u0018\u0010E\u001a\u00020\n2\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010F\u001a\u00020G2\u0006\u00104\u001a\u00020$2\u0006\u0010H\u001a\u00020 H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u00020\u001c*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "callableNameConst", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "callableToFactoryFunction", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceKey;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getterConst", "implicitDeclarationFile", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrFileImpl;", "newDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "setterConst", "arguments", "", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getArguments", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Ljava/util/List;", "arity", "", "getArity", "(Lorg/jetbrains/kotlin/ir/types/IrType;)I", "buildClosureFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "declaration", "factoryFunction", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "buildFactoryFunction", "getterName", "createClosureInstanceName", "createFunctionFactoryName", "createHelperFunctionName", "suffix", "createPropertyFactoryName", "generateFactoryBodyWithGuard", "builder", "Lkotlin/Function0;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "generateSignatureForClosure", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "callable", "factory", "closure", "getReferenceName", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "lowerKFunctionReference", "functionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "lowerKPropertyReference", "getterDeclaration", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "lowerLocalKPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "makeCallableKey", "redirectToFunction", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "newTarget", "CallableReferenceLowerTransformer", "backend.js"})
public final class CallableReferenceLowering
implements FileLoweringPass {
    private final IrConstImpl<String> callableNameConst;
    private final IrConstImpl<String> getterConst;
    private final IrConstImpl<String> setterConst;
    private final Map<CallableReferenceKey, IrSimpleFunction> callableToFactoryFunction;
    private final List<IrDeclaration> newDeclarations;
    private final IrFileImpl implicitDeclarationFile;
    @NotNull
    private final JsIrBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        this.newDeclarations.clear();
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new CallableReferenceLowerTransformer());
        Collection collection = this.implicitDeclarationFile.getDeclarations();
        Iterable iterable = this.newDeclarations;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
    }

    private final CallableReferenceKey makeCallableKey(IrFunction declaration, IrCallableReference reference) {
        return new CallableReferenceKey(declaration, reference.getDispatchReceiver() != null, reference.getExtensionReceiver() != null, IrTypeUtilsKt.asString(reference.getType()));
    }

    /*
     * WARNING - void declaration
     */
    private final IrCallImpl redirectToFunction(IrCallableReference callable, IrFunction newTarget) {
        int n;
        IrExpression it;
        IrExpression irExpression;
        IrCallImpl irCallImpl;
        IrCallImpl $receiver = irCallImpl = new IrCallImpl(callable.getStartOffset(), callable.getEndOffset(), newTarget.getSymbol().getOwner().getReturnType(), newTarget.getSymbol(), newTarget.getSymbol().getDescriptor(), callable.getOrigin(), null, 64, null);
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom($receiver, callable);
        int index2 = 0;
        IrExpression irExpression2 = callable.getDispatchReceiver();
        if (irExpression2 != null) {
            it = irExpression = irExpression2;
            n = index2;
            index2 = n + 1;
            $receiver.putValueArgument(n, it);
        }
        IrExpression irExpression3 = callable.getExtensionReceiver();
        if (irExpression3 != null) {
            it = irExpression = irExpression3;
            n = index2;
            index2 = n + 1;
            $receiver.putValueArgument(n, it);
        }
        int n2 = 0;
        int n3 = callable.getValueArgumentsCount();
        while (n2 < n3) {
            void i;
            IrExpression arg = callable.getValueArgument((int)i);
            if (arg != null) {
                int n4 = index2;
                index2 = n4 + 1;
                $receiver.putValueArgument(n4, arg);
            }
            ++i;
        }
        return irCallImpl;
    }

    private final String createFunctionFactoryName(IrDeclaration declaration) {
        return this.createHelperFunctionName(declaration, "KFunctionFactory");
    }

    private final String createPropertyFactoryName(IrDeclaration declaration) {
        return this.createHelperFunctionName(declaration, "KPropertyFactory");
    }

    private final String createClosureInstanceName(IrDeclaration declaration) {
        return this.createHelperFunctionName(declaration, "KReferenceClosure");
    }

    private final String createHelperFunctionName(IrDeclaration declaration, String suffix) {
        IrDeclaration irDeclaration;
        StringBuilder nameBuilder = new StringBuilder();
        if (declaration instanceof IrConstructor) {
            IrDeclarationParent irDeclarationParent = declaration.getParent();
            if (irDeclarationParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            }
            IrClass klass2 = (IrClass)irDeclarationParent;
            nameBuilder.append(klass2.getName().asString());
            nameBuilder.append('_');
        }
        if ((irDeclaration = declaration) instanceof IrFunction) {
            nameBuilder.append(((IrFunction)declaration).getName());
        } else if (irDeclaration instanceof IrProperty) {
            nameBuilder.append(((IrProperty)declaration).getName());
        } else if (irDeclaration instanceof IrVariable) {
            nameBuilder.append(((IrVariable)declaration).getName());
        } else {
            String string = "Unexpected declaration type";
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        nameBuilder.append('_');
        nameBuilder.append(suffix);
        String string = nameBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nameBuilder.toString()");
        return string;
    }

    private final String getReferenceName(IrDeclaration declaration) {
        String string;
        IrDeclaration irDeclaration = declaration;
        if (irDeclaration instanceof IrConstructor) {
            IrDeclarationParent irDeclarationParent = declaration.getParent();
            if (irDeclarationParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            }
            string = ((IrClass)irDeclarationParent).getName().getIdentifier();
        } else if (irDeclaration instanceof IrProperty) {
            string = ((IrProperty)declaration).getName().getIdentifier();
        } else if (irDeclaration instanceof IrSimpleFunction) {
            string = ((IrSimpleFunction)declaration).getName().asString();
        } else if (irDeclaration instanceof IrVariable) {
            String string2 = ((IrVariable)declaration).getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"declaration.name.asString()");
            string = StringsKt.replace$default((String)string2, (String)"$delegate", (String)"", (boolean)false, (int)4, null);
        } else {
            String string3 = "Unexpected declaration type";
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string3);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"when (declaration) {\n   \u2026 declaration type\")\n    }");
        return string;
    }

    private final IrSimpleFunction lowerKFunctionReference(IrFunction declaration, IrFunctionReference functionReference2) {
        IrSimpleFunction factoryFunction = this.buildFactoryFunction(declaration, functionReference2, this.createFunctionFactoryName(declaration));
        IrFunction closureFunction = this.buildClosureFunction(declaration, factoryFunction, functionReference2, this.getArity(functionReference2.getType()));
        List<IrDeclaration> additionalDeclarations2 = this.generateFactoryBodyWithGuard(factoryFunction, (Function0<? extends Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>)((Function0)new Function0<Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>(this, functionReference2, closureFunction, factoryFunction, declaration){
            final /* synthetic */ CallableReferenceLowering this$0;
            final /* synthetic */ IrFunctionReference $functionReference;
            final /* synthetic */ IrFunction $closureFunction;
            final /* synthetic */ IrSimpleFunction $factoryFunction;
            final /* synthetic */ IrFunction $declaration;

            @NotNull
            public final Pair<List<IrStatement>, IrValueSymbol> invoke() {
                IrCall irCall;
                IrFunctionReferenceImpl irClosureReference = JsIrBuilder.INSTANCE.buildFunctionReference(this.$functionReference.getType(), this.$closureFunction.getSymbol());
                IrVariable irVar = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, irClosureReference.getType(), this.$factoryFunction, null, false, false, false, irClosureReference, 60, null);
                IrCall $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                $receiver.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irVar.getSymbol()));
                $receiver.putValueArgument(1, CallableReferenceLowering.access$getCallableNameConst$p(this.this$0));
                $receiver.putValueArgument(2, JsIrBuilder.INSTANCE.buildString(this.this$0.getContext().getIrBuiltIns().getStringType(), CallableReferenceLowering.access$getReferenceName(this.this$0, this.$declaration)));
                IrCall irSetName = irCall;
                return new Pair((Object)CollectionsKt.listOf((Object[])new IrStatement[]{this.$closureFunction, irVar, irSetName}), (Object)irVar.getSymbol());
            }
            {
                this.this$0 = callableReferenceLowering;
                this.$functionReference = irFunctionReference;
                this.$closureFunction = irFunction;
                this.$factoryFunction = irSimpleFunction;
                this.$declaration = irFunction2;
                super(0);
            }
        }));
        Collection collection = this.newDeclarations;
        Iterable iterable = CollectionsKt.plus((Collection)additionalDeclarations2, (Object)factoryFunction);
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return factoryFunction;
    }

    private final IrSimpleFunction lowerKPropertyReference(IrSimpleFunction getterDeclaration, IrPropertyReference propertyReference) {
        IrFunction irFunction;
        IrFunction irFunction2;
        IrSimpleFunctionSymbol it;
        int arity = this.getArity(propertyReference.getType());
        IrProperty irProperty = getterDeclaration.getCorrespondingProperty();
        if (irProperty == null) {
            Intrinsics.throwNpe();
        }
        String factoryName = this.createPropertyFactoryName(irProperty);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = propertyReference.getGetter();
        if (irSimpleFunctionSymbol == null) {
            Intrinsics.throwNpe();
        }
        IrSimpleFunction factoryFunction = this.buildFactoryFunction(irSimpleFunctionSymbol.getOwner(), propertyReference, factoryName);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = propertyReference.getGetter();
        if (irSimpleFunctionSymbol2 != null) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol3;
            it = irSimpleFunctionSymbol3 = irSimpleFunctionSymbol2;
            irFunction2 = this.buildClosureFunction(it.getOwner(), factoryFunction, propertyReference, arity);
        } else {
            irFunction2 = null;
        }
        if (irFunction2 == null) {
            Intrinsics.throwNpe();
        }
        IrFunction getterFunction = irFunction2;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol4 = propertyReference.getSetter();
        if (irSimpleFunctionSymbol4 != null) {
            IrSimpleFunctionSymbol it2 = it = irSimpleFunctionSymbol4;
            irFunction = this.buildClosureFunction(it2.getOwner(), factoryFunction, propertyReference, arity + 1);
        } else {
            irFunction = null;
        }
        IrFunction setterFunction = irFunction;
        List<IrDeclaration> additionalDeclarations2 = this.generateFactoryBodyWithGuard(factoryFunction, (Function0<? extends Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>)((Function0)new Function0<Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>(this, getterFunction, factoryFunction, setterFunction, getterDeclaration){
            final /* synthetic */ CallableReferenceLowering this$0;
            final /* synthetic */ IrFunction $getterFunction;
            final /* synthetic */ IrSimpleFunction $factoryFunction;
            final /* synthetic */ IrFunction $setterFunction;
            final /* synthetic */ IrSimpleFunction $getterDeclaration;

            @NotNull
            public final Pair<List<IrStatement>, IrValueSymbol> invoke() {
                List statements = CollectionsKt.mutableListOf((Object[])new IrStatement[]{this.$getterFunction});
                ClassDescriptor classDescriptor2 = this.this$0.getContext().getBuiltIns().getFunction(this.$getterFunction.getValueParameters().size() + 1);
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"context.builtIns.getFunc\u2026valueParameters.size + 1)");
                ClassDescriptor getterFunctionType = classDescriptor2;
                IrType type2 = IrTypesKt.toIrType$default(getterFunctionType, false, this.this$0.getContext().getSymbolTable(), 1, null);
                IrFunctionReferenceImpl irGetReference = JsIrBuilder.INSTANCE.buildFunctionReference(type2, this.$getterFunction.getSymbol());
                IrVariable irVar = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, type2, this.$factoryFunction, null, false, false, false, irGetReference, 60, null);
                Collection collection = statements;
                collection.add(irVar);
                collection = statements;
                IrStatement irStatement = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                Object $receiver = irStatement;
                $receiver.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irVar.getSymbol()));
                $receiver.putValueArgument(1, CallableReferenceLowering.access$getGetterConst$p(this.this$0));
                $receiver.putValueArgument(2, JsIrBuilder.INSTANCE.buildGetValue(irVar.getSymbol()));
                collection.add(irStatement);
                if (this.$setterFunction != null) {
                    IrCall $i$a$1$apply;
                    collection = statements;
                    irStatement = this.$setterFunction;
                    collection.add(irStatement);
                    ClassDescriptor classDescriptor3 = this.this$0.getContext().getBuiltIns().getFunction(this.$setterFunction.getValueParameters().size() + 1);
                    Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor3, (String)"context.builtIns.getFunc\u2026valueParameters.size + 1)");
                    ClassDescriptor setterFunctionType = classDescriptor3;
                    IrFunctionReferenceImpl irSetReference = JsIrBuilder.INSTANCE.buildFunctionReference(IrTypesKt.toIrType$default(setterFunctionType, false, this.this$0.getContext().getSymbolTable(), 1, null), this.$setterFunction.getSymbol());
                    $receiver = statements;
                    IrCall $receiver2 = $i$a$1$apply = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                    $receiver2.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irVar.getSymbol()));
                    $receiver2.putValueArgument(1, CallableReferenceLowering.access$getSetterConst$p(this.this$0));
                    $receiver2.putValueArgument(2, irSetReference);
                    $receiver.add($i$a$1$apply);
                }
                collection = statements;
                irStatement = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                $receiver = irStatement;
                $receiver.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irVar.getSymbol()));
                $receiver.putValueArgument(1, CallableReferenceLowering.access$getCallableNameConst$p(this.this$0));
                IrType irType = this.this$0.getContext().getIrBuiltIns().getStringType();
                IrProperty irProperty = this.$getterDeclaration.getCorrespondingProperty();
                if (irProperty == null) {
                    Intrinsics.throwNpe();
                }
                $receiver.putValueArgument(2, JsIrBuilder.INSTANCE.buildString(irType, CallableReferenceLowering.access$getReferenceName(this.this$0, irProperty)));
                collection.add(irStatement);
                return new Pair((Object)statements, (Object)irVar.getSymbol());
            }
            {
                this.this$0 = callableReferenceLowering;
                this.$getterFunction = irFunction;
                this.$factoryFunction = irSimpleFunction;
                this.$setterFunction = irFunction2;
                this.$getterDeclaration = irSimpleFunction2;
                super(0);
            }
        }));
        Collection collection = this.newDeclarations;
        Iterable iterable = CollectionsKt.plus((Collection)additionalDeclarations2, (Object)factoryFunction);
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return factoryFunction;
    }

    private final IrSimpleFunction lowerLocalKPropertyReference(IrLocalDelegatedPropertyReference propertyReference) {
        int arity = this.getArity(propertyReference.getType());
        IrVariable declaration = (IrVariable)propertyReference.getDelegate().getOwner();
        String factoryName = this.createPropertyFactoryName(declaration);
        IrSimpleFunction factoryFunction = this.buildFactoryFunction(propertyReference.getGetter().getOwner(), propertyReference, factoryName);
        IrFunction closureFunction = this.buildClosureFunction(this.context.getIrBuiltIns().getThrowIseFun(), factoryFunction, propertyReference, arity);
        List<IrDeclaration> additionalDeclarations2 = this.generateFactoryBodyWithGuard(factoryFunction, (Function0<? extends Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>)((Function0)new Function0<Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>(this, closureFunction, factoryFunction, declaration){
            final /* synthetic */ CallableReferenceLowering this$0;
            final /* synthetic */ IrFunction $closureFunction;
            final /* synthetic */ IrSimpleFunction $factoryFunction;
            final /* synthetic */ IrVariable $declaration;

            @NotNull
            public final Pair<List<IrStatement>, IrValueSymbol> invoke() {
                IrCall irCall;
                List statements = CollectionsKt.mutableListOf((Object[])new IrStatement[]{this.$closureFunction});
                ClassDescriptor classDescriptor2 = this.this$0.getContext().getBuiltIns().getFunction(this.$closureFunction.getValueParameters().size() + 1);
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"context.builtIns.getFunc\u2026valueParameters.size + 1)");
                ClassDescriptor getterFunctionType = classDescriptor2;
                IrType type2 = IrTypesKt.toIrType$default(getterFunctionType, false, this.this$0.getContext().getSymbolTable(), 1, null);
                IrFunctionReferenceImpl irGetReference = JsIrBuilder.INSTANCE.buildFunctionReference(type2, this.$closureFunction.getSymbol());
                IrVariable irVar = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, type2, this.$factoryFunction, null, false, false, false, irGetReference, 60, null);
                IrVariableSymbol irVarSymbol = (IrVariableSymbol)irVar.getSymbol();
                Collection collection = statements;
                collection.add(irVar);
                collection = statements;
                IrCall $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                $receiver.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irVarSymbol));
                $receiver.putValueArgument(1, CallableReferenceLowering.access$getGetterConst$p(this.this$0));
                $receiver.putValueArgument(2, JsIrBuilder.INSTANCE.buildGetValue(irVarSymbol));
                collection.add(irCall);
                collection = statements;
                $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                $receiver.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irVarSymbol));
                $receiver.putValueArgument(1, CallableReferenceLowering.access$getCallableNameConst$p(this.this$0));
                $receiver.putValueArgument(2, JsIrBuilder.INSTANCE.buildString(this.this$0.getContext().getIrBuiltIns().getStringType(), CallableReferenceLowering.access$getReferenceName(this.this$0, this.$declaration)));
                collection.add(irCall);
                return new Pair((Object)statements, (Object)irVarSymbol);
            }
            {
                this.this$0 = callableReferenceLowering;
                this.$closureFunction = irFunction;
                this.$factoryFunction = irSimpleFunction;
                this.$declaration = irVariable;
                super(0);
            }
        }));
        Collection collection = this.newDeclarations;
        Iterable iterable = CollectionsKt.plus((Collection)additionalDeclarations2, (Object)factoryFunction);
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return factoryFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrDeclaration> generateFactoryBodyWithGuard(IrSimpleFunction factoryFunction, Function0<? extends Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>> builder) {
        Collection collection;
        List returnStatements;
        IrExpression returnValue;
        void bodyStatements;
        Pair pair = (Pair)builder.invoke();
        List list2 = (List)pair.component1();
        IrValueSymbol varSymbol = (IrValueSymbol)pair.component2();
        List statements = new ArrayList();
        if (factoryFunction.getValueParameters().isEmpty()) {
            List $i$a$1$apply;
            IrCall irCall;
            String cacheName = factoryFunction.getName() + '_' + Namer.INSTANCE.getKCALLABLE_CACHE_SUFFIX();
            IrType type2 = factoryFunction.getReturnType();
            IrConstImpl irNull = JsIrBuilder.INSTANCE.buildNull(this.context.getIrBuiltIns().getNothingNType());
            IrVariable cacheVar = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, type2, factoryFunction.getParent(), cacheName, true, false, false, irNull, 48, null);
            IrGetValueImpl irCacheValue = JsIrBuilder.INSTANCE.buildGetValue(cacheVar.getSymbol());
            IrCall $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIrBuiltIns().getEqeqSymbol(), null, null, 6, null);
            $receiver.putValueArgument(0, irCacheValue);
            $receiver.putValueArgument(1, irNull);
            IrCall irIfCondition = irCall;
            IrSetVariableImpl irSetCache = JsIrBuilder.INSTANCE.buildSetVariable((IrVariableSymbol)cacheVar.getSymbol(), JsIrBuilder.INSTANCE.buildGetValue(varSymbol), this.context.getIrBuiltIns().getUnitType());
            List $receiver2 = $i$a$1$apply = (List)new ArrayList();
            $receiver2.addAll((Collection)bodyStatements);
            $receiver2.add(irSetCache);
            List thenStatements = $i$a$1$apply;
            IrBlockImpl irThenBranch = JsIrBuilder.INSTANCE.buildBlock(this.context.getIrBuiltIns().getUnitType(), thenStatements);
            IrWhen irIfNode = JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, this.context.getIrBuiltIns().getUnitType(), irIfCondition, irThenBranch, null, 8, null);
            Collection collection2 = statements;
            collection2.add(irIfNode);
            returnValue = irCacheValue;
            returnStatements = CollectionsKt.listOf((Object)cacheVar);
        } else {
            collection = statements;
            CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)bodyStatements));
            returnValue = JsIrBuilder.INSTANCE.buildGetValue(varSymbol);
            returnStatements = CollectionsKt.emptyList();
        }
        collection = statements;
        IrReturnImpl irReturnImpl = JsIrBuilder.INSTANCE.buildReturn(factoryFunction.getSymbol(), returnValue, this.context.getIrBuiltIns().getNothingType());
        collection.add(irReturnImpl);
        factoryFunction.setBody(JsIrBuilder.INSTANCE.buildBlockBody(statements));
        return returnStatements;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrValueParameter> generateSignatureForClosure(IrFunction callable, IrFunction factory2, IrSimpleFunction closure, IrCallableReference reference, int arity) {
        Object it;
        Object object;
        IrValueParameter irValueParameter4;
        Object it2;
        void $receiver$iv$iv;
        List result2 = new ArrayList();
        int capturedParams = factory2.getValueParameters().size();
        Iterable $receiver$iv = CollectionsKt.dropLast(this.getArguments(reference.getType()), (int)1);
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            Collection collection = destination$iv$iv2;
            void v0 = it2;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrTypeProjection");
            }
            IrType irType = ((IrTypeProjection)v0).getType();
            collection.add(irType);
        }
        List functionSignature = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        IrValueParameter irValueParameter2 = callable.getDispatchReceiverParameter();
        if (irValueParameter2 != null) {
            IrValueParameter dispatch = irValueParameter4 = irValueParameter2;
            if (reference.getDispatchReceiver() == null) {
                destination$iv$iv2 = JsIrBuilder.buildValueParameter$default(JsIrBuilder.INSTANCE, dispatch.getName(), result2.size(), dispatch.getType(), null, 8, null);
                object = result2;
                it = destination$iv$iv2;
                it.setParent(closure);
                it2 = destination$iv$iv2;
                object.add(it2);
            } else {
                int destination$iv$iv2 = capturedParams;
                capturedParams = destination$iv$iv2 + -1;
            }
        }
        IrValueParameter irValueParameter3 = callable.getExtensionReceiverParameter();
        if (irValueParameter3 != null) {
            IrValueParameter ext = irValueParameter4 = irValueParameter3;
            if (reference.getExtensionReceiver() == null) {
                IrValueParameter destination$iv$iv2 = JsIrBuilder.buildValueParameter$default(JsIrBuilder.INSTANCE, ext.getName(), result2.size(), ext.getType(), null, 8, null);
                object = result2;
                it = destination$iv$iv2;
                it.setParent(closure);
                it2 = destination$iv$iv2;
                object.add(it2);
            } else {
                int destination$iv$iv2 = capturedParams;
                capturedParams = destination$iv$iv2 + -1;
            }
        }
        for (IrValueParameter irValueParameter4 : CollectionsKt.zip((Iterable)((Iterable)RangesKt.until((int)result2.size(), (int)arity)), (Iterable)CollectionsKt.drop((Iterable)callable.getValueParameters(), (int)capturedParams))) {
            IrValueParameter irValueParameter5;
            String paramName;
            int index2 = ((Number)irValueParameter4.component1()).intValue();
            IrValueParameter param = (IrValueParameter)irValueParameter4.component2();
            IrType type2 = index2 < functionSignature.size() ? (IrType)functionSignature.get(index2) : param.getType();
            Object object2 = param.getName();
            Name $receiver = object2;
            Intrinsics.checkExpressionValueIsNotNull((Object)(!$receiver.isSpecial() ? $receiver.getIdentifier() : "" + 'p' + index2), (String)"param.name.run { if (!is\u2026entifier else \"p$index\" }");
            paramName = paramName;
            object2 = result2;
            IrValueParameter it3 = irValueParameter5 = JsIrBuilder.INSTANCE.buildValueParameter(paramName, result2.size(), type2);
            it3.setParent(closure);
            object2.add(irValueParameter5);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction buildFactoryFunction(IrFunction declaration, IrCallableReference reference, String getterName) {
        List<IrTypeParameter> list2;
        IrValueParameterImpl it;
        IrDeclarationBase irDeclarationBase;
        Collection collection;
        WrappedCallableDescriptor descriptor2;
        void $receiver$iv$iv2;
        void $receiver$iv;
        IrValueParameter irValueParameter;
        Collection collection2;
        Object it2;
        IrExpression irExpression;
        List receivers = new ArrayList();
        IrExpression irExpression2 = reference.getDispatchReceiver();
        if (irExpression2 != null) {
            irExpression = irExpression2;
            it2 = irExpression;
            collection2 = receivers;
            IrValueParameter irValueParameter2 = declaration.getDispatchReceiverParameter();
            if (irValueParameter2 == null) {
                irValueParameter2 = declaration.getValueParameters().get(0);
            }
            irValueParameter = irValueParameter2;
            collection2.add(irValueParameter);
        }
        IrExpression irExpression3 = reference.getExtensionReceiver();
        if (irExpression3 != null) {
            irExpression = irExpression3;
            it2 = irExpression;
            collection2 = receivers;
            IrValueParameter irValueParameter3 = declaration.getExtensionReceiverParameter();
            if (irValueParameter3 == null) {
                Intrinsics.throwNpe();
            }
            irValueParameter = irValueParameter3;
            collection2.add(irValueParameter);
        }
        it2 = declaration.getValueParameters();
        Collection collection3 = receivers;
        collection2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            IrValueParameter it3 = (IrValueParameter)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it3.getOrigin(), (Object)BOUND_VALUE_PARAMETER.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        List boundValueParameters = CollectionsKt.plus((Collection)collection3, (Iterable)list3);
        IrSimpleFunction factoryDeclaration = JsIrBuilder.buildFunction$default(JsIrBuilder.INSTANCE, getterName, declaration.getVisibility(), null, false, false, false, false, null, 252, null);
        factoryDeclaration.setParent(this.implicitDeclarationFile);
        factoryDeclaration.setReturnType(reference.getType());
        boolean $receiver$iv$iv2 = false;
        for (IrValueParameter p : (Iterable)boundValueParameters) {
            void i;
            descriptor2 = new WrappedValueParameterDescriptor(null, null, 3, null);
            collection = factoryDeclaration.getValueParameters();
            it = irDeclarationBase = new IrValueParameterImpl(p.getStartOffset(), p.getEndOffset(), p.getOrigin(), new IrValueParameterSymbolImpl((ParameterDescriptor)((Object)descriptor2)), p.getName(), (int)i, p.getType(), p.getVarargElementType(), p.isCrossinline(), p.isNoinline());
            descriptor2.bind((IrDeclaration)it);
            it.setParent(factoryDeclaration);
            collection.add(irDeclarationBase);
            ++i;
        }
        if (declaration instanceof IrConstructor) {
            IrDeclarationParent irDeclarationParent = declaration.getParent();
            if (irDeclarationParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            }
            list2 = ((IrClass)irDeclarationParent).getTypeParameters();
        } else {
            list2 = declaration.getTypeParameters();
        }
        List<IrTypeParameter> typeParameters2 = list2;
        for (IrTypeParameter t : typeParameters2) {
            descriptor2 = new WrappedTypeParameterDescriptor(null, null, 3, null);
            collection = factoryDeclaration.getTypeParameters();
            it = irDeclarationBase = new IrTypeParameterImpl(t.getStartOffset(), t.getEndOffset(), t.getOrigin(), new IrTypeParameterSymbolImpl((TypeParameterDescriptor)((Object)descriptor2)), t.getName(), t.getIndex(), t.isReified(), t.getVariance());
            descriptor2.bind((IrDeclaration)it);
            it.setParent(factoryDeclaration);
            collection.add(irDeclarationBase);
        }
        return factoryDeclaration;
    }

    private final List<IrTypeArgument> getArguments(@NotNull IrType $receiver) {
        Object object;
        IrType irType = $receiver;
        if (!(irType instanceof IrSimpleType)) {
            irType = null;
        }
        if ((object = (IrSimpleType)irType) == null || (object = object.getArguments()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final int getArity(@NotNull IrType $receiver) {
        return this.getArguments($receiver).size() - 1;
    }

    /*
     * Unable to fully structure code
     */
    private final IrFunction buildClosureFunction(IrFunction declaration, IrSimpleFunction factoryFunction, IrCallableReference reference, int arity) {
        closureName = this.createClosureInstanceName(declaration);
        v0 = Visibilities.LOCAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"Visibilities.LOCAL");
        it = var7_6 = JsIrBuilder.buildFunction$default(JsIrBuilder.INSTANCE, closureName, v0, null, false, false, false, false, (IrDeclarationOrigin)JsIrBackendContext.Companion.getCallableClosureOrigin(), 124, null);
        it.setParent(factoryFunction);
        closureFunction = var7_6;
        $i$a$1$also = $receiver$iv = (Iterable)factoryFunction.getValueParameters();
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (T item$iv$iv : $receiver$iv$iv) {
            var13_13 = (IrValueParameter)item$iv$iv;
            var25_15 = destination$iv$iv;
            var26_16 = (IrValueParameterSymbol)it.getSymbol();
            var25_15.add(var26_16);
        }
        boundParamSymbols = (List)destination$iv$iv;
        unboundParamDeclarations = this.generateSignatureForClosure(declaration, factoryFunction, closureFunction, reference, arity);
        $receiver$iv = unboundParamDeclarations;
        var11_11 = $receiver$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (T item$iv$iv : $receiver$iv$iv) {
            $i$f$mapTo = (IrValueParameter)item$iv$iv;
            var25_15 = destination$iv$iv;
            var26_16 = (IrValueParameterSymbol)it.getSymbol();
            var25_15.add(var26_16);
        }
        unboundParamSymbols = (List)destination$iv$iv;
        returnType = declaration.getReturnType();
        $receiver$iv$iv = closureFunction.getValueParameters();
        CollectionsKt.addAll((Collection)$receiver$iv$iv, (Iterable)unboundParamDeclarations);
        closureFunction.setReturnType(returnType);
        v1 = this.context.getIr().getDefaultParameterDeclarationsCache().get(declaration);
        if (v1 == null) {
            v1 = declaration;
        }
        callTarget = v1;
        irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, callTarget.getSymbol(), returnType, null, 4, null);
        cp = 0;
        gp = 0;
        if (callTarget.getDispatchReceiverParameter() != null) {
            dispatchReceiverDeclaration = reference.getDispatchReceiver() != null ? (IrValueParameterSymbol)boundParamSymbols.get(gp++) : (IrValueParameterSymbol)unboundParamSymbols.get(cp++);
            irCall.setDispatchReceiver(JsIrBuilder.INSTANCE.buildGetValue(dispatchReceiverDeclaration));
        }
        if (callTarget.getExtensionReceiverParameter() != null) {
            extensionReceiverDeclaration = reference.getExtensionReceiver() != null ? (IrValueParameterSymbol)boundParamSymbols.get(gp++) : (IrValueParameterSymbol)unboundParamSymbols.get(cp++);
            irCall.setExtensionReceiver(JsIrBuilder.INSTANCE.buildGetValue(extensionReceiverDeclaration));
        }
        j = 0;
        $i$a$1$map = gp;
        var17_23 = boundParamSymbols.size();
        while ($i$a$1$map < var17_23) {
            irCall.putValueArgument(j++, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)boundParamSymbols.get(i)));
            ++i;
        }
        var17_23 = unboundParamSymbols.size();
        for (i = cp; i < var17_23; ++i) {
            closureParam = (IrValueParameter)((IrValueParameterSymbol)unboundParamSymbols.get(i)).getOwner();
            value = JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)unboundParamSymbols.get(i));
            parameter = callTarget.getValueParameters().get(j);
            if (parameter.getVarargElementType() == null) ** GOTO lbl-1000
            it = var22_28;
            if (KotlinTypeBasedUtilsKt.isSubtypeOf(closureParam.getType(), it)) {
                v2 = parameter.getType();
                v3 = parameter.getVarargElementType();
                if (v3 == null) {
                    Intrinsics.throwNpe();
                }
                v4 = new IrVarargImpl(-1, -1, v2, v3, CollectionsKt.listOf((Object)value));
            } else lbl-1000:
            // 2 sources

            {
                v4 = value;
            }
            argument = v4;
            irCall.putValueArgument(j++, argument);
        }
        irClosureReturn = JsIrBuilder.INSTANCE.buildReturn(closureFunction.getSymbol(), irCall, this.context.getIrBuiltIns().getNothingType());
        closureFunction.setBody(JsIrBuilder.INSTANCE.buildBlockBody(CollectionsKt.listOf((Object)irClosureReturn)));
        return closureFunction;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public CallableReferenceLowering(@NotNull JsIrBackendContext context) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.callableNameConst = JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), Namer.INSTANCE.getKCALLABLE_NAME());
        this.getterConst = JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), Namer.INSTANCE.getKPROPERTY_GET());
        this.setterConst = JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), Namer.INSTANCE.getKPROPERTY_SET());
        this.callableToFactoryFunction = this.context.getCallableReferencesCache();
        CallableReferenceLowering callableReferenceLowering = this;
        callableReferenceLowering.newDeclarations = list2 = (List)new ArrayList();
        this.implicitDeclarationFile = this.context.getImplicitDeclarationFile();
    }

    public static final /* synthetic */ IrConstImpl access$getCallableNameConst$p(CallableReferenceLowering $this) {
        return $this.callableNameConst;
    }

    public static final /* synthetic */ String access$getReferenceName(CallableReferenceLowering $this, IrDeclaration declaration) {
        return $this.getReferenceName(declaration);
    }

    public static final /* synthetic */ IrConstImpl access$getGetterConst$p(CallableReferenceLowering $this) {
        return $this.getterConst;
    }

    public static final /* synthetic */ IrConstImpl access$getSetterConst$p(CallableReferenceLowering $this) {
        return $this.setterConst;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceLowerTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;)V", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitLocalDelegatedPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "backend.js"})
    public final class CallableReferenceLowerTransformer
    extends IrElementTransformerVoid {
        @Override
        @NotNull
        public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrFunction declaration = expression2.getSymbol().getOwner();
            if (Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)JsIrBackendContext.Companion.getCallableClosureOrigin())) {
                return expression2;
            }
            CallableReferenceKey key = CallableReferenceLowering.this.makeCallableKey(declaration, expression2);
            Map $receiver$iv = CallableReferenceLowering.this.callableToFactoryFunction;
            Object value$iv = $receiver$iv.get(key);
            if (value$iv == null) {
                IrSimpleFunction answer$iv = CallableReferenceLowering.this.lowerKFunctionReference(declaration, expression2);
                $receiver$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            IrSimpleFunction factory2 = (IrSimpleFunction)object;
            return CallableReferenceLowering.this.redirectToFunction(expression2, factory2);
        }

        @Override
        @NotNull
        public IrExpression visitPropertyReference(@NotNull IrPropertyReference expression2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
            if (irSimpleFunctionSymbol == null) {
                Intrinsics.throwNpe();
            }
            IrSimpleFunction declaration = (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
            CallableReferenceKey key = CallableReferenceLowering.this.makeCallableKey(declaration, expression2);
            Map $receiver$iv = CallableReferenceLowering.this.callableToFactoryFunction;
            Object value$iv = $receiver$iv.get(key);
            if (value$iv == null) {
                IrSimpleFunction answer$iv = CallableReferenceLowering.this.lowerKPropertyReference(declaration, expression2);
                $receiver$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            IrSimpleFunction factory2 = (IrSimpleFunction)object;
            return CallableReferenceLowering.this.redirectToFunction(expression2, factory2);
        }

        @Override
        @NotNull
        public IrExpression visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            CallableReferenceKey key = CallableReferenceLowering.this.makeCallableKey(expression2.getGetter().getOwner(), expression2);
            Map $receiver$iv = CallableReferenceLowering.this.callableToFactoryFunction;
            Object value$iv = $receiver$iv.get(key);
            if (value$iv == null) {
                IrSimpleFunction answer$iv = CallableReferenceLowering.this.lowerLocalKPropertyReference(expression2);
                $receiver$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            IrSimpleFunction factory2 = (IrSimpleFunction)object;
            return CallableReferenceLowering.this.redirectToFunction(expression2, factory2);
        }
    }
}

