/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsStatementTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012\u001a(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\n\u0010 \u001a\u00020!*\u00020\"\u001a\n\u0010#\u001a\u00020\u0005*\u00020\u000e\u001ac\u0010$\u001a\u0004\u0018\u0001H%\"\b\b\u0000\u0010%*\u00020&\"\b\b\u0001\u0010'*\u00020\u0012*\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H'0*2\u0006\u0010+\u001a\u0002H'2 \u0010,\u001a\u001c\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H%\u0012\u0006\u0012\u0004\u0018\u0001H%\u0012\u0004\u0012\u0002H%0-\u00a2\u0006\u0002\u0010.\u00a8\u0006/"}, d2={"defineProperty", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "receiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "name", "", "value", "Lkotlin/Function0;", "jsAssignment", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "left", "right", "jsVar", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "initializer", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "prototypeOf", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "classNameRef", "translateCallArguments", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "translateFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isObjectConstructor", "", "asBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "objectInstanceName", "toJsNode", "T", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "D", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "tr", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "data", "node", "Lkotlin/Function3;", "(Lorg/jetbrains/kotlin/ir/expressions/IrWhen;Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;Lkotlin/jvm/functions/Function3;)Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "backend.js"})
public final class JsAstUtilsKt {
    @NotNull
    public static final JsVars jsVar(@NotNull JsName name, @Nullable IrExpression initializer2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        IrExpression irExpression = initializer2;
        JsExpression jsInitializer = irExpression != null ? (JsExpression)irExpression.accept(new IrElementToJsExpressionTransformer(), context) : null;
        return new JsVars(new JsVars.JsVar(name, jsInitializer));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T extends JsNode, D extends JsGenerationContext> T toJsNode(@NotNull IrWhen $receiver, @NotNull BaseIrElementToJsNodeTransformer<? extends T, ? super D> tr, @NotNull D data, @NotNull Function3<? super JsExpression, ? super T, ? super T, ? extends T> node) {
        void $receiver$iv;
        JsNode initial$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(tr, (String)"tr");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        List<IrBranch> list2 = $receiver.getBranches();
        JsNode accumulator$iv = initial$iv = null;
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                JsNode jsNode;
                JsNode jsNode2 = accumulator$iv;
                IrBranch br = (IrBranch)iterator$iv.previous();
                JsNode body = (JsNode)br.getResult().accept((IrElementVisitor)tr, data);
                if (br instanceof IrElseBranch) {
                    jsNode = body;
                } else {
                    void n;
                    JsExpression condition = (JsExpression)br.getCondition().accept(new IrElementToJsExpressionTransformer(), data);
                    jsNode = (JsNode)node.invoke((Object)condition, (Object)body, (Object)n);
                }
                accumulator$iv = jsNode;
            }
        }
        return (T)accumulator$iv;
    }

    @NotNull
    public static final JsBinaryOperation jsAssignment(@NotNull JsExpression left, @NotNull JsExpression right) {
        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        return new JsBinaryOperation(JsBinaryOperator.ASG, left, right);
    }

    @NotNull
    public static final JsNameRef prototypeOf(@NotNull JsExpression classNameRef) {
        Intrinsics.checkParameterIsNotNull((Object)classNameRef, (String)"classNameRef");
        return new JsNameRef(Namer.INSTANCE.getPROTOTYPE_NAME(), classNameRef);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsFunction translateFunction(@NotNull IrFunction declaration, @Nullable JsName name, boolean isObjectConstructor, @NotNull JsGenerationContext context) {
        JsBlock jsBlock;
        JsBlock body;
        JsBlock jsBlock2;
        Object it;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsScope jsScope = context.getCurrentScope();
        StringBuilder stringBuilder = new StringBuilder().append("scope for ");
        Object object = name;
        if (object == null) {
            object = "annon";
        }
        JsFunctionScope functionScope = new JsFunctionScope(jsScope, stringBuilder.append(object).toString());
        JsGenerationContext functionContext = context.newDeclaration(functionScope, declaration);
        Iterable iterable = $receiver$iv = (Iterable)declaration.getValueParameters();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            JsName jsName = functionContext.getNameForSymbol(it.getSymbol());
            collection.add(jsName);
        }
        List functionParams = (List)destination$iv$iv;
        IrBody irBody = declaration.getBody();
        JsStatement jsStatement = irBody != null ? (JsStatement)irBody.accept(new IrElementToJsStatementTransformer(), functionContext) : null;
        if (!(jsStatement instanceof JsBlock)) {
            jsStatement = null;
        }
        if ((jsBlock2 = (JsBlock)jsStatement) == null) {
            jsBlock2 = body = new JsBlock();
        }
        if (isObjectConstructor) {
            JsScope jsScope2 = context.getCurrentScope();
            JsName jsName = name;
            if (jsName == null) {
                Intrinsics.throwNpe();
            }
            JsName jsName2 = jsScope2.declareName(JsAstUtilsKt.objectInstanceName(jsName));
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"context.currentScope.dec\u2026e!!.objectInstanceName())");
            JsName instanceName = jsName2;
            JsBinaryOperation assignObject = JsAstUtilsKt.jsAssignment(new JsNameRef(instanceName), new JsThisRef());
            jsBlock = new JsBlock(assignObject.makeStmt(), body);
        } else {
            jsBlock = body;
        }
        JsBlock functionBody = jsBlock;
        JsScope jsScope3 = functionScope;
        StringBuilder stringBuilder2 = new StringBuilder().append("member function ");
        Object object2 = name;
        if (object2 == null) {
            object2 = "annon";
        }
        JsFunction function2 = new JsFunction(jsScope3, functionBody, stringBuilder2.append(object2).toString());
        function2.setName(name);
        translateFunction.1 addParameter$ = translateFunction.1.INSTANCE;
        IrValueParameter irValueParameter = declaration.getExtensionReceiverParameter();
        if (irValueParameter != null) {
            Object item$iv$iv;
            it = item$iv$iv = irValueParameter;
            translateFunction.1.INSTANCE.invoke(function2, functionContext.getNameForSymbol(it.getSymbol()));
        }
        Iterable $receiver$iv2 = functionParams;
        for (Object element$iv : $receiver$iv2) {
            JsName it2 = (JsName)element$iv;
            translateFunction.1.INSTANCE.invoke(function2, it2);
        }
        if (declaration.getDescriptor().isSuspend()) {
            JsName jsName = context.getCurrentScope().declareName(Namer.INSTANCE.getCONTINUATION());
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"context.currentScope.dec\u2026eName(Namer.CONTINUATION)");
            addParameter$.invoke(function2, jsName);
        }
        return function2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JsExpression> translateCallArguments(@NotNull IrMemberAccessExpression expression2, @NotNull JsGenerationContext context) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        IrElementToJsExpressionTransformer transformer = new IrElementToJsExpressionTransformer();
        int size = expression2.getValueArgumentsCount();
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)size);
        Collection destination$iv = new ArrayList(size);
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv;
            int n = item$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv;
            IrExpression argument = expression2.getValueArgument((int)it);
            Object object = argument;
            if (object == null || (object = (JsExpression)object.accept(transformer, context)) == null) {
                object = new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(1));
            }
            Object result2 = object;
            Object object2 = result2;
            collection.add(object2);
        }
        ArrayList arguments2 = (ArrayList)destination$iv;
        return DescriptorUtilsKt.isSuspend(expression2.getDescriptor()) ? CollectionsKt.plus((Collection)arguments2, (Object)context.getContinuation()) : (List)arguments2;
    }

    @NotNull
    public static final JsBlock asBlock(@NotNull JsStatement $receiver) {
        JsBlock jsBlock;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        JsStatement jsStatement = $receiver;
        if (!(jsStatement instanceof JsBlock)) {
            jsStatement = null;
        }
        if ((jsBlock = (JsBlock)jsStatement) == null) {
            jsBlock = new JsBlock($receiver);
        }
        return jsBlock;
    }

    @NotNull
    public static final String objectInstanceName(@NotNull JsName $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.getIdent() + "_instance";
    }

    @NotNull
    public static final JsInvocation defineProperty(@NotNull JsExpression receiver, @NotNull String name, @NotNull Function0<? extends JsExpression> value) {
        Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        JsNameRef objectDefineProperty = new JsNameRef("defineProperty", (JsExpression)Namer.INSTANCE.getJS_OBJECT());
        return new JsInvocation((JsExpression)objectDefineProperty, receiver, new JsStringLiteral(name), (JsExpression)value.invoke());
    }
}

