/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"asString", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "backend.js"})
public final class IrTypeUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String asString(@NotNull IrType $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        IrType irType = $receiver;
        if (irType instanceof IrErrorType) {
            string = "$ErrorType$";
        } else if (irType instanceof IrDynamicType) {
            string = "dynamic";
        } else if (irType instanceof IrSimpleType) {
            String string2;
            String string3;
            String string4;
            void $receiver$iv;
            Collection collection = ((IrSimpleType)$receiver).getArguments();
            StringBuilder stringBuilder = new StringBuilder().append(IrTypeUtilsKt.asString(((IrSimpleType)$receiver).getClassifier())).append(((IrSimpleType)$receiver).getHasQuestionMark() ? "?" : "");
            void var3_5 = $receiver$iv;
            if (!var3_5.isEmpty()) {
                List $receiver2 = (List)$receiver$iv;
                string4 = CollectionsKt.joinToString$default((Iterable)$receiver2, (CharSequence)",", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)asString.1.1.INSTANCE, (int)24, null);
            } else {
                string4 = null;
            }
            if ((string3 = (string2 = string4)) == null) {
                string3 = "";
            }
            string = stringBuilder.append(string3).toString();
        } else {
            String string5 = "Unexpected kind of IrType: " + $receiver.getClass().getTypeName();
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        return string;
    }

    private static final String asString(@NotNull IrTypeArgument $receiver) {
        String string;
        IrTypeArgument irTypeArgument = $receiver;
        if (irTypeArgument instanceof IrStarProjection) {
            string = "*";
        } else if (irTypeArgument instanceof IrTypeProjection) {
            string = ((IrTypeProjection)$receiver).getVariance().getLabel() + (((IrTypeProjection)$receiver).getVariance() != Variance.INVARIANT ? " " : "") + IrTypeUtilsKt.asString(((IrTypeProjection)$receiver).getType());
        } else {
            String string2 = "Unexpected kind of IrTypeArgument: " + $receiver.getClass().getSimpleName();
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    private static final String asString(@NotNull IrClassifierSymbol $receiver) {
        String string;
        IrClassifierSymbol irClassifierSymbol = $receiver;
        if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
            string = ((IrTypeParameter)((IrTypeParameterSymbol)$receiver).getOwner()).getName().asString();
        } else if (irClassifierSymbol instanceof IrClassSymbol) {
            string = DescriptorUtilsKt.getFqNameUnsafe(((IrClassSymbol)$receiver).getDescriptor()).asString();
        } else {
            String string2 = "Unexpected kind of IrClassifierSymbol: " + $receiver.getClass().getTypeName();
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"when (this) {\n    is IrT\u2026\" + javaClass.typeName)\n}");
        return string;
    }

    public static final /* synthetic */ String access$asString(IrTypeArgument $receiver) {
        return IrTypeUtilsKt.asString($receiver);
    }
}

