/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.util.AstUtil;

public class JsTry
extends SourceInfoAwareJsNode
implements JsStatement {
    private final List<JsCatch> catches;
    private JsBlock finallyBlock;
    private JsBlock tryBlock;

    public JsTry() {
        this.catches = new SmartList();
    }

    public JsTry(JsBlock tryBlock, List<JsCatch> catches, @Nullable JsBlock finallyBlock) {
        this.tryBlock = tryBlock;
        this.catches = catches;
        this.finallyBlock = finallyBlock;
    }

    public JsTry(JsBlock tryBlock, @Nullable JsCatch jsCatch, @Nullable JsBlock finallyBlock) {
        this(tryBlock, (List<JsCatch>)new SmartList(), finallyBlock);
        if (jsCatch != null) {
            this.catches.add(jsCatch);
        }
    }

    public List<JsCatch> getCatches() {
        return this.catches;
    }

    public JsBlock getFinallyBlock() {
        return this.finallyBlock;
    }

    public JsBlock getTryBlock() {
        return this.tryBlock;
    }

    public void setFinallyBlock(JsBlock block) {
        this.finallyBlock = block;
    }

    public void setTryBlock(JsBlock block) {
        this.tryBlock = block;
    }

    @Override
    public void accept(JsVisitor v2) {
        v2.visitTry(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.tryBlock);
        visitor2.acceptWithInsertRemove(this.catches);
        if (this.finallyBlock != null) {
            visitor2.accept(this.finallyBlock);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v2, JsContext ctx) {
        if (v2.visit(this, ctx)) {
            this.tryBlock = v2.acceptStatement(this.tryBlock);
            v2.acceptList(this.catches);
            if (this.finallyBlock != null) {
                this.finallyBlock = v2.acceptStatement(this.finallyBlock);
            }
        }
        v2.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsTry deepCopy() {
        JsBlock tryCopy = AstUtil.deepCopy(this.tryBlock);
        List<JsCatch> catchCopy = AstUtil.deepCopy(this.catches);
        JsBlock finallyCopy = AstUtil.deepCopy(this.finallyBlock);
        return new JsTry(tryCopy, catchCopy, finallyCopy).withMetadataFrom(this);
    }
}

