/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public final class JsDescriptorUtils {
    private static final Set<String> FAKE_CLASSES = ContainerUtil.immutableSet((Object[])new String[]{KotlinBuiltIns.FQ_NAMES.any.asString()});

    private JsDescriptorUtils() {
    }

    private static int valueParametersCount(@NotNull FunctionDescriptor functionDescriptor) {
        return functionDescriptor.getValueParameters().size();
    }

    public static boolean hasParameters(@NotNull FunctionDescriptor functionDescriptor) {
        return JsDescriptorUtils.valueParametersCount(functionDescriptor) > 0;
    }

    public static boolean isCompareTo(@NotNull CallableDescriptor descriptor2) {
        return descriptor2.getName().equals(OperatorNameConventions.COMPARE_TO);
    }

    @Nullable
    public static ClassDescriptor findAncestorClass(@NotNull List<ClassDescriptor> superclassDescriptors) {
        for (ClassDescriptor descriptor2 : superclassDescriptors) {
            if (descriptor2.getKind() != ClassKind.CLASS && descriptor2.getKind() != ClassKind.ENUM_CLASS) continue;
            return descriptor2;
        }
        return null;
    }

    @Nullable
    public static ClassDescriptor getSuperclass(@NotNull ClassDescriptor classDescriptor2) {
        return JsDescriptorUtils.findAncestorClass(DescriptorUtils.getSuperclassDescriptors(classDescriptor2));
    }

    @NotNull
    public static List<KotlinType> getSupertypesWithoutFakes(ClassDescriptor descriptor2) {
        Collection<KotlinType> supertypes2 = descriptor2.getTypeConstructor().getSupertypes();
        return ContainerUtil.filter(supertypes2, type2 -> {
            ClassDescriptor classDescriptor2 = DescriptorUtils.getClassDescriptorForType(type2);
            return !FAKE_CLASSES.contains(DescriptorUtils.getFqNameSafe(classDescriptor2).asString()) && (classDescriptor2.getKind() != ClassKind.INTERFACE || !AnnotationsUtils.isNativeObject(classDescriptor2));
        });
    }

    @NotNull
    public static DeclarationDescriptor getContainingDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        DeclarationDescriptor containing = descriptor2.getContainingDeclaration();
        assert (containing != null) : "Should be called on objects that have containing declaration.";
        return containing;
    }

    @NotNull
    public static ReceiverParameterDescriptor getReceiverParameterForReceiver(@NotNull ReceiverValue receiverParameter) {
        DeclarationDescriptor declarationDescriptor = JsDescriptorUtils.getDeclarationDescriptorForReceiver(receiverParameter);
        return JsDescriptorUtils.getReceiverParameterForDeclaration(declarationDescriptor);
    }

    @NotNull
    private static DeclarationDescriptor getDeclarationDescriptorForReceiver(@NotNull ReceiverValue receiverParameter) {
        if (receiverParameter instanceof ImplicitReceiver) {
            DeclarationDescriptor declarationDescriptor = ((ImplicitReceiver)receiverParameter).getDeclarationDescriptor();
            return declarationDescriptor.getOriginal();
        }
        throw new UnsupportedOperationException("Unsupported receiver type: " + receiverParameter.getClass() + ", receiverParameter = " + receiverParameter);
    }

    @NotNull
    public static ReceiverParameterDescriptor getReceiverParameterForDeclaration(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor instanceof ClassDescriptor) {
            return ((ClassDescriptor)declarationDescriptor).getThisAsReceiverParameter();
        }
        if (declarationDescriptor instanceof CallableMemberDescriptor) {
            ReceiverParameterDescriptor receiverDescriptor = ((CallableMemberDescriptor)declarationDescriptor).getExtensionReceiverParameter();
            assert (receiverDescriptor != null);
            return receiverDescriptor;
        }
        throw new UnsupportedOperationException("Unsupported declaration type: " + declarationDescriptor.getClass() + ", declarationDescriptor = " + declarationDescriptor);
    }

    private static boolean isDefaultAccessor(@Nullable PropertyAccessorDescriptor accessorDescriptor) {
        return accessorDescriptor == null || accessorDescriptor.isDefault() && (!(accessorDescriptor instanceof PropertySetterDescriptor) || !accessorDescriptor.getCorrespondingProperty().isLateInit());
    }

    public static boolean sideEffectsPossibleOnRead(@NotNull PropertyDescriptor property) {
        return DynamicCallsKt.isDynamic(property) || !JsDescriptorUtils.isDefaultAccessor(property.getGetter()) || ModalityKt.isOverridableOrOverrides(property) || JsDescriptorUtils.isStaticInitializationPossible(property);
    }

    private static boolean isStaticInitializationPossible(PropertyDescriptor property) {
        DeclarationDescriptor container2 = property.getContainingDeclaration();
        return container2 instanceof PackageFragmentDescriptor || DescriptorUtils.isObject(container2);
    }

    public static boolean isSimpleFinalProperty(@NotNull PropertyDescriptor propertyDescriptor) {
        return !DescriptorUtils.isExtension(propertyDescriptor) && JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getGetter()) && JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getSetter()) && !TranslationUtils.shouldAccessViaFunctions((CallableDescriptor)propertyDescriptor) && !ModalityKt.isOverridableOrOverrides(propertyDescriptor);
    }

    @NotNull
    public static String getModuleName(@NotNull DeclarationDescriptor descriptor2) {
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(JsDescriptorUtils.findRealInlineDeclaration(descriptor2));
        if (DescriptorUtils.getContainingModule(descriptor2) == moduleDescriptor.getBuiltIns().getBuiltInsModule()) {
            return Namer.KOTLIN_LOWER_NAME;
        }
        String moduleName = moduleDescriptor.getName().asString();
        return moduleName.substring(1, moduleName.length() - 1);
    }

    @NotNull
    public static DeclarationDescriptor findRealInlineDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof FunctionDescriptor) {
            FunctionDescriptor d = (FunctionDescriptor)descriptor2;
            if (d.getKind().isReal() || !d.isInline()) {
                return descriptor2;
            }
            CallableMemberDescriptor real = JsDescriptorUtils.findRealDeclaration(d);
            assert (real != null) : "Couldn't find definition of a fake inline descriptor " + descriptor2;
            return real;
        }
        return descriptor2;
    }

    @Nullable
    public static CallableMemberDescriptor findRealDeclaration(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2.getModality() == Modality.ABSTRACT) {
            return null;
        }
        if (descriptor2.getKind().isReal()) {
            return descriptor2;
        }
        for (CallableMemberDescriptor callableMemberDescriptor : descriptor2.getOverriddenDescriptors()) {
            CallableMemberDescriptor child = JsDescriptorUtils.findRealDeclaration(callableMemberDescriptor);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public static boolean isImmediateSubtypeOfError(@NotNull ClassDescriptor descriptor2) {
        if (!JsDescriptorUtils.isExceptionClass(descriptor2)) {
            return false;
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassOrAny(descriptor2);
        return TypeUtilsKt.isNotNullThrowable(superClass.getDefaultType()) || AnnotationsUtils.isNativeObject(superClass);
    }

    public static boolean isExceptionClass(@NotNull ClassDescriptor descriptor2) {
        ModuleDescriptor module2 = DescriptorUtils.getContainingModule(descriptor2);
        return TypeUtilsKt.isSubtypeOf(descriptor2.getDefaultType(), module2.getBuiltIns().getThrowable().getDefaultType());
    }
}

