/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\u0004*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/InlineParameterChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "reportIncorrectInline", "Lorg/jetbrains/kotlin/psi/KtParameter;", "modifierToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
public final class InlineParameterChecker
implements DeclarationChecker {
    public static final InlineParameterChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (!(declaration instanceof KtFunction)) break block8;
            boolean inline = declaration.hasModifier(KtTokens.INLINE_KEYWORD);
            for (KtParameter parameter : ((KtFunction)declaration).getValueParameters()) {
                VariableDescriptor parameterDescriptor;
                block10: {
                    block9: {
                        parameterDescriptor = (VariableDescriptor)context.getTrace().get(BindingContext.VALUE_PARAMETER, parameter);
                        if (!inline) break block9;
                        if (parameterDescriptor == null) break block10;
                        KotlinType kotlinType2 = parameterDescriptor.getType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"parameterDescriptor.type");
                        if (FunctionTypesKt.isBuiltinFunctionalType(kotlinType2)) break block10;
                    }
                    KtParameter ktParameter = parameter;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.NOINLINE_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.NOINLINE_KEYWORD");
                    this.reportIncorrectInline(ktParameter, ktModifierKeywordToken, context.getTrace());
                    KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.CROSSINLINE_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken2), (String)"KtTokens.CROSSINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter, ktModifierKeywordToken2, context.getTrace());
                }
                if (!inline || parameter.hasModifier(KtTokens.NOINLINE_KEYWORD) || parameter.hasModifier(KtTokens.CROSSINLINE_KEYWORD)) continue;
                Annotated annotated = parameterDescriptor;
                if (annotated == null || (annotated = annotated.getType()) == null) continue;
                if (!FunctionTypesKt.isSuspendFunctionType((KotlinType)annotated)) continue;
                if (declaration.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                    PsiElement modifier;
                    KtModifierList modifierList;
                    KtTypeReference typeReference;
                    KtParameter ktParameter = parameter;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                    if (ktParameter.getTypeReference() == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeReference, (String)"parameter.typeReference!!");
                    if (typeReference.getModifierList() == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)modifierList, (String)"typeReference.modifierList!!");
                    if (modifierList.getModifier(KtTokens.SUSPEND_KEYWORD) == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)modifier, (String)"modifierList.getModifier\u2026Tokens.SUSPEND_KEYWORD)!!");
                    context.getTrace().report(Errors.REDUNDANT_INLINE_SUSPEND_FUNCTION_TYPE.on(modifier));
                    continue;
                }
                context.getTrace().report(Errors.INLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }

    private final void reportIncorrectInline(@NotNull KtParameter $receiver, KtModifierKeywordToken modifierToken, DiagnosticSink diagnosticHolder) {
        block0: {
            PsiElement psiElement;
            PsiElement modifier;
            KtModifierList ktModifierList = $receiver.getModifierList();
            PsiElement psiElement2 = modifier = ktModifierList != null ? ktModifierList.getModifier(modifierToken) : null;
            if (psiElement2 == null) break block0;
            PsiElement it = psiElement = psiElement2;
            diagnosticHolder.report(Errors.ILLEGAL_INLINE_PARAMETER_MODIFIER.on(modifier, modifierToken));
        }
    }

    private InlineParameterChecker() {
    }

    static {
        InlineParameterChecker inlineParameterChecker;
        INSTANCE = inlineParameterChecker = new InlineParameterChecker();
    }
}

