/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThrowStatement;
import java.util.Collections;
import java.util.List;

public class BadHostnameVerifierDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(BadHostnameVerifierDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"BadHostnameVerifier", (String)"Insecure HostnameVerifier", (String)"This check looks for implementations of `HostnameVerifier` whose `verify` method always returns true (thus trusting any hostname) which could result in insecure network traffic caused by trusting arbitrary hostnames in TLS/SSL certificates presented by peers.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("javax.net.ssl.HostnameVerifier");
    }

    public void checkClass(JavaContext context, PsiClass declaration) {
        JavaEvaluator evaluator = context.getEvaluator();
        for (PsiMethod method : declaration.findMethodsByName("verify", false)) {
            if (!evaluator.methodMatches(method, null, false, new String[]{"java.lang.String", "javax.net.ssl.SSLSession"})) continue;
            ComplexVisitor visitor = new ComplexVisitor(context);
            declaration.accept((PsiElementVisitor)visitor);
            if (visitor.isComplex()) {
                return;
            }
            Location location = context.getNameLocation((PsiElement)method);
            String message = String.format("`%1$s` always returns `true`, which could cause insecure network traffic due to trusting TLS/SSL server certificates for wrong hostnames", method.getName());
            context.report(ISSUE, (PsiElement)method, location, message);
            break;
        }
    }

    private static class ComplexVisitor
    extends JavaRecursiveElementVisitor {
        private final JavaContext mContext;
        private boolean mComplex;

        public ComplexVisitor(JavaContext context) {
            this.mContext = context;
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            super.visitThrowStatement(statement);
            this.mComplex = true;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            this.mComplex = true;
        }

        public void visitReturnStatement(PsiReturnStatement node) {
            PsiExpression argument = node.getReturnValue();
            if (argument != null) {
                this.mComplex = !LintUtils.isTrueLiteral((PsiElement)argument);
            }
            super.visitReturnStatement(node);
        }

        public boolean isComplex() {
            return this.mComplex;
        }
    }
}

