/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import java.util.Arrays;
import java.util.List;

public class LogDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(LogDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue CONDITIONAL = Issue.create((String)"LogConditional", (String)"Unconditional Logging Calls", (String)"The BuildConfig class (available in Tools 17) provides a constant, \"DEBUG\", which indicates whether the code is being built in release mode or in debug mode. In release mode, you typically want to strip out all the logging calls. Since the compiler will automatically remove all code which is inside a \"if (false)\" check, surrounding your logging calls with a check for BuildConfig.DEBUG is a good idea.\n\nIf you *really* intend for the logging to be present in release mode, you can suppress this warning with a @SuppressLint annotation for the intentional logging calls.", (Category)Category.PERFORMANCE, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue WRONG_TAG = Issue.create((String)"LogTagMismatch", (String)"Mismatched Log Tags", (String)"When guarding a `Log.v(tag, ...)` call with `Log.isLoggable(tag)`, the tag passed to both calls should be the same. Similarly, the level passed in to `Log.isLoggable` should typically match the type of `Log` call, e.g. if checking level `Log.DEBUG`, the corresponding `Log` call should be `Log.d`, not `Log.i`.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue LONG_TAG = Issue.create((String)"LongLogTag", (String)"Too Long Log Tags", (String)"Log tags are only allowed to be at most 23 tag characters long.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    private static final String IS_LOGGABLE = "isLoggable";
    public static final String LOG_CLS = "android.util.Log";
    private static final String PRINTLN = "println";

    public List<String> getApplicableMethodNames() {
        return Arrays.asList("d", "e", "i", "v", "w", PRINTLN, IS_LOGGABLE);
    }

    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression node, PsiMethod method) {
        boolean withinConditional;
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInClass((PsiMember)method, LOG_CLS)) {
            return;
        }
        String name = method.getName();
        boolean bl = withinConditional = IS_LOGGABLE.equals(name) || LogDetector.checkWithinConditional(context, node.getParent(), node);
        if (("i".equals(name) || "d".equals(name) || "v".equals(name) || PRINTLN.equals(name)) && !withinConditional && LogDetector.performsWork(context, node) && context.isEnabled(CONDITIONAL)) {
            String message = String.format("The log call Log.%1$s(...) should be conditional: surround with `if (Log.isLoggable(...))` or `if (BuildConfig.DEBUG) { ... }`", node.getMethodExpression().getReferenceName());
            context.report(CONDITIONAL, (PsiElement)node, context.getLocation((PsiElement)node), message);
        }
        if (context.isEnabled(LONG_TAG)) {
            PsiExpression argument;
            String tag;
            int tagArgumentIndex = PRINTLN.equals(name) ? 1 : 0;
            PsiParameterList parameterList = method.getParameterList();
            PsiExpressionList argumentList = node.getArgumentList();
            if (evaluator.parameterHasType(method, tagArgumentIndex, "java.lang.String") && parameterList.getParametersCount() == argumentList.getExpressions().length && (tag = ConstantEvaluator.evaluateString((JavaContext)context, (PsiElement)(argument = argumentList.getExpressions()[tagArgumentIndex]), (boolean)true)) != null && tag.length() > 23) {
                String message = String.format("The logging tag can be at most 23 characters, was %1$d (%2$s)", tag.length(), tag);
                context.report(LONG_TAG, (PsiElement)node, context.getLocation((PsiElement)node), message);
            }
        }
    }

    private static boolean performsWork(JavaContext context, PsiMethodCallExpression node) {
        String referenceName = node.getMethodExpression().getReferenceName();
        if (referenceName == null) {
            return false;
        }
        int messageArgumentIndex = PRINTLN.equals(referenceName) ? 2 : 1;
        PsiExpression[] arguments = node.getArgumentList().getExpressions();
        if (arguments.length > messageArgumentIndex) {
            PsiExpression argument = arguments[messageArgumentIndex];
            if (argument == null) {
                return false;
            }
            if (argument instanceof PsiLiteral) {
                return false;
            }
            if (argument instanceof PsiBinaryExpression) {
                String string = ConstantEvaluator.evaluateString((JavaContext)context, (PsiElement)argument, (boolean)false);
                if (string != null) {
                    return false;
                }
            } else if (argument instanceof PsiReferenceExpression) {
                if (((PsiReferenceExpression)argument).getQualifier() == null) {
                    return false;
                }
                String string = ConstantEvaluator.evaluateString((JavaContext)context, (PsiElement)argument, (boolean)false);
                if (string != null) {
                    return false;
                }
                PsiElement resolved = context.getEvaluator().resolve((PsiElement)argument);
                if (resolved instanceof PsiField || resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean checkWithinConditional(JavaContext context, PsiElement curr, PsiMethodCallExpression logCall) {
        while (curr != null) {
            if (curr instanceof PsiIfStatement) {
                PsiMethodCallExpression call;
                PsiIfStatement ifNode = (PsiIfStatement)curr;
                if (ifNode.getCondition() instanceof PsiMethodCallExpression && IS_LOGGABLE.equals((call = (PsiMethodCallExpression)ifNode.getCondition()).getMethodExpression().getReferenceName())) {
                    LogDetector.checkTagConsistent(context, logCall, call);
                }
                return true;
            }
            if (curr instanceof PsiMethodCallExpression || curr instanceof PsiMethod || curr instanceof PsiClass) break;
            curr = curr.getParent();
        }
        return false;
    }

    private static void checkTagConsistent(JavaContext context, PsiMethodCallExpression logCall, PsiMethodCallExpression isLoggableCall) {
        PsiExpression[] isLoggableArguments = isLoggableCall.getArgumentList().getExpressions();
        PsiExpression[] logArguments = logCall.getArgumentList().getExpressions();
        if (isLoggableArguments.length == 0 || logArguments.length == 0) {
            return;
        }
        PsiExpression isLoggableTag = isLoggableArguments[0];
        PsiExpression logTag = logArguments[0];
        String logCallName = logCall.getMethodExpression().getReferenceName();
        if (logCallName == null) {
            return;
        }
        boolean isPrintln = PRINTLN.equals(logCallName);
        if (isPrintln && logArguments.length > 1) {
            logTag = logArguments[1];
        }
        if (logTag != null && !isLoggableTag.textMatches((PsiElement)logTag)) {
            PsiElement resolved1 = context.getEvaluator().resolve((PsiElement)isLoggableTag);
            PsiElement resolved2 = context.getEvaluator().resolve((PsiElement)logTag);
            if ((resolved1 == null || resolved2 == null || !resolved1.equals(resolved2)) && context.isEnabled(WRONG_TAG)) {
                Location location = context.getLocation((PsiElement)logTag);
                Location alternate = context.getLocation((PsiElement)isLoggableTag);
                alternate.setMessage("Conflicting tag");
                location.setSecondary(alternate);
                String isLoggableDescription = resolved1 instanceof PsiMethod ? ((PsiMethod)resolved1).getName() : isLoggableTag.getText();
                String logCallDescription = resolved2 instanceof PsiMethod ? ((PsiMethod)resolved2).getName() : logTag.getText();
                String message = String.format("Mismatched tags: the `%1$s()` and `isLoggable()` calls typically should pass the same tag: `%2$s` versus `%3$s`", logCallName, isLoggableDescription, logCallDescription);
                context.report(WRONG_TAG, (PsiElement)isLoggableCall, location, message);
            }
        }
        if (logCallName.length() != 1 || isLoggableArguments.length < 2) {
            return;
        }
        PsiExpression isLoggableLevel = isLoggableArguments[1];
        if (isLoggableLevel == null) {
            return;
        }
        String levelString = isLoggableLevel instanceof PsiReferenceExpression ? ((PsiReferenceExpression)isLoggableLevel).getReferenceName() : isLoggableLevel.getText();
        if (levelString == null || levelString.isEmpty()) {
            return;
        }
        char levelChar = Character.toLowerCase(levelString.charAt(0));
        if (logCallName.charAt(0) == levelChar || !context.isEnabled(WRONG_TAG)) {
            return;
        }
        switch (levelChar) {
            case 'd': 
            case 'e': 
            case 'i': 
            case 'v': 
            case 'w': {
                break;
            }
            default: {
                return;
            }
        }
        String expectedCall = String.valueOf(levelChar);
        String message = String.format("Mismatched logging levels: when checking `isLoggable` level `%1$s`, the corresponding log call should be `Log.%2$s`, not `Log.%3$s`", levelString, expectedCall, logCallName);
        Location location = context.getNameLocation((PsiElement)logCall);
        Location alternate = context.getLocation((PsiElement)isLoggableLevel);
        alternate.setMessage("Conflicting tag");
        location.setSecondary(alternate);
        context.report(WRONG_TAG, (PsiElement)isLoggableCall, location, message);
    }
}

