/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;

public class ViewHolderDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(ViewHolderDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"ViewHolder", (String)"View Holder Candidates", (String)"When implementing a view Adapter, you should avoid unconditionally inflating a new layout; if an available item is passed in for reuse, you should try to use that one instead. This helps make for example ListView scrolling much smoother.", (Category)Category.PERFORMANCE, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/training/improving-layouts/smooth-scrolling.html#ViewHolder");
    private static final String GET_VIEW = "getView";
    static final String INFLATE = "inflate";

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Collections.singletonList(PsiMethod.class);
    }

    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        return new ViewAdapterVisitor(context);
    }

    private static class InflationVisitor
    extends JavaRecursiveElementVisitor {
        private final JavaContext mContext;
        private List<PsiElement> mNodes;
        private boolean mHaveConditional;

        public InflationVisitor(JavaContext context) {
            this.mContext = context;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression node) {
            String methodName;
            super.visitMethodCallExpression(node);
            PsiReferenceExpression expression = node.getMethodExpression();
            if (expression.getQualifierExpression() != null && ViewHolderDetector.INFLATE.equals(methodName = expression.getReferenceName()) && node.getArgumentList().getExpressions().length >= 1) {
                boolean insideIf = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{PsiConditionalExpression.class, PsiIfStatement.class, PsiSwitchStatement.class}) != null) {
                    insideIf = true;
                    this.mHaveConditional = true;
                }
                if (!insideIf) {
                    if (this.mNodes == null) {
                        this.mNodes = Lists.newArrayList();
                    }
                    this.mNodes.add((PsiElement)node);
                }
            }
        }

        public void finish() {
            if (!this.mHaveConditional && this.mNodes != null) {
                for (PsiElement node : this.mNodes) {
                    String message = "Unconditional layout inflation from view adapter: Should use View Holder pattern (use recycled view passed into this method as the second parameter) for smoother scrolling";
                    this.mContext.report(ISSUE, node, this.mContext.getLocation(node), message);
                }
            }
        }
    }

    private static class ViewAdapterVisitor
    extends JavaElementVisitor {
        private final JavaContext mContext;

        public ViewAdapterVisitor(JavaContext context) {
            this.mContext = context;
        }

        public void visitMethod(PsiMethod method) {
            if (ViewAdapterVisitor.isViewAdapterMethod(this.mContext, method)) {
                InflationVisitor visitor = new InflationVisitor(this.mContext);
                method.accept((PsiElementVisitor)visitor);
                visitor.finish();
            }
        }

        private static boolean isViewAdapterMethod(JavaContext context, PsiMethod node) {
            JavaEvaluator evaluator = context.getEvaluator();
            return ViewHolderDetector.GET_VIEW.equals(node.getName()) && evaluator.parametersMatch(node, new String[]{"int", "android.view.View", "android.view.ViewGroup"});
        }
    }
}

