/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WrongLocationDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"WrongFolder", (String)"Resource file in the wrong `res` folder", (String)"Resource files are sometimes placed in the wrong folder, and it can lead to subtle bugs that are hard to understand. This check looks for problems in this area, such as attempting to place a layout \"alias\" file in a `layout/` folder rather than the `values/` folder where it belongs.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.FATAL, (Implementation)new Implementation(WrongLocationDetector.class, Scope.RESOURCE_FILE_SCOPE));

    public void visitDocument(XmlContext context, Document document) {
        Element root = document.getDocumentElement();
        if (root != null && root.getTagName().equals("resources")) {
            context.report(ISSUE, (Node)root, context.getLocation((Node)root), "This file should be placed in a `values`/ folder, not a `layout`/ folder");
        }
    }
}

