/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/BottomAppBarDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "lint-checks"})
public final class BottomAppBarDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final String OLD_BOTTOM_APP_BAR = "android.support.design.bottomappbar.BottomAppBar";
    private static final String NEW_BOTTOM_APP_BAR = "com.google.android.material.bottomappbar.BottomAppBar";
    private static final String OLD_COORDINATOR_LAYOUT = "android.support.design.widget.CoordinatorLayout";
    private static final String NEW_COORDINATOR_LAYOUT = "androidx.coordinatorlayout.widget.CoordinatorLayout";
    public static final Companion Companion;

    @Nullable
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object[])new String[]{OLD_BOTTOM_APP_BAR, NEW_BOTTOM_APP_BAR});
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        String parentLayout;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Node node = element.getParentNode();
        String string = parentLayout = node != null ? node.getNodeName() : null;
        if (Intrinsics.areEqual((Object)parentLayout, (Object)OLD_COORDINATOR_LAYOUT) ^ true && Intrinsics.areEqual((Object)parentLayout, (Object)NEW_COORDINATOR_LAYOUT) ^ true) {
            String coordinatorLayout = Intrinsics.areEqual((Object)element.getTagName(), (Object)OLD_BOTTOM_APP_BAR) ? OLD_COORDINATOR_LAYOUT : NEW_COORDINATOR_LAYOUT;
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getNameLocation((Node)element), (String)("This `BottomAppBar` must be wrapped in a `CoordinatorLayout` (`" + coordinatorLayout + "`)"), null, (int)16, null);
        }
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(BottomAppBarDetector.class, Scope.RESOURCE_FILE_SCOPE);
        ISSUE = Issue.Companion.create("BottomAppBar", "BottomAppBar Problems", "\n            The `BottomAppBar` widget must be placed within a `CoordinatorLayout`.\n            ", Category.CORRECTNESS, 9, Severity.ERROR, IMPLEMENTATION);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/BottomAppBarDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "NEW_BOTTOM_APP_BAR", "", "NEW_COORDINATOR_LAYOUT", "OLD_BOTTOM_APP_BAR", "OLD_COORDINATOR_LAYOUT", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

