/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils;

import com.android.utils.ILogger;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;

public class MockLog
implements ILogger {
    private ArrayList<String> mMessages = new ArrayList();

    private void add(String code, String format, Object ... args) {
        Formatter formatter = new Formatter();
        this.mMessages.add(formatter.format(code + format, args).toString());
        formatter.close();
    }

    public void warning(String format, Object ... args) {
        this.add("W ", format, args);
    }

    public void info(String format, Object ... args) {
        this.add("P ", format, args);
    }

    public void verbose(String format, Object ... args) {
        this.add("V ", format, args);
    }

    public void error(Throwable t, String format, Object ... args) {
        if (t != null) {
            this.add("T", "%s", t.toString());
        }
        this.add("E ", format, args);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        char lastType = '\u0000';
        for (String s : this.mMessages) {
            if (s.isEmpty()) continue;
            char type = s.charAt(0);
            if (type != lastType) {
                sb.append(s);
                lastType = type;
            } else if (s.length() > 2) {
                sb.append(s.substring(2));
            }
            if (!s.endsWith("\n")) continue;
            lastType = '\u0000';
        }
        return sb.toString();
    }

    public List<String> getMessages() {
        return this.mMessages;
    }

    public void clear() {
        this.mMessages.clear();
    }
}

