/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils;

import java.util.HashMap;
import java.util.Map;

public class SystemPropertyOverrides
implements AutoCloseable {
    private final Map<String, String> mOriginals = new HashMap<String, String>();

    public void setProperty(String key, String value) {
        if (!this.mOriginals.containsKey(key)) {
            String originalValue = System.getProperty(key);
            this.mOriginals.put(key, originalValue);
        }
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    @Override
    public void close() throws Exception {
        for (Map.Entry<String, String> original : this.mOriginals.entrySet()) {
            if (original.getValue() == null) {
                System.clearProperty(original.getKey());
                continue;
            }
            System.setProperty(original.getKey(), original.getValue());
        }
    }
}

