/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.apk;

import com.android.testutils.apk.DexAndroidArchive;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Apk
extends DexAndroidArchive {
    public Apk(Path file) throws IOException {
        super(file, "classes.dex", "classes%d.dex");
    }

    public Apk(File apk) throws IOException {
        this(apk.toPath());
    }

    @Override
    public Path getJavaResource(String name) throws IOException {
        return this.getEntry(name);
    }

    public long getContentsSize() throws IOException {
        long contentsSize = 0L;
        try (ZipFile zipFile = new ZipFile(this.getFile().toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                contentsSize += zipEntry.getCompressedSize();
            }
        }
        return contentsSize;
    }

    @Override
    public String toString() {
        return "Apk<" + this.getFile() + ">";
    }
}

