/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.apk;

import com.google.common.base.Preconditions;
import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Zip
implements AutoCloseable {
    final String displayName;
    private final Path file;
    private final FileSystem zip;
    private final boolean exists;
    private final Map<String, Zip> innerZips;

    public Zip(Path file) throws IOException {
        this(file, file.toString());
    }

    public Zip(File file) throws IOException {
        this(file.toPath());
    }

    private Zip(Path file, String displayName) throws IOException {
        this.file = file;
        this.displayName = displayName;
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            this.exists = false;
            this.zip = Jimfs.newFileSystem((Configuration)Configuration.unix());
        } else {
            if (file.getFileSystem() != FileSystems.getDefault()) {
                throw new IllegalArgumentException("Cannot create zip from non default fs, use getEntryAsZip() instead");
            }
            this.exists = true;
            this.zip = FileSystems.newFileSystem(file, null);
        }
        this.innerZips = new HashMap<String, Zip>();
    }

    public Path getFile() {
        return this.file;
    }

    public final Path getEntry(String name) {
        Path entry = this.zip.getPath(name, new String[0]);
        return Files.exists(entry, new LinkOption[0]) ? entry : null;
    }

    public final List<Path> getEntries() throws IOException {
        return Collections.unmodifiableList(Files.walk(this.zip.getPath("/", new String[0]), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).collect(Collectors.toList()));
    }

    public final List<Path> getEntries(Pattern pattern) throws IOException {
        return Collections.unmodifiableList(Files.walk(this.zip.getPath("/", new String[0]), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> pattern.matcher(path.toString()).matches()).collect(Collectors.toList()));
    }

    public final Zip getEntryAsZip(String name) throws IOException {
        Zip cached = this.innerZips.get(name);
        if (cached != null) {
            return cached;
        }
        Path zipPath = this.getEntry(name);
        Preconditions.checkNotNull((Object)zipPath, (String)"Entry %s should exist ", (Object)name);
        Path temp = Files.createTempFile(this.file.getFileName().toString(), "_inner_zip.zip", new FileAttribute[0]);
        Files.copy(zipPath, temp, StandardCopyOption.REPLACE_EXISTING);
        temp.toFile().deleteOnExit();
        Zip created = new Zip(temp, this.displayName + ":" + name);
        this.innerZips.put(name, created);
        return created;
    }

    public boolean exists() {
        return this.exists;
    }

    public String toString() {
        return "Zip<" + this.displayName + ">";
    }

    @Override
    public void close() throws Exception {
        this.zip.close();
        for (Zip innerZip : this.innerZips.values()) {
            innerZip.close();
        }
    }
}

