/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.concurrency;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.Assert;

public final class ConcurrencyTester<F, T> {
    private static final Duration TIMEOUT_TO_START_ACTION_WHEN_CONCURRENCY_EXPECTED = Duration.ofSeconds(60L);
    private static final Duration TIMEOUT_TO_START_ACTION_WHEN_NO_CONCURRENCY_EXPECTED = Duration.ofSeconds(1L);
    private List<Consumer<Function<F, T>>> methodInvocationList = new LinkedList<Consumer<Function<F, T>>>();
    private List<Function<F, T>> actionUnderTestList = new LinkedList<Function<F, T>>();

    public void addMethodInvocationFromNewThread(Consumer<Function<F, T>> methodUnderTestInvocation, Function<F, T> actionUnderTest) {
        this.methodInvocationList.add(methodUnderTestInvocation);
        this.actionUnderTestList.add(actionUnderTest);
    }

    public void assertThatActionsCanRunConcurrently() {
        Preconditions.checkArgument((this.methodInvocationList.size() >= 2 ? 1 : 0) != 0, (Object)"There must be at least 2 actions for concurrency checks.");
        Assert.assertTrue((String)"Two or more actions ran sequentially while all the actions were expected to run concurrently.", (this.executeActionsAndGetRunningPattern(TIMEOUT_TO_START_ACTION_WHEN_CONCURRENCY_EXPECTED) == RunningPattern.CONCURRENT ? 1 : 0) != 0);
    }

    public void assertThatActionsCannotRunConcurrently() {
        Preconditions.checkArgument((this.methodInvocationList.size() >= 2 ? 1 : 0) != 0, (Object)"There must be at least 2 actions for concurrency checks.");
        Assert.assertTrue((String)"Two or more actions ran concurrently while all the actions were expected to run sequentially.", (this.executeActionsAndGetRunningPattern(TIMEOUT_TO_START_ACTION_WHEN_NO_CONCURRENCY_EXPECTED) == RunningPattern.SEQUENTIAL ? 1 : 0) != 0);
    }

    public void assertThatOnlyOneActionIsExecuted() {
        Preconditions.checkArgument((this.methodInvocationList.size() >= 2 ? 1 : 0) != 0, (Object)"There must be at least 2 actions for concurrency checks.");
        AtomicInteger executedActions = new AtomicInteger(0);
        LinkedList<Runnable> runnables = new LinkedList<Runnable>();
        for (int i = 0; i < this.methodInvocationList.size(); ++i) {
            Consumer methodInvocation = this.methodInvocationList.get(i);
            Function actionUnderTest = this.actionUnderTestList.get(i);
            runnables.add(() -> methodInvocation.accept(input -> {
                executedActions.getAndIncrement();
                return actionUnderTest.apply(input);
            }));
        }
        Map<Thread, Optional<Throwable>> threads = ConcurrencyTester.executeRunnablesInThreads(runnables);
        ConcurrencyTester.waitForThreadsToFinish(threads);
        Assert.assertTrue((String)(executedActions.get() + " actions were executed while only one action was expected to run."), (executedActions.get() == 1 ? 1 : 0) != 0);
    }

    private RunningPattern executeActionsAndGetRunningPattern(Duration timeoutToStartAction) {
        LinkedBlockingQueue startedActionQueue = new LinkedBlockingQueue();
        LinkedBlockingQueue finishRequestQueue = new LinkedBlockingQueue();
        Runnable actionStartedHandler = () -> startedActionQueue.add(Thread.currentThread());
        Runnable actionFinishedHandler = () -> {
            CountDownLatch finishRequest = new CountDownLatch(1);
            finishRequestQueue.add(finishRequest);
            try {
                finishRequest.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        };
        LinkedList<Runnable> runnables = new LinkedList<Runnable>();
        for (int i = 0; i < this.methodInvocationList.size(); ++i) {
            Consumer methodInvocation = this.methodInvocationList.get(i);
            Function actionUnderTest = this.actionUnderTestList.get(i);
            Function<Object, Object> instrumentedActionUnderTest = input -> {
                actionStartedHandler.run();
                try {
                    Object r = actionUnderTest.apply(input);
                    return r;
                }
                finally {
                    actionFinishedHandler.run();
                }
            };
            runnables.add(() -> methodInvocation.accept(instrumentedActionUnderTest));
        }
        Map<Thread, Optional<Throwable>> threads = ConcurrencyTester.executeRunnablesInThreads(runnables);
        int remainingActions = runnables.size();
        LinkedList<CountDownLatch> finishRequests = new LinkedList<CountDownLatch>();
        int maxConcurrentActions = 0;
        while (remainingActions > 0) {
            Thread startedAction;
            try {
                startedAction = finishRequests.isEmpty() ? (Thread)startedActionQueue.take() : (Thread)startedActionQueue.poll(timeoutToStartAction.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (startedAction != null) {
                CountDownLatch finishRequest;
                --remainingActions;
                try {
                    finishRequest = (CountDownLatch)finishRequestQueue.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finishRequests.add(finishRequest);
                if (finishRequests.size() <= maxConcurrentActions) continue;
                maxConcurrentActions = finishRequests.size();
                continue;
            }
            while (!finishRequests.isEmpty()) {
                ((CountDownLatch)finishRequests.remove()).countDown();
            }
        }
        while (!finishRequests.isEmpty()) {
            ((CountDownLatch)finishRequests.remove()).countDown();
        }
        ConcurrencyTester.waitForThreadsToFinish(threads);
        Preconditions.checkState((maxConcurrentActions >= 1 && maxConcurrentActions <= runnables.size() ? 1 : 0) != 0);
        if (maxConcurrentActions == 1) {
            return RunningPattern.SEQUENTIAL;
        }
        if (maxConcurrentActions == runnables.size()) {
            return RunningPattern.CONCURRENT;
        }
        return RunningPattern.MIXED;
    }

    private static Map<Thread, Optional<Throwable>> executeRunnablesInThreads(List<Runnable> runnables) {
        ConcurrentHashMap<Thread, Optional<Throwable>> threads = new ConcurrentHashMap<Thread, Optional<Throwable>>();
        CountDownLatch allThreadsStartedLatch = new CountDownLatch(runnables.size());
        for (Runnable runnable : runnables) {
            Thread thread = new Thread(() -> {
                allThreadsStartedLatch.countDown();
                runnable.run();
            });
            threads.put(thread, Optional.empty());
            thread.setUncaughtExceptionHandler((aThread, throwable) -> threads.put(aThread, Optional.of(throwable)));
        }
        for (Thread thread : threads.keySet()) {
            thread.start();
        }
        try {
            allThreadsStartedLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return threads;
    }

    private static void waitForThreadsToFinish(Map<Thread, Optional<Throwable>> threads) {
        for (Thread thread : threads.keySet()) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        for (Optional optional : threads.values()) {
            if (!optional.isPresent()) continue;
            throw new RuntimeException((Throwable)optional.get());
        }
    }

    private static enum RunningPattern {
        CONCURRENT,
        SEQUENTIAL,
        MIXED;

    }
}

