/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.filesystemdiff;

import com.android.testutils.filesystemdiff.DirectoryEntry;
import com.android.testutils.filesystemdiff.FileEntry;
import com.android.testutils.filesystemdiff.FileSystemEntry;
import com.android.testutils.filesystemdiff.Script;
import com.android.testutils.filesystemdiff.SymbolicLinkEntry;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;

public class TreeDifferenceEngine {
    public static Script computeEditScript(FileSystemEntry root1, FileSystemEntry root2) {
        Script result = new Script();
        TreeDifferenceEngine.computeWorker(result, root1, root2, root1, root2);
        return result;
    }

    private static void computeWorker(Script script, FileSystemEntry leftRoot, FileSystemEntry rightRoot, FileSystemEntry left, FileSystemEntry right) {
        assert (left == leftRoot || left.getPath().getFileName().equals(right.getPath().getFileName()));
        if (!TreeDifferenceEngine.compareEntries(left, right)) {
            script.addDeleteEntry(left);
            script.addCreateEntry(right, TreeDifferenceEngine.mapToLeftEntry(leftRoot, rightRoot, right));
            return;
        }
        Map<String, FileSystemEntry> leftChildren = TreeDifferenceEngine.buildChildMap(left);
        Map<String, FileSystemEntry> rightChildren = TreeDifferenceEngine.buildChildMap(right);
        for (FileSystemEntry leftChild : leftChildren.values()) {
            FileSystemEntry rightChild = rightChildren.get(leftChild.getName());
            if (rightChild != null) {
                TreeDifferenceEngine.computeWorker(script, leftRoot, rightRoot, leftChild, rightChild);
                continue;
            }
            script.addDeleteEntry(leftChild);
        }
        for (FileSystemEntry rightChild : rightChildren.values()) {
            if (leftChildren.containsKey(rightChild.getName())) continue;
            script.addCreateEntry(rightChild, TreeDifferenceEngine.mapToLeftEntry(leftRoot, rightRoot, rightChild));
        }
    }

    private static FileSystemEntry mapToLeftEntry(FileSystemEntry leftRoot, FileSystemEntry rightRoot, FileSystemEntry right) {
        Path relPath = rightRoot.getPath().relativize(right.getPath());
        Path leftPath = leftRoot.getPath().resolve(relPath);
        switch (right.getKind()) {
            case Directory: {
                return new DirectoryEntry(leftPath);
            }
            case SymbolicLink: {
                return new SymbolicLinkEntry(leftPath, ((SymbolicLinkEntry)right).getTarget());
            }
            case File: {
                return new FileEntry(leftPath);
            }
        }
        throw new RuntimeException("Invalid enum value");
    }

    private static boolean compareEntries(FileSystemEntry left, FileSystemEntry right) {
        if (left.getKind() != right.getKind()) {
            return false;
        }
        if (left instanceof SymbolicLinkEntry) {
            SymbolicLinkEntry leftEntry = (SymbolicLinkEntry)left;
            SymbolicLinkEntry rightEntry = (SymbolicLinkEntry)right;
            if (!leftEntry.getTarget().equals(rightEntry.getTarget())) {
                return false;
            }
        }
        return true;
    }

    private static Map<String, FileSystemEntry> buildChildMap(FileSystemEntry parentEntry) {
        TreeMap<String, FileSystemEntry> result = new TreeMap<String, FileSystemEntry>();
        for (FileSystemEntry x : parentEntry.getChildEntries()) {
            result.put(x.getName(), x);
        }
        return result;
    }
}

