/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.internal;

import com.google.common.truth.IterableSubject;
import com.google.common.truth.Truth;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.mockito.stubbing.Answer;

public class CopyOfTester {
    private static final Pattern GETTER_NAME = Pattern.compile("^(get|is)[A-Z].*");
    private static final Predicate<Method> IS_GETTER = m -> GETTER_NAME.matcher(m.getName()).matches();

    public static <T> void assertAllGettersCalled(Class<T> klass, T object, Consumer<T> copyingCode) {
        Set allGetters = Arrays.stream(klass.getMethods()).filter(IS_GETTER).filter(method -> method.getDeclaringClass() != Object.class).map(Method::getName).collect(Collectors.toSet());
        ((IterableSubject)Truth.assertThat(allGetters).named("getters declared in " + klass.getName())).isNotEmpty();
        HashSet gettersCalled = new HashSet();
        Answer recordGetters = invocation -> {
            Method method = invocation.getMethod();
            if (GETTER_NAME.matcher(method.getName()).matches()) {
                gettersCalled.add(method.getName());
            }
            return invocation.callRealMethod();
        };
        Object mock = Mockito.mock(klass, (Answer)recordGetters);
        new LenientCopyTool().copyToMock(object, mock);
        copyingCode.accept(mock);
        ((IterableSubject)Truth.assertThat(gettersCalled).named("getters called")).containsExactlyElementsIn(allGetters);
    }
}

