/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.truth;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedField;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.iface.debug.DebugItem;

public class DexClassSubject
extends Subject<DexClassSubject, DexBackedClassDef> {
    public static final SubjectFactory<DexClassSubject, DexBackedClassDef> FACTORY = new SubjectFactory<DexClassSubject, DexBackedClassDef>(){

        public DexClassSubject getSubject(FailureStrategy failureStrategy, DexBackedClassDef subject) {
            return new DexClassSubject(failureStrategy, subject);
        }
    };

    private DexClassSubject(FailureStrategy failureStrategy, DexBackedClassDef subject) {
        super(failureStrategy, (Object)subject);
    }

    public void hasMethod(String name) {
        if (this.assertSubjectIsNonNull() && !this.checkHasMethod(name)) {
            this.fail("contains method", name);
        }
    }

    public void hasMethods(String ... names) {
        if (this.assertSubjectIsNonNull()) {
            for (String name : names) {
                this.hasMethod(name);
            }
        }
    }

    public void hasMethodWithLineInfoCount(String name, int lineInfoCount) {
        this.assertSubjectIsNonNull();
        for (DexBackedMethod method : ((DexBackedClassDef)this.getSubject()).getMethods()) {
            if (!method.getName().equals(name)) continue;
            if (method.getImplementation() == null) {
                this.fail("contain method implementation for method " + name);
                return;
            }
            int actualLineCnt = 0;
            for (DebugItem debugItem : method.getImplementation().getDebugItems()) {
                if (debugItem.getDebugItemType() != 10) continue;
                ++actualLineCnt;
            }
            if (actualLineCnt != lineInfoCount) {
                this.fail("method has " + lineInfoCount + " debug items, " + actualLineCnt + " are found.");
            }
            return;
        }
        this.fail("contains method", name);
    }

    public void hasField(String name) {
        if (this.assertSubjectIsNonNull() && !this.checkHasField(name)) {
            this.fail("contains field", name);
        }
    }

    public void doesNotHaveField(String name) {
        if (this.assertSubjectIsNonNull() && this.checkHasField(name)) {
            this.fail("does not contain field", name);
        }
    }

    public void doesNotHaveMethod(String name) {
        if (this.assertSubjectIsNonNull() && this.checkHasMethod(name)) {
            this.fail("does not contain method", name);
        }
    }

    private boolean checkHasMethod(String name) {
        for (DexBackedMethod method : ((DexBackedClassDef)this.getSubject()).getMethods()) {
            if (!method.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean checkHasField(String name) {
        for (DexBackedField field : ((DexBackedClassDef)this.getSubject()).getFields()) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean assertSubjectIsNonNull() {
        if (this.getSubject() == null) {
            this.fail("Cannot assert about the contents of a dex class that does not exist.");
            return false;
        }
        return true;
    }

    protected String getDisplaySubject() {
        String subjectName = null;
        if (this.getSubject() != null) {
            subjectName = ((DexBackedClassDef)this.getSubject()).getType();
        }
        if (this.internalCustomName() != null) {
            return this.internalCustomName() + " (<" + subjectName + ">)";
        }
        return "<" + subjectName + ">";
    }
}

