/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.truth;

import com.android.testutils.apk.Zip;
import com.android.testutils.truth.AbstractZipSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.File;
import java.io.IOException;

public class ZipFileSubject
extends AbstractZipSubject<ZipFileSubject, Zip> {
    public static final SubjectFactory<ZipFileSubject, Zip> FACTORY = new SubjectFactory<ZipFileSubject, Zip>(){

        public ZipFileSubject getSubject(FailureStrategy fs, Zip that) {
            return new ZipFileSubject(fs, that);
        }
    };

    public ZipFileSubject(FailureStrategy failureStrategy, Zip subject) {
        super(failureStrategy, subject);
    }

    public static ZipFileSubject assertThat(Zip zip) {
        return (ZipFileSubject)Truth.assert_().about(FACTORY).that((Object)zip);
    }

    public static ZipFileSubject assertThatZip(File file) throws IOException {
        Zip zip = new Zip(file.toPath());
        return (ZipFileSubject)Truth.assert_().about(FACTORY).that((Object)zip);
    }

    @Override
    public void contains(String path) throws IOException {
        this.exists();
        if (((Zip)this.getSubject()).getEntry(path) == null) {
            this.failWithRawMessage("'%s' does not contain '%s'", new Object[]{this.getSubject(), path});
        }
    }

    @Override
    public void doesNotContain(String path) throws IOException {
        this.exists();
        if (((Zip)this.getSubject()).getEntry(path) != null) {
            this.failWithRawMessage("'%s' unexpectedly contains '%s'", new Object[]{this.getSubject(), path});
        }
    }
}

