/*
 * Decompiled with CFR 0.152.
 */
package com.appyvet.materialrangebar;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.appyvet.materialrangebar.Bar;
import com.appyvet.materialrangebar.ConnectingLine;
import com.appyvet.materialrangebar.IRangeBarFormatter;
import com.appyvet.materialrangebar.PinView;
import com.appyvet.materialrangebar.R;
import java.util.ArrayList;
import java.util.HashMap;

public class RangeBar
extends View {
    private static final String TAG = "RangeBar";
    private static final float DEFAULT_TICK_START = 0.0f;
    private static final float DEFAULT_TICK_END = 5.0f;
    private static final float DEFAULT_TICK_INTERVAL = 1.0f;
    private static final float DEFAULT_TICK_HEIGHT_DP = 1.0f;
    private static final float DEFAULT_PIN_PADDING_DP = 16.0f;
    public static final float DEFAULT_MIN_PIN_FONT_SP = 8.0f;
    public static final float DEFAULT_MAX_PIN_FONT_SP = 24.0f;
    private static final float DEFAULT_BAR_WEIGHT_DP = 2.0f;
    private static final float DEFAULT_CIRCLE_BOUNDARY_SIZE_DP = 0.0f;
    private static final int DEFAULT_BAR_COLOR = -3355444;
    private static final int DEFAULT_TEXT_COLOR = -1;
    private static final int DEFAULT_TICK_COLOR = -16777216;
    private static final int DEFAULT_TICK_LABEL_COLOR = -3355444;
    private static final int DEFAULT_TICK_LABEL_SELECTED_COLOR = -16777216;
    private static final String DEFAULT_TICK_LABEL = "";
    public static final float DEFAULT_TICK_LABEL_FONT_SP = 4.0f;
    private static final int DEFAULT_PIN_COLOR = -12627531;
    private static final float DEFAULT_CONNECTING_LINE_WEIGHT_DP = 4.0f;
    private static final int DEFAULT_CONNECTING_LINE_COLOR = -12627531;
    private static final float DEFAULT_EXPANDED_PIN_RADIUS_DP = 12.0f;
    private static final float DEFAULT_CIRCLE_SIZE_DP = 5.0f;
    private static final float DEFAULT_BAR_PADDING_BOTTOM_DP = 24.0f;
    private float mTickHeight = 1.0f;
    private float mTickStart = 0.0f;
    private float mTickEnd = 5.0f;
    private float mTickInterval = 1.0f;
    private float mBarWeight = 2.0f;
    private boolean mIsBarRounded = false;
    private int mBarColor = -3355444;
    private int mPinColor = -12627531;
    private int mTextColor = -1;
    private float mConnectingLineWeight = 4.0f;
    private ArrayList<Integer> mConnectingLineColors = new ArrayList();
    private float mThumbRadiusDP = 12.0f;
    private int mTickDefaultColor = -16777216;
    private ArrayList<Integer> mTickColors = new ArrayList();
    private int mTickLabelColor = -3355444;
    private int mTickLabelSelectedColor = -16777216;
    private int mActiveTickLabelColor;
    private int mActiveTickLabelSelectedColor;
    private float mTickLabelSize = 4.0f;
    private CharSequence[] mTickBottomLabels;
    private CharSequence[] mTickTopLabels;
    private String mTickDefaultLabel = "";
    private float mExpandedPinRadius = 12.0f;
    private int mCircleColor = -12627531;
    private int mCircleColorLeft;
    private int mCircleColorRight;
    private int mCircleBoundaryColor = -12627531;
    private float mCircleBoundarySize = 0.0f;
    private float mCircleSize = 5.0f;
    private float mMinPinFont = 8.0f;
    private float mMaxPinFont = 24.0f;
    private boolean mFirstSetTickCount = true;
    private final DisplayMetrics mDisplayMetrices = this.getResources().getDisplayMetrics();
    private int mDefaultWidth = (int)TypedValue.applyDimension((int)1, (float)250.0f, (DisplayMetrics)this.mDisplayMetrices);
    private int mDefaultHeight = (int)TypedValue.applyDimension((int)1, (float)75.0f, (DisplayMetrics)this.mDisplayMetrices);
    private int mTickCount = (int)((this.mTickEnd - this.mTickStart) / this.mTickInterval) + 1;
    private PinView mLeftThumb;
    private PinView mRightThumb;
    private Bar mBar;
    private ConnectingLine mConnectingLine;
    private OnRangeBarChangeListener mListener;
    private OnRangeBarTextListener mPinTextListener;
    private HashMap<Float, String> mTickMap;
    private int mLeftIndex;
    private int mRightIndex;
    private boolean mIsRangeBar = true;
    private float mPinPadding = 16.0f;
    private float mBarPaddingBottom = 24.0f;
    private int mActiveConnectingLineColor;
    private ArrayList<Integer> mActiveConnectingLineColors = new ArrayList();
    private int mActiveBarColor;
    private int mActiveTickDefaultColor;
    private ArrayList<Integer> mActiveTickColors = new ArrayList();
    private int mActiveCircleColor;
    private int mActiveCircleColorLeft;
    private int mActiveCircleColorRight;
    private int mActiveCircleBoundaryColor;
    private int mDiffX;
    private int mDiffY;
    private float mLastX;
    private float mLastY;
    private IRangeBarFormatter mFormatter;
    private boolean drawTicks = true;
    private boolean mArePinsTemporary = true;
    private boolean mOnlyOnDrag = false;
    private boolean mDragging = false;
    private boolean mIsInScrollingContainer = false;
    private PinTextFormatter mPinTextFormatter = new PinTextFormatter(){

        @Override
        public String getText(String value) {
            if (value.length() > 4) {
                return value.substring(0, 4);
            }
            return value;
        }
    };

    public RangeBar(Context context) {
        super(context);
    }

    public RangeBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.rangeBarInit(context, attrs);
    }

    public RangeBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.rangeBarInit(context, attrs);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putInt("TICK_COUNT", this.mTickCount);
        bundle.putFloat("TICK_START", this.mTickStart);
        bundle.putFloat("TICK_END", this.mTickEnd);
        bundle.putFloat("TICK_INTERVAL", this.mTickInterval);
        bundle.putInt("TICK_COLOR", this.mTickDefaultColor);
        bundle.putIntegerArrayList("TICK_COLORS", this.mTickColors);
        bundle.putInt("TICK_LABEL_COLOR", this.mTickLabelColor);
        bundle.putInt("TICK_LABEL_SELECTED_COLOR", this.mTickLabelSelectedColor);
        bundle.putCharSequenceArray("TICK_TOP_LABELS", this.mTickTopLabels);
        bundle.putCharSequenceArray("TICK_BOTTOM_LABELS", this.mTickBottomLabels);
        bundle.putString("TICK_DEFAULT_LABEL", this.mTickDefaultLabel);
        bundle.putFloat("TICK_HEIGHT_DP", this.mTickHeight);
        bundle.putFloat("BAR_WEIGHT", this.mBarWeight);
        bundle.putBoolean("BAR_ROUNDED", this.mIsBarRounded);
        bundle.putInt("BAR_COLOR", this.mBarColor);
        bundle.putFloat("CONNECTING_LINE_WEIGHT", this.mConnectingLineWeight);
        bundle.putIntegerArrayList("CONNECTING_LINE_COLOR", this.mConnectingLineColors);
        bundle.putFloat("CIRCLE_SIZE", this.mCircleSize);
        bundle.putInt("CIRCLE_COLOR", this.mCircleColor);
        bundle.putInt("CIRCLE_COLOR_LEFT", this.mCircleColorLeft);
        bundle.putInt("CIRCLE_COLOR_RIGHT", this.mCircleColorRight);
        bundle.putInt("CIRCLE_BOUNDARY_COLOR", this.mCircleBoundaryColor);
        bundle.putFloat("CIRCLE_BOUNDARY_WIDTH", this.mCircleBoundarySize);
        bundle.putFloat("THUMB_RADIUS_DP", this.mThumbRadiusDP);
        bundle.putFloat("EXPANDED_PIN_RADIUS_DP", this.mExpandedPinRadius);
        bundle.putFloat("PIN_PADDING", this.mPinPadding);
        bundle.putFloat("BAR_PADDING_BOTTOM", this.mBarPaddingBottom);
        bundle.putBoolean("IS_RANGE_BAR", this.mIsRangeBar);
        bundle.putBoolean("IS_ONLY_ON_DRAG", this.mOnlyOnDrag);
        bundle.putBoolean("ARE_PINS_TEMPORARY", this.mArePinsTemporary);
        bundle.putInt("LEFT_INDEX", this.mLeftIndex);
        bundle.putInt("RIGHT_INDEX", this.mRightIndex);
        bundle.putBoolean("FIRST_SET_TICK_COUNT", this.mFirstSetTickCount);
        bundle.putFloat("MIN_PIN_FONT", this.mMinPinFont);
        bundle.putFloat("MAX_PIN_FONT", this.mMaxPinFont);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mTickCount = bundle.getInt("TICK_COUNT");
            this.mTickStart = bundle.getFloat("TICK_START");
            this.mTickEnd = bundle.getFloat("TICK_END");
            this.mTickInterval = bundle.getFloat("TICK_INTERVAL");
            this.mTickDefaultColor = bundle.getInt("TICK_COLOR");
            this.mTickColors = bundle.getIntegerArrayList("TICK_COLORS");
            this.mTickLabelColor = bundle.getInt("TICK_LABEL_COLOR");
            this.mTickLabelSelectedColor = bundle.getInt("TICK_LABEL_SELECTED_COLOR");
            this.mTickTopLabels = bundle.getCharSequenceArray("TICK_TOP_LABELS");
            this.mTickBottomLabels = bundle.getCharSequenceArray("TICK_BOTTOM_LABELS");
            this.mTickDefaultLabel = bundle.getString("TICK_DEFAULT_LABEL");
            this.mTickHeight = bundle.getFloat("TICK_HEIGHT_DP");
            this.mBarWeight = bundle.getFloat("BAR_WEIGHT");
            this.mIsBarRounded = bundle.getBoolean("BAR_ROUNDED", false);
            this.mBarColor = bundle.getInt("BAR_COLOR");
            this.mCircleSize = bundle.getFloat("CIRCLE_SIZE");
            this.mCircleColor = bundle.getInt("CIRCLE_COLOR");
            this.mCircleColorLeft = bundle.getInt("CIRCLE_COLOR_LEFT");
            this.mCircleColorRight = bundle.getInt("CIRCLE_COLOR_RIGHT");
            this.mCircleBoundaryColor = bundle.getInt("CIRCLE_BOUNDARY_COLOR");
            this.mCircleBoundarySize = bundle.getFloat("CIRCLE_BOUNDARY_WIDTH");
            this.mConnectingLineWeight = bundle.getFloat("CONNECTING_LINE_WEIGHT");
            this.mConnectingLineColors = bundle.getIntegerArrayList("CONNECTING_LINE_COLOR");
            this.mThumbRadiusDP = bundle.getFloat("THUMB_RADIUS_DP");
            this.mExpandedPinRadius = bundle.getFloat("EXPANDED_PIN_RADIUS_DP");
            this.mPinPadding = bundle.getFloat("PIN_PADDING");
            this.mBarPaddingBottom = bundle.getFloat("BAR_PADDING_BOTTOM");
            this.mIsRangeBar = bundle.getBoolean("IS_RANGE_BAR");
            this.mOnlyOnDrag = bundle.getBoolean("IS_ONLY_ON_DRAG");
            this.mArePinsTemporary = bundle.getBoolean("ARE_PINS_TEMPORARY");
            this.mLeftIndex = bundle.getInt("LEFT_INDEX");
            this.mRightIndex = bundle.getInt("RIGHT_INDEX");
            this.mFirstSetTickCount = bundle.getBoolean("FIRST_SET_TICK_COUNT");
            this.mMinPinFont = bundle.getFloat("MIN_PIN_FONT");
            this.mMaxPinFont = bundle.getFloat("MAX_PIN_FONT");
            this.setRangePinsByIndices(this.mLeftIndex, this.mRightIndex);
            super.onRestoreInstanceState(bundle.getParcelable("instanceState"));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measureWidthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int measureHeightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int measureWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measureHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = measureWidthMode == Integer.MIN_VALUE ? measureWidth : (measureWidthMode == 0x40000000 ? measureWidth : this.mDefaultWidth);
        int height = measureHeightMode == Integer.MIN_VALUE ? Math.min(this.mDefaultHeight, measureHeight) : (measureHeightMode == 0x40000000 ? measureHeight : this.mDefaultHeight);
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Context ctx = this.getContext();
        float density = this.mDisplayMetrices.density;
        float expandedPinRadius = this.mExpandedPinRadius / density;
        float yPos = (float)h - this.mBarPaddingBottom;
        if (this.mIsRangeBar) {
            this.mLeftThumb = new PinView(ctx);
            this.mLeftThumb.setFormatter(this.mFormatter);
            this.mLeftThumb.init(ctx, yPos, expandedPinRadius, this.mPinColor, this.mTextColor, this.mCircleSize, this.mCircleColorLeft, this.mCircleBoundaryColor, this.mCircleBoundarySize, this.mMinPinFont, this.mMaxPinFont, this.mArePinsTemporary);
        }
        this.mRightThumb = new PinView(ctx);
        this.mRightThumb.setFormatter(this.mFormatter);
        this.mRightThumb.init(ctx, yPos, expandedPinRadius, this.mPinColor, this.mTextColor, this.mCircleSize, this.mCircleColorRight, this.mCircleBoundaryColor, this.mCircleBoundarySize, this.mMinPinFont, this.mMaxPinFont, this.mArePinsTemporary);
        float marginLeft = Math.max(this.mExpandedPinRadius, this.mCircleSize);
        float barLength = (float)w - 2.0f * marginLeft;
        this.mBar = new Bar(ctx, marginLeft, yPos, barLength, this.mTickCount, this.mTickHeight, this.mTickDefaultColor, this.mTickColors, this.mBarWeight, this.mBarColor, this.mIsBarRounded, this.mTickLabelColor, this.mTickLabelSelectedColor, this.mTickTopLabels, this.mTickBottomLabels, this.mTickDefaultLabel, this.mTickLabelSize);
        if (this.mIsRangeBar) {
            this.mLeftThumb.setX(marginLeft + (float)this.mLeftIndex / (float)(this.mTickCount - 1) * barLength);
            this.mLeftThumb.setXValue(this.getPinValue(this.mLeftIndex));
        }
        this.mRightThumb.setX(marginLeft + (float)this.mRightIndex / (float)(this.mTickCount - 1) * barLength);
        this.mRightThumb.setXValue(this.getPinValue(this.mRightIndex));
        int newLeftIndex = this.mIsRangeBar ? this.mBar.getNearestTickIndex(this.mLeftThumb) : 0;
        int newRightIndex = this.mBar.getNearestTickIndex(this.mRightThumb);
        if ((newLeftIndex != this.mLeftIndex || newRightIndex != this.mRightIndex) && this.mListener != null) {
            this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
        }
        this.mConnectingLine = new ConnectingLine(yPos, this.mConnectingLineWeight, this.mConnectingLineColors);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mIsInScrollingContainer = this.isInScrollingContainer();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mBar.draw(canvas);
        if (this.mIsRangeBar) {
            this.mConnectingLine.draw(canvas, this.mLeftThumb, this.mRightThumb);
            if (this.drawTicks) {
                this.mBar.drawTicks(canvas, this.mExpandedPinRadius, this.mRightThumb, this.mLeftThumb);
            }
            this.mLeftThumb.draw(canvas);
        } else {
            this.mConnectingLine.draw(canvas, this.getMarginLeft(), this.mRightThumb);
            if (this.drawTicks) {
                this.mBar.drawTicks(canvas, this.mExpandedPinRadius, this.mRightThumb);
            }
        }
        this.mRightThumb.draw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.mDiffX = 0;
                this.mDiffY = 0;
                this.mLastX = event.getX();
                this.mLastY = event.getY();
                if (!this.mIsInScrollingContainer) {
                    this.onActionDown(event.getX(), event.getY());
                }
                return true;
            }
            case 1: {
                if (this.mDragging || event.getX() == this.mLastX && event.getY() == this.mLastY) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                    this.onActionUp(event.getX(), event.getY());
                }
                return true;
            }
            case 3: {
                if (this.mDragging || event.getX() == this.mLastX && event.getY() == this.mLastY) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                    this.onActionUp(event.getX(), event.getY());
                }
                return true;
            }
            case 2: {
                float curX = event.getX();
                float curY = event.getY();
                this.mDiffX = (int)((float)this.mDiffX + Math.abs(curX - this.mLastX));
                this.mDiffY = (int)((float)this.mDiffY + Math.abs(curY - this.mLastY));
                this.mLastX = curX;
                this.mLastY = curY;
                if (!this.mDragging) {
                    if (this.mDiffX > this.mDiffY) {
                        this.onActionDown(event.getX(), event.getY());
                        return true;
                    }
                    return false;
                }
                this.onActionMove(event.getX());
                this.getParent().requestDisallowInterceptTouchEvent(true);
                if (this.mDiffX < this.mDiffY) {
                    if (!this.mIsInScrollingContainer) {
                        this.getParent().requestDisallowInterceptTouchEvent(false);
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void setOnlyOnDrag(boolean onlyOnDrag) {
        this.mOnlyOnDrag = onlyOnDrag;
    }

    public void setOnRangeBarChangeListener(OnRangeBarChangeListener listener) {
        this.mListener = listener;
    }

    public void setPinTextListener(OnRangeBarTextListener mPinTextListener) {
        this.mPinTextListener = mPinTextListener;
    }

    public void setFormatter(IRangeBarFormatter formatter) {
        if (this.mLeftThumb != null) {
            this.mLeftThumb.setFormatter(formatter);
        }
        if (this.mRightThumb != null) {
            this.mRightThumb.setFormatter(formatter);
        }
        this.mFormatter = formatter;
    }

    public void setDrawTicks(boolean drawTicks) {
        this.drawTicks = drawTicks;
    }

    public void setTickStart(float tickStart) {
        int tickCount = (int)((this.mTickEnd - tickStart) / this.mTickInterval) + 1;
        if (this.isValidTickCount(tickCount)) {
            this.mTickCount = tickCount;
            this.mTickStart = tickStart;
            if (this.mFirstSetTickCount) {
                this.mLeftIndex = 0;
                this.mRightIndex = this.mTickCount - 1;
                if (this.mListener != null) {
                    this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
                }
            }
            if (this.indexOutOfRange(this.mLeftIndex, this.mRightIndex)) {
                this.mLeftIndex = 0;
                this.mRightIndex = this.mTickCount - 1;
                if (this.mListener != null) {
                    this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
                }
            }
        } else {
            Log.e((String)TAG, (String)"tickCount less than 2; invalid tickCount.");
            throw new IllegalArgumentException("tickCount less than 2; invalid tickCount.");
        }
        this.createBar();
        this.createPins();
    }

    public void setTickInterval(float tickInterval) {
        int tickCount = (int)((this.mTickEnd - this.mTickStart) / tickInterval) + 1;
        if (this.isValidTickCount(tickCount)) {
            this.mTickCount = tickCount;
            this.mTickInterval = tickInterval;
            if (this.mFirstSetTickCount) {
                this.mLeftIndex = 0;
                this.mRightIndex = this.mTickCount - 1;
                if (this.mListener != null) {
                    this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
                }
            }
            if (this.indexOutOfRange(this.mLeftIndex, this.mRightIndex)) {
                this.mLeftIndex = 0;
                this.mRightIndex = this.mTickCount - 1;
                if (this.mListener != null) {
                    this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
                }
            }
        } else {
            Log.e((String)TAG, (String)"tickCount less than 2; invalid tickCount.");
            throw new IllegalArgumentException("tickCount less than 2; invalid tickCount.");
        }
        this.createBar();
        this.createPins();
    }

    public void setTickEnd(float tickEnd) {
        int tickCount = (int)((tickEnd - this.mTickStart) / this.mTickInterval) + 1;
        if (this.isValidTickCount(tickCount)) {
            this.mTickCount = tickCount;
            this.mTickEnd = tickEnd;
            if (this.mFirstSetTickCount) {
                this.mLeftIndex = 0;
                this.mRightIndex = this.mTickCount - 1;
                if (this.mListener != null) {
                    this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
                }
            }
            if (this.indexOutOfRange(this.mLeftIndex, this.mRightIndex)) {
                this.mLeftIndex = 0;
                this.mRightIndex = this.mTickCount - 1;
                if (this.mListener != null) {
                    this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
                }
            }
        } else {
            Log.e((String)TAG, (String)"tickCount less than 2; invalid tickCount.");
            throw new IllegalArgumentException("tickCount less than 2; invalid tickCount.");
        }
        this.createBar();
        this.createPins();
    }

    public void setTickHeight(float tickHeight) {
        this.mTickHeight = tickHeight;
        this.createBar();
    }

    public void setBarWeight(float barWeight) {
        this.mBarWeight = barWeight;
        this.createBar();
    }

    public boolean isBarRounded() {
        return this.mIsBarRounded;
    }

    public void setBarRounded(boolean isBarRounded) {
        this.mIsBarRounded = isBarRounded;
        this.createBar();
    }

    public void setBarColor(int barColor) {
        this.mBarColor = barColor;
        this.createBar();
    }

    public void setPinColor(int pinColor) {
        this.mPinColor = pinColor;
        this.createPins();
    }

    public void setPinTextColor(int textColor) {
        this.mTextColor = textColor;
        this.createPins();
    }

    public void setRangeBarEnabled(boolean isRangeBar) {
        this.mIsRangeBar = isRangeBar;
        this.invalidate();
    }

    public void setTemporaryPins(boolean arePinsTemporary) {
        this.mArePinsTemporary = arePinsTemporary;
        this.invalidate();
    }

    public void setTickDefaultColor(int tickDefaultColor) {
        this.mTickDefaultColor = tickDefaultColor;
        this.setTickColors(tickDefaultColor);
        this.createBar();
    }

    public void setTickColors(ArrayList<Integer> tickColors) {
        this.mTickColors = new ArrayList<Integer>(tickColors);
        this.createBar();
    }

    public void setTickColors(int color) {
        for (int i = 0; i < this.mTickColors.size(); ++i) {
            this.mTickColors.set(i, color);
        }
        this.createBar();
    }

    public void setTickLabelColor(int tickLabelColor) {
        this.mTickLabelColor = tickLabelColor;
        this.createBar();
    }

    public void setTickLabelSelectedColor(int tickLabelSelectedColor) {
        this.mTickLabelSelectedColor = tickLabelSelectedColor;
        this.createBar();
    }

    public void setTickTopLabels(CharSequence[] tickLabels) {
        this.mTickTopLabels = tickLabels;
        this.createBar();
    }

    public void setTickBottomLabels(CharSequence[] tickLabels) {
        this.mTickBottomLabels = tickLabels;
        this.createBar();
    }

    public void setSelectorColor(int selectorColor) {
        this.mCircleColor = selectorColor;
        this.setLeftSelectorColor(selectorColor);
        this.setRightSelectorColor(selectorColor);
        this.createPins();
    }

    public void setSelectorBoundaryColor(int selectorBoundaryColor) {
        this.mCircleBoundaryColor = selectorBoundaryColor;
        this.createPins();
    }

    public void setSelectorBoundarySize(int selectorBoundarySize) {
        this.mCircleBoundarySize = selectorBoundarySize;
        this.createPins();
    }

    public void setConnectingLineWeight(float connectingLineWeight) {
        this.mConnectingLineWeight = connectingLineWeight;
        this.createConnectingLine();
    }

    public void setConnectingLineColor(int connectingLineColor) {
        this.mConnectingLineColors.clear();
        this.mConnectingLineColors.add(connectingLineColor);
        this.createConnectingLine();
    }

    public void setConnectingLineColors(ArrayList<Integer> connectingLineColors) {
        this.mConnectingLineColors = new ArrayList<Integer>(connectingLineColors);
        this.createConnectingLine();
    }

    public void setPinRadius(float pinRadius) {
        this.mExpandedPinRadius = pinRadius;
        this.createPins();
    }

    public void setLeftSelectorColor(int mCircleColorLeft) {
        this.mCircleColorLeft = mCircleColorLeft;
        this.createPins();
    }

    public void setRightSelectorColor(int mCircleColorRight) {
        this.mCircleColorRight = mCircleColorRight;
        this.createPins();
    }

    public int getLeftSelectorColor() {
        return this.mCircleColorLeft;
    }

    public int getRightSelectorColor() {
        return this.mCircleColorRight;
    }

    public float getTickStart() {
        return this.mTickStart;
    }

    public float getTickEnd() {
        return this.mTickEnd;
    }

    public int getTickCount() {
        return this.mTickCount;
    }

    public CharSequence[] getTickTopLabels() {
        return this.mTickTopLabels;
    }

    public CharSequence[] getTickBottomLabels() {
        return this.mTickBottomLabels;
    }

    public ArrayList<Integer> getTickColors() {
        return this.mTickColors;
    }

    public int getTickColor(int index) {
        return this.mTickColors.get(index);
    }

    public void setRangePinsByIndices(int leftPinIndex, int rightPinIndex) {
        if (this.indexOutOfRange(leftPinIndex, rightPinIndex)) {
            Log.e((String)TAG, (String)("Pin index left " + leftPinIndex + ", or right " + rightPinIndex + " is out of bounds. Check that it is greater than the minimum (" + this.mTickStart + ") and less than the maximum value (" + this.mTickEnd + ")"));
            throw new IllegalArgumentException("Pin index left " + leftPinIndex + ", or right " + rightPinIndex + " is out of bounds. Check that it is greater than the minimum (" + this.mTickStart + ") and less than the maximum value (" + this.mTickEnd + ")");
        }
        if (this.mFirstSetTickCount) {
            this.mFirstSetTickCount = false;
        }
        this.mLeftIndex = leftPinIndex;
        this.mRightIndex = rightPinIndex;
        this.createPins();
        if (this.mListener != null) {
            this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
        }
        this.invalidate();
        this.requestLayout();
    }

    public void setSeekPinByIndex(int pinIndex) {
        if (pinIndex < 0 || pinIndex > this.mTickCount) {
            Log.e((String)TAG, (String)("Pin index " + pinIndex + " is out of bounds. Check that it is greater than the minimum (" + 0 + ") and less than the maximum value (" + this.mTickCount + ")"));
            throw new IllegalArgumentException("Pin index " + pinIndex + " is out of bounds. Check that it is greater than the minimum (" + 0 + ") and less than the maximum value (" + this.mTickCount + ")");
        }
        if (this.mFirstSetTickCount) {
            this.mFirstSetTickCount = false;
        }
        this.mRightIndex = pinIndex;
        this.createPins();
        if (this.mListener != null) {
            this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
        }
        this.invalidate();
        this.requestLayout();
    }

    public void setRangePinsByValue(float leftPinValue, float rightPinValue) {
        if (this.valueOutOfRange(leftPinValue, rightPinValue)) {
            Log.e((String)TAG, (String)("Pin value left " + leftPinValue + ", or right " + rightPinValue + " is out of bounds. Check that it is greater than the minimum (" + this.mTickStart + ") and less than the maximum value (" + this.mTickEnd + ")"));
            throw new IllegalArgumentException("Pin value left " + leftPinValue + ", or right " + rightPinValue + " is out of bounds. Check that it is greater than the minimum (" + this.mTickStart + ") and less than the maximum value (" + this.mTickEnd + ")");
        }
        if (this.mFirstSetTickCount) {
            this.mFirstSetTickCount = false;
        }
        this.mLeftIndex = (int)((leftPinValue - this.mTickStart) / this.mTickInterval);
        this.mRightIndex = (int)((rightPinValue - this.mTickStart) / this.mTickInterval);
        this.createPins();
        if (this.mListener != null) {
            this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
        }
        if (this.mListener != null) {
            this.mListener.onTouchEnded(this);
        }
        this.invalidate();
        this.requestLayout();
    }

    public void setSeekPinByValue(float pinValue) {
        if (pinValue > this.mTickEnd || pinValue < this.mTickStart) {
            Log.e((String)TAG, (String)("Pin value " + pinValue + " is out of bounds. Check that it is greater than the minimum (" + this.mTickStart + ") and less than the maximum value (" + this.mTickEnd + ")"));
            throw new IllegalArgumentException("Pin value " + pinValue + " is out of bounds. Check that it is greater than the minimum (" + this.mTickStart + ") and less than the maximum value (" + this.mTickEnd + ")");
        }
        if (this.mFirstSetTickCount) {
            this.mFirstSetTickCount = false;
        }
        this.mRightIndex = (int)((pinValue - this.mTickStart) / this.mTickInterval);
        this.createPins();
        if (this.mListener != null) {
            this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
        }
        this.invalidate();
        this.requestLayout();
    }

    public boolean isRangeBar() {
        return this.mIsRangeBar;
    }

    public String getLeftPinValue() {
        return this.getPinValue(this.mLeftIndex);
    }

    public String getRightPinValue() {
        return this.getPinValue(this.mRightIndex);
    }

    public int getLeftIndex() {
        return this.mLeftIndex;
    }

    public int getRightIndex() {
        return this.mRightIndex;
    }

    public double getTickInterval() {
        return this.mTickInterval;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.mBarColor = -3355444;
            this.setConnectingLineColor(-3355444);
            this.mCircleColor = -3355444;
            this.mCircleColorLeft = -3355444;
            this.mCircleColorRight = -3355444;
            this.mCircleBoundaryColor = -3355444;
            this.mTickDefaultColor = -3355444;
            this.setTickColors(-3355444);
            this.mTickLabelColor = -3355444;
            this.mTickLabelSelectedColor = -3355444;
        } else {
            this.mBarColor = this.mActiveBarColor;
            this.setConnectingLineColor(this.mActiveConnectingLineColor);
            this.setConnectingLineColors(this.mActiveConnectingLineColors);
            this.mCircleColor = this.mActiveCircleColor;
            this.mCircleColorLeft = this.mActiveCircleColorLeft;
            this.mCircleColorRight = this.mActiveCircleColorRight;
            this.mCircleBoundaryColor = this.mActiveCircleBoundaryColor;
            this.mTickDefaultColor = this.mActiveTickDefaultColor;
            this.setTickColors(this.mActiveTickColors);
            this.mTickLabelColor = this.mActiveTickLabelColor;
            this.mTickLabelSelectedColor = this.mActiveTickLabelSelectedColor;
        }
        super.setEnabled(enabled);
        this.createBar();
        this.createPins();
        this.createConnectingLine();
    }

    public void setPinTextFormatter(PinTextFormatter pinTextFormatter) {
        this.mPinTextFormatter = pinTextFormatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rangeBarInit(Context context, AttributeSet attrs) {
        if (this.mTickMap == null) {
            this.mTickMap = new HashMap();
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RangeBar, 0, 0);
        try {
            int mConnectingLineColor;
            float tickStart = ta.getFloat(R.styleable.RangeBar_mrb_tickStart, 0.0f);
            float tickEnd = ta.getFloat(R.styleable.RangeBar_mrb_tickEnd, 5.0f);
            float tickInterval = ta.getFloat(R.styleable.RangeBar_mrb_tickInterval, 1.0f);
            int tickCount = (int)((tickEnd - tickStart) / tickInterval) + 1;
            if (this.isValidTickCount(tickCount)) {
                this.mTickCount = tickCount;
                this.mTickStart = tickStart;
                this.mTickEnd = tickEnd;
                this.mTickInterval = tickInterval;
                this.mLeftIndex = 0;
                this.mRightIndex = this.mTickCount - 1;
                if (this.mListener != null) {
                    this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
                }
            } else {
                Log.e((String)TAG, (String)"tickCount less than 2; invalid tickCount. XML input ignored.");
            }
            this.mTickHeight = ta.getDimension(R.styleable.RangeBar_mrb_tickHeight, TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.mDisplayMetrices));
            this.mBarWeight = ta.getDimension(R.styleable.RangeBar_mrb_barWeight, TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.mDisplayMetrices));
            this.mCircleSize = ta.getDimension(R.styleable.RangeBar_mrb_selectorSize, TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.mDisplayMetrices));
            this.mCircleBoundarySize = ta.getDimension(R.styleable.RangeBar_mrb_selectorBoundarySize, TypedValue.applyDimension((int)1, (float)0.0f, (DisplayMetrics)this.mDisplayMetrices));
            this.mConnectingLineWeight = ta.getDimension(R.styleable.RangeBar_mrb_connectingLineWeight, TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.mDisplayMetrices));
            this.mExpandedPinRadius = ta.getDimension(R.styleable.RangeBar_mrb_pinRadius, TypedValue.applyDimension((int)1, (float)12.0f, (DisplayMetrics)this.mDisplayMetrices));
            this.mPinPadding = ta.getDimension(R.styleable.RangeBar_mrb_pinPadding, TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)this.mDisplayMetrices));
            this.mBarPaddingBottom = ta.getDimension(R.styleable.RangeBar_mrb_rangeBarPaddingBottom, TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)this.mDisplayMetrices));
            this.mBarColor = ta.getColor(R.styleable.RangeBar_mrb_rangeBarColor, -3355444);
            this.mTextColor = ta.getColor(R.styleable.RangeBar_mrb_pinTextColor, -1);
            this.mPinColor = ta.getColor(R.styleable.RangeBar_mrb_pinColor, -12627531);
            this.mActiveBarColor = this.mBarColor;
            this.mCircleColor = ta.getColor(R.styleable.RangeBar_mrb_selectorColor, -12627531);
            this.mCircleColorLeft = ta.getColor(R.styleable.RangeBar_mrb_leftSelectorColor, this.mCircleColor);
            this.mCircleColorRight = ta.getColor(R.styleable.RangeBar_mrb_rightSelectorColor, this.mCircleColor);
            this.mCircleBoundaryColor = ta.getColor(R.styleable.RangeBar_mrb_selectorBoundaryColor, -12627531);
            this.mActiveCircleColor = this.mCircleColor;
            this.mActiveCircleColorLeft = this.mCircleColorLeft;
            this.mActiveCircleColorRight = this.mCircleColorRight;
            this.mActiveCircleBoundaryColor = this.mCircleBoundaryColor;
            this.mActiveTickDefaultColor = this.mTickDefaultColor = ta.getColor(R.styleable.RangeBar_mrb_tickDefaultColor, -16777216);
            this.mTickColors = this.getColors(ta.getTextArray(R.styleable.RangeBar_mrb_tickColors), this.mTickDefaultColor);
            this.mActiveTickColors = new ArrayList<Integer>(this.mTickColors);
            this.mActiveTickLabelColor = this.mTickLabelColor = ta.getColor(R.styleable.RangeBar_mrb_tickLabelColor, -3355444);
            this.mActiveTickLabelSelectedColor = this.mTickLabelSelectedColor = ta.getColor(R.styleable.RangeBar_mrb_tickLabelSelectedColor, -16777216);
            this.mTickBottomLabels = ta.getTextArray(R.styleable.RangeBar_mrb_tickBottomLabels);
            this.mTickTopLabels = ta.getTextArray(R.styleable.RangeBar_mrb_tickTopLabels);
            this.mTickDefaultLabel = ta.getString(R.styleable.RangeBar_mrb_tickDefaultLabel);
            this.mTickDefaultLabel = this.mTickDefaultLabel != null ? this.mTickDefaultLabel : DEFAULT_TICK_LABEL;
            this.mActiveConnectingLineColor = mConnectingLineColor = ta.getColor(R.styleable.RangeBar_mrb_connectingLineColor, -12627531);
            CharSequence[] colors = ta.getTextArray(R.styleable.RangeBar_mrb_connectingLineColors);
            if (colors != null && colors.length > 0) {
                for (CharSequence colorHex : colors) {
                    String hexString = colorHex.toString();
                    if (hexString.length() == 4) {
                        hexString = hexString + "000";
                    }
                    this.mConnectingLineColors.add(Color.parseColor((String)hexString));
                }
            } else {
                this.mConnectingLineColors.add(mConnectingLineColor);
            }
            this.mActiveConnectingLineColors = new ArrayList<Integer>(this.mConnectingLineColors);
            this.mIsRangeBar = ta.getBoolean(R.styleable.RangeBar_mrb_rangeBar, true);
            this.mArePinsTemporary = ta.getBoolean(R.styleable.RangeBar_mrb_temporaryPins, true);
            this.mIsBarRounded = ta.getBoolean(R.styleable.RangeBar_mrb_rangeBar_rounded, false);
            float density = this.mDisplayMetrices.density;
            this.mMinPinFont = ta.getDimension(R.styleable.RangeBar_mrb_pinMinFont, 8.0f * density);
            this.mMaxPinFont = ta.getDimension(R.styleable.RangeBar_mrb_pinMaxFont, 24.0f * density);
            this.mTickLabelSize = ta.getDimension(R.styleable.RangeBar_mrb_tickLabelSize, 4.0f * density);
            this.mIsRangeBar = ta.getBoolean(R.styleable.RangeBar_mrb_rangeBar, true);
            this.mOnlyOnDrag = ta.getBoolean(R.styleable.RangeBar_mrb_onlyOnDrag, false);
        }
        finally {
            ta.recycle();
        }
    }

    private void createBar() {
        this.mBar = new Bar(this.getContext(), this.getMarginLeft(), this.getYPos(), this.getBarLength(), this.mTickCount, this.mTickHeight, this.mTickDefaultColor, this.mTickColors, this.mBarWeight, this.mBarColor, this.mIsBarRounded, this.mTickLabelColor, this.mTickLabelSelectedColor, this.mTickTopLabels, this.mTickBottomLabels, this.mTickDefaultLabel, this.mTickLabelSize);
        this.invalidate();
    }

    private void createConnectingLine() {
        this.mConnectingLine = new ConnectingLine(this.getYPos(), this.mConnectingLineWeight, this.mConnectingLineColors);
        this.invalidate();
    }

    private void createPins() {
        Context ctx = this.getContext();
        float yPos = this.getYPos();
        float expandedPinRadius = 0.0f;
        if (this.isEnabled()) {
            expandedPinRadius = this.mExpandedPinRadius / this.mDisplayMetrices.density;
        }
        if (this.mIsRangeBar) {
            this.mLeftThumb = new PinView(ctx);
            this.mLeftThumb.init(ctx, yPos, expandedPinRadius, this.mPinColor, this.mTextColor, this.mCircleSize, this.mCircleColorLeft, this.mCircleBoundaryColor, this.mCircleBoundarySize, this.mMinPinFont, this.mMaxPinFont, this.mArePinsTemporary);
        }
        this.mRightThumb = new PinView(ctx);
        this.mRightThumb.init(ctx, yPos, expandedPinRadius, this.mPinColor, this.mTextColor, this.mCircleSize, this.mCircleColorRight, this.mCircleBoundaryColor, this.mCircleBoundarySize, this.mMinPinFont, this.mMaxPinFont, this.mArePinsTemporary);
        float marginLeft = this.getMarginLeft();
        float barLength = this.getBarLength();
        if (this.mIsRangeBar) {
            this.mLeftThumb.setX(marginLeft + (float)this.mLeftIndex / (float)(this.mTickCount - 1) * barLength);
            this.mLeftThumb.setXValue(this.getPinValue(this.mLeftIndex));
        }
        this.mRightThumb.setX(marginLeft + (float)this.mRightIndex / (float)(this.mTickCount - 1) * barLength);
        this.mRightThumb.setXValue(this.getPinValue(this.mRightIndex));
        this.invalidate();
    }

    private float getMarginLeft() {
        return Math.max(this.mExpandedPinRadius, this.mCircleSize);
    }

    private float getYPos() {
        return (float)this.getHeight() - this.mBarPaddingBottom;
    }

    private float getBarLength() {
        return (float)this.getWidth() - 2.0f * this.getMarginLeft();
    }

    private boolean indexOutOfRange(int leftThumbIndex, int rightThumbIndex) {
        return leftThumbIndex < 0 || leftThumbIndex >= this.mTickCount || rightThumbIndex < 0 || rightThumbIndex >= this.mTickCount;
    }

    private boolean valueOutOfRange(float leftThumbValue, float rightThumbValue) {
        return leftThumbValue < this.mTickStart || leftThumbValue > this.mTickEnd || rightThumbValue < this.mTickStart || rightThumbValue > this.mTickEnd;
    }

    private boolean isValidTickCount(int tickCount) {
        return tickCount > 1;
    }

    private float getLeftThumbXDistance(float x) {
        if (this.isRangeBar()) {
            float leftThumbX = this.mLeftThumb.getX();
            return leftThumbX == this.mRightThumb.getX() && x < leftThumbX ? 0.0f : Math.abs(leftThumbX - x);
        }
        return 0.0f;
    }

    private float getRightThumbXDistance(float x) {
        return Math.abs(this.mRightThumb.getX() - x);
    }

    private void onActionDown(float x, float y) {
        if (this.mIsRangeBar) {
            if (!this.mRightThumb.isPressed() && this.mLeftThumb.isInTargetZone(x, y)) {
                this.pressPin(this.mLeftThumb);
            } else if (!this.mLeftThumb.isPressed() && this.mRightThumb.isInTargetZone(x, y)) {
                this.pressPin(this.mRightThumb);
            }
        } else if (this.mRightThumb.isInTargetZone(x, y)) {
            this.pressPin(this.mRightThumb);
        }
        this.mDragging = true;
        if (this.mListener != null) {
            this.mListener.onTouchStarted(this);
        }
    }

    private void onActionUp(float x, float y) {
        if (this.mIsRangeBar && this.mLeftThumb.isPressed()) {
            this.releasePin(this.mLeftThumb);
        } else if (this.mRightThumb.isPressed()) {
            this.releasePin(this.mRightThumb);
        } else if (!this.mOnlyOnDrag) {
            float rightThumbXDistance;
            float leftThumbXDistance = this.getLeftThumbXDistance(x);
            if (leftThumbXDistance < (rightThumbXDistance = this.getRightThumbXDistance(x)) && this.mIsRangeBar) {
                this.mLeftThumb.setX(x);
                this.releasePin(this.mLeftThumb);
            } else {
                this.mRightThumb.setX(x);
                this.releasePin(this.mRightThumb);
            }
            int newLeftIndex = this.mIsRangeBar ? this.mBar.getNearestTickIndex(this.mLeftThumb) : 0;
            int newRightIndex = this.mBar.getNearestTickIndex(this.mRightThumb);
            if (newLeftIndex != this.mLeftIndex || newRightIndex != this.mRightIndex) {
                this.mLeftIndex = newLeftIndex;
                this.mRightIndex = newRightIndex;
                if (this.mListener != null) {
                    this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
                }
            }
        }
        this.mDragging = false;
        if (this.mListener != null) {
            this.mListener.onTouchEnded(this);
        }
    }

    private void onActionMove(float x) {
        if (this.mIsRangeBar && this.mLeftThumb.isPressed()) {
            this.movePin(this.mLeftThumb, x);
        } else if (this.mRightThumb.isPressed()) {
            this.movePin(this.mRightThumb, x);
        }
        if (this.mIsRangeBar && this.mLeftThumb.getX() > this.mRightThumb.getX()) {
            PinView temp = this.mLeftThumb;
            this.mLeftThumb = this.mRightThumb;
            this.mRightThumb = temp;
        }
        int newLeftIndex = this.mIsRangeBar ? this.mBar.getNearestTickIndex(this.mLeftThumb) : 0;
        int newRightIndex = this.mBar.getNearestTickIndex(this.mRightThumb);
        int componentLeft = this.getPaddingLeft();
        int componentRight = this.getRight() - this.getPaddingRight() - componentLeft;
        if (x <= (float)componentLeft) {
            newLeftIndex = 0;
            this.movePin(this.mLeftThumb, this.mBar.getLeftX());
        } else if (x >= (float)componentRight) {
            newRightIndex = this.getTickCount() - 1;
            this.movePin(this.mRightThumb, this.mBar.getRightX());
        }
        if (newLeftIndex != this.mLeftIndex || newRightIndex != this.mRightIndex) {
            this.mLeftIndex = newLeftIndex;
            this.mRightIndex = newRightIndex;
            if (this.mIsRangeBar) {
                this.mLeftThumb.setXValue(this.getPinValue(this.mLeftIndex));
            }
            this.mRightThumb.setXValue(this.getPinValue(this.mRightIndex));
            if (this.mListener != null) {
                this.mListener.onRangeChangeListener(this, this.mLeftIndex, this.mRightIndex, this.getPinValue(this.mLeftIndex), this.getPinValue(this.mRightIndex));
            }
        }
    }

    private void pressPin(final PinView thumb) {
        if (this.mFirstSetTickCount) {
            this.mFirstSetTickCount = false;
        }
        if (this.mArePinsTemporary) {
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.mExpandedPinRadius});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RangeBar.this.mThumbRadiusDP = ((Float)animation.getAnimatedValue()).floatValue();
                    thumb.setSize(RangeBar.this.mThumbRadiusDP, RangeBar.this.mPinPadding * animation.getAnimatedFraction());
                    RangeBar.this.invalidate();
                }
            });
            animator.start();
        }
        thumb.press();
    }

    private void releasePin(final PinView thumb) {
        float nearestTickX = this.mBar.getNearestTickCoordinate(thumb);
        thumb.setX(nearestTickX);
        int tickIndex = this.mBar.getNearestTickIndex(thumb);
        thumb.setXValue(this.getPinValue(tickIndex));
        if (this.mArePinsTemporary) {
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.mExpandedPinRadius, 0.0f});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RangeBar.this.mThumbRadiusDP = ((Float)animation.getAnimatedValue()).floatValue();
                    thumb.setSize(RangeBar.this.mThumbRadiusDP, RangeBar.this.mPinPadding - RangeBar.this.mPinPadding * animation.getAnimatedFraction());
                    RangeBar.this.invalidate();
                }
            });
            animator.start();
        } else {
            this.invalidate();
        }
        thumb.release();
    }

    private String getPinValue(int tickIndex) {
        if (this.mPinTextListener != null) {
            return this.mPinTextListener.getPinValue(this, tickIndex);
        }
        float tickValue = tickIndex == this.mTickCount - 1 ? this.mTickEnd : (float)tickIndex * this.mTickInterval + this.mTickStart;
        String xValue = this.mTickMap.get(Float.valueOf(tickValue));
        if (xValue == null) {
            xValue = (double)tickValue == Math.ceil(tickValue) ? String.valueOf((int)tickValue) : String.valueOf(tickValue);
        }
        return this.mPinTextFormatter.getText(xValue);
    }

    private ArrayList<Integer> getColors(CharSequence[] colors, int defaultColor) {
        ArrayList<Integer> colorList = new ArrayList<Integer>();
        if (colors != null && colors.length > 0) {
            for (CharSequence colorHex : colors) {
                String hexString = colorHex.toString();
                if (hexString.length() == 4) {
                    hexString = hexString + "000";
                }
                colorList.add(Color.parseColor((String)hexString));
            }
        } else {
            colorList.add(defaultColor);
        }
        return colorList;
    }

    private void movePin(PinView thumb, float x) {
        if (!(x < this.mBar.getLeftX()) && !(x > this.mBar.getRightX()) && thumb != null) {
            thumb.setX(x);
            this.invalidate();
        }
    }

    private boolean isInScrollingContainer() {
        for (ViewParent p = this.getParent(); p != null && p instanceof ViewGroup; p = p.getParent()) {
            if (!((ViewGroup)p).shouldDelayChildPressedState()) continue;
            return true;
        }
        return false;
    }

    public static interface OnRangeBarTextListener {
        public String getPinValue(RangeBar var1, int var2);
    }

    public static interface PinTextFormatter {
        public String getText(String var1);
    }

    public static interface OnRangeBarChangeListener {
        public void onRangeChangeListener(RangeBar var1, int var2, int var3, String var4, String var5);

        public void onTouchStarted(RangeBar var1);

        public void onTouchEnded(RangeBar var1);
    }
}

